(function(window,document){
    'use strict';
    //给hotcss开辟个命名空间，准备会用到的方法，免得用到的时候还要自己写。
    var hotcss = {};
    (function(){
        var viewportEl = document.querySelector('meta[name="viewport"]'),
            hotcssEl = document.querySelector('meta[name="hotcss"]'),
            //声明设备变量
            isAndroid = window.navigator.appVersion.match(/android/gi),
            isIPhone = window.navigator.appVersion.match(/iphone/gi),
            //获取设备的dpr
            dpr = window.devicePixelRatio,
            //设置页面最大能显示的尺寸
            maxWidth = 1020,
            //声明表示设计图尺寸的变量
            designWidth = 750;
            //判断设备是安卓还是苹果
            if(isIPhone){
                //若是苹果设备，获取设备的dpr
                dpr = window.devicePixelRatio;
            }
            if(isAndroid){
                //若是安卓设备，为防止因dpr不同导致的怪异问题，统一设置dpr为1
                dpr = 1;
            }
        //允许通过自定义name为hotcss的meta头，通过initial-dpr来强制定义页面缩放
        if(hotcssEl){
            var hotcssCon = hotcssEl.getAttribute('content');
            if(hotcssCon){
                var initialDprMatch = hotcssCon.match(/initial\-dpr=([\d\.]+)/);
                if(initialDprMatch){
                    dpr = parseFloat(initialDprMatch[1]);
                }
                var maxWidthMatch = hotcssCon.match(/max\-width=([\d\.]+)/);
                if(maxWidthMatch){
                    maxWidth = parseFloat(maxWidthMatch[1]);
                }
                var designWidthMatch = hotcssCon.match(/design\-width=([\d\.]+)/);
                if(designWidthMatch){
                    designWidth = parseFloat(designWidthMatch[1]);
                }
            }
        }
        document.documentElement.setAttribute('data-dpr',dpr);
        hotcss.dpr = dpr;
        document.documentElement.setAttribute('max-width',maxWidth);
        hotcss.maxWidth = maxWidth;
        if(designWidth){
            document.documentElement.setAttribute('design-width',designWidth);
            hotcss.designWidth = designWidth;
        }
        var scale = 1 / dpr;
        var content = 'width=device-width, initial-scale=' + scale + ', minimum-scale=' + scale + ', maximum-scale=' + scale + ', user-scalable=no';
        //判断head头中是否有viewport，若有，则更改属性，若没有，创建，并写入属性
        if(viewportEl){
            viewportEl.setAttribute('content',content);
        }else{
            viewportEl = document.createElement('meta');
            viewportEl.setAttribute('name','viewport');
            viewportEl.setAttribute('content',content);
            document.head.appendChild(viewportEl);
        }
    })();
    
    
    //核心方法，给HTML设置font-size。
    hotcss.mresize = function(){     
        var innerWidth = document.documentElement.getBoundingClientRect().width || window.innerWidth;
        if(hotcss.maxWidth && (innerWidth/hotcss.dpr > hotcss.maxWidth)){
            innerWidth = hotcss.maxWidth*hotcss.dpr;
        }
        if(!innerWidth){return false;}
        //这里更改设计图尺寸，根元素为100px  便于计算
        document.documentElement.style.fontSize = (innerWidth*100/hotcss.designWidth) + 'px';
        hotcss.callback && hotcss.callback();
    };   
    //直接调用一次
    hotcss.mresize(); 
    //绑定resize的时候调用
    window.addEventListener('resize',function(){
        clearTimeout(hotcss.tid);
        hotcss.tid = setTimeout(hotcss.mresize,33);
    },false);    
    //防止不明原因的bug，load之后再调用一次。
    window.addEventListener('load',hotcss.mresize,false);    
    //防止某些机型怪异现象，异步再调用一次
    setTimeout(function(){
        hotcss.mresize();        
    },333);
    //命名空间暴露，方便调用。
    window.hotcss = hotcss;
})(window,document);