$(function () {
    function CountDown(buttonId, buttonText, Second, ClickEvent) {
        var btn = $('#' + buttonId);
        btn.unbind();
        var countdown = setInterval(function () {
            if (Second <= 1) {
                window.clearInterval(countdown);
                btn.val(buttonText);
                btn.bind('click', ClickEvent);
                return;
            }
            Second -= 1;
            btn.val(Second);
        }, 1000);
    }
    function error(msg) {
        $('.error').html(msg).show();
        setTimeout(function(){
            $('.error').hide();
        },2000);
    }

    function getValidCode() {
        var post = {};
        var phone = $('.phone').val();
        var checkVcode = false;
        var vkey = $('#vkey').val();
        if (typeof vkey != 'undefined') {
            checkVcode = true;
        }
        if (phone.length != 11) {
            error('请正确输入手机号')
            return;
        }
        if (checkVcode) {
            var vcode = $('#vcode').val();
            if (vcode.length < 1) {
                error('请输入图形验证码')
                return;
            }
            var params = {phone: phone, _vkey: vkey, _vcode: vcode,type:2};
        } else {
            var params = {mobile: phone,type:2};
        }
        $.post('/app/plan/send-sms', params, function (data) {
            if (data.code == 200){
                CountDown('btnGetValidCode', '获取验证码', 60, function () {
                    getValidCode();
                });
                error(data.message);
            }
            if (data.code == 1) {
                error('发送验证码次数过多,请稍后再试')
                return;
            }
            if(data.code==2){
            	error('请输入注册火山贷时的手机号');
            }
            },'json');
    }

    $('#btnGetValidCode').bind('click', function () {
        getValidCode();
    });

    $('#login-btn').bind('click', function () {
        var post = {};
        var url_refer = $('#url_refer').val();
        var phone = $('.login_phone').val();
        var code = $('#login-p-s1-d2-d2-i').val();
        if (phone.length != 11) {
            error('请正确输入手机号');
            return;
        }

        $.post('/login/register/login', {phone: phone, code: code, url_refer: url_refer}, function (data) {
            if (data.status > 0) {
                alert(data.msg);
                return;
            }
            if (data.status == 0) {
                window.location.href = data.url_refer + '?time=' + ((new Date()).getTime());
            }
        });
    });

    function refreshVCode() {   
        var vkey = $('#vkey').val();
        var timestamp = new Date().getTime();
        var url = '/util/vcode?_vkey=' + vkey + '&t=' + timestamp;
        $('#vcode_img').attr('src', url);
        return false;
    }

    $('#vcode_img').on('click', refreshVCode);
});