<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <link rel="stylesheet" href="/index/css/questionnaire.css" />
    <!-- <link rel="stylesheet" href="css/mui.min.css"> -->
    <title>公共艺术品上报</title>
  </head>

  <body>
    <div class="box">
      <form action="/index/add" method="post" onsubmit="return checkFrom()" >
        <div class="main-fm">
          <ul>
            <li>
              <label>名称</label>
              <input type="text" name="name" placeholder="请输入" data-check="名称"/>
            </li>
            <li>
              <label>建造时间</label>
              <input type="text" name="project_time" placeholder="请输入" data-check="建造时间" />
            </li>
            <li>
              <label>建设单位</label>
              <input type="text" name="project" placeholder="请输入" data-check="建造单位" />
            </li>
	   <li>
              <label>作者</label>
              <input type="text" name="author" placeholder="请输入" data-check="作者" />
            </li>
            <li class="region">
              <label>详细地址</label>
              <div>
                <select name="district" id="district" data-check="区">
                    <option value="">区</option>
                  <?php
                        foreach ($district as $key=>$value) {
                            ?>
                            <option value="<?= $value['district'] ?>"><?= $value['district'] ?></option>
                            <?php
                        }
                    ?>
                </select>
                <select name="street" id="street" data-check="街道">
                  <option value="">街乡镇</option>
                </select>
                  <input type="text" name="location" placeholder="输入详细地址" data-check="详细地址"  style="float: left;border: none; width: 90%;border-bottom: 0.01rem solid #eee9bf;outline: none;text-indent: 0.2rem;background: #f9f9f9;font-size: 0.24rem;"/>
              </div>
            </li>

            <li class="putes">
              <span>摆放环境</span>
              <div>
                <div>
                  <label><input type="radio" name="put_location" value="道路绿地" checked />道路绿地</label>
                  <label><input type="radio" name="put_location" value="公园" />公园</label>
                  <label><input type="radio" name="put_location" value="广场" />广场</label>
                  <label><input type="radio" name="put_location" value="校园" />校园</label>
                  <label><input type="radio" name="put_location" value="居住地" />居住地</label>
                  <label><input type="radio" name="put_location" value="办公区" />办公区</label>
                  <label><input type="radio" name="put_location" value="商业区" />商业区</label>
                  <label><input type="radio" name="put_location" value="机场" />机场</label>
                  <label><input type="radio" name="put_location" value="地铁" />地铁</label>
                  <label><input type="radio" name="put_location" value="客运站" />客运站</label>
                  <label><input type="radio" name="put_location" value="其他" />其他</label>
                </div>
              </div>
            </li>
            <li class="coordinate">
              <label>经度</label>
              <input type="text" name="longitude_1" placeholder="" data-check="经度" /><span>°</span> <input type="text" name="longitude_2" placeholder="" /><span
                >’</span
              >
              <input type="text" name="longitude_3" placeholder="" /><span>’’</span>
            </li>
              <li class="coordinate">
                  <label>纬度</label>
                  <input type="text" name="latitude_1" placeholder="" data-check="纬度" /><span>°</span> <input type="text" name="latitude_2" placeholder="" /><span
                  >’</span
                  >
                  <input type="text" name="latitude_3" placeholder="" /><span>’’</span>
              </li>
            <li class="sizezp" >
              <label>作品尺寸</label>
              <select name="type" id="type">
                <option value="1">圆雕</option>
                <option value="2">浮雕</option>
		<option value="3">壁画</option>
              </select>
              <div>
                <span>高</span><input type="text" name="length" placeholder=""  data-check="长" style="width:60px" onkeyup="clearNoNum(this)"/>米- <span>宽</span
                  ><input type="text" name="width" placeholder="" data-check="宽" style="width:60px" onkeyup="clearNoNum(this)/>米- <span class="hou">厚</span><input class="hou" type="text" name="thick" placeholder="" style="width:60px" onkeyup="clearNoNum(this)/><span class="hou">米</span>
              </div>
            </li>
            <li class="putes materials">
              <span>材料</span>
              <div>
                <div>
                  <label><input type="checkbox" name="material[]" value="石材" checked />石材</label>
                  <label><input type="checkbox" name="material[]" value="铜" />铜</label>
                  <label><input type="checkbox" name="material[]" value="不锈钢" />不锈钢</label>
                  <label><input type="checkbox" name="material[]" value="钢板" />钢板</label>
                  <label><input type="checkbox" name="material[]" value="木材" />木材</label>
                  <label><input type="checkbox" name="material[]" value="铝合金" />铝合金</label>
                  <label><input type="checkbox" name="material[]" value="玻璃钢" />玻璃钢</label>
                  <label><input type="checkbox" name="material[]" value="水泥" />水泥</label>
                  <label><input type="checkbox" name="material[]" value="人造石" />人造石</label>
                  <label><input type="checkbox" name="material[]" value="陶瓷" />陶瓷</label>
                  <label><input type="checkbox" name="material[]" value="玻璃" />玻璃</label>
                  <label><input type="checkbox" name="material[]" value="其他" />其他</label>
                </div>
              </div>
            </li>
            <li class="putes technology">
              <span>工艺</span>
              <div>
                <div>
                  <label><input type="checkbox" name="technology[]" value="雕刻"  checked/>雕刻</label>
                  <label><input type="checkbox" name="technology[]" value="锻造" />锻造</label>
                  <label><input type="checkbox" name="technology[]" value="铸造" />铸造</label>
                  <label><input type="checkbox" name="technology[]" value="焊接" />焊接</label>
                  <label><input type="checkbox" name="technology[]" value="喷漆" />喷漆</label>
                  <label><input type="checkbox" name="technology[]" value="电镀" />电镀</label>
                  <label><input type="checkbox" name="technology[]" value="贴金" />贴金</label>
                  <label><input type="checkbox" name="technology[]" value="3d雕刻打印" />3d雕刻打印</label>
                  <label><input type="checkbox" name="technology[]" value="其他" />其他</label>
                </div>
              </div>
            </li>
            <li class="putes appearance">
              <span>外观现状</span>
              <div>
                <div>
                  <label><input type="radio" name="outward" value="完好"  checked/>完好</label>
                  <label><input type="radio" name="outward" value="污染" />污染</label>
                  <label><input type="radio" name="outward" value="褪色" />褪色</label>
                  <label><input type="radio" name="outward" value="损坏" />损坏</label>
                  <label><input type="radio" name="outward" value="基座破损" />基座破损</label>
                  <label><input type="radio" name="outward" value="其他" />其他</label>
                </div>
              </div>
            </li>
            <li>
              <label>填报人</label>
              <input type="text" name="input_people" placeholder="请输入"  data-check="填报人"/>
            </li>
            <li>
              <label>填报单位</label>
              <input type="text" name="input_unit" placeholder="请输入" data-check="填报单位" />
            </li>
            <li>
              <label>联系电话</label>
              <input type="text" name="mobile" placeholder="请输入" data-check="联系电话" />
            </li>
            <li style="height: auto">
              <label>艺术品铭⽂</label>
                <textarea class="textarea"  name="epigraph" placeholder="请输入" data-check="艺术品铭文" ></textarea>
                <div style="clear:both"></div>
            </li>
            <li>
              <label>艺术品描述</label>
              <input type="text" name="content" placeholder="请输入"  data-check="艺术品描述" />
            </li>
            <li class="scupload">
              <label>照片:</label>
              <div>东、南、西、北</div>
              <div class="container">
                <!--    照片添加    -->
                <input value="" type="text" id="imgList" name="image" style="display: none"/>
                <div class="z_photo" id="z_photo">
                  <div class="z_file">
                    <input
                      class="huodong-msg"
                      type="file"
                      name="file"
                      id="upFile"
                      accept="image/jpg,image/jpeg,image/png"
                    />
                  </div>
<!--                  <div class="z_addImg">-->
<!--                    <img src="" alt="" />-->
<!--                  </div>-->
                </div>

                <!--遮罩层-->
                <div class="z_mask">
                  <!--弹出框-->
                  <div class="z_alert">
                    <p>确定要删除这张图片吗？</p>
                    <p>
                      <span class="z_cancel">取消</span>
                      <span class="z_sure">确定</span>
                    </p>
                  </div>
                </div>
              </div>
            </li>
          </ul>
        </div>
        <div class="subtn">
          <button>提交</button>
        </div>
      </form>
    </div>

    <script src="/index/js/flexable.js"></script>
    <script src="/index/js/jquery-1.11.1.min.js"></script>
    <script src="/index/js/ajaxfileupload.js"></script>
    <script>
     function checkFrom() {
        var $el = $('[data-check]')

        for (var i = 0; i < $el.length; i++) {
          console.log($el.eq(i).val())
          if (!$el.eq(i).val()) {
            alert($el.eq(i).attr('data-check') + '不能为空')
            return false
          }
        }

        if ($('#imgList').val() == '') {
          alert('请上传图片')
          return false
        }
      }

      $(function() {
        function addImg(url) {
          var url = url
          var str = '<div class="z_addImg">' + '<img src="' + url + '" alt="" />' + '</div>'
          $('#z_photo').append(str)
          fileToinput()
        }
        function fileToinput() {
          var arr = []
          $('.z_addImg img').each(function() {

            arr.push($(this).attr('src'))
          })
            console.log(arr.join(','))
          $('#imgList').val(arr.join(','))
        }
        var currentImg = null
        $('#z_photo').on('click', '.z_addImg', function() {
          currentImg = $(this)
          $('.z_mask').show()
        })
        $('.z_sure').on('click', function() {
          if (currentImg) {
            currentImg.remove()
            fileToinput()
          }
          $('.z_mask').hide()
        })
        $('.z_cancel').on('click', function() {
          $('.z_mask').hide()
        })
        $('.z_file').on('change','#upFile', function() {
            if($('.z_addImg').size()>=4){
                alert('最多上传4张')
                return false
            }
          $.ajaxFileUpload({
            data: {},
            url: '/index/upload', //你处理上传文件的服务端
            secureuri: false,
            fileElementId: 'upFile',
            dataType: 'json',
            success: function(data) {
                if(data.success){
                    addImg(data.file_path)
                }else{
                    alert('网络可能出小差了，请稍后在试一次')
                }
                $('#upFile').val('')
            },error:function (e) {
                  console.log(e)
              }
          })
        })
      })
      $('#district').on('change', function() {
          var val = this.value
          $.ajax({
            url:'/index/get-street',
            data:{district:val},
            type:"post",
            dataType:'json',
            success:function(data){
                var str = ''
                $.each(data, function(index, item) {
                    str += '<option value="' + item.street + '">' + item.street + '</option>'
                })
                $('#street').html(str)
            }
          })

      })
      $('#type').on('change', function() {
          var val = this.value
          if(val != 1){
              $('.hou').hide();
          }else{
              $('.hou').show();
          }

      })
     function clearNoNum(obj){
         obj.value = obj.value.replace(/[^\d.]/g,"");  //清除“数字”和“.”以外的字符
         obj.value = obj.value.replace(/^\./g,"");  //验证第一个字符是数字而不是.
         obj.value = obj.value.replace(/\.{2,}/g,"."); //只保留第一个. 清除多余的.
         obj.value = obj.value.replace(".","$#$").replace(/\./g,"").replace("$#$",".");

     }
    </script>
  </body>
</html>
