<!DOCTYPE html>
<html class="x-admin-sm">
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <script type="text/javascript" src="/admin1/lib/jquery/1.9.1/jquery.min.js"></script>
        <script src="/js/echarts_s.js"></script>
        <link rel="stylesheet" href="/X-admin/css/xadmin.css" media="all">
    </head>
    <body>
        <div class="layui-card">
            <div class="layui-card-body ">
                <?php foreach ($district as $key => $value) { ?>
                    <a class="layui-btn"  style='margin-left: 20px;margin-top:10px;' href="/admin/visualize/district?qu=<?= $value['district'] ?>" target="_blank"> <?php echo $value['district']; ?></a>
                <?php }?>
            </div>
        </div>
        <div id="district" style="width: 100%;height:500px;border:1px solid #ccc;"></div>
        <div id="size" style="width: 48%;height:500px;border:1px solid #ccc;margin-top:10px;float:left"></div>
        <div id="environment" style="width: 48%;height:500px;border:1px solid #ccc;margin-top:10px;float:right"></div>
        <div id="outward" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:left"></div>
        <div id="size_yd" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:right;"></div>
        <div id="size_bh" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:left;"></div>
        <div id="size_fd" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:right;"></div>
        <div id="size_sx" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:left;"></div>
        <div id="level" style="width: 48%;height:600px;border:1px solid #ccc;margin-top:10px;float:right"></div>

        <div id="material" style="width: 100%;height:2000px;border:1px solid #ccc;margin-top:10px;float:left"></div>
        <div id="technology" style="width: 100%;height:2000px;border:1px solid #ccc;margin-top:10px;float:left"></div>
        
        <div id="show" style="width: 48%;height:500px;border:1px solid #ccc;margin-top:10px;float:left"></div>
        <div id="status" style="width: 48%;height:500px;border:1px solid #ccc;margin-top:10px;float:right"></div>
        
        <script type="text/javascript">
        var district_json = <?= $district_json ?>;
        var size_json = <?= $size_json ?>;
        var show_json = <?= $show_json ?>;
        var environment_json = <?= $environment_json ?>;
        var status_json = <?= $status_json ?>;
        var material_json = <?= $material_json ?>;
        var technology_json = <?= $technology_json ?>;
        var outward_json = <?= $outward_json ?>;
        var level_json = <?= $level_json ?>;
        var sizes_fd_json = <?= $sizes_fd ?>;
        var sizes_yd_json = <?= $sizes_yd ?>;
        var sizes_bh_json = <?= $sizes_bh ?>;
        var sizes_sx_json = <?= $sizes_sx ?>;

        var chartDom = document.getElementById('district');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '北京公共空间艺术品数据统计总览',
                subtext: '城区划分 总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: district_json
                }
            ]
        };



        option && myChart.setOption(option);

        var chartDom = document.getElementById('size');
        var myChart = echarts.init(chartDom);
        var option;

        option = {
            color:["#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '属性划分',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    type: 'pie',
                    radius: ['40%', '70%'],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: size_json
                }
            ]
        };

        option && myChart.setOption(option);

        var chartDom = document.getElementById('show');
        var myChart = echarts.init(chartDom);
        var option;

        option = {
            color:["#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '展示状态区分',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    type: 'pie',
                    radius: ['40%', '70%'],
                    avoidLabelOverlap: false,
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: show_json
                }
            ]
        };

        option && myChart.setOption(option);

        var chartDom = document.getElementById('environment');
        var myChart = echarts.init(chartDom);
        var option;

        option = {
            title: {
                text: '摆放环境分布',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item'
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            visualMap: {
                show: false,
                min: 80,
                max: 600,
                inRange: {
                    colorLightness: [0, 1]
                }
            },
            series: [
                {
                    type: 'pie',
                    radius: '55%',
                    center: ['50%', '50%'],
                    data: environment_json,
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    roseType: 'radius',
                    animationType: 'scale',
                    animationEasing: 'elasticOut',
                    animationDelay: function (idx) {
                        return Math.random() * 200;
                    }
                }
            ]
        };

        option && myChart.setOption(option);


        var chartDom = document.getElementById('status');
        var myChart = echarts.init(chartDom);
        var option;

        option = {
            title: {
                text: '各区审核情况',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item'
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            series: [
                {
                    type: 'pie',
                    radius: '55%',
                    center: ['50%', '50%'],
                    data: status_json,
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    }
                }
            ]
        };

        option && myChart.setOption(option);


        var chartDom = document.getElementById('material');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '材质划分',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: material_json
                }
            ]
        };



        option && myChart.setOption(option);


        var chartDom = document.getElementById('technology');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '工艺划分',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: technology_json
                }
            ]
        };



        option && myChart.setOption(option);


        var chartDom = document.getElementById('outward');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '外观划分',
                subtext: '总计：<?= $num ?>',
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: outward_json
                }
            ]
        };
        option && myChart.setOption(option);


        // 圆雕
        var chartDom = document.getElementById('size_yd');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '圆雕',
                subtext: '总计：'+(sizes_yd_json[0]['value']+sizes_yd_json[1]['value']+sizes_yd_json[2]['value']+sizes_yd_json[3]['value']),
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: sizes_yd_json
                }
            ]
        };
        option && myChart.setOption(option);
        // 浮雕
        var chartDom = document.getElementById('size_fd');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '浮雕',
                subtext: '总计：'+(sizes_fd_json[0]['value']+sizes_fd_json[1]['value']+sizes_fd_json[2]['value']+sizes_fd_json[3]['value']),
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: sizes_fd_json
                }
            ]
        };
        option && myChart.setOption(option);
        // 壁画
        var chartDom = document.getElementById('size_bh');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '壁画',
                subtext: '总计：'+(sizes_bh_json[0]['value']+sizes_bh_json[1]['value']+sizes_bh_json[2]['value']+sizes_bh_json[3]['value']),
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: sizes_bh_json
                }
            ]
        };
        option && myChart.setOption(option);

        // 塑像
        var chartDom = document.getElementById('size_sx');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '塑像',
                subtext: '总计：'+(sizes_sx_json[0]['value']+sizes_sx_json[1]['value']+sizes_sx_json[2]['value']+sizes_sx_json[3]['value']),
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: sizes_sx_json
                }
            ]
        };
        option && myChart.setOption(option);
        // 是否拆除
        var chartDom = document.getElementById('level');
        var myChart = echarts.init(chartDom);
        var option;
        option = {
            color:["#FFFF00","#C0C0C0","#00FFFF","#082E54","#802A2A","#D2691E","#A020F0","#DA70D6","#E3170D","#1E90FF","#FF4500","#B22222","#FFC0CB","#B03060","#FF4500","#FFFFCD","#ED9121","#00C78C","#D2B48C"],
            fontSize:25,
            title: {
                text: '是否建议拆除',
                subtext: '总计：'+<?= $num;?>,
                left: 'center',
                textStyle:{
                    fontSize:24
                },
                subtextStyle:{
                    fontSize:18
                }
            },
            tooltip: {
                trigger: 'item',
            },
            toolbox: {
                show: true,
                feature: {
                    mark: {show: true},
                    dataView: {show: true, readOnly: false,optionToContent:"<tr></tr>"},
                    restore: {show: true},
                    saveAsImage: {show: true}
                }
            },
            legend: {
                orient: 'vertical',
                left: 'left',
                textStyle:{
                    fontSize:18
                }
            },
            series: [
                {
                    name: '总计',
                    type: 'pie',
                    radius: '50%',
                    center: ['50%', '60%'],
                    label: {
                        normal: {
                            formatter: '{b} : {c} ({d}%)',
                            textStyle:{
                                fontSize:18
                            }
                        }
                    },
                    data: level_json
                }
            ]
        };
        option && myChart.setOption(option);
    </script>
    </body>
</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>