<!DOCTYPE html>
<html class="x-admin-sm">
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <link rel="stylesheet" href="/X-admin/viewerjs/viewer.min.css">
        <script src="/X-admin/viewerjs/viewer.min.js"></script>
        <script type="text/javascript" src="/admin1/lib/jquery/1.9.1/jquery.min.js"></script>
        <!--[if lt IE 9]>
          <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
          <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
         <style type="text/css">
            .active a{
                background:rgb(107,168,212);
                color:white;
            }
        </style>
        <link rel="stylesheet" href="/layui/css/global.css"  media="all">
    </head>
    <body>
        <div class="x-nav" style="background: none;border:0px;height: 0px"></div>
        <div class="layui-fluid" style="padding-left: 20px;padding-right: 20px">
            <div class="layui-row layui-col-space15">
                <div class="layui-col-md12">
                    <div class="layui-card">
                       <div class="layui-card-body layui-card-bodys">
                            <form class="layui-form layui-col-space5" method="get">

                                <div class="layui-input-inline layui-show-xs-block" style="width:100px">
                                    <select name="type" id='type'>
                                        <option value="0">全部</option>
                                        <option <?php if(1 ==$type){ echo 'selected="selected"';} ?> value="1">已巡查</option>
                                        <option <?php if(2 ==$type){ echo 'selected="selected"';} ?> value="2">未巡查</option>
                                    </select>
                                </div>
                                <?php 
                                    $year = (int)date('Y');
                                    $num_year = $year-2021;
                                ?>
                                <div class="layui-input-inline layui-show-xs-block" style="width:180px">
                                    <select name="nian" id='nian'>
                                        <?php for ($i=0; $i <= $num_year; $i++) {  ?>
                                            <option <?php if($i+2021 == $nian){ echo 'selected="selected"';} ?> value="<?= $i+2021; ?>"><?= $i+2021; ?>年</option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="layui-input-inline layui-show-xs-block" style="width:100px">
                                        <select name="yue" id='yue'>
                                        <option <?php if('03' == $yue){ echo 'selected="selected"';} ?> value="03">3月</option>
                                        <option <?php if('06' == $yue){ echo 'selected="selected"';} ?> value="06">6月</option>
                                        <option <?php if('09' == $yue){ echo 'selected="selected"';} ?> value="09">9月</option>
                                        <option <?php if('12' == $yue){ echo 'selected="selected"';} ?> value="12">12月</option>
                                    </select>
                                </div>
                                <?php  $session = Yii::$app->session;?>
                                <?php if($session['role_level'] < 2 ){ ?> 
                                  <div class="layui-input-inline layui-show-xs-block" style="width:200px">
                                    <select name="district" id='district' lay-filter="district">
                                      <option value="">请选择区域</option>
                                      <?php foreach ($dizhi as $key => $value) { ?>
                                        <option <?php if($value['district'] ==$district){ echo 'selected="selected"';} ?> value="<?= $value['district']?>"> <?= $value['district']?> </option>
                                      <?php } ?>
                                    </select>
                                </div>
                                <?php } ?>
                                <?php if($session['role_level'] <= 2 ){ ?> 
                                    <div class="layui-input-inline layui-show-xs-block" style="width:200px">
                                    <select name="street" id='street'  lay-filter="street">
                                      <option value="">请选择街道</option>
                                      <?php foreach ($dizhis as $key => $value) { ?>
                                        <option <?php if($value['street'] ==$street){ echo 'selected="selected"';} ?> value="<?= $value['street']?>"> <?= $value['street']?> </option>
                                      <?php } ?>
                                    </select>
                                    </div>
                                <?php } ?>
                                <div class="layui-inline layui-show-xs-block layui-btn-normal"  style="background:rgb(173,145,108);border-radius: 5px">
                                    <button class="layui-btn  layui-btn-normal"  lay-submit="" lay-filter="sreach"  style="background: rgb(173,145,108)"><i class="layui-icon">&#xe615;</i></button>
                                </div>
                                <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108)" onclick="location.reload()" title="刷新" ><i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
                                <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108);margin-right: 10px" id='count' title="总计">总计：<?= $page->totalCount ?>件</a> 
                                <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108);margin-right: 10px" id='dc' title="导出">导出</a>
								<?php if($session['role_level'] < 2 ){ ?> 
                                <a class="layui-btn layui-btn-small layui-btn-normal" href="/admin/index/signcount" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108);margin-right: 10px" title="统计">统计</a>
                                <?php } ?>
                            </form>
                        </div>
                        <div style="height: 15px;background-color:rgb(241,241,241)"></div>
                        <div class="layui-card-body layui-table-body layui-table-main">
                            <div class="layui-row flow-default" id="LAY_demo2">
                                    <?php
                                    foreach ($list as $key => $val) {
                                        $val['district'] = str_replace('公司','',$val['district']);
                                        $val['zpbh'] = str_replace('区','',$val['district']).str_pad($val['zpbh'],3,"0",STR_PAD_LEFT);
                                        if($val['day'] =='' || $val['day'] ==null){ ?>
                                            <a href="/admin/index/detail?id=<?= $val['id']?>&type=zl" target="_blank"  class="layui-col-xs1 usercss"><div class="grid-demo layui-bg-red"><?= $val['zpbh'] ?></div></a>
                                    <?php    }else{ ?>
                                            <a href="/admin/index/signinfo?id=<?= $val['id']; ?>&day=<?= $val['day']?>" target="_blank" class="layui-col-xs1 usercss">
                                                <div class="grid-demo grid-demo-bg3"><?= $val['zpbh'] ?>
                                                <?php if($val['content'] !=''){ ?>
                                                    <div class='userbadge'>备</div>
                                                <?php } ?>
                                                </div>
                                            </a>
                                    <?php    }
                                    }
                                    ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
        <input type="hidden" id='pagess' value="<?= $pages?>">
    </body>
    <script>
    
        layui.use(['element', 'form'], function () {
            form = layui.form;
            form.on('select(district)', function (data) {
                var companyId = data.value;
                console.log(companyId);
                var s = '<option value="">请选择街道</option>';
                if (companyId == '') {
                    // $("#street").html(s);
                    // form.render('select');
                } else {
                    $.ajax({
                        async: false,
                        type: "POST", //提交方式
                        url: "/admin/index/getstreet",//路径
                        data: {
                            district: companyId
                        },
                        success: function (result) {
                            if (result.code === 200) {
                                $("#street").html("");
                                var list = result.result;
                                $.each(list, function (i, ss) {
                                    s = s + '<option value="' + ss.street + '">' + ss.street + '</option>';
                                });
                                $("#street").html(s);
                                form.render('select');
                            }
                        }
                    });
                }
            });
        })
        layui.use('flow', function(){
            var flow = layui.flow;
            flow.load({
                elem: '#LAY_demo2' //指定列表容器
                ,done: function(page, next){ //到达临界点（默认滚动触发），触发下一页
                var lis = [];
                //以jQuery的Ajax请求为例，请求下一页数据（注意：page是从2开始返回）
                var nian = $("#nian option:selected").val();
                var yue = $("#yue option:selected").val();
                var district = $("#district option:selected").val();
                var street = $("#street option:selected").val();
                var type = $("#type option:selected").val();
                var day = nian+yue;
                $.ajax({
                    type:'post',
                    dataType:'json',
                    data:{page:page,day:day,district:district,type:type,street:street},
                    url:'/admin/index/signjson',
                    success:function(data){
                        if(data.code=='200'){
                            var lis = [];
                            $.each(data.data,function (index) {
                                if(data.data[index].day == null){
                                    lis.push('<a target="_blank" href="/admin/index/detail?id='+data.data[index].id+'&type=zl" class="layui-col-xs1 usercss"><div class="grid-demo layui-bg-red">'+data.data[index].zpbh+'</div></a>');
                                }else{
                                    str = '<a target="_blank" href="/admin/index/signinfo?id='+data.data[index].id+'&day='+data.data[index].day+'" class="layui-col-xs1 usercss"><div class="grid-demo grid-demo-bg3">';
                                    str += data.data[index].zpbh;
                                    if(data.data[index].content !=''){
                                        str += '<div class="userbadge">备</div>';
                                    }
                                    str +='</div></a>';
                                    lis.push(str);
                                }
                                
                            });
                            // next(lis.join(''), page < 6);
                            next(lis.join(''), page < <?= $pages ?>);    
                        }else{
                            layer.msg('没有数据了!',{icon:1,time:1000});
                        }
                        
                    },
                    error:function(data){
                        layer.msg('获取数据失败!',{icon:1,time:1000});
                    }
                })
                }
            });

            
        });
        $("#dc").click(function(){
            var nian = $("#nian option:selected").val();
            var yue = $("#yue option:selected").val();
            var district = $("#district option:selected").val();
            var type = $("#type option:selected").val();
            var street = $("#street option:selected").val();
            var day = nian+yue;
            if(day !=''){ day = "&day="+day;}else{day = "";}
            if(district !=''){ district = "&district="+district;}else{district = "";}
            if(street !=''){ street = "&street="+street;}else{street = "";}
            if(type !=''){ type = "&type="+type;}else{type = "";}
            window.open("/admin/daochu/sign?"+day+type+district+street);
        })
        
    </script>
</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>