<?php
/**
 * Created by PhpStorm.
 * User: shangpeng
 * Date: 2018/9/9
 * Time: 上午9:20
 */


use yii\widgets\LinkPager;

?>
<!DOCTYPE html>
<html class="x-admin-sm">
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <!--[if lt IE 9]>
          <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
          <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
         <style type="text/css">
          .active a{
              display: inline-block;
              color: rgb(255, 255, 255);
              min-width: 15px;
              background: -webkit-linear-gradient(top,rgb(250,8,20),rgb(191,5,14));
              padding: 5px;
              border-width: 1px;
              border-style: solid;
              border-color: rgb(0, 150, 136);
              border-image: initial;
          }
        </style>
    </head>
    <body>
        <div class="x-nav">
<!--           <span class="layui-breadcrumb">
            <a href="">首页</a>
            <a href="">演示</a>
            <a>
              <cite>导航元素</cite></a>
          </span> -->
          <a class="layui-btn layui-btn-small" style="line-height:1.6em;margin-top:3px;float:right;background: -webkit-linear-gradient(top,rgb(250,8,20),rgb(191,5,14));" onclick="location.reload()" title="刷新">
            <i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
        </div>
        <div class="layui-fluid">
            <div class="layui-row layui-col-space15">
                <div class="layui-col-md12">
                    <div class="layui-card">
                        <div class="layui-card-body layui-card-bodys">
                            <form class="layui-form layui-col-space5" method="get">
                                <div class="layui-input-inline layui-show-xs-block">
                                    <input class="layui-input" placeholder="开始时间" name="start_time" value="<?php echo $where['start_time'];?>" id="start">
                                </div>
                                <div class="layui-input-inline layui-show-xs-block">
                                    <input class="layui-input" placeholder="截止时间" name="end_time" id="end" value="<?php echo $where['end_time'];?>"></div>
                                <?php if($role_id==1){?>
                                <div class="layui-input-inline layui-show-xs-block">
                                    <select name="district_name">
                                        <option value="">地区选择</option>
                                        <?php foreach ($district as $value){
                                            if($where['district_name'] == $value['district_name']){ ?>
                                            <option selected="selected" value="<?php echo $value['district_name']?>"><?php echo $value['district_name']?></option>
                                        <?php }else{?>
                                            <option value="<?php echo $value['district_name']?>"><?php echo $value['district_name']?></option>
                                        <?php }}?>
                                    </select>
                                </div>
                                 <?php }?>
                                <div class="layui-input-inline layui-show-xs-block">
                                    <select name="type">
                                        <option  value="">是否打卡</option>
                                        <option <?php if($where['type']==1){echo 'selected';}?> value="1">已打卡</option>
                                        <option <?php if($where['type']==2){echo 'selected';}?> value="2">未打卡</option>
                                    </select>
                                </div>
                                <div class="layui-input-inline layui-show-xs-block">
                                    <input type="text" name="username" placeholder="标题查询" autocomplete="off" class="layui-input"></div>
                                <div class="layui-input-inline layui-show-xs-block" style="background: -webkit-linear-gradient(top,rgb(250,8,20),rgb(191,5,14));">
                                    <button class="layui-btn" lay-submit="" style="background: -webkit-linear-gradient(top,rgb(250,8,20),rgb(191,5,14));" lay-filter="sreach">
                                        <i class="layui-icon">&#xe615;</i></button>
                                </div>
                            </form>
                        </div>
                        <div class="layui-card-body layui-table-body layui-table-main">
                            <table class="layui-table layui-form">
                                <thead>
                                  <tr>
                                    <th>巡查时间</th>
                                    <th>图片</th>
                                    <th>巡查位置</th>
                                    <th>员工名称</th>
                                    <th>浮雕名称</th>
                                    
                                </thead>
                                <tbody>
                                <?php
                                    foreach ($list as $key=>$val){ ?>
                                        <?php if($where['type']==1){
                                            $imgs = $val['image'];
                                            ?>
                                        <tr class="text-c">
                                            <td><?= $val['create_time']?></td>
                                            <td><img src="<?= $imgs?>" style="width: 120px;height: 80px"></td>
                                            <td><?= $val['district'].'-'.$val['street'].'-'.$val['location']?></td>
                                            <td><?= $val['username']?></td>
                                            <td><?= $val['sculpture_name']?></td>
                                            
                                        </tr>
                                        <?php } else {?>
                                        <tr class="text-c">
                                            <td>-</td>
                                            <td>-</td>
                                            <td><?= $val['username']?></td>
                                            <td>-</td>
                                            <td>-</td>
                                        </tr>
                                        <?php
                                        }
                                    }
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="layui-card-body ">
                            <div class="page">
                                 <?php if($pages->totalCount > 11){ ?>
                                <p style="position: absolute;width:300px;font-size: 18px;left: 20px;padding: 5px;">
                                  跳转至：<input type="number" name="page" id="page" value="" style="width:50px" onchange="myFunction()">&nbsp;页/共<?php echo ceil($pages->totalCount/10); ?>页
                                </p>
                              <?php } ?>
                                        <script>
                                  function myFunction(){
                                      var x=document.getElementById("page").value;
                                      window.location.href+="&page="+x;
                                   }
                              </script>

                                 <?php echo LinkPager::widget(['pagination' => $pages]); ?>
                 <!--                <div>
                                  <a class="prev" href="">&lt;&lt;</a>
                                  <a class="num" href="">1</a>
                                  <span class="current">2</span>
                                  <a class="num" href="">3</a>
                                  <a class="num" href="">489</a>
                                  <a class="next" href="">&gt;&gt;</a>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
    </body>
    <script>
        layui.use(['laydate', 'form'],
        function() {
            var laydate = layui.laydate;

            //执行一个laydate实例
            laydate.render({
                elem: '#start' //指定元素
            });

            //执行一个laydate实例
            laydate.render({
                elem: '#end' //指定元素
            });
        });
      /*用户-删除*/
      function member_del(obj,id){
          layer.confirm('确认要删除编号为'+id+'的用户吗？',function(index){
              //发异步删除数据
               $.ajax({
                type:'post',
                dataType:'json',
                data:{id:id},
                url:'/admin/admin/del-admin',
                success:function(data){
                    if(data.code=='1'){
                        $(obj).parents("tr").remove();
                        layer.msg('已删除!',{icon:1,time:1000});
                        // $("#del-"+id+"").parent('td').parent('tr').hide();
                        // alert('删除成功')
                    }else{
                        layer.msg('删除失败!',{icon:1,time:1000});
                    }

                },
                error:function(data){
                    layer.msg('删除失败!',{icon:1,time:1000});
                }
            })
              
          });
      }

    </script>
</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>