<?php
$session = Yii::$app->session;
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="apple-mobile-web-app-status-bar-style" content="black">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="format-detection" content="telephone=no">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css" media="all">
        <script src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <link rel="stylesheet" href="/X-admin/viewerjs/viewer.min.css">
        <script src="/X-admin/viewerjs/viewer.min.js"></script>


        <style type="text/css">
            .layui-card-header{
                    background-color: #f2f2f2;
            }
            .layui-btn{
                border-radius: 10px;
            }
        </style>
    </head>
    <body>
        <div class="layui-col-md12"  style="padding-left: 20px;padding-right: 20px">
            <div class="layui-card">
                <div class="layui-card-header" style="background: rgb(173,145,108);font-size: 18px;color: white;">
                    艺术品导出(常规)
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108)" onclick="location.reload()" title="刷新" style=""><i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="font-size: 18px;float:right;background:rgb(173,145,108);line-height: 40px;height: 100%;background:rgb(121,155,154);border:1px solid white;" href="javascript:history.go(-1)" title="刷新" style="">返回上一页</a>
                </div>
                <div class="layui-card-body ">
                    <a class="layui-btn"  style='margin-left: 50px;' href="/admin/daochu/execl" >导出所有艺术品(不附带图片) 共计：<?php echo $num; ?></a>
                </div>
                <div class="layui-card-body ">
                    <?php 
                        $sum = ceil($num/500);
                        for ($i=0; $i < $sum; $i++) { ?>
                            <a class="layui-btn"  style='margin-left: 50px;margin-top:30px;' href="/admin/daochu/execls?page=<?php echo $i; ?>&title=公共艺术品<?php echo $i*500; echo "至"; echo ($i+1)*500; ?>" > 导出<?php echo $i*500; echo "至"; echo ($i+1)*500; ?>件艺术品(带图片)</a>
                        <?php }
                    ?>
                </div>
                <?php if($session['role_level'] == '1'){ ?>
                <div class="layui-card-body ">
                    <?php foreach ($district as $key => $value) { ?>
                        <a class="layui-btn"  style='margin-left: 50px;margin-top:30px;' href="/admin/daochu/execls?district=<?php echo $value['district']; ?>&title=公共艺术品_<?php echo $value['district']; ?>" > 导出<?php echo $value['district']; ?>公共艺术品(带图片)</a>
                    <?php }?>
                </div>
                <?php }?>
            </div>
            <?php if($session['role_level'] == '1'){ ?>
                <div class="layui-card">
                <div class="layui-card-header" style="background: rgb(173,145,108);font-size: 18px;color: white;">
                    艺术品导出(条件检索)
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108)" onclick="location.reload()" title="刷新" style=""><i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="font-size: 18px;float:right;background:rgb(173,145,108);line-height: 40px;height: 100%;background:rgb(121,155,154);border:1px solid white;" href="javascript:history.go(-1)" title="刷新" style="">返回上一页</a>
                </div>
                <form class="layui-form layui-col-space5" method="get" action="/admin/daochu/scuexecls" style="">
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;;margin-left: 20px;margin-top:10px">
                        <select name="district_value" lay-filter="district">
                            <option value="">全市</option>
                            <?php
                            foreach ($district as $k => $v) { ?>
                                <option  value="<?= $v['district'] ?>"><?= $v['district'] ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="layui-inline layui-show-xs-block" style="width:200px;margin-left: 20px">
                        <input type="text"  name="dizhi" placeholder="请输入地址" autocomplete="off" class="layui-input">
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="is_show" lay-filter="is_show">
                            <option value="">公开状态</option>
                            <option  value="1">公开</option>
                            <option  value="3">不公开</option>
                            <!-- <option  value="2">待公开</option> -->
                        </select>
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="qu_status" lay-filter="qu_status">
                            <option value="">区审核状态</option>
                            <option  value="3">未审核</option>
                            <option value="1">审核通过</option>
                            <option  value="2">审核未通过</option>
                        </select>
                    </div>
                    <!-- 属性 -->
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="type" lay-filter="type" id='type'>
                            <option value="">请选择属性</option>
                            <option  value="1">圆雕</option>
                            <option  value="2">浮雕</option>
                            <option  value="3">壁画</option>
                            <option  value="4">塑像</option>
                        </select>
                    </div>
                    <!-- 材料 -->
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="material" lay-filter="material">
                            <option value="">请选择材料</option>
                            <option  value="石材">石材</option>
                            <option  value="铜">铜</option>
                            <option  value="不锈钢">不锈钢</option>
                            <option  value="钢板">钢板</option>
                            <option  value="人造石和水泥">人造石和水泥</option>
                            <option  value="陶瓷">陶瓷</option>
                            <option  value="玻璃">玻璃</option>
                            <option  value="其他">其他</option>
                        </select>
                    </div>
                    <!-- 工艺 -->
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="technology" lay-filter="technology">
                            <option value="">请选择工艺</option>
                            <option  value="雕刻">雕刻</option>
                            <option  value="锻造">锻造</option>
                            <option  value="铸造">铸造</option>
                            <option  value="焊接">焊接</option>
                            <option  value="喷漆">喷漆</option>
                            <option  value="电镀">电镀</option>
                            <option  value="贴金">贴金</option>
                            <option  value="3d雕刻打印">3d雕刻打印</option>
                            <option  value="其他">其他</option>
                        </select>
                    </div>
                    <!-- 外观 -->
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="outward" lay-filter="outward">
                            <option value="">请选择外观</option>
                            <option value="完好">完好</option>
                            <option value="需清洗">需清洗</option>
                            <option value="需维修">需维修</option>
                        </select>
                    </div>
                    <!-- 摆放环境 -->
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="put_location" lay-filter="put_location">
                            <option value="">请选择摆放环境</option>
                            <option value="道路绿地">道路绿地</option>
                            <option value="公园">公园</option>
                            <option value="广场">广场</option>
                            <option value="校园">校园</option>
                            <option value="居住地">居住地</option>
                            <option value="办公区">办公区</option>
                            <option value="商业区">商业区</option>
                            <option value="机场">机场</option>
                            <option value="地铁">地铁</option>
                            <option value="客运站">客运站</option>
                            <option value="其他">其他</option>
                        </select>
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="size" lay-filter="size" id='size'>
                            <option value="">请选择尺寸</option>
                            <option value="特大型">特大型</option>
                            <option value="大型">大型</option>
                            <option value="中型">中型</option>
                            <option value="小型">小型</option>
                        </select>
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="level" lay-filter="level">
                            <option value="">是否建议拆除</option>
                            <option value="1">否</option>
                            <option value="2">是</option>
                        </select>
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="img" lay-filter="img">
                            <option value="">是否携带图片</option>
                            <option value="1">否</option>
                            <option value="2">是</option>
                        </select>
                    </div>
                    <div class="layui-input-inline layui-show-xs-block" style="width:200px;margin-left: 20px;margin-top:10px">
                        <select name="del" lay-filter="del">
                            <option value="">是否是删除</option>
                            <option value="1">否</option>
                            <option value="2">是</option>
                        </select>
                    </div>
                    <div class="layui-inline layui-show-xs-block layui-btn-normal"  style="background:rgb(173,145,108);border-radius: 5px;margin-left:20px;">
                        <button class="layui-btn  layui-btn-normal"  lay-submit="" lay-filter="sreach"  style="background: rgb(173,145,108)">导出</button>
                    </div>
                </form>
            </div>
            <?php } ?>
            
        </div>
        <script>
        layui.use(['form','layer','upload'], function() {
        $ = layui.jquery;
        var form = layui.form,
        layer = layui.layer; 
        form.on('submit(sreach)', function(data){
          var type = $("#type option:selected").val();
          var size = $("#size option:selected").val();
          if(size !='' && type==''){
            layer.msg("请选择艺术品属性");
            return false;
          }
        });
      
      });
    </script>
    </body>
</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>