<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta name="keywords" content="天地图"/>
    <title>北京公共空间艺术品数字化信息系统</title>
    <!-- <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests"> -->
    <link rel="stylesheet" href="/X-admin/css/xadmin.css" media="all">
        <script src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <link rel="stylesheet" href="/X-admin/viewerjs/viewer.min.css">
        <script src="/X-admin/viewerjs/viewer.min.js"></script>
        <script type="text/javascript" src="/admin1/lib/jquery/1.9.1/jquery.min.js"></script> 
    <!-- <script type="text/javascript" src="https://api.tianditu.gov.cn/api?v=4.0&tk=cf23c498b9c4b59fa7ed29c4b8f6cff2"></script> -->
    <script type="text/javascript" src="https://api.tianditu.gov.cn/api?v=4.0&tk=cf23c498b9c4b59fa7ed29c4b8f6cff2"></script>
    <script type="text/javascript" src="/js/coordtransform.js"></script>
    <style type="text/css">body,html{width:100%;height:100%;margin:0;font-family:"Microsoft YaHei"}#mapDiv{width:100%;height:100%}input,b,p{margin-left:5px;font-size:14px}</style>
    <script>
        var list = <?php echo $list; ?>;
        var len = list.length;
        var lists = new Array();
        // 先对经纬度进行转换
        for(var i=0,l=list.length;i<l;i++){
            var bd09togcj02 = coordtransform.bd09togcj02(list[i]['longitude'], list[i]['latitude']);
            var gcj02towgs84 = coordtransform.gcj02towgs84(bd09togcj02[0], bd09togcj02[1]);
            var arr_list = new Array();
            arr_list['longitude'] = gcj02towgs84[0];
            arr_list['latitude'] = gcj02towgs84[1];
            arr_list['name'] = list[i]['name'];
            arr_list['id'] = list[i]['id'];
            lists.push(arr_list);
        }
        var lens = lists.length;
        var zoom = 12;
        var map;
        var center;
        var localsearch;
        var radius = 5000;
        var infoWin;
        function onLoad() {
            //初始化地图对象
            var map=new T.Map('mapDiv');
            // map = new T.Map('mapDiv', {
            //     layers:[lay],
            //     attributionControl: false,
            //     inertia: false
            // });
            map.centerAndZoom(new T.LngLat(116.40969, 39.89945), zoom);

            var arrayObj = new Array();
            for (var i = 0; i < lens; i++)
            {
                var marker  = new T.Marker(new T.LngLat(lists[i]['longitude'],lists[i]['latitude']));
                arrayObj.push(marker);
                
                label = new T.Label({
                    text: "<a href='/admin/index/detail?id="+list[i]['id']+"' target='_blank' style='font-size:18px;font-weight:bold'>"+lists[i]['name']+"<a>",
                    position: marker.getLngLat(),
                    offset: new T.Point(3, -30)
                });
                map.addOverLay(label);
                marker.addEventListener("drag", function (e) {
                    label.setLngLat(marker.getLngLat());
                })
            }
            styles = [{
                        url:'/images/cluster0.png',
                        size:[49, 49], //图片大小
                        offset:new T.Point(-15, -13), //显示图片的偏移量
                        textColor:'#000000', //显示数字的颜色
                        textSize:14,//显示文字的大小
                        range:[0, 50],
                        }];
            var markers = new T.MarkerClusterer(map, {markers: arrayObj,styles:styles});
                
            var scale = new T.Control.Scale();
            map.addControl(scale);
        }
        

    </script>
</head>
<body onLoad="onLoad()">
<!-- <body> -->
<div class="layui-form-item" style="position: fixed;top: 0px;width: 100%;z-index:99999">
    <form class="layui-form layui-col-space5" method="get">
        <div class="layui-input-inline layui-show-xs-block" style="width:200px">
            <select name="district" lay-filter="district">
                <?php 
                foreach ($district as $key => $value) { ?>
                    <option value="<?= $value['district'] ?>" <?php if($districts==$value['district']){ echo "selected='selected'";} ?>><?= $value['district'] ?></option>
                <?php 
                }
                ?>
            </select>
        </div>
        <div class="layui-input-inline layui-show-xs-block" style="width:200px">
            <select name="type" lay-filter="type">
                <option value="2" <?php if($type==2){ echo "selected='selected'";} ?>>切换为11实景图</option>
                <option value="1" <?php if($type==1){ echo "selected='selected'";} ?>>切换为矢量图</option>
            </select>
        </div>
        <button class="layui-btn "  lay-submit="" lay-filter="sreach" ><i class="layui-icon">&#xe615;</i></button>
    </form>
</div>
<div id="mapDiv"></div>
<script>
    layui.use(['form','layer','upload'], function() {
        $ = layui.jquery;
        var form = layui.form,
        layer = layui.layer; 
    })
</script>
</body>
</html>