<!DOCTYPE html>
<html class="x-admin-sm">
    
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script type="text/javascript" src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
        <!--[if lt IE 9]>
            <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
            <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
        <style type="text/css">
          .layui-form-label{
              width: 200px;
            }
        </style>
    </head>
    <body>
        <div class="layui-fluid">
            <div class="layui-row">
                <form class="layui-form" method="post">
                  <div class="layui-form-item">
                      <label for="nikename" class="layui-form-label">
                          <span class="x-red">*</span>用户名
                      </label>
                      <div class="layui-input-inline">
                          <input type="text" id="name" name="name" value="<?php echo $info['username']; ?>" required="" lay-verify="required"
                          autocomplete="off" class="layui-input" readonly="readonly">
                      </div>
                      <!-- <div class="layui-form-mid layui-word-aux">
                          <span class="x-red">*</span>
                      </div> -->
                  </div>
                  <div class="layui-form-item">
                      <label for="phone" class="layui-form-label">
                          <span class="x-red"></span>手机号
                      </label>
                      <div class="layui-input-inline">
                          <input type="text" id="phone" name="mobile" value="<?php echo $info['mobile']; ?>" autocomplete="off" class="layui-input" lay-verify="phone">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          <span class="x-red">*</span>
                      </div>
                  </div>
                  <!-- <div class="layui-form-item">
                  <label for="username" class="layui-form-label">
                        <span class="x-red">*</span>状态</label>
                    <div class="layui-input-inline">
                      <select name="status" id='status' lay-filter="status">
                          <option value="1" <?php if($info['status']==1){ echo "selected='selected'";} ?>>正常</option>
                          <option value="0" <?php if($info['status']==0){ echo "selected='selected'";} ?>>冻结</option>
                      </select>
                    </div>
                  </div> -->
                  <div class="layui-form-item">
                      <label for="L_pass" class="layui-form-label">
                          新密码
                      </label>
                      <div class="layui-input-inline">
                          <input type="password" id="pwd" name="pwd" lay-verify="pass"
                          autocomplete="off" class="layui-input">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          6位以上大小写字母及数字 为空 则为不变更密码
                      </div>
                  </div>
                    <input type="hidden" name="type" id="id" value="<?= $info['id']?>">
                  <div class="layui-form-item">
                      <label for="L_repass" class="layui-form-label">
                      </label>
                      <input name="_csrf" type="hidden" id="_csrf" value="<?= Yii::$app->request->csrfToken ?>">
                      <!-- <input class="layui-btn" type="button" value="&nbsp;&nbsp;提交&nbsp;&nbsp;" onclick="save();"> -->
                      <button  class="layui-btn layui-btn-normal" lay-filter="add" lay-submit="">
                          保存
                      </button>
                  </div>
              </form>
            </div>
        </div>
        <script>
          layui.use(['form', 'layer'],
            function() {
                $ = layui.jquery;
                var form = layui.form,
                layer = layui.layer;

                //自定义验证规则
                form.verify({
                    nikename: function(value) {
                        if (value.length < 5) {
                            return '昵称至少得5个字符啊';
                        }
                    },
                    // pass: [/(.+){6,12}$/, '密码必须6到12位'],
                    // repass: function(value) {
                    //     if ($('#L_pass').val() != $('#L_repass').val()) {
                    //         return '两次密码不一致';
                    //     }
                    // }
                });



                form.on('submit(add)',
                function(data) {

                    var pwd=$("#pwd").val();
                    var id=$("#id").val();
                    var mobile=$("#phone").val();
                    var status=$("#status").val();
                    var csrfToken= $("#_csrf").val();
                    if(pwd !=''){
                        if(checkStrong(pwd) >=2){
                        }else{
                            layer.msg('密码强度不够');
                            return false;
                        }
                    }
                    
                    $.ajax({
                        type:'post',
                        url:'/admin/admin/edit-admins',
                        dataType:'json',
                        data:{id:id,pwd:pwd,mobile:mobile,status:status,_csrf:csrfToken},
                        success:function(data){
                              if(data.code=='1'){
                                code = 1;
                                var index = parent.layer.getFrameIndex(window.name);
                                window.parent.location.reload();//刷新父页面
                                parent.layer.close(index);//关闭弹出层
                              }else{
                                alert("修改失败");
                              }
                          },
                    })
                    
                });
            });
            function checkStrong(val) {
                var modes = 0;
                if (val.length < 8) return 0;
                if (/\d/.test(val)) modes++; //数字
                if (/[a-z]/.test(val)) modes++; //小写
                if (/[A-Z]/.test(val)) modes++; //大写 
                if (val.length > 12) return 3;
                return modes;
            };
            // function save(){
            // var name=$("#name").val();
            // var mobile=$("#mobile").val();
            // var pwd=$("#pwd").val();
            // var jurisdiction=$(".layui-this").text();
            // var parent=$(".layui-this").attr("lay-value");
            // // var jurisdiction=$("#jurisdiction option::selected").text();
     
            // $.ajax({
            //     type:'post',
            //     url:'/admin/admin/add-admins',
            //     dataType:'json',
            //     data:{name:name,mobile:mobile,pwd:pwd,jurisdiction:jurisdiction,parent:parent},
            //     success:function(data){
            //         if(data.code=='1'){
            //             var index = parent.layer.getFrameIndex(window.name);
            //             layer.msg('已提交',{time:1000});
            //             parent.location.reload();
            //             window.location.reload('/admin/admin/adms');
            //             parent.layer.close(index);
            //         }else{
            //             layer.msg("'"+data.msg+"'",{time:1000});
            //         }
            //     },
            //     error:function(data){
            //         console.log(data.msg)
            //     }
            // })
            // }

          </script>
       
    </body>

</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>
