
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="apple-mobile-web-app-status-bar-style" content="black">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="format-detection" content="telephone=no">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css" media="all">
        <script src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <link rel="stylesheet" href="/X-admin/viewerjs/viewer.min.css">
        <script src="/X-admin/viewerjs/viewer.min.js"></script>
        <script type="text/javascript" src="/admin1/lib/jquery/1.9.1/jquery.min.js"></script>


        <style type="text/css">
            .layui-card-header{
                    background-color: #f2f2f2;
            }
            .layui-btn{
                border-radius: 10px;
            }
            .layui-table img{
                max-width: 800px
            }
            .layui-form-radio *{
              font-size: 24px
            }
            .layui-form-item .layui-input-inline{
              width: 500px
            }
            .layui-form-label{
              width: 200px;
              font-size: 22px;
            }
            .layui-form-label input{
              font-size: 22px;
            }
        </style>
    </head>
    <body>
        <div class="x-nav" style="background: none;border:0px;height: 0px">
        </div>
        <div class="layui-col-md12"  style="padding-left: 20px;padding-right: 20px">
            <div class="layui-card">
                <div class="layui-card-header" style="background: rgb(173,145,108);font-size: 18px;color: white;">
                    专家信息登记表(历史登记记录)
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108)" onclick="location.reload()" title="刷新" style=""><i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="font-size: 18px;float:right;background:rgb(173,145,108);line-height: 40px;height: 100%;background:rgb(121,155,154);border:1px solid white;" href="javascript:history.go(-1)" title="刷新" style="">返回上一页</a>
                </div>
                <?php 
                    foreach($list as $key=>$value){ ?>


                
                <div class="layui-card-body ">
                    <table class="layui-table" style=" width:100%;">
                        <tbody>
                            <tr>
                                <td colspan="3" style="font-weight: bold;">专家信息登记表(基础表)</td>
                                <td style="font-weight: bold;">编号：<?= $value['number']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">姓    名 </td> 
                                <td><?= $value['name']; ?></td>
                                <td style="font-weight: bold;">性    别  </td> 
                                <td><?php 
                                switch ($value['sex']) {
                                    case '1':echo "男";break;
                                    case '2':echo "女";break;
                                    default:echo "未知";break;
                                }
                                ?>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">国    籍 </td> 
                                <td><?= $value['nationality']; ?></td>
                                <td style="font-weight: bold;">民    族 </td> 
                                <td><?= $value['nation']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">政治面貌</td> 
                                <td><?= $value['face']; ?></td>
                                <td style="font-weight: bold;">出生年月</td> 
                                <td><?= $value['birthday']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">证件类型</td> 
                                <td><?= $value['type']; ?></td>
                                <td style="font-weight: bold;">证件号码</td> 
                                <td><?= $value['certificates']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">手    机</td> 
                                <td><?= $value['phone']; ?></td>
                                <td style="font-weight: bold;">固定电话</td> 
                                <td><?= $value['telephone']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">电子邮箱</td> 
                                <td><?= $value['email']; ?></td>
                                <td style="font-weight: bold;">微 信 号</td> 
                                <td><?= $value['wx']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">工作单位</td> 
                                <td><?= $value['work_unit']; ?></td>
                                <td style="font-weight: bold;">职    务</td> 
                                <td><?= $value['job']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">常 住 地</td> 
                                <td><?= $value['permanent']; ?></td>
                                <td style="font-weight: bold;">技术职称</td> 
                                <td><?= $value['title']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">收件地址</td> 
                                <td colspan="3"><?= $value['address']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">最后毕业院校</td> 
                                <td><?= $value['school']; ?></td>
                                <td style="font-weight: bold;">毕业时间</td> 
                                <td><?= $value['school_time']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">所学专业</td> 
                                <td><?= $value['major']; ?></td>
                                <td style="font-weight: bold;">最高学历</td> 
                                <td><?= $value['education']; ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">专业领域</td> 
                                <td colspan="3"><?= $value['fields']; ?></td>
                            </tr>
                            <?php $work = explode(';', $value['experience']); $worknum = count($work);?>
                            <tr>
                                <td rowspan="<?= $worknum+1; ?>" style="font-weight: bold;">工作经历</td>
                                <td style="font-weight: bold;">起止时间</td>
                                <td style="font-weight: bold;">工作单位</td>
                                <td style="font-weight: bold;">职   务</td>
                            </tr>
                            <?php foreach ($work as $wk => $wv) { ?>
                            <tr>
                                <?php $wx_array = explode("|", $wv); ?>
                                <td><?= @$wx_array[0]; ?></td>
                                <td><?= @$wx_array[1]; ?></td>
                                <td><?= @$wx_array[2]; ?></td>
                            </tr>   
                            <?php } ?>
                            
                            <tr>
                                <td style="font-weight: bold;">主要成就：<br>（1）著作<br>（2）重大课题<br>（3）个展或参展</td>
                                <td colspan="3">
                                    <?php 
                                    $order=array("\r\n","\n","\r");
                                    $replace='<br/>';
                                    echo str_replace($order,$replace,$value['achievement']); ?>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">主要作品:<br>（收藏机构）</td>
                                <td colspan="3">
                                    <?php echo str_replace($order,$replace,$value['opus']); ?>
                                </td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">其他</td>
                                <td colspan="3"><?php echo str_replace($order,$replace,$value['other']); ?></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">近期照片</td>
                                <td colspan="3"><img src="<?= $value['simg']; ?>" style="width: 150px;"></td>
                            </tr>
                        </tbody>
                    </table>

                    
                </div>

                <?php    }
                ?>
            </div>
          
       
        </div>
    </body>
    <script type="text/javascript">
    </script>
</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>