<!DOCTYPE html>
<html class="x-admin-sm">
    
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script type="text/javascript" src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
        <!--[if lt IE 9]>
            <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
            <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
       <style type="text/css">
         .layui-form-label{
              width: 200px;
            }
       </style>
    </head>
    <body>
        <div class="layui-fluid">
            <div class="layui-row">
                <form class="layui-form" method="post">
                  <div class="layui-form-item">
                      <label for="username" class="layui-form-label">
                          <span class="x-red">*</span>标题
                      </label>
                      <div class="layui-input-inline">
                          <input id="title" type="text" id="unit_name" name="unit_name" required="" lay-verify="required"
                          autocomplete="off" class="layui-input">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          <span class="x-red">*</span>
                      </div>
                  </div>
                  <div class="layui-form-item layui-form-text">
                    <label for="desc" class="layui-form-label">描述</label>
                    <div class="layui-input-inline">
                          <textarea name="content" id="content" cols="60" rows="10" class="layui-textarea"  required=""></textarea>
                      </div>
                  </div>
                  <div class="layui-form-item">
                      <label for="L_repass" class="layui-form-label">
                      </label>
                      <!-- <input class="layui-btn" type="button" value="&nbsp;&nbsp;提交&nbsp;&nbsp;" onclick="save();"> -->
                      <button  class="layui-btn layui-btn-normal" lay-filter="add" lay-submit="" style="background:rgb(173,145,108);border-radius: 5px">
                          提交
                      </button>
                  </div>
              </form>
            </div>
        </div>
        <script>layui.use(['laydate','form', 'layer'],
              function() {
                $ = layui.jquery;
                var form = layui.form,
                layer = layui.layer;
                // var laydate = layui.laydate;
                // laydate.render({
                //     elem: '#expect_end_time' //指定元素
                // });
                //自定义验证规则
                form.verify({
                    nikename: function(value) {
                        if (value.length < 5) {
                            return '昵称至少得5个字符啊';
                        }
                    },
                    pass: [/(.+){6,12}$/, '密码必须6到12位'],
                    repass: function(value) {
                        if ($('#L_pass').val() != $('#L_repass').val()) {
                            return '两次密码不一致';
                        }
                    }
                });
                
                // alert(index);
                form.on('submit(add)',
                function(data) {
                    var title=$("#title").val();
                    var content=$("#content").val();
                      $.ajax({
                          type:'post',
                          url:'/admin/index/notice_add',
                          dataType:'json',
                          data:{title:title,content:content},
                          success:function(data){
                              if(data.code=='1'){
                                code = 1;
                                var index = parent.layer.getFrameIndex(window.name);
                                window.parent.location.reload();//刷新父页面
                                parent.layer.close(index);//关闭弹出层
                              }else{
                                alert("添加失败");
                              }
                          },
                      })
                      
                });

          })


          </script>
       
    </body>

</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>
