<!DOCTYPE html>
<html class="x-admin-sm">
    
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script type="text/javascript" src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
        <!--[if lt IE 9]>
            <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
            <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
       
    </head>
    <body>
        <div class="layui-fluid">
            <div class="layui-row">
                <form class="layui-form" method="post">
                  <div class="layui-form-item">
                      <label for="username" class="layui-form-label">
                          <span class="x-red">*</span>角色名：
                      </label>
                      <div class="layui-input-inline">
                          <input type="text" id="role_name" name="role_name" required="" lay-verify="required"
                          autocomplete="off" class="layui-input">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          <span class="x-red">*</span>
                      </div>
                  </div>
                  
                  <div class="layui-form-item">
                        <label for="username" class="layui-form-label">
                            <span class="x-red">*</span>所属角色：</label>
                        <div class="layui-input-inline">
                            <select name="object_id" id='object_id'>
                                 <?php
                                  foreach ($object as $kk=>$vv){
                                      ?>
                                      <option value="<?= $vv['id']?>"><?= $vv['object_name']?></option>
                                      <?php
                                  } ?>
                            </select>
                        </div>
                    </div>
                    
                    <input type="hidden" name="type" id="type" value="<?= $type?>">
                  <div class="layui-form-item">
                      <label for="L_repass" class="layui-form-label">
                      </label>
                      <!-- <input class="layui-btn" type="button" value="&nbsp;&nbsp;提交&nbsp;&nbsp;" onclick="save();"> -->
                      <button  class="layui-btn layui-btn-normal" lay-filter="add" lay-submit="">
                      提交
                      </button>
                  </div>
              </form>
            </div>
        </div>
        <script>layui.use(['form', 'layer'],
            function() {
                $ = layui.jquery;
                var form = layui.form,
                layer = layui.layer;

                //自定义验证规则
                form.verify({
                    nikename: function(value) {
                        if (value.length < 5) {
                            return '昵称至少得5个字符啊';
                        }
                    },
                    pass: [/(.+){6,12}$/, '密码必须6到12位'],
                    repass: function(value) {
                        if ($('#L_pass').val() != $('#L_repass').val()) {
                            return '两次密码不一致';
                        }
                    }
                });
                form.on('submit(add)',
                function(data) {
                    var role_name=$("#role_name").val();
                    var object=$("select").val();
                    var object_id='';
                    for(i=0;i<object.length;i++){
                        if(i!=0){
                            object_id=object_id+','+object[i];
                        }else{
                            object_id=object[i];
                        }

                    }
                      $.ajax({
                          type:'post',
                          url:'/admin/admin/add-roles',
                          dataType:'json',
                          data:{role_name:role_name,object_id:object_id},
                          success:function(data){
                              if(data.code=='1'){
                                code = 1;
                                var index = parent.layer.getFrameIndex(window.name);
                                window.parent.location.reload();//刷新父页面
                                parent.layer.close(index);//关闭弹出层
                              }else{
                                alert("添加失败");
                              }
                          },
                      })
                      // layer.alert("增加成功", {
                      //     icon: 6
                      // },
                      // function() {
                      //     //关闭当前frame
                      //     xadmin.close();

                      //     // 可以对父窗口进行刷新 
                      //     xadmin.father_reload();
                      // });
                });


            });


          </script>
       
    </body>

</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>
