<!DOCTYPE html>
<html class="x-admin-sm">
    
    <head>
        <meta charset="UTF-8">
        <title>北京公共空间艺术品数字化信息系统</title>
        <meta name="renderer" content="webkit">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=yes, minimum-scale=0.4, initial-scale=0.8,target-densitydpi=low-dpi" />
        <link rel="stylesheet" href="/X-admin/css/font.css">
        <link rel="stylesheet" href="/X-admin/css/xadmin.css">
        <script type="text/javascript" src="/X-admin/lib/layui/layui.js" charset="utf-8"></script>
        <script type="text/javascript" src="/X-admin/js/xadmin.js"></script>
        <!-- 让IE8/9支持媒体查询，从而兼容栅格 -->
        <!--[if lt IE 9]>
            <script src="https://cdn.staticfile.org/html5shiv/r29/html5.min.js"></script>
            <script src="https://cdn.staticfile.org/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->
        <style type="text/css">
          .layui-card-header{
                    background-color: #f2f2f2;
            }
            .layui-btn{
                border-radius: 10px;
            }
            .delinfo{
              background: rgb(107,168,212);
              padding-left:5px;
              padding-right:5px;
              color:white;
              width: 150px;
              text-align: center;
            }
            .layui-form-radio *{
              font-size: 18px
            }
            .layui-form-item .layui-input-inline{
              width: 500px
            }
            .layui-form-label{
              width: 200px;
            }
        </style>
    </head>
    <body>
      <div class="x-nav" style="background: none;border:0px;height: 0px"></div>
      <div class="layui-fluid" style="padding-left: 20px;padding-right: 20px">
          <div class="layui-card-header" style="background: rgb(173,145,108);font-size: 18px;color: white;position: fixed;top: 10px;right:0px;z-index: 999;width: 98%">
                    添加用户
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="line-height:1.6em;margin-top:3px;float:right;background:rgb(173,145,108)" onclick="location.reload()" title="刷新" style=""><i class="layui-icon layui-icon-refresh" style="line-height:35px"></i></a>
                    <a class="layui-btn layui-btn-small layui-btn-normal" style="font-size: 18px;float:right;background:rgb(173,145,108);line-height: 40px;height: 100%;background:rgb(121,155,154);border:1px solid white;" href="/admin/admin/admin-list" title="刷新" style="">返回上一页</a>
                </div>
            <div class="layui-row" style="margin-top:55px">
                <form class="layui-form" method="post" action="/admin/admin/add-admins">
                  <div class="layui-form-item">
                      <label for="username" class="layui-form-label">
                          <span class="x-red">*</span>用户名
                      </label>
                      <div class="layui-input-inline">
                          <input type="text" id="name" name="name" required="" lay-verify="required"
                          autocomplete="off" class="layui-input">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          <span class="x-red">*</span>
                      </div>
                  </div>
                  <div class="layui-form-item">
                      <label for="phone" class="layui-form-label">
                          <span class="x-red">*</span>手机
                      </label>
                      <div class="layui-input-inline">
                          <input type="text" id="mobile" name="mobile" required="" lay-verify="phone"
                          autocomplete="off" class="layui-input">
                      </div>
                  </div>
                  <div class="layui-form-item">
                      <label for="L_pass" class="layui-form-label">
                          <span class="x-red">*</span>密码
                      </label>
                      <div class="layui-input-inline">
                          <input type="password" id="pwd" name="pwd" required="" lay-verify="pass"
                          autocomplete="off" class="layui-input">
                      </div>
                      <div class="layui-form-mid layui-word-aux">
                          6到16个字符
                      </div>
                  </div>
                  <div class="layui-form-item">
                    <label for="username" class="layui-form-label">
                        <span class="x-red">*</span>级别</label>
                    <div class="layui-input-inline">
                      <select name="level" id='level' lay-filter="level">
                        <!-- 判断用户级别 -->
                        <?php 
                        $session = Yii::$app->session;
                        echo $session['role_level'];
                        switch ($session['role_level']) {
                          case '0':
                            echo '<option value="">请选择</option>
                            <option value="1">市</option>
                            <option value="2">区</option>
                            <option value="3">乡、镇街道工作人员</option>
                            <option value="4">乡、镇街道工作人员</option>';
                            break;
                          case '1':
                            echo '<option value="">请选择</option>
                            <option value="1">市</option>
                            <option value="2">区</option>
                            <option value="3">乡、镇街道工作人员</option>
                            <option value="4">乡、镇街道工作人员</option>';
                            break;
                          case '2':
                            echo '<option value="">请选择</option>
                            <option value="3">乡、镇街道工作人员</option>
                            <option value="4">乡、镇街道工作人员</option>';
                            break;
                          case '3':
                            echo '<option value="">请选择</option>
                            <option value="4">乡、镇街道工作人员</option>';
                            break;
                          default:
                            # code...
                            break;
                        }
                        ?>
<!--                         <option value="">请选择</option>
                        <option value="1">市</option>
                        <option value="2">区</option>
                        <option value="3">乡/镇</option>
                        <option value="4">街道</option> -->
                      </select>
                    </div>
                  </div>
                  <div class="layui-form-item">
                    <label for="username" class="layui-form-label">
                        <span class="x-red">*</span>上级</label>
                    <div class="layui-input-inline">
                      <select name="parent" id='parent' lay-filter="parent">
                     
                      </select>
                    </div>
                  </div>
                    <div class="layui-form-item">
                        <label for="username" class="layui-form-label">
                            <span class="x-red">*</span>选择负责区域：</label>
                        <div class="layui-input-inline">
                            <select name="jurisdiction" id='jurisdiction'>
                            </select>
                        </div>
                    </div>
                  <div class="layui-form-item">
                      <label for="L_repass" class="layui-form-label">
                      </label>
                      <input class="layui-btn" type="submit" style=" background: rgb(191,5,14);height: 90%;width: 200px;" value="&nbsp;&nbsp;提交&nbsp;&nbsp;">
                    <!--   <button  class="layui-btn layui-btn-normal" lay-submit="" style="background:rgb(173,145,108);border-radius: 5px">
                          增加
                      </button> -->
                  </div>
              </form>
            </div>
        </div>
        <script>
          layui.use(['form', 'layer'],
            function() {
                $ = layui.jquery;
                var form = layui.form,
                layer = layui.layer;

                //自定义验证规则
                form.verify({
                    nikename: function(value) {
                        if (value.length < 5) {
                            return '昵称至少得5个字符啊';
                        }
                    },
                    pass: [/(.+){6,12}$/, '密码必须6到12位'],
                    repass: function(value) {
                        if ($('#L_pass').val() != $('#L_repass').val()) {
                            return '两次密码不一致';
                        }
                    }
                });

                form.on('select(level)', function(data){
                  var areaId=data.elem.value;
                  $.ajax({
                      type: 'POST',
                      url: "/admin/index/getparent",
                      data: {level:areaId},
                      dataType:  'json',
                      success:function(e){
                          console.log(e.data);
                          //empty() 方法从被选元素移除所有内容
                          $("select[name='parent']").empty();
                          var html = "<option value=''>请选择</option>";
                          $(e.data).each(function (v, k) {
                              html += "<option value='" + k.id + "'>" + k.username + "</option>";
                          });
                          // console.log(html)
                          //把遍历的数据放到select表里面
                          $("select[name='parent']").append(html);
                          //从新刷新了一下下拉框
                          form.render('select');      //重新渲染
                      }
                  });
                })
                form.on('select(parent)', function(data){
                  var areaId=data.elem.value;
                  $.ajax({
                      type: 'POST',
                      url: "/admin/index/getparentqy",
                      data: {qy:areaId},
                      dataType:  'json',
                      success:function(e){
                          // console.log(e.data);
                          //empty() 方法从被选元素移除所有内容
                          $("select[name='jurisdiction']").empty();
                          var html = "<option value=''>请选择</option>";
                          $(e.data).each(function (v, k) {
                              html += "<option value='" + k.street + "'>" + k.street + "</option>";
                          });
                          // console.log(html)
                          //把遍历的数据放到select表里面
                          $("select[name='jurisdiction']").append(html);
                          //从新刷新了一下下拉框
                          form.render('select');      //重新渲染
                      }
                  });
                })

                // form.on('submit(add)',
                // function(data) {
                //     var name=$("#name").val();
                //     var mobile=$("#mobile").val();
                //     var pwd=$("#pwd").val();
                //     var jurisdiction=$(".layui-this").text();
                //     var parents=$(".layui-this").attr("lay-value");
                //     console.log(jurisdiction);
                //     console.log(parents);
                    // $.ajax({
                    //     type:'post',
                    //     url:'/admin/admin/add-adminsss',
                    //     dataType:'json',
                    //     data:{name:name,mobile:mobile,pwd:pwd,jurisdiction:jurisdiction,parent:parents},
                    //     success:function(data){
                    //         if(data.code=='1'){
                    //             code = 1;
                    //             var index = parent.layer.getFrameIndex(window.name);
                    //             window.parent.location.reload();//刷新父页面
                    //             parent.layer.close(index);//关闭弹出层
                    //           }else{
                    //             alert("添加失败");
                    //           }
                    //     },
                    // })
                      
                // });

                


            });

            // function save(){
            // var name=$("#name").val();
            // var mobile=$("#mobile").val();
            // var pwd=$("#pwd").val();
            // var jurisdiction=$(".layui-this").text();
            // var parent=$(".layui-this").attr("lay-value");
            // // var jurisdiction=$("#jurisdiction option::selected").text();
     
            // $.ajax({
            //     type:'post',
            //     url:'/admin/admin/add-admins',
            //     dataType:'json',
            //     data:{name:name,mobile:mobile,pwd:pwd,jurisdiction:jurisdiction,parent:parent},
            //     success:function(data){
            //         if(data.code=='1'){
            //             var index = parent.layer.getFrameIndex(window.name);
            //             layer.msg('已提交',{time:1000});
            //             parent.location.reload();
            //             window.location.reload('/admin/admin/adms');
            //             parent.layer.close(index);
            //         }else{
            //             layer.msg("'"+data.msg+"'",{time:1000});
            //         }
            //     },
            //     error:function(data){
            //         console.log(data.msg)
            //     }
            // })
            // }

          </script>
       
    </body>

</html>
<?php echo $this->renderFile('@app/views/admin/beian.php'); ?>
