<?php
/**
 * Created by PhpStorm.
 * User: shangpeng
 * Date: 2019/2/21
 * Time: 上午8:59
 */
namespace app\utils;
class RsaCommon
{
    private static $pubKey = '';
    private static $priKey = '';

    /**
     * @param $pathPubKey
     * @param $data
     * @return string
     * pub key enc
     * 公钥加密
     */
    public static function encryptPub($pathPubKey, $data )
    {
        self::$pubKey = openssl_pkey_get_public(file_get_contents($pathPubKey));
        openssl_public_encrypt($data, $encode_data,self::$pubKey);
        return base64_encode($encode_data);
    }

    /**
     * @param $pathPriKey
     * @param $data
     * @return string
     * pri key enc
     * 私钥加密
     */
    public static function encryptPri($pathPriKey, $data )
    {
        self::$priKey = openssl_pkey_get_private(file_get_contents($pathPriKey));
        openssl_private_encrypt($data, $encode_data,self::$priKey);
        return base64_encode($encode_data);
    }

    /**
     * @param $pathPubKey
     * @param $data
     * @return string
     * pri key enc
     * 公钥解密
     */
    public static function decryptPub($pathPubKey,$data)
    {
        self::$pubKey = openssl_pkey_get_public(file_get_contents($pathPubKey));
        $decrypted = '';
        $encrypted = base64_decode($data);
        openssl_public_decrypt($encrypted, $decrypted, self::$pubKey);
        return $decrypted;
    }

    /**
     * @param $pathPriKey
     * @param $data
     * @return string
     * pri key enc
     * 私钥解密
     */
    public static function decryptPri($pathPriKey,$data)
    {
        self::$priKey = openssl_pkey_get_private(file_get_contents($pathPriKey));
        $decrypted = '';
        $encrypted = base64_decode($data);
        openssl_private_decrypt($encrypted, $decrypted, self::$priKey);
        var_dump($decrypted);die;
        return $decrypted;
    }
}