<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */
namespace app\models;

use Yii;
use yii\base\Model;

class DbWork extends Model
{
    public function __construct(array $config = [])
    {
        parent::__construct($config);
    }


    /**
     * @param $table
     * @param array $data
     * @param array $where
     * @return int
     * 更新操作
     */
    public static function update($table, array $data , array $where)
    {
        return Yii::$app->db->createCommand()->update($table, $data, $where)->execute();
    }

    /**
     * @return \yii\db\Transaction
     *
     */
    public static function startTrans()
    {
        return Yii::$app->db->beginTransaction();
    }

    /**
     * @param $table
     * @param array $data
     * @return int PrimaryKey
     * 保存数据
     */
    public static function save($table, array $data)
    {
        $res = Yii::$app->db->createCommand()->insert($table, $data)->execute();
        if($res){
            return self::getLastId();
        }
        return false;
    }

    /**
     * @param $table
     * @param mixed $fieds
     * @param array $where
     * @return array|bool
     * 获取单行数据
     */
    public static function getRow( $table, $fieds, array $where , $orderby = '')
    {
        $query = new \yii\db\Query();
        if(!empty($orderby)){
            $query -> orderBy($orderby);
        }
        return $query->select($fieds)->from($table)->where($where)->limit(1)->one();
    }

    /**
     * @param $table
     * @param mixed $fieds
     * @param array $where
     * @param null $limit
     * @return array
     * 获取多行数据
     */
    public static function getAll( $table,$fieds, array $where , $limit = null, $orderby = [])
    {
        $query = new \yii\db\Query();
        if(!empty($orderby)){
            $query -> orderBy($orderby);
        }
        $res = $query->select($fieds)->from($table)->where($where)->limit($limit)->all();

        //$commandQuery = clone $query;
        //echo $commandQuery->createCommand()->getRawSql();die;

        return $res;
    }

    /**
     * @param array $where
     * @return int
     * 删除数据
     */
    public static function delete($table,array $where)
    {
        return Yii::$app->db->createCommand()->delete($table, $where)->execute();
    }

    /**
     * @return string
     *
     */
    public static function getLastId()
    {
        return Yii::$app->db->getLastInsertId();
    }

    public static function queryAll($sql)
    {
        return Yii::$app->db->createCommand($sql)->queryAll();
    }

    public static function queryOne($sql)
    {
        return Yii::$app->db->createCommand($sql)->queryOne();
    }

}
