<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */

namespace app\models;


use yii\base\Model;

class AuthControl extends Model
{
    public function __construct(array $config = [])
    {
        parent::__construct($config);
    }

    /**
     * @param $route
     * @param $session
     * @return bool
     * 检查权限
     */
    public static function checkAuth($route, $session)
    {

        $role = DbWork::getRow('admin_role','*',['admin_id'=> $session['admin_id']]);
        if(!$role){
            return false;
        }
        $object = DbWork::getAll('role_object','*',['role_id'=> $role['role_id']]);
        $object_url = array_column($object,'object_url');
        if(in_array(strtolower('/'.$route), $object_url,true)){
           return true;
        }
        return false;
    }
}