<?php

namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;
use yii\web\request;


class VisualizeController extends BaseController
{
    // 按照尺寸或属性进行统计分析
    public function Visualize_size($qu = '')
    {
        $query = (new \yii\db\Query())
            ->select('type,count(*) as num')
            ->groupBy("type")
            ->from("sculpture");    
        $query->andWhere(['del' => 0]);  
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        }
        $arr = $query->all();      
        foreach ($arr as $key => $value) {
            $crr['value'] = $value['num'];
            switch ($value['type']) {
                case '1':
                    $crr['name'] ="圆雕";
                    break;
                case '2':
                    $crr['name'] ="浮雕";
                    break;
                case '3':
                    $crr['name'] ="壁画";
                    break;
                case '4':
                    $crr['name'] ="塑像";
                    break;
                default:
                    $crr['name'] ="不详";
                    break;
            }
            
            $json_arr[] = $crr;
        }
        $json = json_encode($json_arr);
        return $json;
    }
    // 按照城区进行统计
    public function Visualize_district()
    {
        $query = (new \yii\db\Query())
            ->select('district,count(district)')
            ->groupBy("district")
            ->from("sculpture");    
        $query->andWhere(['del' => 0]);  
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(district)",'desc');
        foreach ($arr as $key => $value) {
            $arr['value'] = $value['count(district)'];
            $arr['name'] = $value['district'];
            $json_arr[] = $arr;
        }
        $json = json_encode($json_arr);
        return $json;
    }
    // 按照公开情况统计
    public function Visualize_show(){
        $query = (new \yii\db\Query())
            ->select('is_show,count(is_show)')
            ->groupBy("is_show")
            ->from("sculpture");    
        $query->andWhere(['del' => 0]);  
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(is_show)",'desc');
        foreach ($arr as $key => $value) {
            $arr['value'] = $value['count(is_show)'];
            switch ($value['is_show']) {
                case '1':
                    $arr['name'] ="公开";
                    break;
                default:
                    $arr['name'] ="不公开";
                    break;
            }
            
            $json_arr[] = $arr;
        }
        $json = json_encode($json_arr);
        return $json;
    }
    // 按照摆放环境统计
    public function Visualize_environment($qu =''){
        $query = (new \yii\db\Query())
            ->select('put_location,count(put_location)')
            ->groupBy("put_location")
            ->from("sculpture");  
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        }  
        $query->andWhere(['del' => 0]);  
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(put_location)",'desc');
        foreach ($arr as $key => $value) {
            $arr['value'] = $value['count(put_location)'];
            $arr['name'] = $value['put_location'];
            $json_arr[] = $arr;
        }
        $json = json_encode($json_arr);
        return $json;
    }
    // 按照各区审核情况统计
    public function Visualize_status(){
        // $query = (new \yii\db\Query())
        //     ->select('qu_status,count(qu_status)')
        //     ->groupBy("qu_status")
        //     ->from("sculpture");    
         

        $query = (new \yii\db\Query())
                ->select('sculpture_sub.status,count(sculpture_sub.status)')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->groupBy("sculpture_sub.status")
                ->from("sculpture");
        $query->andWhere(['sculpture.del' => 0]); 
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(sculpture_sub.status)",'desc');
        foreach ($arr as $key => $value) {
            $arr['value'] = $value['count(sculpture_sub.status)'];
            switch ($value['status']) {
                case '1':
                    $arr['name'] ="审核通过";
                    break;
                case '2':
                    $arr['name'] ="审核未通过";
                    break;
                default:
                    $arr['name'] ="未审核";
                    break;
            }
            $json_arr[] = $arr;
        }
        $json = json_encode($json_arr);
        return $json;
    }
    // 按照材质统计
    public function Visualize_material($qu =''){
        $query = (new \yii\db\Query())
            ->select('material,count(material)')
            ->groupBy("material")
            ->from("sculpture");    
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        }
        $query->andWhere(['del' => 0]);  
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(material)",'asc'); 
        foreach ($arr as $key => $value) {
            $arr[$key]['material'] = self::arr_order($value['material']);
        }
        $zrr = array();
        $result= array();
        foreach ($arr as $key => $info) {
            $result[$info['material']][] = $info;
        } 
        foreach ($result as $key => $value) {
            $crr['name'] = $value[0]['material'];
            $crr['value'] = 0;
            foreach ($value as $k => $v) {
               $crr['value'] +=$v['count(material)'];
            }
            $zrr[] = $crr;
        }
        $zrr = json_encode($zrr);
        return $zrr;
    }
    // 按照工艺划分
    public function Visualize_technology($qu =''){
        $query = (new \yii\db\Query())
            ->select('technology,count(technology)')
            ->groupBy("technology")
            ->from("sculpture");    
        $query->andWhere(['del' => 0]); 
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        } 
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(technology)",'asc'); 
        foreach ($arr as $key => $value) {
            $arr[$key]['technology'] = self::arr_order($value['technology']);
        }
        $zrr = array();
        $result= array();
        foreach ($arr as $key => $info) {
            $result[$info['technology']][] = $info;
        } 
        foreach ($result as $key => $value) {
            $crr['name'] = $value[0]['technology'];
            $crr['value'] = 0;
            foreach ($value as $k => $v) {
               $crr['value'] +=$v['count(technology)'];
            }
            $zrr[] = $crr;
        }
        $zrr = json_encode($zrr);
        return $zrr;
    }
    // 按照外观划分
    public function Visualize_outward($qu =''){
        $query = (new \yii\db\Query())
            ->select('outward,count(outward)')
            ->groupBy("outward")
            ->from("sculpture");    
        $query->andWhere(['del' => 0]);  
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        }
        $arr = $query->all();
        $arr = self::arraySort($arr,"count(outward)",'asc'); 
        foreach ($arr as $key => $value) {
            $arr[$key]['outward'] = self::arr_order($value['outward']);
        }
        $zrr = array();
        $result= array();
        foreach ($arr as $key => $info) {
            $result[$info['outward']][] = $info;
        } 
        foreach ($result as $key => $value) {
            $crr['name'] = $value[0]['outward'];
            $crr['value'] = 0;
            foreach ($value as $k => $v) {
               $crr['value'] +=$v['count(outward)'];
            }
            $zrr[] = $crr;
        }
        $zrr = json_encode($zrr);
        return $zrr;
    }
    public function Visualize_sizes($num,$qu = '',$type=''){
        $query = (new \yii\db\Query())
            ->select('model,count(*)')
            ->groupBy("model")
            ->from("sculpture");  
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        }
        if($type !=''){
            switch ($type) {
                case '圆雕':
                    $query->andWhere(['type' => 1]);  
                    break;
                case '浮雕':
                    $query->andWhere(['type' => 2]);  
                    break;
                case '壁画':
                    $query->andWhere(['type' => 3]);  
                    break;
                case '塑像':
                    $query->andWhere(['type' => 4]);  
                    break;
                default:
                    # code...
                    break;
            }
            
        }
        $query->andWhere(['del' => 0]);  
        $arr = $query->all();
        $json = array(
            array('name'=>"特大型","value"=>0),
            array('name'=>"大型","value"=>0),
            array('name'=>"中型","value"=>0),
            array('name'=>"小型","value"=>0)
        );
        foreach ($arr as $key => $value) {
            if($value['model'] == 0){
                $json[3]['value'] = (int)$value['count(*)'];
            }
            if($value['model'] == 1){
                $json[2]['value'] = (int)$value['count(*)'];
            }
            if($value['model'] == 2){
                $json[1]['value'] = (int)$value['count(*)'];
            }
            if($value['model'] == 3){
                $json[0]['value'] = (int)$value['count(*)'];
            }
        }
        $json = json_encode($json);
        return $json;
    }
    public function Visualize_level($num,$qu = '',$type=''){

        $query = (new \yii\db\Query())
            ->select('dismantle')
            ->from("sculpture");    
        $query->andWhere(['del' => 0]); 
        if($qu !=''){
            $query->andWhere(['district' => $qu]);  
        } 
        $query->andWhere(['dismantle'=>'1']);
        // $query = (new \yii\db\Query())
        //     ->select('sculpture.id')
        //     ->leftJoin('sculpture_attach', 'sculpture.id  = sculpture_attach.sid')
        //     ->from("sculpture");    
        // $query->andWhere(['sculpture.del' => 0]); 
        // $query->andWhere(['sculpture_attach.level'=>'1']);
        // if($qu !=''){
        //     $query->andWhere(['sculpture.district' => $qu]);  
        // }
        $arr = $query->count();
        $zrr = array();
        $chai['name'] = '是';
        $chai['value'] = (int)$arr;
        $chais['name'] = '否';
        $chais['value'] = $num-(int)$arr;
        $zrr[] = $chai;
        $zrr[] = $chais;
        // foreach ($result as $key => $value) {
        //     $crr['name'] = $value[0]['technology'];
        //     $crr['value'] = 0;
        //     foreach ($value as $k => $v) {
        //        $crr['value'] +=$v['count(technology)'];
        //     }
        //     $zrr[] = $crr;
        // }
        $zrr = json_encode($zrr);
        return $zrr;
    }
    public function arr_order($str){
        $str_arr = explode(',',$str);
        asort($str_arr);
        $strs = implode(',',$str_arr);
        return $strs;
    }
    // 数据总览
    public function actionIndex()
    {
        $num =  (new \yii\db\Query())
            ->from('sculpture')
            ->where(['del' => '0'])
            ->count();
        $sizes_yd = self::Visualize_sizes($num,'','圆雕');
        $sizes_bh = self::Visualize_sizes($num,'','壁画');
        $sizes_fd = self::Visualize_sizes($num,'','浮雕');
        $sizes_sx = self::Visualize_sizes($num,'','塑像');
        $district_json = self::Visualize_district($num);
        $level_json = self::Visualize_level($num);
        $size_json = self::Visualize_size();
        $show_json = self::Visualize_show();
        $environment_json = self::Visualize_environment();
        $status_json = self::Visualize_status();
        $material_json = self::Visualize_material();
        $technology_json = self::Visualize_technology();
        $outward_json = self::Visualize_outward();
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        return $this->renderPartial('/admin/visualize',["district_json"=>$district_json,'num'=>$num,"size_json"=>$size_json,"show_json"=>$show_json,"environment_json"=>$environment_json,"status_json"=>$status_json,"material_json"=>$material_json,"technology_json"=>$technology_json,"outward_json"=>$outward_json,"district"=>$district,"sizes_yd"=>$sizes_yd,"district"=>$district,"sizes_bh"=>$sizes_bh,"sizes_fd"=>$sizes_fd,"sizes_sx"=>$sizes_sx,"level_json"=>$level_json]);
    }
    public function actionDistrict()
    {
        $qu = empty($this->_GETDATA['qu']) ? '' :$this->_GETDATA['qu']; 
        $num =  (new \yii\db\Query())
            ->from('sculpture')
            ->where(['del' => '0'])
            ->andWhere(['district' => $qu])
            ->count();
        $sizes_yd = self::Visualize_sizes($num,$qu,'圆雕');
        $sizes_bh = self::Visualize_sizes($num,$qu,'壁画');
        $sizes_fd = self::Visualize_sizes($num,$qu,'浮雕');
        $sizes_sx = self::Visualize_sizes($num,$qu,'塑像');
        $level_json = self::Visualize_level($num,$qu);
        $size_json = self::Visualize_size($qu);
        $environment_json = self::Visualize_environment($qu);
        $material_json = self::Visualize_material($qu);
        $technology_json = self::Visualize_technology($qu);
        $outward_json = self::Visualize_outward($qu);
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        foreach ($district as $key => $value) {
            if($key<17){
                unset($district[$key]);
            }
        }
        $dis_arr = array(array("district"=>"东城区"),array("district"=>"西城区"),array("district"=>"朝阳区"),array("district"=>"海淀区"),array("district"=>"丰台区"),array("district"=>"石景山区"),array("district"=>"门头沟区"),array("district"=>"房山区"),array("district"=>"通州区"),array("district"=>"顺义区"),array("district"=>"大兴区"),array("district"=>"昌平区"),array("district"=>"平谷区"),array("district"=>"密云区"),array("district"=>"延庆区"),array("district"=>"亦庄开发区"));
        $district = array_merge($dis_arr,$district);
        return $this->renderPartial('/admin/visualizes',['num'=>$num,"size_json"=>$size_json,"environment_json"=>$environment_json,"material_json"=>$material_json,"technology_json"=>$technology_json,"outward_json"=>$outward_json,"sizes_yd"=>$sizes_yd,"district"=>$district,"sizes_bh"=>$sizes_bh,"sizes_fd"=>$sizes_fd,"sizes_sx"=>$sizes_sx,"level_json"=>$level_json]);
    }
    function arraySort($array,$keys,$sort='asc') {
        $newArr = $valArr = array();
        foreach ($array as $key=>$value) {
            $valArr[$key] = $value[$keys];
        }
        ($sort == 'asc') ?  asort($valArr) : arsort($valArr);
        reset($valArr);
        foreach($valArr as $key=>$value) {
            $newArr[$key] = $array[$key];
        }
        return $newArr;
    }
}