<?php
namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;
use yii\web\UploadedFile;


class UserController extends BaseController
{
    // 人员管理 街道添加基层用户
    public function actionUser()
    {
        $query = (new \yii\db\Query())
            ->select('adminrole.admin_id,adminrole.parent,admin.username,admin.mobile,admin.create_time,admin.pwd')
            ->leftJoin('admin', 'adminrole.admin_id  = admin.id')
            ->from("adminrole");
        $query->andWhere(['adminrole.parent'=>$this->admin_id]);
        $query->andWhere(['admin.status'=>1]);
        $query->orderBy('admin.create_time DESC');
        $list = $query->all();
        return $this->renderPartial('/admin/user',["list"=>$list]);
    }
    // 人员管理 区添加街乡镇用户
    public function actionUsers()
    {
        $query = (new \yii\db\Query())
            ->select('adminrole.admin_id,adminrole.parent,admin.username,admin.mobile,admin.create_time,admin.pwd')
            ->leftJoin('admin', 'adminrole.admin_id  = admin.id')
            ->from("adminrole");
        $query->andWhere(['adminrole.parent'=>$this->admin_id]);
        $query->andWhere(['admin.status'=>1]);
        $query->orderBy('admin.create_time DESC');
        $list = $query->all();
        return $this->renderPartial('/admin/users',["list"=>$list]);
    }
    // 新增人员 
    public function actionUserAdd()
    {
        $pwd = self::GetRandStr();
        return $this->renderPartial('/admin/user_add',['pwd'=>$pwd]);
    }
    // 新增人员  新增街乡镇的
    public function actionUserAdds()
    {
        $pwd = self::GetRandStr();
        return $this->renderPartial('/admin/user_adds',['pwd'=>$pwd]);
    }
    // 新增操作
    public function actionAddUser()
    {
        Yii::getLogger()->log('人员添加',yii\log\Logger::LEVEL_INFO,'admin_log');
        $info = DbWork::getRow('adminrole','jurisdiction',['admin_id'=>$this->admin_id,'level'=>'3']);
        if($info){
            $where = $this->_DATA;
            unset($where['_csrf']);
            $where['password'] = md5($where['pwd']);
            $where['create_time'] = time();
            $res = DbWork::save('admin', $where);
            if($res){
                $err['parent'] = $this->admin_id;
                $err['admin_id'] = $res;
                $err['jurisdiction'] = $info['jurisdiction'];
                $err['level'] = 4;
                $res_s = DbWork::save('adminrole', $err);
                if($res_s){
                    return $this->redirect('/admin/user/user');
                }else{
                    $res = DbWork::delete('admin',['id'=>$res]);
                    echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
                }
            }else{
                echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
            }
        }else{
            echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
        }
    }
    // 新增操作 新增街乡镇
    public function actionAddUsers()
    {
        Yii::getLogger()->log('街乡镇添加',yii\log\Logger::LEVEL_INFO,'admin_log');
        $info = DbWork::getRow('adminrole','jurisdiction',['admin_id'=>$this->admin_id,'level'=>2]);
        if($info){
            $where = $this->_DATA;
            unset($where['_csrf']);
            // 检测街乡镇是否重复
            $street = $where['street'];
            unset($where['street']);
            $is_res = DbWork::getRow('location','*',['district'=>$info['jurisdiction'],'street'=>$street]);
            if($is_res){
                echo "<script>alert('街乡镇已存在'); javascript:history.go(-1)</script>";
                die;
            }else{
                // 创建街道
                $arr['district'] = $info['jurisdiction'];
                $arr['street'] = $street;
                $res_arr = DbWork::save('location', $arr); 
            }
            $where['password'] = md5($where['pwd']);
            $where['create_time'] = time();
            $res = DbWork::save('admin', $where);
            if($res){
                $err['parent'] = $this->admin_id;
                $err['admin_id'] = $res;
                $err['jurisdiction'] = $street;
                $err['level'] = 3;
                $res_s = DbWork::save('adminrole', $err);
                if($res_s){
                    return $this->redirect('/admin/user/users');
                }else{
                    $res = DbWork::delete('admin',['id'=>$res]);
                    echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
                    die;
                }
            }else{
                echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
                die;
            }
        }else{
            echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
            die;
        }
    }
    public function actionEdit()
    {
        $pwd = self::GetRandStr();
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //
        $info = DbWork::getRow('admin','id,username',['id'=>$id]);
        return $this->renderPartial('/admin/user_edit',['pwd'=>$pwd,'info'=>$info]);
    }
    public function actionEditUser()
    {
        Yii::getLogger()->log('人员修改',yii\log\Logger::LEVEL_INFO,'admin_log');
        $where = $this->_DATA;
        unset($where['_csrf']);
        if($where['id']){
            // 检测是否是自己的人员
            $info = DbWork::getRow('adminrole','id',['admin_id'=>$where['id'],'parent'=>$this->admin_id]);
            if($info){
                $user = DbWork::getRow('admin','salt',['id'=>$where['id']]);
                $where['password'] = md5($where['pwd'].$user['salt']);
                $res = DbWork::update('admin',$where,['id'=>$where['id']]);
                return $this->redirect('/admin/user/user');
            }
            echo "<script>alert('添加失败1'); javascript:history.go(-1)</script>";
            die;
        }else{
            echo "<script>alert('添加失败2'); javascript:history.go(-1)</script>";
            die;
        }
    }
    public function actionEdits()
    {
        $pwd = self::GetRandStr();
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //
        $info = DbWork::getRow('admin','id,username',['id'=>$id]);
        return $this->renderPartial('/admin/user_edits',['pwd'=>$pwd,'info'=>$info]);
    }
    public function actionEditUsers()
    {
        Yii::getLogger()->log('人员修改',yii\log\Logger::LEVEL_INFO,'admin_log');
        $where = $this->_DATA;
        unset($where['_csrf']);
        if($where['id']){
            // 检测是否是自己的人员
            $info = DbWork::getRow('adminrole','id',['admin_id'=>$where['id'],'parent'=>$this->admin_id]);
            if($info){
                $user = DbWork::getRow('admin','salt',['id'=>$where['id']]);
                $where['password'] = md5($where['pwd'].$user['salt']);
                $res = DbWork::update('admin',$where,['id'=>$where['id']]);
                return $this->redirect('/admin/user/users');
            }
            echo "<script>alert('添加失败1'); javascript:history.go(-1)</script>";
            die;
        }else{
            echo "<script>alert('添加失败2'); javascript:history.go(-1)</script>";
            die;
        }
    }
    function GetRandStr(){
        $str='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $len=strlen($str)-1;
        $randstr='';
        for($i=0;$i<8;$i++){
        $num=mt_rand(0,$len);
        $randstr .= $str[$num];
        }
        return $randstr;
    }
}