<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 2:16 PM
 */
namespace app\controllers\admin;

use app\models\DbWork;
use app\models\Admin;
use Yii;
use yii\web\rsa;
use yii\web\Controller;
use app\models\VerifyForm;


class LoginController extends BaseController
{
    public $enableCsrfValidation = false;

    public function actions()
    {
        return [
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'maxLength' => 4, //生成的验证码最大长度
                'minLength' => 4,  //生成的验证码最短长度
                //背景颜色
                'backColor' => 0x000000,
                //最大显示个数
                'maxLength' => 4,
                //最少显示个数
                'minLength' => 4,
                //间距
                'padding' => 2,
                //高度
                'height' => 30,
                //宽度
                'width' => 85,
                //字体颜色
                'foreColor' => 0xffffff,
                //设置字符偏移量
                'offset' => 4,
            ],
        ];
    }

    public function actionLoginOut()
    {
        $session = Yii::$app->session;
        unset($session['login']);
        unset($session['admin_id']);
        unset($session['admin_name']);
        unset($_SESSION);
        return $this->redirect('/admin/login/login');

    }

    public function actionLogin()
    {
        $session = Yii::$app->session;
        if (isset($session['login']) && isset($session['admin_id'])) {
            return $this->redirect('/admin/index/index');
        }
        $this->createAction('captcha')->getVerifyCode(TRUE);
        // $session['login_num'] = 0;
        return $this->renderPartial('/admin/login', []);
        
    }
    public function actionLoginCheck()
    {

        $session = Yii::$app->session;
        $rsa = new rsa();

        $captcha = $this->_DATA['captcha'];
        $iscaptcha = $this->createAction('captcha')->validate($captcha, false);
        if ($iscaptcha) {
            
        } else {
            $rsa_str = $rsa->publicEncrypt(json_encode(['code' => -1, 'message' => '验证码错误']));
            return json_encode(['data' => $rsa_str]);
        }

        // return json_encode(['code' => 1, 'message' => '登录成功']);
        if($session['login_num']>=3){
            // 设定锁定时间为2分钟
            $gq_time = $session['login_num_time']+120;
            if($gq_time >= time()){
                // return json_encode(['code' => -1, 'message' => '账号密码尝试次数太多,请稍后再试']);
                $rsa_str = $rsa->publicEncrypt(json_encode(['code' => -1, 'message' => '账号密码尝试次数太多,请稍后再试']));
                return json_encode(['data' => $rsa_str]);
            }else{
                $session['login_num'] = 0;
            }
        }
        // $name = base64_decode($this->_DATA['name']);
        // $pwd = base64_decode($this->_DATA['pwd']);
        $name = $rsa->privDecrypt($this->_DATA['name']);
        $pwd = $rsa->privDecrypt($this->_DATA['pwd']);
        $admin = Admin::check($name, $pwd);
        if ($admin) {
            if(strlen($pwd) <8){
                $session['login_num'] = $session['login_num']+1;
                $session['login_num_time'] = time();
                $rsa_str = $rsa->publicEncrypt(json_encode(['code' => -1, 'message' => '账户被冻结，请联系管理员']));
                return json_encode(['data' => $rsa_str]);
            }
            $session['login'] = 1;
            $session['admin_id'] = $admin['id'];
            $session['admin_name'] = $name;
            // 存储权限信息
            $role = DbWork::getRow('adminrole', '*', ['admin_id' => $admin['id']]);
            $session['role_level'] = $role['level'];
            $session['role_parent'] = $role['parent'];
            $session['role_jurisdiction'] = $role['jurisdiction'];
            $session['is_read'] = $admin['is_read'];
            unset($session['login_num']);
            unset($session['login_num_time']);
            
            $rsa_str = $rsa->publicEncrypt(json_encode(['code' => 1, 'message' => '登录成功']));
            return json_encode(['data' => $rsa_str]);
        }
        $session['login_num'] = $session['login_num']+1;
        if($session['login_num']>=3){ 
            $session['login_num_time'] = time();
            // return json_encode(['code' => -1, 'message' => '账号密码尝试次数太多']);
            $rsa_str = $rsa->publicEncrypt(json_encode(['code' => -1, 'message' => '账号密码尝试次数太多']));
            return json_encode(['data' => $rsa_str]);
        }
        // die($session['login_num']++);
        // return json_encode(['code' => -1, 'message' => '账号有误']);
        $rsa_str = $rsa->publicEncrypt(json_encode(['code' => -1, 'message' => '账号有误']));
        return json_encode(['data' => $rsa_str]);
     
    }

}