<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */

namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;
use yii\web\UploadedFile;
use yii\web\request;


class IndexController extends BaseController
{
    public $enableCsrfValidation = false;
    public $keys;


    public function actionIndex()
    {
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("announcement");
        $query->orderBy('id DESC');

        $list = $query->offset(0)->limit(5)->all();
        return $this->renderPartial('/admin/index', ['list' => $list]);
    }
    public function actionAdminpwd()
    {
        $info = DbWork::getRow('admin','*',['id'=>$this->admin_id]);
        return $this->renderPartial('/admin/adminpwd',['info'=>$info]);
    }
    public function getRandomString($len='6', $chars=null)
    {
        if (is_null($chars)){
            $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        } 
        mt_srand(10000000*(double)microtime());
        for ($i = 0, $str = '', $lc = strlen($chars)-1; $i < $len; $i++){
            $str .= $chars[mt_rand(0, $lc)]; 
        }
        return $str;
    }
    // 调整艺术品填报人
    public function actionSculptureuser()
    {
        // $info = DbWork::getRow('sculpture','id,admin_id',['id'=>$this->admin_id]);
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; 
        $query = (new \yii\db\Query())
            ->select('sculpture.admin_id,sculpture.id,admin.username')
            ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
            ->from("sculpture");
        $query->andWhere(['sculpture.id'=>$id]);
        $info = $query->one();
        return $this->renderPartial('/admin/sculptureuser',['info'=>$info]);
    }
    public function actionSculptureusered()
    {
        Yii::getLogger()->log('艺术品调整填报人',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = $this->_DATA['id'];
        $where['admin_id'] = $this->_DATA['admin_id'];
        $res = DbWork::update('sculpture',$where,['id'=>$id]);
        if($res){
            echo "<script>alert('保存成功');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }else{
            echo "<script>alert('保存失败');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }
    }
    // 总览
    public function actionZllist()
    {

        // 获取用户id
        $id = $this->admin_id;
        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('district_value');
        $ids = empty($this->_GETDATA['ids']) ? '' :$this->_GETDATA['ids']; //Yii::$app->request->get('ids');
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name'];  //Yii::$app->request->get('approval_name');
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh'];  //Yii::$app->request->get('approval_name');
        $lastid =  empty($this->_GETDATA['lastid']) ? '' :$this->_GETDATA['lastid']; //Yii::$app->request->get('lastid');
        $ht =  empty($this->_GETDATA['ht']) ? '' :$this->_GETDATA['ht']; //Yii::$app->request->get('ht');
        $dizhi =  empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');
        $qu_status =  empty($this->_GETDATA['qu_status']) ? '' :$this->_GETDATA['qu_status']; //Yii::$app->request->get('dizhi');
        // 多条件检索
        $arr['type'] = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $arr['material'] = empty($this->_GETDATA['material']) ? '' :$this->_GETDATA['material']; //Yii::$app->request->get('material');
        $arr['technology'] = empty($this->_GETDATA['technology']) ? '' :$this->_GETDATA['technology']; //Yii::$app->request->get('technology');
        $arr['outward'] = empty($this->_GETDATA['outward']) ? '' :$this->_GETDATA['outward'];//Yii::$app->request->get('outward');
        $arr['put_location'] = empty($this->_GETDATA['put_location']) ? '' :$this->_GETDATA['put_location']; //Yii::$app->request->get('put_location');
        $arr['size'] = empty($this->_GETDATA['size']) ? '' :$this->_GETDATA['size'];
        $arr['is_show'] = empty($this->_GETDATA['is_show']) ? '' :$this->_GETDATA['is_show']; //Yii::$app->request->get('is_show');
        $arr['level'] = empty($this->_GETDATA['level']) ? '' :$this->_GETDATA['level']; //Yii::$app->request->get('is_show');
        $arr['ispeople'] = empty($this->_GETDATA['ispeople']) ? '' :$this->_GETDATA['ispeople']; //Yii::$app->request->get('is_show');
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.district,sculpture.street,sculpture.location,sculpture.admin_id,sculpture.is_show,sculpture.create_time,sculpture.width,sculpture.length,sculpture.thick,sculpture.img_url,sculpture.zpbh,admin.username,sculpture.dismantle,sculpture_sub.status as qu_status,sculpture_sub.shangbao')
                ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        if($ids){
            $idss = explode(',', $ids);
            $query->andWhere(['in', 'sculpture.id', $idss]);
        }
        if($district_value && $district_value!='全市'){
            $query->andWhere(['sculpture.district' => $district_value]);
        }
        if($zpbh && $zpbh!='编号'){
            $query->andWhere(['sculpture.zpbh' => $zpbh]);
        }
        if($qu_status && $qu_status!='区审核状态'){
            if($qu_status =='3'){
                $query->andWhere(['sculpture_sub.status' => '0']);
            }else{
                $query->andWhere(['sculpture_sub.status' => $qu_status]);
            }
        }
        
        if($approval_name){
            if($ht=='chachong'){
                $query->andWhere(['sculpture.name'=>$approval_name]);
            }else{
                $query->andWhere(['like','sculpture.name',$approval_name]);
            }
            
        }
        if($dizhi){
            $query->andWhere(['or',['like','sculpture.street',$dizhi],['like','sculpture.location',$dizhi]]);
        }
        if($arr['type'] && $arr['type']!='请选择属性'){
            $query->andWhere(['sculpture.type'=>$arr['type']]);
        }
        if($arr['material'] && $arr['material']!='请选择材料'){
            $query->andWhere(['like','sculpture.material',$arr['material']]);
        }
        if($arr['technology'] && $arr['technology']!='请选择工艺'){
            $query->andWhere(['like','sculpture.technology',$arr['technology']]);
        }
        if($arr['outward'] && $arr['outward']!='请选择外观'){
            $query->andWhere(['like','sculpture.outward',$arr['outward']]);
        }
        if($arr['put_location'] && $arr['put_location']!='请选择摆放环境'){
            $query->andWhere(['sculpture.put_location'=>$arr['put_location']]);
        }
        if($arr['level'] && $arr['level']!='是否建议拆除'){
            if($arr['level']==2){
                $query->andWhere(['sculpture.dismantle'=>'1']);
            }else{
                $query->andWhere(['sculpture.dismantle'=>'0']);
            }
        }
        if($arr['is_show']!=NULL && $arr['is_show']!='公开状态'){
            if($arr['is_show'] == 1){
                $query->andWhere(['sculpture.is_show'=>1]);
            }else{
                $query->andWhere(['<>','sculpture.is_show',1]);
            }
        }
        if($arr['size'] && $arr['type']){
            switch ($arr['size']) {
                case '特大型':
                    $query->andWhere(['sculpture.model'=>3]);
                    break;
                case '大型':
                    $query->andWhere(['sculpture.model'=>2]);
                    break;
                case '中型':
                    $query->andWhere(['sculpture.model'=>1]);
                    break;
                case '小型':
                    $query->andWhere(['sculpture.model'=>0]); 
                    break;
                default:
                    # code...
                    break;
            }
        }
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        $query->andWhere(['sculpture.del' => 0]);
		$query->andWhere(['<>','sculpture.district','']);
        $query->orderBy('sculpture.create_time DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        foreach ($list as $key => $value) {
            if(in_array($value['street'],$this->street_arr)){
                $list[$key]['location'] = $value['location']."(".$value['street'].")";
                $list[$key]['street'] = '';
            }
        }
        // var_dump($arr);
        return $this->renderPartial('/admin/zllist',["list"=>$list,"pages" => $page,"district"=>$district,"district_value"=>$district_value,"approval_name"=>$approval_name,"page_now"=>$page_now,"dizhi"=>$dizhi,"ht"=>$ht,"lastid"=>$lastid,"arr"=>$arr,'qu_status'=>$qu_status,'zpbh'=>$zpbh]);
    }
    // 雕塑 待审核
    public function actionList()
    {
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name']; //Yii::$app->request->get('approval_name');
        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('district_value');
        $street_value = empty($this->_GETDATA['street_value']) ? '' :$this->_GETDATA['street_value']; //Yii::$app->request->get('street_value');
        $dizhi = empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.admin_id,sculpture.district,sculpture.street,sculpture.location,sculpture.img_url,sculpture.zpbh,sculpture.is_show,admin.username,sculpture_sub.status as qu_status,sculpture_sub.shangbao')
                ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        if($district_value && $district_value!='请选择城区'){
            $query->andWhere(['sculpture.district' => $district_value]);
        }
        if($street_value && $street_value!='请选择街乡镇'){
            $query->andWhere(['sculpture.street' => $street_value]);
        }
        if($dizhi){
            $query->andWhere(['or',['like','sculpture.street',$dizhi],['like','sculpture.location',$dizhi]]);
        }
        switch ($this->role_level) {
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                $role_jurisdiction = $this->role_jurisdiction;
                $district = array();
                $street = array();
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                $query->andWhere(['sculpture_sub.shangbao' => 1]);
                $query->andWhere(['sculpture_sub.status' => 0]);
                $query->orderBy('sculpture_sub.shangbao_time DESC,sculpture.id DESC');
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
                $query->andWhere(['sculpture_sub.shangbao' => 0]);
                $street = array();
                $district = array();
                $role_jurisdiction = $this->role_jurisdiction;
                $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                $query->orderBy('sculpture_sub.status_time DESC,sculpture.id DESC');
                break;
            default:
                die('权限不足');
                break;
        }
        if(!empty($approval_name)){
            $query->andWhere(['like','sculpture.name',$approval_name]);
        }
        if($district_value){
            $street = DbWork::queryAll("select street from location where district='{$district_value}' and status=1");
        }
        $query->andWhere(['sculpture.del'=>0]);
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/admin/list', ['list' => $list, 'pages' => $page,'role_id'=>$this->role_id,'approval_name'=>$approval_name,"street"=>$street,"district"=>$district,"street_value"=>$street_value,"district_value"=>$district_value,'page_now'=>$page_now,'dizhi'=>$dizhi]);
    }
    // 已审核列表
    public function actionApprovalList()
    {
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name']; //Yii::$app->request->get('approval_name');
        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('district_value');
        $street_value = empty($this->_GETDATA['street_value']) ? '' :$this->_GETDATA['street_value']; //Yii::$app->request->get('street_value');
        $status = empty($this->_GETDATA['status']) ? '' :$this->_GETDATA['status']; //Yii::$app->request->get('street_value');
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.admin_id,sculpture.district,sculpture.street,sculpture.location,sculpture.img_url,sculpture.zpbh,sculpture.is_show,admin.username,sculpture_sub.status as qu_status,sculpture_sub.shangbao')
                ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        if(!empty($status)){
            $query->andWhere(['sculpture_sub.status' => $status]);
        }
        if(!empty($street_value)){
            $query->andWhere(['sculpture.street' => $street_value]);
        }
        $dizhi = empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');
        if($dizhi){
            $query->andWhere(['or',['like','sculpture.street',$dizhi],['like','sculpture.location',$dizhi]]);
        }
        switch ($this->role_level) {
            case '2':
                $xia_qu = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $xia_qu]);
                $district = array();
                $street = DbWork::queryAll("select street from location where district='{$xia_qu}' and status=1");
                $query->andWhere(['or',['sculpture_sub.status'=>1],['sculpture_sub.status'=>2]]);
                break;
            case '3':
                $district = array();
                $street = array();
                // 获取已上报的信息
                $query->andWhere(['sculpture_sub.shangbao' => 1]);
                $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                break;
            case '4':
                $district = array();
                $street = array();
                $admin = $this->admin_id;
                $query->andWhere(['sculpture.admin_id'=>$admin]);
                break;
            default:
                die('权限不足');
                break;
        }
        if(!empty($approval_name)){
            $query->andWhere(['like','sculpture.name',$approval_name]);
        }
        

        if($district_value){
            $street = DbWork::queryAll("select street from location where district='{$district_value}' and status=1");
        }
        $query->andWhere(['sculpture.del'=>0]);
        $query->orderBy('sculpture.id DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/approval-list', ['list' => $list, 'pages' => $page,'role_id'=>$this->role_id,'approval_name'=>$approval_name,"street"=>$street,"district"=>$district,"street_value"=>$street_value,"district_value"=>$district_value,'page_now'=>$page_now,'dizhi'=>$dizhi,'status'=>$status]);
    }
    // 本账户提交数据
    public function actionBrlist()
    {
        // 获取用户id
        $id = $this->admin_id;
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name']; //Yii::$app->request->get('approval_name');
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.admin_id,sculpture.district,sculpture.street,sculpture.location,sculpture.img_url,sculpture.zpbh,sculpture.is_show,admin.username,sculpture_sub.status as qu_status,sculpture_sub.shangbao')
                ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");

        if($approval_name){
            $query->andWhere(['like','sculpture.name',$approval_name]);
        }
        $query->andWhere(['sculpture.del' => 0]);
        $query->andWhere(['sculpture.admin_id' => $id]);
        $query->andWhere(['sculpture.del'=>0]);
        $query->orderBy('sculpture.id DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/brlist',["list"=>$list,"pages" => $page,"page_now"=>$page_now,"approval_name"=>$approval_name]);
    }
    public function actionListDel()
    { 
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name']; //Yii::$app->request->get('approval_name');
        $role_name = empty($this->_GETDATA['role_name']) ? '' :$this->_GETDATA['role_name']; //Yii::$app->request->get('role_name');
        $deluid = empty($this->_GETDATA['deluid']) ? '' :$this->_GETDATA['deluid']; //Yii::$app->request->get('role_name');
        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('role_name');
        
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        if($role_name == 2){
            $role_name = 2; 
            // $user = DbWork::getAll('adminrole','admin_id',['parent'=>$this->admin_id ]);
            // array_push($user, $this->admin_id);

            $query = (new \yii\db\Query())
            ->select('sculptures.id,sculptures.del,sculptures.del_time,sculptures.img_url,sculptures.name,sculptures.district,sculptures.street,sculptures.location,sculptures.name,sculptures.del_uid,admin.username as del_name')
            // ->select('sculpture.*,admin.username')
            ->leftJoin('admin', 'sculptures.del_uid  = admin.id')
            ->from("sculptures");
            $querys = (new \yii\db\Query())
                ->select('count(*) as num,sculptures.del_uid,admin.username')
                ->leftJoin('admin', 'sculptures.del_uid  = admin.id')
                ->from("sculptures");
            $querys->groupBy('sculptures.del_uid,admin.username');

            switch ($this->role_level) {
                case '0':
                    break;
                case '1':
                    break;
                case '2':
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculptures.district' => $role_jurisdiction]);
                    $querys->andWhere(['sculptures.district' => $role_jurisdiction]);
                    break;
                case '3':
					$jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                    $query->andWhere(['sculptures.district' => $jurisdiction['jurisdiction']]);
                    $querys->andWhere(['sculptures.district' => $jurisdiction['jurisdiction']]);
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculptures.street' => $role_jurisdiction]);
                    $querys->andWhere(['sculptures.street' => $role_jurisdiction]);
                    break;
                case '4':
                    break;
                default:
                    die('权限不足');
                    break;
            }
            if(!empty($approval_name)){
                $query->andWhere(['like','sculptures.name',$approval_name]);
                $querys->andWhere(['like','sculptures.name',$approval_name]);
            }
            if(!empty($deluid)){
                $query->andWhere(['sculptures.del_uid'=>$deluid]);
            }
            if(!empty($district_value)){
                $query->andWhere(['sculptures.district'=>$district_value]);
            }
            $query->andWhere(['sculptures.del'=>1]);
            $querys->andWhere(['sculptures.del'=>1]);
            $query->orderBy('sculptures.del_time DESC');
            $countQuery = clone $query;
            $page = new Pagination(
                ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
            );
            $list = $query->offset($page->offset)->limit($page->limit)->all();
            $userlist = $querys->all();
        }else{
            // 获取下级用户
            // $this->admin_id;
            // $user = DbWork::getAll('adminrole','admin_id',['parent'=>$this->admin_id ]);
            // array_push($user, $this->admin_id);
            // var_dump($user);
            // die;
            $role_name = 1; 
            $query = (new \yii\db\Query())
            ->select('sculpture.id,sculpture.del,sculpture.del_time,sculpture.img_url,sculpture.name,sculpture.district,sculpture.street,sculpture.location,sculpture.name,sculpture.del_uid,admin.username as del_name,sculpture.zpbh')
            // ->select('sculpture.*,admin.username')
            ->leftJoin('admin', 'sculpture.del_uid  = admin.id')
            ->from("sculpture");
            $querys = (new \yii\db\Query())
                ->select('count(*) as num,sculpture.del_uid,admin.username')
                ->leftJoin('admin', 'sculpture.del_uid  = admin.id')
                ->from("sculpture");
            $querys->groupBy('sculpture.del_uid,admin.username');
            switch ($this->role_level) {
                case '0':
                    break;
                case '1':
                    break;
                case '2':
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                    $querys->andWhere(['sculpture.district' => $role_jurisdiction]);
                    break;
                case '3':
					$jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                    $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                    $querys->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                    $querys->andWhere(['sculpture.street' => $role_jurisdiction]);
                    break;
                case '4':
                    $admin = $this->admin_id;
                    $query->andWhere(['sculpture.admin_id'=>$admin]);
                    // $query->andWhere(['in','sculpture.del_uid',$user]);
                    $querys->andWhere(['sculpture.admin_id'=>$admin]);
                    // $querys->andWhere(['in','sculpture.del_uid',$user]);
                    break;
                default:
                    break;
            }
            if(!empty($approval_name)){
                $query->andWhere(['like','sculpture.name',$approval_name]);
                $querys->andWhere(['like','sculpture.name',$approval_name]);
            }
            if(!empty($deluid)){
                $query->andWhere(['sculpture.del_uid'=>$deluid]);
            }
            if(!empty($district_value)){
                $query->andWhere(['sculpture.district'=>$district_value]);
            }
            $query->andWhere(['sculpture.del'=>1]);
            $query->orderBy('sculpture.del_time DESC');
            $querys->andWhere(['sculpture.del'=>1]);
            $countQuery = clone $query;
            $page = new Pagination(
                ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
            );
            $list = $query->offset($page->offset)->limit($page->limit)->all();
            $userlist = $querys->all();
            // foreach ($list as $key => $value) {
            //     $name = DbWork::getRow('admin', 'username', ['id' => $value['del_uid']]);
            //     $list[$key]['del_name'] = $name['username'];
            // }
        }
        return $this->renderPartial('/admin/list-del', ['list' => $list,'pages' => $page,'role_name'=>$role_name,'approval_name'=>$approval_name,'userlist'=>$userlist,'deluid'=>$deluid,'district_value'=>$district_value,'district'=>$district]);
    }
    public function actionListreduction()
    {
        Yii::getLogger()->log('艺术品还原',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = empty($this->_DATA['id']) ? '' :$this->_DATA['id']; //Yii::$app->request->post('id');
        $type = empty($this->_DATA['type']) ? '' :$this->_DATA['type']; //Yii::$app->request->post('type');
        if(empty($id)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if(empty($type)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if($type == 1){
            $id = $this->_DATA['id'];
            // 判断是否是数组
            if( is_array($id) ){
                foreach ($id as $key => $value) {
                    $res = DbWork::update('sculpture',['del'=>0],['id'=>$value]);
                }
            }else{
                $res = DbWork::update('sculpture',['del'=>0],['id'=>$id]);
            }
        }else{
            $id = $this->_DATA['id'];
            // 判断是否是数组
            if( is_array($id) ){
                foreach ($id as $key => $value) {
                    $res = DbWork::update('sculptures',['del'=>0],['id'=>$value]);
                }
            }else{
                $res = DbWork::update('sculptures',['del'=>0],['id'=>$id]);
            }
            // $res = DbWork::update('sculptures',['del'=>0],['id'=>$this->_DATA['id']]);
        }
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);

    }
    public function actionListreductions()
    {
        Yii::getLogger()->log('艺术品彻底删除',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = empty($this->_DATA['id']) ? '' :$this->_DATA['id']; //Yii::$app->request->post('id');
        $type = empty($this->_DATA['type']) ? '' :$this->_DATA['type']; //Yii::$app->request->post('type');
        if(empty($id)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if(empty($type)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if($type == 1){
            $id = $this->_DATA['id'];
            // 判断是否是数组
            if( is_array($id) ){
                foreach ($id as $key => $value) {
                    $res = DbWork::update('sculpture',['del'=>2,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$value]);
                    // $res = DbWork::delete('sculpture',['id'=>$value]);
                }
            }else{
                $res = DbWork::update('sculpture',['del'=>2,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$id]);
                // $res = DbWork::delete('sculpture',['id'=>$id]);
            }
        }else{
            $id = $this->_DATA['id'];
            // 判断是否是数组
            if( is_array($id) ){
                foreach ($id as $key => $value) {
                    $res = DbWork::delete('sculptures',['id'=>$value]);
                }
            }else{
                $res = DbWork::delete('sculptures',['id'=>$id]);
            }
            // $res = DbWork::delete('sculptures',['id'=>$this->_DATA['id']]);
        }
        if($res){
            return json_encode(['code'=>1,'msg'=>'操作成功']);
        }else{
            return json_encode(['code'=>0,'msg'=>'操作失败']);
        } 
    }

    public function actionQzlist()
    {
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name']; //Yii::$app->request->get('approval_name');
        $dizhi = empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');

        $query = (new \yii\db\Query())
                ->select('sculptures.*')
                ->from("sculptures");
        if($dizhi){
            $query->andWhere(['or',['like','sculptures.street',$dizhi],['like','sculptures.location',$dizhi]]);
        }
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                break;
            case '2':
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculptures.district' => $role_jurisdiction]);
                break;
            case '3':
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculptures.street' => $role_jurisdiction]);
                break;
            default:
                die('权限不足');
                break;
        }
        if(!empty($approval_name)){
            $query->andWhere(['like','sculptures.name',$approval_name]);
        }
        $query->andWhere(['sculptures.del'=>0]);
        $query->orderBy('sculptures.id DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/qzlist', ['list' => $list, 'pages' => $page,'role_id'=>$this->role_id,'approval_name'=>$approval_name,'page_now'=>$page_now,'dizhi'=>$dizhi]);
    }

    public function actionDelds()
    {
        Yii::getLogger()->log('艺术品进入回收站',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = $this->_DATA['id'];
        if( is_array($id) ){
            foreach ($id as $key => $value) {
            $res = DbWork::update('sculpture',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
            $res = DbWork::update('sculpture',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$this->_DATA['id']]);
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
        }
        // $res = DbWork::delete('sculpture', ['id' => $this->_DATA['id']]);
        
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    public function actionIsshow()
    {
        Yii::getLogger()->log('艺术品公开状态变更',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = $this->_DATA['id'];
        // 判断是否是数组
        if( is_array($id) ){
            foreach ($id as $key => $value) {
                $res = DbWork::update('sculpture',['is_show'=>$this->_DATA['isshow'] ],['id'=>$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
             $res = DbWork::update('sculpture',['is_show'=>$this->_DATA['isshow'] ],['id'=>$id]);
             if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        // $res = DbWork::update('sculpture',['is_show'=>$this->_DATA['isshow'] ],['id'=>$this->_DATA['id']]);
        
    }
    public function actionLevel()
    {
        Yii::getLogger()->log('艺术品附加属性变更',yii\log\Logger::LEVEL_INFO,'admin_log');
        $id = $this->_DATA['id'];
        $arr['dismantle'] = (int)$this->_DATA['level'];
        // $info = DbWork::getRow('sculpture_attach', 'level', ['sid' => $id]);
        // if($info){
            $res = DbWork::update('sculpture',$arr,['id'=>$id]);
        // }else{
            // $crr['sid'] = $id;
            // $crr['level'] = $this->_DATA['level'];
            // $res = DbWork::save('sculpture_attach',$crr);
        // }
        if ($res) {
            echo "<script>alert('保存成功'); javascript:history.go(-1)</script>";
            // return $this->redirect('/admin/login/login');
        }else{
            echo "<script>alert('保存失败'); javascript:history.go(-1)</script>";
        }
    }
    // 快速预览 列表页
    public function actionLevel_list()
    {
        $districts = empty($this->_GETDATA['district']) ? '东城区' :$this->_GETDATA['district']; 
        $get_level = $level = empty($this->_GETDATA['level']) ? '' :$this->_GETDATA['level']; 
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh'];
        if($zpbh !=''){
            $district = DbWork::queryAll("select distinct(district) from location where status=1");
            $district = DistrictSort($district);
            $query = (new \yii\db\Query())
                    ->select('sculpture.id as zpid,sculpture.zpbh,sculpture.name,sculpture.admin_id,sculpture.district,sculpture.street,sculpture.location,sculpture.type,sculpture.img_url,sculpture.length,sculpture.width,sculpture.material,sculpture.thick,sculpture.technology,sculpture.author,sculpture.dismantle')
                    ->from("sculpture");
            if($level && $level!='等级'){
                $query->andWhere(['sculpture.dismantle'=>($level-1)]);
            }
            $query->andWhere(['sculpture.zpbh'=>$zpbh]);
            $query->andWhere(['sculpture.district'=>$districts]);
            $query->andWhere(['sculpture.del'=>0]);
            $query->orderBy('sculpture.id DESC');
            $list = $query->one();
        }else{
            // 城区数据
            $district = DbWork::queryAll("select distinct(district) from location where status=1");
            $district = DistrictSort($district);
            $query = (new \yii\db\Query())
                    ->select('sculpture.id as zpid,sculpture.zpbh,sculpture.name,sculpture.admin_id,sculpture.district,sculpture.street,sculpture.location,sculpture.type,sculpture.img_url,sculpture.length,sculpture.width,sculpture.material,sculpture.thick,sculpture.technology,sculpture.author,sculpture.dismantle')
                    ->from("sculpture");
            if($level && $level!='等级'){
                $query->andWhere(['sculpture.dismantle'=>($level-1)]);
            }
            $query->andWhere(['sculpture.district'=>$districts]);
            $query->andWhere(['sculpture.del'=>0]);
            $query->orderBy('sculpture.id DESC');
            $list = $query->one();
            
            
        }
        // 获取本区所有数据。拿取当前艺术品的上一件下一件
        $query = (new \yii\db\Query())
                ->select('sculpture.zpbh,sculpture.dismantle')
                // ->leftJoin('sculpture_attach', 'sculpture.id  = sculpture_attach.sid')
                ->from("sculpture");
        
        if($level && $level!='等级'){
            $query->andWhere(['sculpture.dismantle'=>($level-1)]);
        }
        $query->andWhere(['sculpture.district'=>$districts]);
        $query->andWhere(['sculpture.del'=>0]);
        $query->orderBy('sculpture.id DESC');
        $lists = $query->all();
        //echo $query->createCommand()->getRawSql();
        $id_array = array_column($lists,'zpbh');
        $page['prev'] = NULL;
        $page['next'] = NULL;
        foreach ($id_array as $key => $value) {
            if($value==$list['zpbh']){
                $page['prev'] = @$id_array[$key-1];
                $page['next'] = @$id_array[$key+1];
            }
        }
        return $this->renderPartial('/admin/level-list',['detail' => $list,'district'=>$district,'districts'=>$districts,'page'=>$page,'level'=>$get_level]);
    }
    public function actionDeldss()
    {
        Yii::getLogger()->log('群众艺术品删除',yii\log\Logger::LEVEL_INFO,'admin_log');
        // $res = DbWork::delete('sculptures', ['id' => $this->_DATA['id']]);
        $res = DbWork::update('sculptures',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$this->_DATA['id']]);
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    
    public function actionEdit()
    {
       
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $page = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        // $detail = DbWork::getRow('sculpture', '*', ['id' => $id]);
        // $query = (new \yii\db\Query())
        //     ->select('sculpture.admin_id,sculpture.id,admin.username')
        //     ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
        //     ->from("sculpture");
        $query = (new \yii\db\Query())
            ->select('sculpture.*,admin.username,sculpture_sub.status as qu_status,sculpture_sub.shangbao,sculpture_att.*,sculpture.id,sculpture_sub.content as bh_content')
            ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->from("sculpture");
        $query->andWhere(['sculpture.del'=>0]);
        $query->andWhere(['sculpture.id'=>$id]);
        $detail = $query->one();
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        $street = DbWork::queryAll("select street from location where district='{$detail['district']}' and status=1");
        return $this->renderPartial('/admin/edit', ['detail' => $detail,'district'=>$district,'street'=>$street,'page'=>$page,'type'=>$type]);
    }
    public function actionBredit()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $page = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        // $detail = DbWork::getRow('sculpture', '*', ['id' => $id]);
        $query = (new \yii\db\Query())
            ->select('sculpture.*,admin.username,sculpture_sub.status as qu_status,sculpture_sub.shangbao,sculpture_att.*,sculpture.id')
            ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->from("sculpture");
        $query->andWhere(['sculpture.del'=>0]);
        $query->andWhere(['sculpture.id'=>$id]);
        $detail = $query->one();
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        $street = DbWork::queryAll("select street from location where district='{$detail['district']}' and status=1");
        return $this->renderPartial('/admin/bredit', ['detail' => $detail,'district'=>$district,'street'=>$street,'page'=>$page,'type'=>$type]);
    }
    public function actionEditss()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $page = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $detail = DbWork::getRow('sculptures', '*', ['id' => $id]);
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        $street = DbWork::queryAll("select street from location where district='{$detail['district']}' and status=1");
        return $this->renderPartial('/admin/editss', ['detail' => $detail,'district'=>$district,'street'=>$street,'page'=>$page,'type'=>$type]);
    }
    // 本人提交修改
    public function actionBredits()
    {
        $where = $this->_DATA;
        unset($where['_csrf']);
        // 查询状态
        $crr = array();
        $crr['weibao_danwei'] = $where['weibao_danwei'];
        $crr['weibao_name'] = $where['weibao_name'];
        $crr['weibao_phone'] = $where['weibao_phone'];
        // $crr['decipher'] = $where['decipher'];
        unset($where['weibao_danwei']);
        unset($where['weibao_name']);
        unset($where['weibao_phone']);
        // unset($where['decipher']);
        if(!empty($where['material'])){
            $where['material'] =implode(',',array_keys($where['material']));
        }
        if(!empty($where['technology'])){
            $where['technology'] =implode(',',array_keys($where['technology']));
        }
        if(!empty($where['img_url'])){
            $where['img_url'] = json_encode($where['img_url']);
        }
        unset($where['file']);
        $where['model'] = ScuSize($where['width'],$where['length'],$where['type']);
        $res = DbWork::update('sculpture', $where, ['id' => $where['id']]);
        $ress = DbWork::update('sculpture_att', $crr, ['sid' => $where['id']]);
        if($res || $ress){
            echo "<script>alert('保存成功');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }else{
            echo "<script>alert('保存失败');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }
    }

    public function actionEdits()
    {
        $where = $this->_DATA;
        Yii::getLogger()->log('艺术品修改',yii\log\Logger::LEVEL_INFO,'admin_log');
        unset($where['_csrf']);
        $crr = array();
        $crr['weibao_danwei'] = $where['weibao_danwei'];
        $crr['weibao_name'] = $where['weibao_name'];
        $crr['weibao_phone'] = $where['weibao_phone'];
        $crr['decipher'] = $where['decipher'];
        unset($where['weibao_danwei']);
        unset($where['weibao_name']);
        unset($where['weibao_phone']);
        unset($where['decipher']);
        if(!empty($where['material'])){
            $where['material'] =implode(',',array_keys($where['material']));
        }
        if(!empty($where['technology'])){
            $where['technology'] =implode(',',array_keys($where['technology']));
        }
        if(empty($where['name'])){
            $where['name'] ='不详';
        }
        if(!empty($where['img_url'])){
            $where['img_url'] = json_encode($where['img_url']);
        }
        unset($where['file']);
        $where['model'] = ScuSize($where['width'],$where['length'],$where['type']);
        $res = DbWork::update('sculpture', $where, ['id' => $where['id']]);
        $ress = DbWork::update('sculpture_att', $crr, ['sid' => $where['id']]);
        if($res || $ress){
            echo "<script>alert('保存成功');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }else{
            echo "<script>alert('保存失败');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }
        
    }
    public function actionEditsq()
    {

        $where = $this->_DATA;
        if(!empty($where['material'])){
            $where['material'] =implode(',',array_keys($where['material']));
        }
        if(!empty($where['technology'])){
            $where['technology'] =implode(',',array_keys($where['technology']));
        }
        if(!empty($where['img_url'])){
            $where['img_url'] = json_encode($where['img_url']);
        }
        unset($where['file']);
        DbWork::update('sculptures', $where, ['id' => $where['id']]);
        echo "<script>alert('保存成功');</script>";
        echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        // return $this->redirect(['admin/index/qzlist', 'id' => 1]);
        
        // Header("Location: ../../../admin/index/list");
        // return $this->renderPartial('/admin/list', ['detail' => $detail,'district'=>$district,'street'=>$street]);
    }
    public function actionGetstreet()
    {
        $district = $this->_DATA['district'];
        $street = DbWork::queryAll("select street from location where district='{$district}' and status=1");
        return self::responseJson($street, 200, '请求成功');
    }
    // 
    public function actionGetqu()
    {
        $level = $this->_DATA['level'];
        $parent = $this->_DATA['parent'];
        if(empty($level)){
            return self::responseJson(array(), 400, '请求失败');
        }
        if(empty($parent)){
            return self::responseJson(array(), 400, '请求失败');
        }
        $query = (new \yii\db\Query())
            ->select('adminrole.admin_id as id,admin.username,adminrole.jurisdiction,districtorder.ord')
            ->leftJoin('admin', 'adminrole.admin_id  = admin.id')
            ->leftJoin('districtorder', 'adminrole.jurisdiction  = districtorder.district')
            ->from("adminrole");
        // $query->andWhere(['adminrole.parent'=>$this->admin_id]);
        $query->andWhere(['admin.status'=>1]);
        $query->andWhere(['adminrole.level'=>$level]);
        $query->andWhere(['adminrole.parent'=>$parent]);
        if($level == 2){
            $query->andWhere(['<','adminrole.admin_id',3355]);
            $query->orWhere(['adminrole.admin_id'=>6104]);
        }
        $query->orderBy('districtorder.ord asc');
        $list = $query->all();
        // $street = DbWork::queryAll("select * from adminrole where level='2' and admin_id<3339");
        return self::responseJson($list, 200, '请求成功');
    }
    
    public function actionGetsculpture()
    {
        $district = $this->_DATA['district'];
        
        
        switch ($this->role_level) {
            case '1':
                $district = str_replace("委宣传部",'',$district);
                $query = (new \yii\db\Query())
                    ->select('id,name')
                    ->where("del=0")
                    ->from("sculpture");
                $query->andWhere(['sculpture.district' => $district]);
                break;
            case '2':
                // 区
                $query = (new \yii\db\Query())
                    ->select('id,name')
                    ->where("del=0")
                    ->from("sculpture");
                $query->andWhere(['sculpture.street' => $district]);
                break;
            case '3':
                // 区
                $query = (new \yii\db\Query())
                    ->select('id,name')
                    ->where("del=0")
                    ->from("sculpture");
                $query->andWhere(['sculpture.street' => $detail['jurisdiction']]);
                break;
            default:
                return json_encode(['code' => 0]);
                break;
        }
        // if($level =='1'){
        //     $query->andWhere(['sculpture.district' => $district]);
        // }elseif($level =='4'){
        //     $query->andWhere(['sculpture.street' => $this->role_jurisdiction]);
        // }else{
        //     $query->andWhere(['sculpture.street' => $district]);
        // }

        // $query->orWhere(['sculpture.street' => $district]);
        
        // $query->andWhere(['like','outward','需']);
        $query->orderBy('id ASC');
        $level = $query->all();
        foreach ($level as $key => $value) {
           $level[$key]['value'] = $value['id'];
        }
        return self::responseJson($level, 200, '请求成功');
    }
    //格式化JSON返回
    public function responseJson($result, $code = true, $message = null, $ext = null, $exit = true)
    {
        if (!empty($this->postBody)) {
            Yii::info(json_encode($this->postBody), 'api_log');
        } else {
            Yii::info('当前请求没有参数', 'api_log');
        }
        $data = [
            'code' => $code,
            'message' => $message ? $message : '',
            'result' => $result,
            'token' => (isset($this->user)) ? $this->user['token'] : ''
        ];
        if ($ext !== null && is_array($ext)) {
            foreach ($ext as $k => $v) {
                if (!isset($data[$k])) {
                    $data[$k] = $v;
                }
            }
        }
        $json = json_encode($data);
        Yii::info($json, 'api_log');
        header('Content-type: application/json');
        echo $json;
        ob_flush();
        if ($exit === true) {
            exit;
        }
    }
    // 艺术品详情页
    public function actionDetail()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $types = empty($this->_GETDATA['types']) ? '' :$this->_GETDATA['types']; //Yii::$app->request->get('type');

        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('district_value');
        $ids = empty($this->_GETDATA['ids']) ? '' :$this->_GETDATA['ids']; //Yii::$app->request->get('ids');
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name'];  //Yii::$app->request->get('approval_name');
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh'];  //Yii::$app->request->get('approval_name');
        $lastid =  empty($this->_GETDATA['lastid']) ? '' :$this->_GETDATA['lastid']; //Yii::$app->request->get('lastid');
        $ht =  empty($this->_GETDATA['ht']) ? '' :$this->_GETDATA['ht']; //Yii::$app->request->get('ht');
        $dizhi =  empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');
        $qu_status =  empty($this->_GETDATA['qu_status']) ? '' :$this->_GETDATA['qu_status']; //Yii::$app->request->get('dizhi');
        // 多条件检索
        $arr['type'] = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $arr['material'] = empty($this->_GETDATA['material']) ? '' :$this->_GETDATA['material']; //Yii::$app->request->get('material');
        $arr['technology'] = empty($this->_GETDATA['technology']) ? '' :$this->_GETDATA['technology']; //Yii::$app->request->get('technology');
        $arr['outward'] = empty($this->_GETDATA['outward']) ? '' :$this->_GETDATA['outward'];//Yii::$app->request->get('outward');
        $arr['put_location'] = empty($this->_GETDATA['put_location']) ? '' :$this->_GETDATA['put_location']; //Yii::$app->request->get('put_location');
        $arr['size'] = empty($this->_GETDATA['size']) ? '' :$this->_GETDATA['size'];
        $arr['is_show'] = empty($this->_GETDATA['is_show']) ? '' :$this->_GETDATA['is_show']; //Yii::$app->request->get('is_show');
        $arr['level'] = empty($this->_GETDATA['level']) ? '' :$this->_GETDATA['level']; //Yii::$app->request->get('is_show');
        $arr['ispeople'] = empty($this->_GETDATA['ispeople']) ? '' :$this->_GETDATA['ispeople']; //Yii::$app->request->get('is_show');

        // $detail = DbWork::getRow('sculpture', '*', ['id' => $id]);
        $query = (new \yii\db\Query())
                ->select('sculpture.*,sculpture_att.*,sculpture_sub.status as qu_status,sculpture_sub.shangbao,sculpture.id,sculpture_sub.content as qu_content,sculpture_sub.shangbao_time,sculpture_sub.status_time')
                ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        // $query->andWhere(['sculpture.del'=>'0']); 
        $query->andWhere(['sculpture.id'=>(int)$id]); 
        $detail = $query->one();
       
        // 上一件下一件
        $query = (new \yii\db\Query())
                ->select('sculpture.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        if($ids){
            $idss = explode(',', $ids);
            $query->andWhere(['in', 'sculpture.id', $idss]);
        }
        if($district_value && $district_value!='全市'){
            $query->andWhere(['sculpture.district' => $district_value]);
        }
        if($zpbh && $zpbh!='编号'){
            $query->andWhere(['sculpture.zpbh' => $zpbh]);
        }
        if($qu_status && $qu_status!='区审核状态'){
            if($qu_status =='3'){
                $query->andWhere(['sculpture_sub.status' => '0']);
            }else{
                $query->andWhere(['sculpture_sub.status' => $qu_status]);
            }
        }

        if($approval_name){
            if($ht=='chachong'){
                $query->andWhere(['sculpture.name'=>$approval_name]);
            }else{
                $query->andWhere(['like','sculpture.name',$approval_name]);
            }
            
        }
        if($dizhi){
            $query->andWhere(['or',['like','sculpture.street',$dizhi],['like','sculpture.location',$dizhi]]);
        }
        if($arr['type'] && $arr['type']!='请选择属性'){
            $query->andWhere(['sculpture.type'=>$arr['type']]);
        }
        if($arr['material'] && $arr['material']!='请选择材料'){
            $query->andWhere(['like','sculpture.material',$arr['material']]);
        }
        if($arr['technology'] && $arr['technology']!='请选择工艺'){
            $query->andWhere(['like','sculpture.technology',$arr['technology']]);
        }
        if($arr['outward'] && $arr['outward']!='请选择外观'){
            $query->andWhere(['like','sculpture.outward',$arr['outward']]);
        }
        if($arr['put_location'] && $arr['put_location']!='请选择摆放环境'){
            $query->andWhere(['sculpture.put_location'=>$arr['put_location']]);
        }
        if($arr['level'] && $arr['level']!='是否建议拆除'){
            if($arr['level']==2){
                $query->andWhere(['sculpture.dismantle'=>'1']);
            }else{
                $query->andWhere(['sculpture.dismantle'=>'0']);
            }
        }
        if($arr['is_show']!=NULL && $arr['is_show']!='公开状态'){
            if($arr['is_show'] == 1){
                $query->andWhere(['sculpture.is_show'=>1]);
            }else{
                $query->andWhere(['<>','sculpture.is_show',1]);
            }
        }
        if($arr['size'] && $arr['type']){
            switch ($arr['size']) {
                case '特大型':
                    $query->andWhere(['sculpture.model'=>3]);
                    break;
                case '大型':
                    $query->andWhere(['sculpture.model'=>2]);
                    break;
                case '中型':
                    $query->andWhere(['sculpture.model'=>1]);
                    break;
                case '小型':
                    $query->andWhere(['sculpture.model'=>0]); 
                    break;
                default:
                    # code...
                    break;
            }
        }
        if($types =='ds'){
            switch ($this->role_level) {
                case '2':
                    // 区 判断审核判断 或者进行再次上报 
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                    $query->andWhere(['sculpture_sub.shangbao' => 1]);
                    $query->andWhere(['sculpture_sub.status' => 0]);
                    // $query->orderBy('sculpture_sub.shangbao_time DESC,sculpture.id DESC');
                    break;
                case '3':
                    // 街道办事处 判断是否是进行上报的 
                    $query->andWhere(['sculpture_sub.shangbao' => 0]);
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                    // 
                    break;
                default:
                    
                    break;
            }
        }
        $query->andWhere(['sculpture.del' => 0]);
        $query->orderBy('sculpture.create_time DESC');
        $countQuery = clone $query;
        $query->andWhere(['>','sculpture.create_time',$detail['create_time']]);
        $prev = $query->all();
        $vrr = array_pop($prev);
        $countQuery->andWhere(['<','sculpture.create_time',$detail['create_time']]);
        $next = $countQuery->limit(1)->all();
        $info['prev'] = "";
        $info['next'] = "";
        $canshu = "&district_value=".$district_value."&approval_name=".$approval_name."&dizhi=".$dizhi."&qu_status=".$qu_status."&zpbh=".$zpbh."";
        foreach ($arr as $key => $value) {
            $canshu .= "&".$key."=".$value;
        }
        if($vrr){
            $info['prev'] = "/admin/index/detail?id=".$vrr['id']."&types=zl".$canshu;
        }
        if($next){
            $info['next'] = "/admin/index/detail?id=".$next[0]['id']."&types=zl".$canshu;
        }

        if(in_array($detail['street'],$this->street_arr)){
            $detail['location'] = $detail['location']."(".$detail['street'].")";
            $detail['street'] = '';
        }
        if($detail['input_people'] ==''){
            $admin = DbWork::getRow('admin', '*', ['id' => $detail['admin_id']]);
            $street = DbWork::getRow('street_admin', '*', ['admin_id' => $detail['admin_id']]);
            $detail['mobile'] = $admin['mobile'];
            $detail['username'] = $admin['username'];
        }else{
            $detail['mobile'] = $detail['mobile'];
            $detail['username'] = $detail['input_people'];
        }
        return $this->renderPartial('/admin/detail', ['detail' => $detail,'role' => $this->role_id,'types'=>$types,'info'=>$info]);
    }
    // public function actionDetailxiafa()
    // {
    //     $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
    //     $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
    //     $detail = DbWork::getRow('sculpture', '*', ['id' => $id]);
    //     $admin = DbWork::getRow('admin', '*', ['id' => $detail['admin_id']]);
    //     $street = DbWork::getRow('street_admin', '*', ['admin_id' => $detail['admin_id']]);
    //     $detail['mobile'] = $admin['mobile'];
    //     $detail['username'] = $admin['username'];
    //     // $detail['street'] = $street['street_name'];
    //     return $this->renderPartial('/admin/detailxiafa', ['detail' => $detail, 'role' => $this->role_id,'type'=>$type]);
    // }
    public function actionDetails()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $detail = DbWork::getRow('sculptures', '*', ['id' => $id]);
        
        if($detail['input_people'] ==''){
            $admin = DbWork::getRow('admin', '*', ['id' => $detail['admin_id']]);
            $street = DbWork::getRow('street_admin', '*', ['admin_id' => $detail['admin_id']]);
            $detail['mobile'] = $admin['mobile'];
            $detail['username'] = $admin['username'];
            //$detail['street'] = $street['street_name'];
        }else{
            $detail['mobile'] = $detail['mobile'];
            $detail['username'] = $detail['input_people'];
            //$detail['street'] = $detail['input_unit'];
        }
        return $this->renderPartial('/admin/details', ['detail' => $detail, 'role' => $this->role_id, 'type' => $type]);
    }
    // 审核通过 
    public function actionApproval()
    {
        $id = $this->_DATA['id'];
        switch ($this->role_level) {
            case '2':
                // 区
                $res = DbWork::update('sculpture_sub', ['status' => 1,'status_time'=>time()], ['sid' => $id]);
                break;
            default:
                return json_encode(['code' => 0]);
                break;
        }
        if($res){
            return json_encode(['code' => 1]);
        }else{
            return json_encode(['code' => 0]);
        }
        
    }
    // 街道上报操作
    public function actionShangbao()
    {
        $id = $this->_DATA['id'];
        $type = $this->_DATA['type'];
        switch ($type) {
            case '3':
                $res = DbWork::update('sculpture_sub', ['shangbao' => 1,'status'=>0,'shangbao_time'=>time()], ['sid' => $id]);
                break;
            default:
                return json_encode(['code' => 0]);
                break;
        }
        if($res){
            return json_encode(['code' => 1]);
        }else{
            return json_encode(['code' => 0]);
        }
        
    }
    // 作品评级
    public function actionPingji()
    {
        $id = (int)$this->_DATA['id'];
        $level = $this->_DATA['level'];
        $res = DbWork::update('sculpture', ['level' =>$level], ['id' => $id]);
        if($res){
            return json_encode(['code' => 1]);
        }else{
            return json_encode(['code' => 0]);
        }
        
        
    }
    public function actionApprovals()
    {
        $id = $this->_DATA['id'];
        $type = $this->_DATA['type'];
        $res = false;
        if ($type == 1) {
            // 审核通过 
            // 计算作品编号
            // DbWork::update('sculptures', ['status' => 4], ['id' => $id]);
            $sculptures = DbWork::getRow('sculptures','*',['id'=>$id]);
            $query = (new \yii\db\Query())
                    ->select('id')
                    ->from("sculpture");
            $query->andWhere(['district' => $sculptures['district']]);
            $num = $query->count();
            $sculptures['zpbh'] = $num+1;
            $sculptures['model']= ScuSize($sculptures['width'],$sculptures['length'],$sculptures['type']);
            unset($sculptures['id']);
            unset($sculptures['ip']);
            unset($sculptures['status']);
            $sculptures['admin_id'] = -1;
            $sub['wx_openid'] = $sculptures['wx_openid'];
            $sub['wx_name'] = $sculptures['wx_name'];
            $sub['wx_sex'] = $sculptures['wx_sex'];
            $sub['wx_headimgurl'] = $sculptures['wx_headimgurl'];
            $sub['weibao_danwei'] = $sculptures['weibao_danwei'];
            $sub['weibao_phone'] = $sculptures['weibao_phone'];   
            $sub['weibao_name'] = $sculptures['weibao_name'];   
            unset($sculptures['wx_openid']);
            unset($sculptures['wx_name']);
            unset($sculptures['wx_sex']);
            unset($sculptures['wx_headimgurl']);
            unset($sculptures['weibao_danwei']);
            unset($sculptures['weibao_phone']);
            unset($sculptures['weibao_name']);
            $transaction = Yii::$app->db->beginTransaction();
            $m = new DbWork();
            try {
                $res = $m->save('sculpture',$sculptures);
                if(!$res){
                    $transaction->rollBack();
                    return json_encode(['code' => 0]);
                }
                $att['sid'] = $sub['sid'] = $res;
                $res1 = $m->save('sculpture_sub',$att);
                $res2 = $m->save('sculpture_att',$sub);
                $res3 = $m->delete('sculptures',['id'=>$id]);
                $transaction->commit();
                return json_encode(['code' => 1]);
            } catch (\Exception $e) {
                $transaction->rollBack();
                return json_encode(['code' => 2]);
            }
        } else {
            $res = DbWork::delete('sculptures',['id'=>$id]);
        }
        if($res){
            return json_encode(['code' => 1]);
        }else{
            return json_encode(['code' => 0]);
        }
        
    }

    public function actionDeny()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        return $this->renderPartial('/admin/deny', ['id' => $id]);
    }

    public function actionDenys()
    { 
        $id = $this->_DATA['id'];
        $deny = $this->_DATA['deny'];
        // 判断级别 是 市 区驳回
        switch ($this->role_level) {
            case '2':
                // 区
                $res = DbWork::update('sculpture_sub', ['status' => 2,'shangbao'=>'0','content'=>$deny,'status_time'=>time()], ['sid' => $id]);
                break;
            default:
                return json_encode(['code' => 0]);
                break;
        }
        if($res){
            return json_encode(['code' => 1]);
        }else{
            return json_encode(['code' => 0]);
        }
    }
    // 日常巡查 列表页
    public function actionSign_views()
    {
        $district = empty($this->_GETDATA['district']) ? '' :$this->_GETDATA['district']; //Yii::$app->request->get('district');
        $street = empty($this->_GETDATA['street']) ? '' :$this->_GETDATA['street']; //Yii::$app->request->get('street');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $nian = empty($this->_GETDATA['nian']) ? '' :$this->_GETDATA['nian']; //Yii::$app->request->get('nian');
        $yue = empty($this->_GETDATA['yue']) ? '' :$this->_GETDATA['yue']; //Yii::$app->request->get('yue');
        // $location = empty($this->_GETDATA['location']) ? '' :$this->_GETDATA['location']; //Yii::$app->request->get('yue');
        if(empty($nian) || empty($yue)){
            $nian = $DateY = (string)date("Y");
            $DateM = (string)date("m");
            $spring = array('01','02','03');
            $summer = array('04','05','06');
			$autumn = array('07','08','09');
            $winter = array('10','11','12');
            if(in_array($DateM,$spring)){ $yue = '03';}
            if(in_array($DateM,$summer)){ $yue = '06';}
            if(in_array($DateM,$autumn)){ $yue = '09';}
            if(in_array($DateM,$winter)){ $yue = '12';}
            $BeginDate=$nian.$yue;
        }else{
            $BeginDate = $nian.$yue;
        }
        $dizhi = DbWork::queryAll("select distinct(district) from location where status=1");
        $dizhi = DistrictSort($dizhi);
        $page['totalCount'] = 0;
        $page = (Object)($page);
        $dizhis = array();
        $spring = array('01','02','03');
        $summer = array('04','05','06');
		$autumn = array('07','08','09');
        $winter = array('10','11','12');
        if(in_array((string)date("m"),$spring)){ $sj_time = date("Y").'03';}
        if(in_array((string)date("m"),$summer)){ $sj_time = date("Y").'06';}
        if(in_array((string)date("m"),$autumn)){ $sj_time = date("Y").'09';}
        if(in_array((string)date("m"),$winter)){ $sj_time = date("Y").'12';}
        if((int)$BeginDate <=202103 || $BeginDate>$sj_time){
            return $this->renderPartial('/admin/sign_lists_new',['dizhi'=>$dizhi,'nian'=>$nian,'yue'=>$yue,'district'=>$district,'street'=>$street,'list'=>array(),'page'=>$page,'pages'=>0,'dizhis'=>$dizhis,'type'=>$type]);
            die;
        }

        // 获取时间
        
		$query = (new \yii\db\Query())

            ->select('sculpture.zpbh,sculpture.id,sculpture.name,sculpture.district,punch_list.day,punch_list.content,sculpture_sub.status_time')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin("punch_list", "sculpture.id  = punch_list.sculpture_id and punch_list.day='$BeginDate'")
            ->from("sculpture");
        $query->andWhere(['sculpture_sub.status'=>1]); 
        $query->andWhere(['sculpture.del'=>0]); 
        $query->andWhere(['<=','sculpture_sub.status_time',getthemonth(substr($BeginDate,0,4).'-'.substr($BeginDate,4,6).'-01')]); 
        $query->distinct(TRUE); //是否唯一查询 
        $dizhis = array();
        $dizhi = array();
        // 根据级别获取 获取地理位置
        switch ($this->role_level) {
            case '0':
                $dizhi = DbWork::queryAll("select distinct(district) from location where status=1");
                $dizhi = DistrictSort($dizhi);
                if($district){
                    $dizhis = DbWork::queryAll("select * from location where status=1 and district='{$district}'");
                }
                break;
            case '1':
                $dizhi = DbWork::queryAll("select distinct(district) from location where status=1");
                $dizhi = DistrictSort($dizhi);
                if($district){
                    $dizhis = DbWork::queryAll("select * from location where status=1 and district='{$district}'");
                }
                break;
            case '2':
                $districts = str_replace('委宣传部','',$this->admin_name);
                $dizhis = DbWork::queryAll("select * from location where status=1 and district='{$districts}'");
                $query->andWhere(['sculpture.district'=>$districts]);
                break;
            case '3':
                 $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $jurisdiction =  DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->admin_id]);
                $query->andWhere(['sculpture.street'=>$jurisdiction['jurisdiction']]);
                break;
            default:
                die('权限不足');
                break;
        }
        if($district){
           $query->andWhere(['sculpture.district'=>$district]); 
        }
        if($street){
           $query->andWhere(['sculpture.street'=>$street]); 
        }
        switch ($type) {
            case '1':
                $query->andWhere(['<>','punch_list.day','']); 
                break;
            case '2':
                $query->andWhere(['punch_list.day'=>null]); 
                break;
            default:
                # code...
                break;
        }
        $query->orderBy('sculpture.id ASC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => @$countQuery->count(), 'defaultPageSize' => '500',"PageSize"=>'500', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        
        $pages = ceil($page->totalCount/500);
        return $this->renderPartial('/admin/sign_lists_new',['dizhi'=>$dizhi,'nian'=>$nian,'yue'=>$yue,'district'=>$district,'street'=>$street,'list'=>$list,'page'=>$page,'pages'=>$pages,'dizhis'=>$dizhis,'type'=>$type]);
    }
	// 巡查统计
    public function actionSigncount()
    {
        $nian = empty($this->_GETDATA['nian']) ? '' :$this->_GETDATA['nian']; //Yii::$app->request->get('nian');
        $yue = empty($this->_GETDATA['yue']) ? '' :$this->_GETDATA['yue']; //Yii::$app->request->get('yue');
        if(empty($nian) || empty($yue)){
            $nian = $DateY = (string)date("Y");
            $DateM = (string)date("m");
            $spring = array('01','02','03');
            $summer = array('04','05','06');
            $autumn = array('07','08','09');
            $winter = array('10','11','12');
            if(in_array($DateM,$spring)){ $yue = '03';}
            if(in_array($DateM,$summer)){ $yue = '06';}
            if(in_array($DateM,$autumn)){ $yue = '09';}
            if(in_array($DateM,$winter)){ $yue = '12';}
            $BeginDate=$nian.$yue;
        }else{
            $BeginDate = $nian.$yue;
        }
        $dizhi = DbWork::queryAll("select distinct(district) from location where status=1");
        $dizhi = DistrictSort($dizhi);
        foreach ($dizhi as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('sculpture.zpbh,sculpture.id,sculpture.name,sculpture.district,punch_list.day,punch_list.content,sculpture_sub.status_time')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->leftJoin("punch_list", "sculpture.id  = punch_list.sculpture_id and punch_list.day='$BeginDate'")
                ->from("sculpture");
            $query->andWhere(['sculpture_sub.status'=>1]); 
            $query->andWhere(['sculpture.district'=>$value['district']]); 
            $query->andWhere(['sculpture.del'=>0]); 
            $query->andWhere(['<=','sculpture_sub.status_time',getthemonth(substr($BeginDate,0,4).'-'.substr($BeginDate,4,6).'-01')]); 
            $query->distinct(TRUE); //是否唯一查询  
            $query->andWhere(['<>','punch_list.day','']);
            // 已巡查
            $dizhi[$key]['sign_num'] = $query->count();

            $querys = (new \yii\db\Query())
                ->select('sculpture.zpbh,sculpture.id,sculpture.name,sculpture.district,sculpture_sub.status_time')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
            $querys->andWhere(['sculpture_sub.status'=>1]); 
            $querys->andWhere(['sculpture.district'=>$value['district']]); 
            $querys->andWhere(['sculpture.del'=>0]); 
            $querys->andWhere(['<=','sculpture_sub.status_time',getthemonth(substr($BeginDate,0,4).'-'.substr($BeginDate,4,6).'-01')]); 
            $querys->distinct(TRUE); //是否唯一查询  
            $dizhi[$key]['sign_nums'] = $querys->count();
        }
        return $this->renderPartial('/admin/sign_lists_count',['dizhi'=>$dizhi,'nian'=>$nian,'yue'=>$yue]);
    }
    // 日常巡查 下一页
    public function actionSignjson()
    {
        $district = empty($this->_DATA['district']) ? '' :$this->_DATA['district'];
        $street = empty($this->_DATA['street']) ? '' :$this->_DATA['street'];
        $day = empty($this->_DATA['day']) ? '' :$this->_DATA['day']; 
        $page = empty($this->_DATA['page']) ? '' :$this->_DATA['page']; 
        $type = empty($this->_DATA['type']) ? '' :$this->_DATA['type'];
        $spring = array('01','02','03');
        $summer = array('04','05','06');
		$autumn = array('07','08','09');
        $winter = array('10','11','12');
        if(in_array((string)date("m"),$spring)){ $sj_time = date("Y").'03';}
        if(in_array((string)date("m"),$summer)){ $sj_time = date("Y").'06';}
        if(in_array((string)date("m"),$autumn)){ $sj_time = date("Y").'09';}
        if(in_array((string)date("m"),$winter)){ $sj_time = date("Y").'12';}
        if((int)$day <=202103 || (int)$day>(int)$sj_time){
            return json_encode(['code' => 200, 'msg' => '获取成功','data'=>array(),'num'=>0]);
        }


   
		$query = (new \yii\db\Query())
            ->select('sculpture.zpbh,sculpture.id,sculpture.name,sculpture.district,punch_list.day,punch_list.content,sculpture_sub.status_time')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin("punch_list", "sculpture.id  = punch_list.sculpture_id and punch_list.day='$day'")
            ->from("sculpture");
        $query->andWhere(['sculpture_sub.status'=>1]); 
        $query->andWhere(['sculpture.del'=>0]); 
        $query->andWhere(['<=','sculpture_sub.status_time',getthemonth(substr($day,0,4).'-'.substr($day,4,6).'-01')]);
        $query->distinct(TRUE); //是否唯一查询
        switch ($this->role_level) {
            case '2':
                $districts = str_replace('委宣传部','',$this->admin_name);
                $query->andWhere(['sculpture.district'=>$districts]);
                break;
            case '3':
                $jurisdiction =  DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->admin_id]);
                $query->andWhere(['sculpture.street'=>$jurisdiction['jurisdiction']]);
                break;
            default:
                break;
        }
        if($district){
           $query->andWhere(['sculpture.district'=>$district]); 
        }
        if($street){
           $query->andWhere(['sculpture.street'=>$street]); 
        }
        switch ($type) {
            case '1':
                $query->andWhere(['<>','punch_list.day','']); 
                break;
            case '2':
                $query->andWhere(['punch_list.day'=>null]); 
                break;
            default:
                # code...
                break;
        }
        $query->orderBy('sculpture.id ASC');
        $countQuery = clone $query;
        $list = $query->offset(($page) * 500)->limit(500)->all();
        foreach ($list as $key => $value) {
            $value['district'] = str_replace('公司','',$value['district']);
            $list[$key]['zpbh'] = str_replace('区','',$value['district']).str_pad($value['zpbh'],3,"0",STR_PAD_LEFT);
        }
        return json_encode(['code' => 200, 'msg' => '获取成功','data'=>$list,'num'=>@$countQuery->count()]);
    }
    public function actionSigninfo()
    {
        $id = empty($this->_GETDATA['id']) ? '' : $this->_GETDATA['id'];
        $day = empty($this->_GETDATA['day']) ? '' : $this->_GETDATA['day'];
        $id = (int)$id;
        $query = (new \yii\db\Query())
            ->select('day')
            ->groupBy('day')
            ->from("punch_list");
        $query->andWhere(['sculpture_id'=>$id]); 
        $days = $query->all();
        $query = (new \yii\db\Query())
            ->select('punch_list.*,sculpture.zpbh,sculpture.district')
            ->leftJoin('sculpture', 'punch_list.sculpture_id  = sculpture.id')
            ->from("punch_list");
        $query->andWhere(['sculpture_id'=>$id]);  
        $query->distinct(TRUE); //是否唯一查询
        $list = $query->all();   
        // $list =  DbWork::getRow('punch_list', '*', ['sculpture_id' => $id]);
        return $this->renderPartial('/admin/signinfonew',['list' => $list,'days'=>$days,'day'=>$day]);
        
    }
	public function actionSigninfos()
    {
        $id = empty($this->_GETDATA['id']) ? '' : $this->_GETDATA['id'];
        $id = (int)$id;
        $detail =  DbWork::getRow('punch_list', '*', ['id' => $id]);
        return $this->renderPartial('/admin/signinfos',['detail' => $detail]);
        
    }
    public function actionSignedit()
    {
        $where = $this->_DATA;
        unset($where['_csrf']);
        unset($where['file']);
        $where['image'] = implode(';',$where['image']);
        $id = (int)$where['id'];
        unset($where['id']);
        $res = DbWork::update('punch_list',$where,['id'=>$id]);
        if($res){
            echo "<script>alert('修改成功'); window.close();</script>";
            die;
        }else{
            echo "<script>alert('修改失败'); javascript:history.go(-1)</script>";
            die;
        }
        
    }
    /**
     * 任务列表
     * @return string
     */
    public function actionTask_list()
    {
        $approval_name = empty($this->_GETDATA['role_name']) ? '' :$this->_GETDATA['role_name']; //Yii::$app->request->get('role_name');
        $query = (new \yii\db\Query())
            ->select('task_list.*,adminrole.level')
            ->leftJoin('adminrole', 'task_list.admin_id  = adminrole.admin_id')
            ->from("task_list");

        switch ($this->role_level) {
            case '0':
                // 获取所有的任务
                $query->orWhere(['task_list.publish_admin_id'=>$this->admin_id]);
                $query->orWhere(['task_list.shi_uid'=>$this->admin_id]);
                $query->orWhere(['task_list.admin_id'=>$this->admin_id]);
                break;
            case '1':
                $query->orWhere(['task_list.publish_admin_id'=>$this->admin_id]);
                $query->orWhere(['task_list.shi_uid'=>$this->admin_id]);
                $query->orWhere(['task_list.admin_id'=>$this->admin_id]);
                break;
            case '2':
                $query->orWhere(['task_list.publish_admin_id'=>$this->admin_id]);
                $query->orWhere(['task_list.qu_uid'=>$this->admin_id]);
                $query->orWhere(['task_list.admin_id'=>$this->admin_id]);
                break;
            case '3':
                $query->orWhere(['task_list.publish_admin_id'=>$this->admin_id]);
                $query->orWhere(['task_list.xiang_uid'=>$this->admin_id]);
                $query->orWhere(['task_list.admin_id'=>$this->admin_id]);
                break;
            default:
                die('权限不足');
                break;
        }
        $query->orderBy('task_list.ob_id DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );

        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/task_list', ['list' => $list, 'pages' => $page,"role_name"=>$approval_name]);
    }
    /**
     * 任务详情页
     * @return string
     */
    public function actionTaskinfo()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $detail = DbWork::getRow('task_list', '*', ['ob_id' => $id]);
        return $this->renderPartial('/admin/taskinfo', ['detail' => $detail]);
    }
    /**
     * 添加任务页
     * @return string
     */
    public function actionAdd_task()
    {
        switch ($this->role_level) {
            case 0:
                // 获取所有的街道信息
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['level'=>3]);
                break;
            case 1:
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username as jurisdiction,parent,adminrole.admin_id')
                    ->from("adminrole")
                    ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
                $query->andWhere(['>=','admin.id','3322']);
                $query->andWhere(['<=','admin.id','3355']);
                $query->andWhere(['adminrole.level' => 2]);
                $info = $query->all();
                // $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['level'=>2]);
                break;
            case 2:
                // 获取对应权限的街道
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['parent'=>$this->admin_id]);
                break;
            case 3:
                // 基层员工
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username as jurisdiction,parent,adminrole.admin_id')
                    ->from("adminrole")
                    ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
                $query->andWhere(['adminrole.parent'=>$this->admin_id]);
                $info = $query->all();    
                // $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['parent'=>$this->admin_id]);
                break;
            default:
                
                break;
        }
        // $info = DbWork::getAll('district_admin', 'id,district_name,admin_id', []);
        // 获取所有雕塑
        return $this->renderPartial('/admin/add_task', ['list' => $info]);
    }

    /**
     * 任务添加
     * @return string
     */
    public function actionTask_add()
    {
        $unit_name = $this->_DATA['district_id'];
        switch ($this->role_level) {
            case '0':

                break;
            case '1':
                $admin_name = $unit_name.'委宣传部';
                break;
            case '2':
                $admin_name = $unit_name.'管理员';
                break;
            case '3':
                $admin_name = $unit_name;
                break;
            case '4':
                break;
            default:
                break;
        }
        
        // $admin_name = $unit_name.'管理员';
        $sculpture_id = $this->_DATA['sculpture_id'];
        $district_id = $this->admin_id;
        $expect_end_time = $this->_DATA['expect_end_time'];
        $describe = $this->_DATA['describe'];
        $sculpture = DbWork::getRow('sculpture', 'name', ['id' => $sculpture_id]);
        $admin_name = DbWork::getRow('admin', 'username,id', ['username' => $admin_name]);
        // if (empty($unit_name) || empty($sculpture_id) || empty($district_id) || empty($expect_end_time) || empty($describe)) {
        //     return $this->render('error', ['exception' => '数据不完整']);
        // }
        // list($sculpture1, $sculpture2) = explode('|', $sculpture_id);
        // list($district1, $district2) = explode('|', $district_id);
        $data = array(
            'sculpture_id' => $sculpture_id,
            'sculpture_name' => $sculpture['name'],
            'describe' => $describe,
            'start_time' => date('Y-m-d'),
            'publish_admin_id' => $this->admin_id,
            'district_id' => $district_id,
            'district_name' => $this->admin_name,
            'unit_name' => $unit_name,
            'expect_end_time' => $expect_end_time,
            'create_time' => date('Y-m-d H:i:s'),
            'update_time' => date('Y-m-d H:i:s'),
            'type'=>1,
            'admin_id'=>$admin_name['id'],
            'admin_name'=>$admin_name['username'],
        );
        // 判断level  
        switch ($this->role_level) {
            case '0':

                break;
            case '1':
                $data['qu_uid'] = $admin_name['id'];
                $data['shi_uid'] = $this->admin_id;
                break;
            case '2':
                $data['xiang_uid'] = $admin_name['id'];
                break;
            case '3':
                break;
            case '4':
                break;
            default:
                break;
        }
        $res = DbWork::save('task_list', $data);

        if ($res) {
            return $this->redirect(['admin/index/task_list', 'id' => 1]);
            // $control=Yii::app()->runController('admin/index/task_list');
            // Header("Location: ../../../admin/index/task_list");
            // return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return $this->redirect(['admin/index/task_list', 'id' => 1]);
        // $control=Yii::app()->runController('admin/index/task_list');
        // Header("Location: ../../../admin/index/task_list");
        // return json_encode(['code' => 0, 'msg' => '操作失败']);
    }

    /**
     * 分配任务页
     */
    public function actionAdd_task_up()
    {
        $publish_admin_id = empty($this->_GETDATA['publish_admin_id']) ? '' :$this->_GETDATA['publish_admin_id']; //Yii::$app->request->get('publish_admin_id', '');
        $ob_id = empty($this->_GETDATA['ob_id']) ? '' :$this->_GETDATA['ob_id']; //Yii::$app->request->get('ob_id', '');

        $info = DbWork::getRow('task_list','*',['ob_id'=>$ob_id]);
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username')
            // ->where("parent =  '{$publish_admin_id}'")
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->orderBy('id ASC');
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                $query->andWhere(['parent' => $info['shi_uid']]);
                break;
            case '2':
                $query->andWhere(['parent' => $info['qu_uid']]);
                break;
            case '3':
                $query->andWhere(['parent' => $info['xiang_uid']]);
                break;
            case '4':
                break;
            default:
                break;
        }
        // 获取对应街道所有下属用户
        // $info = DbWork::getAll('adminrole','*',['parent'=>$publish_admin_id]);
        // $query = (new \yii\db\Query())
        //     ->select('admin.id,admin.username')
        //     ->where("parent =  '{$publish_admin_id}'")
        //     ->from("adminrole")
        //     ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        // $query->orderBy('id ASC');
        $level = $query->all();
        return $this->renderPartial('/admin/add_task_up', ['list' => $level, 'ob_id' => $ob_id]);
    }

    /**
     * 分配任务
     */
    public function actionAdd_task_street()
    {
        $ob_id = $this->_DATA['ob_id'];
        $street_id = $this->_DATA['sculpture_id'];
        if (empty($street_id)) {
            $list1 = $this->admin_id;
            $list2 = $this->admin_name;
        } else {
            list($list1, $list2) = explode('|', $street_id);
        }
        $arr['admin_id'] = $list1;
        $arr['admin_name'] = $list2;
        $arr['type'] = 1;
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                $arr['qu_uid'] = $list1;
                $arr['qu_status'] = 1;
                break;
            case '2':
                $arr['xiang_uid'] = $list1;
                $arr['xiang_status'] = 1;
                break;
            case '3':
                $arr['ji_uid'] = $list1;
                $arr['ji_status'] = 1;
                break;
            case '4':
                break;
            default:
                break;
        }
        
        
        $res = DbWork::update('task_list', $arr, ['ob_id' => $ob_id]);

        if($res){
            echo "<script>alert('下发成功');</script>";
            return $this->redirect("/admin/index/task_list");
        }else{
            echo "<script>alert('下发失败');</script>";
            return $this->redirect("admin/index/task_list");
        }
    }
    // 回退任务
    public function actionTask_huitui()
    {
        $ob_id = empty($this->_DATA['id']) ? '' :$this->_DATA['id'];
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                break;
            case '2':
                $arr['admin_id'] = '';
                $arr['admin_name'] = '';
                $arr['type'] = '';
                $arr['qu_uid'] = '';
                $arr['qu_status'] = '';
                break;
            case '3':
                $arr['admin_id'] = '';
                $arr['admin_name'] = '';
                $arr['type'] = '';
                $arr['xiang_uid'] = '';
                $arr['xiang_status'] = '';
                break;
            case '4':
                break;
            default:
                break;
        }
        $res = DbWork::update('task_list', $arr, ['ob_id' => $ob_id]);
        if($res){
            return json_encode(['code' => 1]); 
        }else{
             return json_encode(['code' => 0]); 
        }
    }


    /**
     * 公告列表
     * @return string
     */
    public function actionNotice_list()
    {

        $query = (new \yii\db\Query())
            ->select('*')
            ->from("announcement");
        $query->andWhere(['del'=>0]);
        $query->orderBy('id DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/notice_list', ['list' => $list, 'pages' => $page]);
    }
    /**
     * 投诉与举报列表
     * @return string
     */
    public function actionTipoffs()
    {

        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        // 获取时间
        if(empty($nian) || empty($yue)){

        }
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("tipoffs");
        switch ($type) {
            case '2':
                $query->andWhere(['type' => 0]);
                break;
            case '1':
                $query->andWhere(['type' => 1]);
                break;
            default:
                # code...
                break;
        }

        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                break;
            case '2':
                $query->andWhere(['tipoffs.district' => $this->role_jurisdiction]);
                break;
            case '3':
                $query->andWhere(['tipoffs.street' => $this->role_jurisdiction]);
                break;
            case '4':
                break;
            default:
                break;
        }
        $query->andWhere(['del' => 0]);
        $query->orderBy('addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/admin/tipoffs', ['list' => $list, 'pages' => $page,'type'=>$type]);
    }
    // 新 发文 列表页
    public function actionLetter()
    {
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type'];
        $title = empty($this->_GETDATA['title']) ? '' :$this->_GETDATA['title'];
        $query = (new \yii\db\Query())
            ->select('id,title,addtime')
            ->from("letters");
        if($title){
            $query->andWhere(['like','title',$title]);
        }
        $query->andWhere(['admin_id'=>$this->admin_id]);
        $query->orderBy('addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();  
        return $this->renderPartial('/admin/letters_list', ['list' => $list, 'pages' => $page,'title'=>$title]);
    }
    // 收文
    public function actionReceive()
    {
        $query = (new \yii\db\Query())
            ->select('letters.id,letters.title,letters_reply.id as rid,letters_reply.addtime,letters_reply.type,letters_reply.admin_id,admin.username,letters.addtime as l_addtime')
            ->join("LEFT JOIN","letters","letters_reply.lid=letters.id")
            ->join("LEFT JOIN","admin","letters_reply.admin_id=admin.id")
            ->from("letters_reply");
        $query->andWhere(['or',['letters_reply.admin_id'=>$this->admin_id],['letters_reply.send'=>$this->admin_id]]);
        // $query->andWhere(['letters_reply.path'=>0]);
        //$query->orderBy('letters_reply.addtime,letters.addtime DESC');
		$query->orderBy('letters.addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/admin/letters_receive', ['list' => $list, 'pages' => $page]);
    }
    // 发文回复
    public function actionLetters_reply()
    {
        $id = empty($this->_DATA['id']) ? '' :(int)$this->_DATA['id'];
        $path = empty($this->_DATA['path']) ? '' :(int)$this->_DATA['path'];
        $send = empty($this->_DATA['send']) ? '' :(int)$this->_DATA['send'];
        $detail = DbWork::getRow('letters_reply', '*', ['id' => $id]);
        $user = DbWork::getRow('letters', 'admin_id', ['id' => $detail['lid']]);
        if($detail['content']=='' && $detail['title']=='' && $detail['isreply']==0 && $detail['admin_id']==$this->admin_id){
            $where['title'] = $this->_DATA['title'];
            $where['content'] = stripslashes(htmlspecialchars_decode($this->_DATA['content']));
            $where['file'] = $this->_DATA['file'] ? implode(";",$this->_DATA['file']) : '';
            $where['isreply'] = 1;
            $where['isread'] = 1;
            $where['send'] = $user['admin_id'];
            $where['addtime'] = time();
            $res = DbWork::update('letters_reply', $where, ['id' =>$id]);
        }else{
            $where['title'] = $this->_DATA['title'];
            $where['content'] = stripslashes(htmlspecialchars_decode($this->_DATA['content']));
            $where['file'] = $this->_DATA['file'] ? implode(";",$this->_DATA['file']) : '';
            $where['addtime'] = time();
            $where['path'] = $id;
            $where['isreply'] = 1;
            $where['isread'] = 1;
            $where['send'] = $send;
            $where['lid'] = $detail['lid'];
            $where['admin_id'] = $this->admin_id;
            $res = DbWork::save('letters_reply', $where);
            $wheres['s_isread'] = 1;
            $res = DbWork::update('letters_reply', $wheres, ['id' =>$id]);
        }
        if($res){
            echo "<script>alert('回复成功');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }else{
            echo "<script>alert('回复失败');</script>";
            echo "<script>location.href='".$_SERVER["HTTP_REFERER"]."';</script>";
        }
        // 'title' => $this->_DATA['title'],
        // 'admin_id' => $this->admin_id,
        // 'content' => stripslashes(htmlspecialchars_decode($this->_DATA['content'])),
        // 'file' => $this->_DATA['file'],
        // 'addtime' => time(),
    }
	 //  发文追加页
    public function actionLetter_add()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $arr = DbWork::getRow('letters', 'id,title', ['id' => $id]);
        // 获取已发送的用户数组
        $query = (new \yii\db\Query())
            ->select('admin_id')
            ->from("letters_reply");
        $query->andWhere(['lid'=>$id]);
        $crr = $query->all();
        $zrr = array();
        foreach ($crr as $key => $value) {
            $zrr[] = $value['admin_id'];
        }
        $user = array();
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'1']);
        $query->andWhere(['admin.status'=>'1']);
        $shi = $query->all();
        $db = array('3344','3345','3346','3347','3348','3351','3352','3371','3372','3374','3370','3375','3373','5511','5512','5513','5514','5515','5516','5517');
        foreach ($shi as $key => $value) {
            if(in_array($value['id'],$db)){
                unset($shi[$key]);
            }
        }
        $quanshi = array();
        foreach ($shi as $key => $value) {
            if(in_array($value['id'],$zrr)){
                $value['disabled'] = true;
                $a = $value['id'];
                unset($zrr[$a]);
            }
            $quanshi[] = $value;
        }
        // 区
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent,admin_id')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'2']);
        $query->andWhere(['<','admin.id','5245']); 
        $query->andWhere(['admin.status'=>'1']);
        $query->orderBy('ord desc,id ASC');
        $jiedao = $qu = $query->all();
        foreach ($qu as $key => $value) {
            if(in_array($value['id'],$zrr)){
                $qu[$key]['disabled'] = true;
            }
        }
        foreach ($jiedao as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('admin.id,admin.username as title,parent,admin_id')
                ->from("adminrole")
                ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
            $query->andWhere(['adminrole.parent'=>$value['admin_id']]);
            $query->andWhere(['admin.status'=>'1']);
            $dbs = array('5506','5507','5508','5509');
            $query->andWhere(['not in', 'admin.id', $dbs]);
            $query->orderBy('id ASC');
            $xiang = $query->all();
            foreach ($xiang as $k => $v) {
                $xiang[$k]['title'] = str_replace('管理员','',$v['title']);
                $xiang[$k]['title'] = str_replace('001','',$xiang[$k]['title']);
                $xiang[$k]['children'] = array();
                if(in_array($v['id'],$zrr)){
                    $xiang[$k]['disabled'] = true;
                }
            }
            $jiedao[$key]['children'] = $xiang;
            $jiedao[$key]['id'] = $jiedao[$key]['id'].'aaaa';
        }
        $user[] = array("title"=>"市","id"=>"0","parent"=>"1","children"=>$quanshi);
        $user[] = array("title"=>"区","id"=>"0","parent"=>"1","children"=>$qu);
        $user[] = array("title"=>"街乡镇","id"=>"0","parent"=>"1","children"=>$jiedao);
        $data = json_encode($user);
        return $this->renderPartial('/admin/letter_add', ['user'=>$data,'arr' => $arr]);
    }
    public function actionLetter_adds()
    {
        $lid = $this->_DATA['lid'];
        $dept = $this->_DATA['dept'];
        $depts =  @$this->_DATA['depts'];
        $transaction = Yii::$app->db->beginTransaction();
        $m = new DbWork();
        try {
            // 写入
            if($dept !=''){
                $dept_arr = explode(',',$dept); 
                foreach ($dept_arr as $key => $value) {
                    $reply = array(
                        "admin_id" => $value,
                        "lid" => $lid,
                    );
                    $res = $m->save('letters_reply', $reply);  
                }
            }
            if($depts !=''){
                $depts_arr = explode(',',$depts); 
                foreach ($depts_arr as $key => $value) {
                    $reply = array(
                        "admin_id" => $value,
                        "lid" => $lid,
                        "type" => '1',
                    );
                    $ress = $m->save('letters_reply', $reply);  
                }
            }
            $transaction->commit();
            return $this->redirect(['admin/index/letter_status', 'id' => $lid]);
        } catch (\Exception $e) {
            $transaction->rollBack();
            return $this->redirect(['admin/index/letter_status', 'id' => $lid]);
        }
    }
    // 发文新增页
    public function actionAdd_letter()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $user = array();
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'1']);
        $query->andWhere(['admin.status'=>'1']);
        $shi = $query->all();
        $db = array('3344','3345','3346','3347','3348','3351','3352','3371','3372','3374','3370','3375','3373','5511','5512','5513','5514','5515','5516','5517');
        foreach ($shi as $key => $value) {
            if(in_array($value['id'],$db)){
                unset($shi[$key]);
            }
        }
        $quanshi = array();
        foreach ($shi as $key => $value) {
            $quanshi[] = $value;
        }
        // 区
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent,admin_id')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'2']);
        $query->andWhere(['<','admin.id','5245']); 
        $query->andWhere(['admin.status'=>'1']);
        $query->orderBy('ord desc,id ASC');
        $jiedao = $qu = $query->all();
        foreach ($jiedao as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('admin.id,admin.username as title,parent,admin_id')
                ->from("adminrole")
                ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
            $query->andWhere(['adminrole.parent'=>$value['admin_id']]);
            $query->andWhere(['admin.status'=>'1']);
            $dbs = array('5506','5507','5508','5509');
            $query->andWhere(['not in', 'admin.id', $dbs]);
            $query->orderBy('id ASC');
            $xiang = $query->all();
            foreach ($xiang as $k => $v) {
                $xiang[$k]['title'] = str_replace('管理员','',$v['title']);
                $xiang[$k]['title'] = str_replace('001','',$xiang[$k]['title']);
                $xiang[$k]['children'] = array();
            }
            $jiedao[$key]['children'] = $xiang;
            $jiedao[$key]['id'] = $jiedao[$key]['id'].'aaaa';
        }
        $user[] = array("title"=>"市","id"=>"0","parent"=>"1","children"=>$quanshi);
        $user[] = array("title"=>"区","id"=>"0","parent"=>"1","children"=>$qu);
        $user[] = array("title"=>"街乡镇","id"=>"0","parent"=>"1","children"=>$jiedao);
        $data = json_encode($user);
        return $this->renderPartial('/admin/add_letter', ['user'=>$data,'id' => $id]);
    }
    public function actionGetuser()
    {
        // 获取所有区级账户
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent,admin_id')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'2']);
        $query->andWhere(['<','admin.id','5245']); 
        $query->orderBy('ord desc,id ASC');
        $qu = $query->all();
        foreach ($qu as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('admin.id,admin.username as title,parent,admin_id')
                ->from("adminrole")
                ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
            $query->andWhere(['adminrole.parent'=>$value['admin_id']]);
            $query->orderBy('id ASC');
            $xiang = $query->all();
            foreach ($xiang as $k => $v) {
                $xiang[$k]['title'] = str_replace('管理员','',$v['title']);
                $xiang[$k]['subs'] = array();
            }
            $qu[$key]['subs'] = $xiang;
        }
        // 获取所有市级用户
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as title,parent')
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['adminrole.level'=>'1']);
        $query->andWhere(['<>','admin.id','3344']); 
        $query->andWhere(['<>','admin.id','3345']); 
        $query->andWhere(['<>','admin.id','3346']); 
        $query->andWhere(['<>','admin.id','3347']); 
        $query->andWhere(['<>','admin.id','3348']); 
        $query->andWhere(['<>','admin.id','3351']); 
        $query->andWhere(['<>','admin.id','3352']); 
        $query->andWhere(['<>','admin.id','3371']); 
        $query->andWhere(['<>','admin.id','3372']); 
        $query->andWhere(['<>','admin.id','3373']); 
        $query->andWhere(['<>','admin.id','3374']); 
        $query->andWhere(['<>','admin.id','3370']); 
        $query->andWhere(['<>','admin.id','3375']); 
        $query->andWhere(['<>','admin.id','5511']); 
        $query->andWhere(['<>','admin.id','5512']); 
        $query->andWhere(['<>','admin.id','5513']); 
        $query->andWhere(['<>','admin.id','5514']); 
        $query->andWhere(['<>','admin.id','5515']); 
        $query->andWhere(['<>','admin.id','5516']); 
        $query->andWhere(['<>','admin.id','5517']); 
        $query->orderBy('ord desc,id ASC');
        $level = $query->all();
        foreach ($level as $key => $value) {
            $level[$key]['subs'] = array();
        }
        $header = array("id"=>"000","title"=>"各区级用户","parent"=>"1","subs"=>$qu);
        array_unshift($level,$header);
        // $level[] = 
        // $data['data'] = $level;
        $str = json_encode($level);
        return $str;
    }
    public function actionGetusers()
    {
        $username = empty($this->_DATA['name']) ? '' :$this->_DATA['name'];
        // 构建数据
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username as deptname,parent')
            // ->where(['parent'=>0])
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->andWhere(['<>','admin.id','3344']); 
        $query->andWhere(['<>','admin.id','3345']); 
        $query->andWhere(['<>','admin.id','3346']); 
        $query->andWhere(['<>','admin.id','3347']); 
        $query->andWhere(['<>','admin.id','3348']); 
        $query->andWhere(['<>','admin.id','3351']); 
        $query->andWhere(['<>','admin.id','3352']); 
        $query->andWhere(['<>','admin.id','3371']); 
        $query->andWhere(['<>','admin.id','3372']); 
        $query->andWhere(['<>','admin.id','3373']); 
        $query->andWhere(['<>','admin.id','3374']); 
        $query->andWhere(['<>','admin.id','3370']); 
        $query->andWhere(['<>','admin.id','3375']); 
        $query->andWhere(['<>','admin.id','1']); 
        // $query->andWhere(['<>','adminrole.level','0']); 
        $query->andWhere(['admin.status'=>'1']); 
        // $query->andWhere(['admin.username'=>$username]); 
        $query->andWhere(['like','admin.username',$username]);
        // $query->andWhere(['<','admin.id','3369']); 
        // $query->orWhere(['or','admin.id','3339']); 
        $query->orderBy('ord desc,id ASC');
        // echo $query->createCommand()->getRawSql();
        $level = $query->all();  
        $data['data'] = $level;
        $data['code'] = 1;
        $str = json_encode($data);
        // $str = json_encode($zrr);
        die($str);
    }

    public function actionGetnext()
    {
        $path = $this->_DATA['path'];
        $query = (new \yii\db\Query())
            ->select('admin.id,admin.username')
            ->where("parent =  '{$path}'")
            ->from("adminrole")
            ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
        $query->orderBy('id ASC');
        $level = $query->all();
        return self::responseJson($level, 200, '请求成功');
    }
    // 发文详情页 
    public function actionLettercontent()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id'];
        $detail = DbWork::getRow('letters', '*', ['id' => (int)$id]);
        // 变成已读
        $arr['isread'] = 1;
        DbWork::update('letters_reply', $arr, ['lid' => $id,'admin_id'=>$this->admin_id,'type'=>1]);
        return $this->renderPartial('/admin/letters_info', ['detail'=>$detail,'id' => $id]);
    }
    public function actionLetter_status()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id'];
        $query = (new \yii\db\Query())
            ->select('letters_reply.id,letters_reply.isread,letters_reply.isreply,letters_reply.type,admin.username')
            ->from("letters_reply")
            ->join("LEFT JOIN","admin","letters_reply.admin_id=admin.id");
        $query->andWhere(['letters_reply.type'=>'0']); 
        $query->andWhere(['letters_reply.path'=>'0']); 
        $query->andWhere(['letters_reply.lid'=>(int)$id]); 
        $query->orderBy('letters_reply.id ASC');
        $jieshou = $query->all();
        // echo $query->createCommand()->getRawSql();
        // die;
        $query = (new \yii\db\Query())
            ->select('letters_reply.id,letters_reply.isread,letters_reply.isreply,letters_reply.type,admin.username')
            ->from("letters_reply")
            ->join("LEFT JOIN","admin","letters_reply.admin_id=admin.id");
        $query->orderBy('letters_reply.id ASC');
        $query->andWhere(['letters_reply.type'=>'1']); 
        $query->andWhere(['letters_reply.path'=>'0']); 
        $query->andWhere(['letters_reply.lid'=>(int)$id]); 
        $jieshous = $query->all();
        return $this->renderPartial('/admin/letters_status', ['id' => $id,'jieshou'=>$jieshou,'jieshous'=>$jieshous]);
    }
    // 发文 回复界面
    public function actionLettercontents()
    {
        $id = empty($this->_GETDATA['id']) ? '' :(int)$this->_GETDATA['id'];
        // $detail = DbWork::getRow('letters_reply', '*', ['id' => (int)$id]);
        $query = (new \yii\db\Query())
            ->select('letters_reply.*,admin.username')
            ->from("letters_reply")
            ->join("LEFT JOIN","admin","letters_reply.admin_id=admin.id");
        $query->andWhere(['letters_reply.id'=>(int)$id]); 
        $detail = $query->one();
		
		$query = (new \yii\db\Query())
            ->select('letters.*,admin.username as send')
            ->from("letters")
            ->join("LEFT JOIN","admin","letters.admin_id=admin.id");
        $query->andWhere(['letters.id'=>(int)$detail['lid']]); 
        $info = $query->one();
        // 变成已读
        $arr['s_isread'] = 1;
        DbWork::update('letters_reply', $arr, ['path' => $id,'send'=>$this->admin_id]);
        $arr['s_isread'] = 1;
        DbWork::update('letters_reply', $arr, ['id' => $id,'send'=>$this->admin_id]);
        $arrs['isread'] = 1;
        DbWork::update('letters_reply', $arrs, ['id' => $id,'admin_id'=>$this->admin_id]);
        // 获取发文往来历史
        $query = (new \yii\db\Query())
            ->select('letters_reply.*,admin.username')
            ->from("letters_reply")
            ->join("LEFT JOIN","admin","letters_reply.admin_id=admin.id");
        $query->andWhere(['letters_reply.type'=>'0']); 
        $query->andWhere(['letters_reply.path'=>$detail['id']]); 
        $query->andWhere(['letters_reply.lid'=>$detail['lid']]); 
        $query->orderBy('addtime ASC');
        $msg = $query->all();
        return $this->renderPartial('/admin/letters_infos', ['detail'=>$detail,'id' => $id,'msg'=>$msg,'info'=>$info]);
    }
    // 新增 发文 
    public function actionAdd_letters()
    {

        $dept = $this->_DATA['dept'];
        $depts =  @$this->_DATA['depts'];
        $transaction = Yii::$app->db->beginTransaction();
        $m = new DbWork();
        try {
            // 写入
            $data = array(
                'title' => $this->_DATA['title'],
                'admin_id' => $this->admin_id,
                'content' => stripslashes(htmlspecialchars_decode($this->_DATA['content'])),
                'file' => $this->_DATA['file'] ? implode(";",$this->_DATA['file']) : '',
                'wenhao' => $this->_DATA['wenhao'],
                'addtime' => time(),
            ); 
            $lid = $m->save('letters', $data);  
            if($dept !=''){
                $dept_arr = explode(',',$dept); 
                foreach ($dept_arr as $key => $value) {
                    $reply = array(
                        "admin_id" => $value,
                        "lid" => $lid,
                    );
                    $res = $m->save('letters_reply', $reply);  
                }
            }
            if($depts !=''){
                $depts_arr = explode(',',$depts); 
                foreach ($depts_arr as $key => $value) {
                    $reply = array(
                        "admin_id" => $value,
                        "lid" => $lid,
                        "type" => '1',
                    );
                    $ress = $m->save('letters_reply', $reply);  
                }
            }
            $transaction->commit();
            return $this->redirect(['admin/index/letter', 'id' => 1]);
        } catch (\Exception $e) {
            $transaction->rollBack();
            return $this->redirect(['admin/index/letter', 'id' => 1]);
        }
    }
    public function actionCk_upload()
    {

        $path = \Yii::$app->basePath . '/web';
        $img = getimagesize($_FILES['upload']['tmp_name']);
        if(!$img){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $type = file_format($_FILES['upload']['name']);
        if($type !=3){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $d111cn = explode('.',$_FILES['upload']['name']);
        $exif = $_FILES['upload']['tmp_name'];
        $exif_name = md5($_FILES['upload']['name'] . mt_rand(1, 9999999)) .'.'.strtolower(array_pop($d111cn));
        $file_r_path = '/upload/works_img/' . date('Y-m-d') . '/';
        $des = $path . $file_r_path . $exif_name;

        if (!is_dir($path . $file_r_path)) {
            @mkdir($des, 0777, true);
        }
        $id = @move_uploaded_file($_FILES['upload']['tmp_name'], $des);
        if (!$id) {// 上传错误提示错误信息
            $arr['uploaded'] = 0;
            $arr['error']['message'] = '上传失败';
            die(json_encode($arr));
        } else {// 上传成功
            $src = $file_r_path . $exif_name;
            // $callback = $_REQUEST["CKEditorFuncNum"];  
            $arr['uploaded'] = 1;
            // $arr['fileName'] = I('post.ckCsrfToken');
            $arr['url'] = $src;
            die(json_encode($arr));
            echo "<script type='text/javascript'>window.parent.CKEDITOR.tools.callFunction($callback,'".$src."','');</script>";  
            exit;
        }
    }
    public function actionUpload()
    {
        $path = \Yii::$app->basePath . '/web';
        $img = getimagesize($_FILES['file']['tmp_name']);
        if(!$img){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
            die;
        }
        $type = file_format($_FILES['file']['name']);

        if($type !=3){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
            die;
        }
        
        // var_dump($_FILES['file']['tmp_name']);
        // list($width,$height,$type)=getimagesize($_FILES['file']['tmp_name']);
        $d111cn = explode('.',$_FILES['file']['name']);
        $exif = $_FILES['file']['tmp_name'];
        $exif_name = md5($_FILES['file']['name'] . mt_rand(1, 9999999)) .'.'.strtolower(array_pop($d111cn));
        $file_r_path = '/upload/img/' . date('Y-m-d') . '/';
        $des = $path . $file_r_path . $exif_name;

        if (!is_dir($path . $file_r_path)) {
            @mkdir($des, 0777, true);
        }
        $id = @move_uploaded_file($_FILES['file']['tmp_name'], $des);
        if (!$id) {
            // return $this->responseJson([], 400, '上传失败');
            $arr['code'] = 400;
            $arr['msg'] = '上传失败';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $arr['code'] = 200;
        $arr['msg'] = '上传成功';
        $arr['data']['src'] = $file_r_path . $exif_name;
        $ss = self::getThumb('.'.$arr['data']['src'],400,400);
        if($ss){
            return json_encode($arr);
        }else{
            $arr['code'] = 400;
            $arr['msg'] = '上传失败';
            $arr['data']['src'] = "";
        }
        // self::compressedImage('.'.$arr['data']['src'],$file_r_path);
        
        // return $this->responseJson(['url' => $file_r_path . $exif_name], 200, '请求成功');
    }
    /**
     * 图片压缩处理
     * @param string $sFile 源图片路径
     * @param int $iWidth 自定义图片宽度
     * @param int $iHeight 自定义图片高度
     * @return string 压缩后的图片路径
     */
    function getThumb($sFile,$iWidth,$iHeight){
        //图片公共路径
        $public_path = '';
        //判断该图片是否存在
        if(!file_exists($public_path.$sFile)) return $sFile;
        //判断图片格式(图片文件后缀)
        $extend = explode("." , $sFile);
        $attach_fileext = strtolower($extend[count($extend) - 1]);
        if (!in_array($attach_fileext, array('jpg','png','jpeg'))){
        return '';
        }
        //压缩图片文件名称
        $sFileNameS = str_replace(".".$attach_fileext, "_".$iWidth.'_'.$iHeight.'.'.$attach_fileext, $sFile);
        //判断是否已压缩图片，若是则返回压缩图片路径
        if(file_exists($public_path.$sFileNameS)){
        return $sFileNameS;
        }
            
        //生成压缩图片，并存储到原图同路径下
        self::resizeImage($public_path.$sFile, $public_path.$sFileNameS, $iWidth, $iHeight);
        if(!file_exists($public_path.$sFileNameS)){
            return $sFile;
        }
        return $sFileNameS;
    }
    /**
 * 生成图片
 * @param string $im 源图片路径
 * @param string $dest 目标图片路径
 * @param int $maxwidth 生成图片宽
 * @param int $maxheight 生成图片高
 */
function resizeImage($im, $dest, $maxwidth, $maxheight) {
    $img = getimagesize($im);
    switch ($img[2]) {
    case 1:
     $im = @imagecreatefromgif($im);
     break;
    case 2:
     $im = @imagecreatefromjpeg($im);
     break;
    case 3:
     $im = @imagecreatefrompng($im);
     break;
    }
     
    $pic_width = imagesx($im);
    $pic_height = imagesy($im);
    $resizewidth_tag = false;
    $resizeheight_tag = false;
    if (($maxwidth && $pic_width > $maxwidth) || ($maxheight && $pic_height > $maxheight)) {
    if ($maxwidth && $pic_width > $maxwidth) {
     $widthratio = $maxwidth / $pic_width;
     $resizewidth_tag = true;
    }
     
    if ($maxheight && $pic_height > $maxheight) {
     $heightratio = $maxheight / $pic_height;
     $resizeheight_tag = true;
    }
     
    if ($resizewidth_tag && $resizeheight_tag) {
     if ($widthratio < $heightratio)
     $ratio = $widthratio;
     else
     $ratio = $heightratio;
    }
     
     
    if ($resizewidth_tag && !$resizeheight_tag)
     $ratio = $widthratio;
    if ($resizeheight_tag && !$resizewidth_tag)
     $ratio = $heightratio;
    $newwidth = $pic_width * $ratio;
    $newheight = $pic_height * $ratio;
     
    if (function_exists("imagecopyresampled")) {
     $newim = imagecreatetruecolor($newwidth, $newheight);
     imagecopyresampled($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $pic_width, $pic_height);
    } else {
     $newim = imagecreate($newwidth, $newheight);
     imagecopyresized($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $pic_width, $pic_height);
    }
     
    imagejpeg($newim, $dest);
    imagedestroy($newim);
    } else {
    imagejpeg($im, $dest);
    }
   }
    public function actionUploadletter()
    {
        $path = \Yii::$app->basePath . '/web';
        if($_FILES['file']['size'] < 30000){
            $arr['code'] = 400;
            $arr['msg'] = '请上传指定类型文件';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $type = file_format($_FILES['file']['name']);
        if($type ==6){
            $arr['code'] = 400;
            $arr['msg'] = '请上传指定类型文件';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $d111cn = explode('.',$_FILES['file']['name']);
        $exif = $_FILES['file']['tmp_name'];
        $exif_name = md5($_FILES['file']['name'] . mt_rand(1, 9999999)) .'.'.strtolower(array_pop($d111cn));
        $file_r_path = '/upload/img/' . date('Y-m-d') . '/';
        $des = $path . $file_r_path . $exif_name;

        if (!is_dir($path . $file_r_path)) {
            @mkdir($des, 0777, true);
        }
        $id = @move_uploaded_file($_FILES['file']['tmp_name'], $des);
        if (!$id) {
            // return $this->responseJson([], 400, '上传失败');
            $arr['code'] = 400;
            $arr['msg'] = '上传失败';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $arr['code'] = 200;
        $arr['msg'] = '上传成功';
        $arr['data']['src'] = $file_r_path . $exif_name;
        return json_encode($arr);
        // return $this->responseJson(['url' => $file_r_path . $exif_name], 200, '请求成功');
    }

    /**
     * 添加公告页
     * @return string
     */
    public function actionAdd_notice_view()
    {
        return $this->renderPartial('/admin/add_notice', []);
    }

    /**
     * 公告添加
     * @return string
     */
    public function actionNotice_add()
    {
        $title = $this->_DATA['title'];
        $content = $this->_DATA['content'];

        if (empty($title) || empty($content)) {
            return json_encode(['code' => 0, 'msg' => '内容为空']);
        }

        $data = array(
            'title' => $title,
            'content' => $content,
            'create_time' => date('Y-m-d H:i:s'),
        );

        $res = DbWork::save('announcement', $data);

        if ($res) {
            return json_encode(['code' => 1, 'msg' => '添加成功']);
        }
        return json_encode(['code' => 0, 'msg' => '添加失败']);
    }

    /**
     * 公告详情
     */
    public function actionNotice_detail()
    {
        $id = empty($this->_GETDATA['id']) ? '' :$this->_GETDATA['id']; //Yii::$app->request->get('id', '');
        $detail = DbWork::getRow('announcement', '*', ['id' => $id]);

        return $this->renderPartial('/admin/notice_detail', ['detail' => $detail]);
    }
    public function actionWelcome()
    {
        // 待审核
        $query = (new \yii\db\Query())
                ->select('sculpture.id,admin.username,sculpture_sub.status,sculpture_sub.shangbao')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        $arr['daichuli'] = 0;
        $arr['yichuli'] = 0;
        switch ($this->role_level) {
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                $xia_qu = $this->admin_name;
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                $query->andWhere(['sculpture_sub.shangbao' => 1]);
                $query->andWhere(['sculpture_sub.status' => 0]);
                //$query->andWhere(['sculpture.qu_shangbao' => 0]);
                $query->andWhere(['sculpture.del'=>0]);
                $arr['daichuli'] = $query->count();
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
                $query->andWhere(['sculpture_sub.shangbao' => 0]);
                $street = array();
                $district = array();
                $role_jurisdiction = $this->role_jurisdiction;
                // echo $role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                $query->andWhere(['sculpture.del'=>0]);
                $arr['daichuli'] = $query->count();
				$jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                // $query->andWhere(['sculpture.status' => 1]);
                break;
            case '4':
                $query->andWhere(['sculpture.del'=>0]);
                $arr['daichuli'] = 0;
                break;
            default:
                //die('权限不足');
                break;
        }
        // 已审核
        $query = (new \yii\db\Query())
                ->select('sculpture.id,admin.username,sculpture_sub.status,sculpture_sub.shangbao')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->from("sculpture");
        switch ($this->role_level) {
            case '2':
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                $query->andWhere(['sculpture_sub.shangbao' => 1]);
                $query->andWhere(['or',['sculpture_sub.status'=>1],['sculpture_sub.status'=>2]]);
                $query->andWhere(['sculpture.del'=>0]);
                $arr['yichuli'] = $query->count();
                break;
            case '3':
                // 获取已上报的信息
				$jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $query->andWhere(['sculpture_sub.shangbao' => 1]);
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                $query->andWhere(['sculpture.del'=>0]);
                $arr['yichuli'] = $query->count();
                break;
            case '4':
                $query->andWhere(['sculpture.del'=>0]);
                $arr['yichuli'] = 0;
                break;
            default:
               // die('权限不足');
                break;
        }
        

        // 公开艺术品总数
        $query = (new \yii\db\Query())
                ->select('sculpture.*,admin.username')
                ->from("sculpture");
        switch ($this->role_level) {
            case '0':
                $query->andWhere(['sculpture.is_show' => 1]);
                break;
            case '1':
                $admin = $this->admin_id;
                $query->andWhere(['sculpture.is_show' => 1]);
                break;
            case '2':
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                $query->andWhere(['sculpture.is_show' => 1]);
                break;
            case '3':
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                $query->andWhere(['sculpture.is_show' => 1]);
                break;
            case '4':
                $admin = $this->admin_id;
                $query->andWhere(['sculpture.admin_id'=>$admin]);
                $query->andWhere(['sculpture.is_show' => 1]);
                break;
            default:
                //die('权限不足');
                break;
        }
        $query->andWhere(['sculpture.del'=>0]);
        $arr['gongkai'] = $query->count();

        $query = (new \yii\db\Query())
            ->select('*')
            ->from("announcement");
        $query->andWhere(['del'=>0]);
        $query->orderBy('id DESC');
        $countQuery = clone $query;
        $list = $query->limit(5)->all();

        return $this->renderPartial('/admin/welcome',['data' => $arr,'list'=>$list]);
    }
    public function actionNotice_del()
    {
        $list = array();
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        if($type == 2){
            // 通知
            $query = (new \yii\db\Query())
                ->select('*')
                ->from("announcement");
            $query->andWhere(['del'=>1]);
            $query->orderBy('id DESC');
            $countQuery = clone $query;
            $page = new Pagination(
                ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
            );
            $list = $query->offset($page->offset)->limit($page->limit)->all();
            return $this->renderPartial('/admin/notice_del',['list'=>$list,'type'=>$type,'pages'=>$page]);
        }elseif ($type == 1) {
            // 回信
            $query = (new \yii\db\Query())
                ->select('*')
                ->from("letter");
            $query->andWhere(['receive'=>$this->admin_id]);
            $query->andWhere(['<>','path',0]);
            $query->andWhere(['del'=>1]);
            $query->orderBy('del_time DESC');
            $countQuery = clone $query;
            $page = new Pagination(
                ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
            );
            $list = $query->offset($page->offset)->limit($page->limit)->all();
            foreach ($list as $key => $value) {
                $detail = DbWork::getRow('admin', 'username', ['id' => $value['send']]);
                $list[$key]['send'] = $detail['username'];
                $list[$key]['receive'] = '本账户';
                
            }
            // echo $query->createCommand()->getRawSql();
            return $this->renderPartial('/admin/notice_del',['list'=>$list,'type'=>$type,'pages'=>$page]);
        }else{
            // 发文
            $query = (new \yii\db\Query())
                ->select('*')
                ->from("letter");
            $query->andWhere(['send'=>$this->admin_id]);
            $query->andWhere(['del'=>1]);
            $query->andWhere(['path'=>0]);
            $query->orderBy('del_time DESC');
            $countQuery = clone $query;
            $page = new Pagination(
                ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
            );
            $list = $query->offset($page->offset)->limit($page->limit)->all();
            foreach ($list as $key => $value) {
                $detail = DbWork::getRow('admin', 'username', ['id' => $value['receive']]);
                $list[$key]['receive'] = $detail['username'];
                $list[$key]['send'] = '本账户';
                
            }
            
            return $this->renderPartial('/admin/notice_del',['list'=>$list,'type'=>$type,'pages'=>$page]);
        }

        
    }
    public function actionGetinfo()
    {
        $openid = $this->_DATA['id'];
        if(!empty($openid)){
            $access = self::get_access_token();
            $url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token={$access}&openid={$openid}&lang=zh_CN";
            $data = self::Geturl($url);
            if($data){
                return json_encode(['code' => 1,'data'=>$data]); 
            }
        }else{
          return json_encode(['code' => 0]);  
        }

    }
    public function get_access_token()
    {
        $res = DbWork::getRow('accesstoken', '*', ['id' => 1]);
        $sc_time = time()-$res['time'];
        if($sc_time >= 7000){
            $appid = 'wxd4f2106846f1f913';
            $secret = 'b34a2d41611bf0941317e54409593302';
            // $url = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
            $url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$appid}&secret={$secret}";
            $data = self::Geturl($url);
            if($data){
                $arr['time'] = time();
                $arr['access_token'] = $data['access_token'];
                DbWork::update('accesstoken', $arr, ['id' => 1]);
                $access_token = $data['access_token'];
            return $access_token;
            }else{
                die("获取access_token 出错");
            }
        }else{
            $access_token = $res['access_token'];
            return $access_token;
        }
    }
    public function Geturl($url){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return json_decode($output,true);
    } 
    // 查重
    public function actionChachong()
    {
        $id = Yii::$app->request->get('id');
        // 获取经纬度 
        $detail = DbWork::getRow('sculpture', 'id,longitude,latitude,name', ['id' => $id]);
        $query = (new \yii\db\Query())
            ->select('id,name,longitude,latitude,img_url,district,street,location,is_show')
            ->where(['del'=>0])
            ->andWhere(['<>','id',$id]) 
            ->from("sculpture");
        $list = $query->all();
        $arr = array();
        foreach ($list as $k => $v) {
            $kil = self::actionGetdistance($detail['longitude'],$detail['latitude'],$v['longitude'],$v['latitude']);
            if($kil<=50){
                $arr[] = $v;
            }
        }
        $page = new Pagination(
            ['totalCount' => count($arr), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $start=($page_now-1)*10;//偏移量，当前页-1乘以每页显示条数
        $arr = array_slice($arr,$start,10);
        return $this->renderPartial('/admin/chachongs',["list"=>$arr,"pages" => $page,"page_now"=>$page_now,]);
        // 
    }
    // 获取上级用户列表
    public function actionGetparent()
    {
        $level = $this->_DATA['level'];
        if(!empty($level)){
            $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>1]);
                $query->andWhere(['adminrole.level' => $level-1]);
                $query->orderBy('admin.id DESC');
                $list = $query->all();
            if($list){
                return json_encode(['code' => 1,'data'=>$list]); 
            }
        }else{
          return json_encode(['code' => 0]);  
        }
    }
    // 获取所负责的区域
    public function actionGetparentqy()
    {
        $qy = $this->_DATA['qy'];
        if(!empty($qy)){
            // 先获取父级的负责区域
            $detail = DbWork::getRow('adminrole', '*', ['admin_id' => $qy]);
            $jurisdiction = $detail['jurisdiction'];
            if($detail['level'] ==3){
                $quyu = array("id"=>"0","street"=>$detail['jurisdiction']);
            }elseif($detail['level'] ==2){
                $query = (new \yii\db\Query())
                    ->select('*')
                    ->where(['district'=>$jurisdiction,'status' => 1])
                    ->from("location");
                $quyu = $query->all();
            }else{
                $quyu = array("id"=>"0","street"=>"默认");
            }
            // 通过区域获取下级区域
            
            if($quyu){
                return json_encode(['code' => 1,'data'=>$quyu]); 
            }
        }else{
          return json_encode(['code' => 0]);  
        }
    }
    // 经纬度分组距离
    public function actionJuli()
    {
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        if($type =="chachong"){
            $this->redirect(array('/admin/index/chachong'));
            // return $this->renderPartial('/admin/juli');
        }
        $query = (new \yii\db\Query())
                    ->select('id,name,longitude,latitude')
                    ->where(['del'=>0])
                    ->from("sculpture");
        $list = $query->all();
        foreach ($list as $key => $value) {
            $longitude = trim(str_replace('（E）','', $value['longitude']));
            $longitude = preg_replace('/([\x80-\xff]*)/i','',$longitude);
            $longitude = trim(str_replace('E','', $longitude));
            $longitude = trim(str_replace('（N）','', $longitude));
            $list[$key]['longitude'] = trim(str_replace('N','', $longitude));

            $latitude = trim(str_replace('（E）','', $value['latitude']));
            $latitude = preg_replace('/([\x80-\xff]*)/i','',$latitude);
            $latitude = trim(str_replace('E','', $latitude));
            $latitude = trim(str_replace('（N）','', $latitude));
            $list[$key]['latitude'] = trim(str_replace('N','', $latitude));
        }
        foreach ($list as $key => $value) {
            $ids = "";
            if((strpos($value['longitude'],'-') !== false) || (strpos($value['latitude'],'-') !== false)){ 
                unset($list[$key]);
                continue;
            }
            foreach ($list as $k => $v) {
                if((strpos($v['longitude'],'-') !== false) || (strpos($v['latitude'],'-') !== false)){ 
                    continue;
                }
                if($value['id'] == $v['id']){ 
                    continue;
                }
                $kil = self::actionGetdistance($value['longitude'],$value['latitude'],$v['longitude'],$v['latitude']);
                if($kil<=50 && $value['name']==$v['name']){
                    if($ids == ""){
                        $ids .=$v['id'];
                    }else{
                        $ids .=",".$v['id'];
                    }
                }
            }
            if($ids ==""){
                unset($list[$key]);
            }else{
                $list[$key]['ids'] = $ids;
            }
        }
        foreach ($list as $key => $value) {
            $del = 0;
            $ids_arr = explode(',', $value['ids']);
            $ids_arr[] = $value['id'];
            // if(count($ids_arr) == 1){
            foreach ($list as $k => $v) {
                if($v['id'] != $value['id']){
                    $ids_arrv = explode(',', $v['ids']);
                    $ids_arrv[] = $v['id'];
                    $cou = count(array_diff($ids_arrv,$ids_arr));
                    if($cou == 0){
                        $del = 1;
                    }
                }
            }
            if($del == 1){
                unset($list[$key]);
            }
            

        }
        foreach ($list as $key => $value) {
            $detail = DbWork::getRow('chachong', '*', ['sid' => $value['id'],'type' => 0]);
            if($detail){
                $arrs = explode(',', $detail['ids']);
                $arrss = explode(',', $value['ids']);
                // $zrr = array_diff_assoc($arrs, $arrss);
                foreach ($arrss as $z => $x) {
                    foreach ($arrs as $e => $a) {
                        if($x == $a){
                            unset($arrss[$z]);
                        }
                    }
                }
                    
                if(empty($arrss)){
                    unset($list[$key]);
                }else{
                    $list[$key]['ids'] = implode(',', $arrss);
                }
            }
            
        }
        $page = new Pagination(
            ['totalCount' => count($list), 'defaultPageSize' => '10', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        }
        $start=($page_now-1)*10;//偏移量，当前页-1乘以每页显示条数
        $list = array_slice($list,$start,10);
        return $this->renderPartial('/admin/juli',["list"=>$list,"pages" => $page,"page_now"=>$page_now,]);
    }

    /**
     * 根据两点间的经纬度计算距离
     * @param $lng1
     * @param $lat1
     * @param $lng2
     * @param $lat2
     * @return int
     */
    public function actionGetdistance($lng1, $lat1, $lng2, $lat2)
    {
        //将角度转为狐度
        $radLat1 = deg2rad((float)$lat1);//deg2rad()函数将角度转换为弧度
        $radLat2 = deg2rad((float)$lat2);
        $radLng1 = deg2rad((float)$lng1);
        $radLng2 = deg2rad((float)$lng2);
        $a = $radLat1 - $radLat2;
        $b = $radLng1 - $radLng2;
        $s = 2 * asin(sqrt(pow(sin($a / 2), 2) + cos($radLat1) * cos($radLat2) * pow(sin($b / 2), 2))) * 6378.137 * 1000;
        return $s;
    }
    public function actionBiaoji()
    {
        $id = $this->_DATA['id'];
        $where['sid'] = $this->_DATA['last'];
        $where['type'] = $this->_DATA['type'];
        foreach ($id as $key => $value) {
            if($id[$key] == $where['sid']){
                unset($id[$key]);
            }
        }
        $detail = DbWork::getRow('chachong', '*', ['sid' => $where['sid'],'type' => 0]);
        if($detail){
            $detail['ids'] = explode(',', $detail['ids']);
            $detail['ids'] = array_merge_recursive($detail['ids'],$id);
            $detail['ids'] = implode(',', $detail['ids']);
            $res = DbWork::update('chachong',$detail,['id'=>$detail['id']]);
            if($res){
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }else{
                return json_encode(['code' => 0, 'msg' => '操作失败']);
            }
        }else{
            $where['ids'] = implode(',', $id);
            $res = DbWork::save('chachong', $where);
            if($res){
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }else{
                return json_encode(['code' => 0, 'msg' => '操作失败']);
            }
        }
        
    }
    public function actionTipoffs_del()
    {
        $user = DbWork::getAll('adminrole','admin_id',['parent'=>$this->admin_id ]);
        array_push($user, $this->admin_id);
        $list = array();
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("tipoffs");
        $query->andWhere(['del'=>1]);
        $query->andWhere(['in','del_uid',$user]);
        // $query->andWhere(['del_uid'=>$this->admin_id]);
        $query->orderBy('del_time DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        foreach ($list as $key => $value) {
            $name = DbWork::getRow('admin', 'username', ['id' => $value['del_uid']]);
            $list[$key]['del_name'] = $name['username'];
        }
        return $this->renderPartial('/admin/tipoffs_del',['list'=>$list,'pages'=>$page]);
    }
    public function actionMap()
    {
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.longitude,sculpture.latitude')
                ->from("sculpture");
        $query->andWhere(['sculpture.del' => 0]);
        $list = $query->all();    
        return $this->renderPartial('/admin/map',['list'=>json_encode($list)]);
    }
    public function actionMaps()
    {
        $type = empty($this->_GETDATA['type']) ? 1 :$this->_GETDATA['type'];
        $districts = empty($this->_GETDATA['district']) ? '东城区' :$this->_GETDATA['district']; 
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        $query = (new \yii\db\Query())
                ->select('sculpture.id,sculpture.name,sculpture.longitude,sculpture.latitude')
                ->from("sculpture");
        $query->andWhere(['sculpture.del' => 0]);
        $query->andWhere(['sculpture.district' => $districts]);
        $list = $query->all();    
        if($type == 2){
            return $this->renderPartial('/admin/maps',['list'=>json_encode($list),'district'=>$district,'districts'=>$districts,'type'=>$type]);
        }else{
            return $this->renderPartial('/admin/map',['list'=>json_encode($list),'district'=>$district,'districts'=>$districts,'type'=>$type]);
        }
        
    }
    // 图片旋转
    public function actionImgturns($src,$direction)
    {
        $ext = pathinfo($src)['extension'];
        switch ($ext) {
            case 'gif':
                $img = imagecreatefromgif($src);
                break;
            case 'jpg':
                $img = imagecreatefromjpeg($src);
            case 'jpeg':
                $img = imagecreatefromjpeg($src);
                break;
            case 'png':
                $img = imagecreatefrompng($src);
                break;
            default:
                return self::responseJson('', 400, '图片格式错误');
                break;
        }
        $width = imagesx($img);
        $height = imagesy($img);
        $img2 = imagecreatetruecolor($height,$width);
        //顺时针旋转90度
        if($direction==1)
        {
            for ($x = 0; $x < $width; $x++) {
                for($y=0;$y<$height;$y++) {
                    imagecopy($img2, $img, $height-1-$y,$x, $x, $y, 1, 1);
                }
            }
        }else if($direction==2) {
            //逆时针旋转90度
            for ($x = 0; $x < $height; $x++) {
                for($y=0;$y<$width;$y++) {
                    imagecopy($img2, $img, $x, $y, $width-1-$y, $x, 1, 1);
                }
            }
        }
        switch ($ext) {
            case 'jpg':
            case "jpeg":
                imagejpeg($img2, $src, 100);
                break;
            case "gif":
                imagegif($img2, $src, 100);
                break;
            case "png":
                imagepng($img2, $src, 9);
                break;
                
            default:
                return self::responseJson('', 400, '图片格式错误');
                die;
                break;
        }
        imagedestroy($img);
        imagedestroy($img2);
    }
    public function actionImgfm(){
        $src = $this->_DATA['src']?$this->_DATA['src']:die();
        $id = $this->_DATA['id']?$this->_DATA['id']:die();
        $detail = DbWork::getRow('sculpture', 'id,img_url', ['id' => (int)$id]);
        if($detail){
            $img = json_decode($detail['img_url']);
            $img[] = $src;
            $data['img_url'] = json_encode($img);
            $res = DbWork::update('sculpture', $data, ['id' => $detail['id']]);
            if($res){
                return self::responseJson('', 200, '成功'); 
            }else{
                return self::responseJson('', 400, '写入出错'); 
            }
        }else{
            return self::responseJson('', 400, '出错');
        }
    }
    public function actionImgturn()
    {
        // $src = './upload/img/2021-01-05/7bb88b8f3a9eeced86a8af3881fafd12 - 副本.png';
        // $direction = 1;
        $src = $this->_DATA['src']?$this->_DATA['src']:die();
        $direction = $this->_DATA['direction']?$this->_DATA['direction']:1;
        $extend = explode("." , $src);
        $thumb_img = "_400_400.".$extend[1];
        $srcs = '.'.$extend[0].$thumb_img;
        // 判断图片是否存在
        if(file_exists($srcs)){
            self::actionImgturns($srcs,$direction);
        }
        $src = '.'.$src;
        $ext = pathinfo($src)['extension'];
        switch ($ext) {
            case 'gif':
                $img = imagecreatefromgif($src);
                break;
            case 'jpg':
                $img = imagecreatefromjpeg($src);
            case 'jpeg':
                $img = imagecreatefromjpeg($src);
                break;
            case 'png':
                $img = imagecreatefrompng($src);
                break;
            default:
                return self::responseJson('', 400, '图片格式错误');
                break;
        }
        $width = imagesx($img);
        $height = imagesy($img);
        $img2 = imagecreatetruecolor($height,$width);
        //顺时针旋转90度
        if($direction==1)
        {
            for ($x = 0; $x < $width; $x++) {
                for($y=0;$y<$height;$y++) {
                    imagecopy($img2, $img, $height-1-$y,$x, $x, $y, 1, 1);
                }
            }
        }else if($direction==2) {
            //逆时针旋转90度
            for ($x = 0; $x < $height; $x++) {
                for($y=0;$y<$width;$y++) {
                    imagecopy($img2, $img, $x, $y, $width-1-$y, $x, 1, 1);
                }
            }
        }
        switch ($ext) {
            case 'jpg':
            case "jpeg":
                imagejpeg($img2, $src, 100);
                break;
            case "gif":
                imagegif($img2, $src, 100);
                break;
            case "png":
                imagepng($img2, $src, 9);
                break;
                
            default:
                return self::responseJson('', 400, '图片格式错误');
                die;
                break;
        }
        imagedestroy($img);
        imagedestroy($img2);
        $src = '../../'.$src;
        return self::responseJson($src, 200, '成功');
        die;
    }
    public function actionArtisthistory()
    {
        $id = (int)$this->_GETDATA['id'];
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("artist_history");
        $query->andWhere(['number' => $id]);
        $query->orderBy('addtime DESC');
        $list = $query->all();
        return $this->renderPartial('/admin/artisthistory', ['list' => $list]);
    }
    // 总览 城区
    public function actionZllistcq()
    {
        $star_time = date("Y-m-d H:i:s", mktime(0, 0, 0, date('m'), date('d'), date('Y')));
    $end_time = date("Y-m-d H:i:s", mktime(0, 0, 0, date('m'), date('d')+1, date('Y'))-1);
 
    $star = strtotime($star_time);
    $end = strtotime($end_time);
    $xinzeng = 0;
    $xinzeng = (new \yii\db\Query())
            ->from('sculpture')
            ->where(['del' => '0'])
            ->andFilterWhere(['between','create_time',$star, $end])
            ->count();
        // 密云区， 延庆区， 朝阳区 ，丰台区， 石景山区， 海淀区 ，门头沟区， 房山区 ，通州区 ，顺义区 ，昌平区 ，大兴区， 怀柔区 ，平谷区 ，东城区 ，西城区。
        $list = DbWork::queryAll("select distinct(district) from location where status=1");
        $list = DistrictSort($list);
        $sumall = 0;
        $gkall = 0;
        foreach ($list as $key => $value) {
            $list[$key]['zongji'] = (new \yii\db\Query())
                                        ->from('sculpture')
                                        ->where(['del' => '0','district'=>$value['district']])
                                        ->count();
            $list[$key]['gongkai'] = (new \yii\db\Query())
                                        ->from('sculpture')
                                        ->where(['del' => '0','district'=>$value['district'],'is_show' => '1'])
                                        ->count();
            $sumall += $list[$key]['zongji'];
            $gkall += $list[$key]['gongkai'];
        }
        return $this->renderPartial('/admin/zllistcq',['list'=>$list,'sumall'=>$sumall,'gkall'=>$gkall,'xinzeng'=>$xinzeng]);
    }
    public function actionQulist()
    {
        // $str = "密云,延庆,朝阳,丰台,石景山,海淀,门头沟,房山,通州,顺义,昌平,大兴,怀柔,平谷,东城,西城,亦庄开发";
        // $str = explode(',', $str);
        // foreach ($str as $k => $v) {
            $query = (new \yii\db\Query())
                ->select('admin.id,admin.username,adminrole.parent,admin.pwd,admin.is_read')
                ->from("adminrole")
                ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
            $query->andWhere(['admin.status' => 1]);
            $query->andWhere(['adminrole.level' => 1]);
            // $query->andWhere(['adminrole.parent' => $value['admin_id']]);
            // $query->andWhere(['like','admin.username',$v]);
            $query->orderBy('id ASC');
            $lists = $query->all();
            $title = '雕塑北京市级管理员账户表';
            self::actionAdminexecl($lists,$title); 
        // }
    }
    public function actionLocation()
    {
        // $str = "密云区,延庆区,朝阳区,丰台区,石景山区";
        // $str = "海淀区,门头沟区,房山区,通州区,顺义区,昌平区,大兴区";
        // $str = "怀柔区,平谷区,东城区 ,西城区,亦庄开发区";
        // $qus = explode(',',$str);
        // foreach ($qus as $e => $r) {
            $qu = '丰台区委宣传部';
            $user = DbWork::getRow('admin', 'id', ['username' => $qu]);
            $list = DbWork::queryAll("select * from adminrole where parent='{$user['id']}'");
            foreach ($list as $key => $value) {
                $arr = array();
                $arr[] = DbWork::getRow('admin', 'id,username,pwd', ['id' => $value['admin_id']]);
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.parent,admin.pwd,admin.is_read')
                    ->from("adminrole")
                    ->join("LEFT JOIN","admin","admin.id=adminrole.admin_id");
                $query->andWhere(['admin.status' => 1]);
                $query->andWhere(['adminrole.parent' => $value['admin_id']]);
                $query->orderBy('id ASC');
                $lists = $query->all();
                // var_dump($lists);
                foreach ($lists as $k => $v) {
                    array_push($arr, $v);
                }
                $brr['data'] = $arr;
                $brr['string'] = $value['jurisdiction'];
                $crr[] = $brr;
            }
            self::actionAdminexecl($crr,$qu.'用户表'); 
            // foreach ($crr as $key => $value) {
            //     var_dump($value['string']);
            //     echo '<hr>';
            // }

        // }
        die;
        $list = explode('，', $str);
        foreach ($list as $key => $value) {
           $arr =  DbWork::queryAll("select id,username,pwd from admin where username='{$value}'");
           
        }
        // $list = DbWork::queryAll("select * from location where status=1");
        
    }
    public function actionAdminexecl($data,$title)
    {
    
        $objPHPExcel = new \PHPExcel();
        // 设置excel文档的属性
        $objPHPExcel->getProperties()->setCreator("Sam.c")
                     ->setLastModifiedBy("Sam.c Test")
                     ->setTitle("Microsoft Office Excel Document")
                     ->setSubject("Test")
                     ->setDescription("Test")
                     ->setKeywords("Test")
                     ->setCategory("Test result file");
        // 开始操作excel表
        foreach ($data as $k => $v) {
            if($k !=0){
                $objPHPExcel->createSheet();
            }
            $objPHPExcel->setActiveSheetIndex($k);
            $objPHPExcel->getActiveSheet()->setTitle($v['string']);
            // 设置默认字体和大小
            $objPHPExcel->getDefaultStyle()->getFont()->setName(iconv('gbk', 'utf-8', '宋体'));
            $objPHPExcel->getDefaultStyle()->getFont()->setSize(10);
            $objPHPExcel->getActiveSheet()
                ->setCellValue("A1",'编号')
                ->setCellValue("B1","账户")
                ->setCellValue("C1","初始密码");
            //设置默认行高
            $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(20);
            //所有垂直居中
            $objPHPExcel->getActiveSheet()->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
            //设置单元格宽度
            //
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(40);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(60);
            $objPHPExcel->getActiveSheet()->getStyle("A1:C1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
            //设置单元格边框
            // $objPHPExcel->getActiveSheet()->getStyle('A1:C1')->getBorders()->getAllBorders()->setBorderStyle(\PHPExcel_Style_Border::BORDER_THIN);

            $row = 1;
            foreach ($v['data'] as $val) {
                $row++;
                $objPHPExcel->getActiveSheet($k)
                    ->setCellValue("A".$row,$val['id'])
                    ->setCellValue("B".$row,$val['username'])
                    ->setCellValue("C".$row,$val['pwd']);
            }
        }
        // 从浏览器直接输出$filename
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xls");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;

    }
    // 邀请函报名情况
    public function actionMeetingform()
    {
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("meetingform");
        // $query->andWhere(['del'=>1]);
        $query->orderBy('addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '15', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/meetingform',['list'=>$list,'pages'=>$page]);
    } 
    // 邀请函导出
    public function actionMeetingformexecl()
    {
        $title = "北京冬奥艺术征集邀请函登记情况";
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("meetingform");
        // $query->andWhere(['del'=>1]);
        $query->orderBy('addtime DESC');
        $res = $query->offset(0)->all();
        $objPHPExcel = new \PHPExcel();

        $objSheet=$objPHPExcel->getActiveSheet();
        $objSheet->setTitle($title);
        $objSheet
            ->setCellValue("A1",'姓名')
            ->setCellValue("B1","电话")
            ->setCellValue("C1","是否有疑似症状（发热/干咳/胸闷等）")
            ->setCellValue("D1","近14天内个人及家属是否前往国内高风险城市或区域")
            ->setCellValue("E1","近14天内个人及家属是否有出国出境")
            ->setCellValue("F1","填报时间");
        //设置默认行高
        $objSheet->getDefaultRowDimension()->setRowHeight(20);
        //所有垂直居中
        $objSheet->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
        //设置单元格宽度
        //
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objSheet->getStyle("A1:F1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
        //设置单元格边框
        // $objPHPExcel->getActiveSheet()->getStyle('A1:C1')->getBorders()->getAllBorders()->setBorderStyle(\PHPExcel_Style_Border::BORDER_THIN);

        $row = 1;
        foreach ($res as $val) {
            switch ($val['suspected']) {
              case 'false':
                $val['suspected'] = '否';
                break;
              case 'true':
                $val['suspected'] = '是';
                break;
              default:
                $val['suspected'] = '未知';
                break;
            }
            switch ($val['isGoRiskAreas']) {
              case 'false':
                $val['isGoRiskAreas'] = '否';
                break;
              case 'true':
                $val['isGoRiskAreas'] = '是';
                break;
              default:
                $val['isGoRiskAreas'] = '未知';
                break;
            }
            switch ($val['beenAbroad']) {
              case 'false':
                $val['beenAbroad'] = '否';
                break;
              case 'true':
                $val['beenAbroad'] = '是';
                break;
              default:
                $val['beenAbroad'] = '未知';
                break;
            }
            $row++;
            $objSheet
                ->setCellValue("A".$row,$val['name'])
                ->setCellValue("B".$row,' '.html_entity_decode($val['phone']))
                ->setCellValue("C".$row,$val['suspected'])
                ->setCellValue("D".$row,$val['isGoRiskAreas'])
                ->setCellValue("E".$row,$val['beenAbroad'])
                ->setCellValue("F".$row,date('Y-m-d H:i:s',$val['addtime']));
        }
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xls");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;
    }

}
