<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */

namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;
use yii\web\UploadedFile;

class DaochuController extends BaseController
{
    public $enableCsrfValidation = false;
    public $keys;
	
	
	public function actionSculevel()
    {
        $arr = array();
        $arr['纪念性主题'] = array('东城区469','东城区010','东城区096','东城区076','东城区075','西城区340','西城区339');
        $arr['文化主题'] = array('东城区467','东城区455','东城区453','东城区408','东城区073','西城区032','西城区027','西城区026','西城区028','西城区029','西城区030','西城区024','西城区025','西城区023','西城区021','西城区022','西城区020');
        $arr['地标标志'] = array('东城区174','东城区108','东城区007','西城区544','西城区542');
        $arr['人物'] = array('东城区451','东城区030','东城区133','东城区095','东城区087','东城区347','东城区086','东城区029','西城区550','西城区546','西城区398','西城区107');
        $arr['环境类'] = array('东城区413','东城区410','东城区011','东城区088','东城区097','东城区176','东城区091','东城区152','东城区089','东城区090','东城区188','东城区074','西城区545','西城区046','西城区047','西城区095','西城区101','西城区169');
        
        foreach ($arr as $key => $value) {
            foreach ($value as $k => $v) {
                $districts = mb_substr($v,0,3);
                $zpbh = mb_substr($v,3,6);
                $zpbh = str_pad($zpbh,3,'0',STR_PAD_LEFT);
                $query = (new \yii\db\Query())
                    ->select('sculpture.*,admin.username,sculpture_sub.status,sculpture_att.*,admin.username as del_name')
                    ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                    ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                    ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
                    ->leftJoin('districtorder', 'sculpture.district  = districtorder.district')
                    ->from("sculpture");
                $query->andWhere(['sculpture.zpbh'=>$zpbh]);
                $query->andWhere(['sculpture.district'=>$districts]);
                $query->andWhere(['sculpture.del'=>0]);
                $query->orderBy('sculpture.id DESC');
                $list[] = $query->one();
            }
        }
        $title = date("Y_m_d_H_i",time()).'艺术品导出';
        // 判断是不是携带图片导出
        self::actionImgExecl($list,$title,1);
    }
	public function actionRuwei()
    {
        $query = (new \yii\db\Query())
            ->select('zp_jcb.zpbh,zp_jcb.zpmc,zp_jcb.deleted,zp_jcb.zpmc_fy,zp_jcb.czsm,zp_jcb.czsm_fy,gw_opus.zpcz,gw_opus.zpccchang,gw_opus.zpcckuan,gw_opus.zpccgao,gw_enroll.xm,gw_enroll.xb,gw_enroll.csrq,gw_enroll.gj,gw_enroll.szcs,gw_enroll.gzdwjzw,gw_enroll.zjlx,gw_enroll.zjhm,gw_enroll.txdz,gw_enroll.dzyj,gw_enroll.yzbm,gw_enroll.gddh,gw_enroll.yddh,gw_enroll.zpcz,gw_enroll.rylx,gw_enroll.fddbrxm,gw_enroll.zcsj,gw_enroll.tyshxydm,gw_enroll.cz,gw_enroll.lxr,gw_enroll.fdzs,gw_enroll.yzrgx,gw_enroll.yzdlrxm,gw_enroll.yzdlrzjhm,gw_enroll.yzdlrxb,gw_enroll.yzdlryddh,gw_enroll.yzdlrtxdz,gw_opus.enroll_id as dsid')
            ->leftJoin('dongao.zp_jcb','zp_rw.zp_id=zp_jcb.zpbh')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            ->from("dongao.zp_rw");
        $query->andWhere(['zp_rw.ss'=>1]);
        $list = $query->all();
        foreach ($list as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('name,zjhm')
                ->from("dongao.gw_qtyzr");
            $query->andWhere(['enroll_id' => $value['dsid']]);
            $list_users = $query->all();
            $list[$key]['other'] = '';
            $other = array();
            foreach ($list_users as $k => $v) {
                $other[] = implode(':',$v);
            }
            if($other){
                $list[$key]['other'] = implode(';',$other);
            }
        }
        $title = '入围作品总览';
        self::dongao($title,$list);
    }
    public function actionTiming()
    {
        $query = (new \yii\db\Query())
            ->select('zp_jcb.zpbh,zp_jcb.zpmc,zp_jcb.deleted,zp_jcb.zpmc_fy,zp_jcb.czsm,zp_jcb.czsm_fy,gw_opus.zpcz,gw_opus.zpccchang,gw_opus.zpcckuan,gw_opus.zpccgao,gw_enroll.xm,gw_enroll.xb,gw_enroll.csrq,gw_enroll.gj,gw_enroll.szcs,gw_enroll.gzdwjzw,gw_enroll.zjlx,gw_enroll.zjhm,gw_enroll.txdz,gw_enroll.dzyj,gw_enroll.yzbm,gw_enroll.gddh,gw_enroll.yddh,gw_enroll.zpcz,gw_enroll.rylx,gw_enroll.fddbrxm,gw_enroll.zcsj,gw_enroll.tyshxydm,gw_enroll.cz,gw_enroll.lxr,gw_enroll.fdzs,gw_enroll.yzrgx,gw_enroll.yzdlrxm,gw_enroll.yzdlrzjhm,gw_enroll.yzdlrxb,gw_enroll.yzdlryddh,gw_enroll.yzdlrtxdz,gw_opus.enroll_id as dsid')
            ->leftJoin('dongao.zp_jcb','zp_wl.zp_id=zp_jcb.zpbh')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            ->from("dongao.zp_wl");
        $query->andWhere(['zp_wl.del'=>0]);
        $list = $query->all();
        foreach ($list as $key => $value) {
            $query = (new \yii\db\Query())
                ->select('name,zjhm')
                ->from("dongao.gw_qtyzr");
            $query->andWhere(['enroll_id' => $value['dsid']]);
            $list_users = $query->all();
            $list[$key]['other'] = '';
            $other = array();
            foreach ($list_users as $k => $v) {
                $other[] = implode(':',$v);
            }
            if($other){
                $list[$key]['other'] = implode(';',$other);
            }
        }
        $title = '提名作品总览';
        self::dongao($title,$list);
    }
    public function dongao($title,$data)
    {
        $num  = count($data);
        $objPHPExcel = new \PHPExcel();
        $objSheet=$objPHPExcel->getActiveSheet();
        $objSheet->setTitle($title);
        $objSheet
            ->setCellValue("A1",'作品编号')
            ->setCellValue("B1","作品名称")
            ->setCellValue("C1","作品名称(翻译)")
            ->setCellValue("D1","创作说明")
            ->setCellValue("E1","创作说明(翻译)")
            ->setCellValue("F1","创作说明(翻译)")
            ->setCellValue("G1","作品尺寸(长*宽*高)")
            ->setCellValue("H1","作者姓名")
            ->setCellValue("I1","性别")
            ->setCellValue("J1","出生日期")
            ->setCellValue("K1","国籍")
            ->setCellValue("L1","所在城市")
            ->setCellValue("M1","工作单位及职位")
            ->setCellValue("N1","证件类型")
            ->setCellValue("O1","证件号码")
            ->setCellValue("P1","通讯地址")
            ->setCellValue("Q1","电子邮件")
            ->setCellValue("R1","邮政编码")
            ->setCellValue("S1","固定电话")
            ->setCellValue("T1","移动电话")
            ->setCellValue("U1","人员类型")
            ->setCellValue("V1","法定代编人姓名")
            ->setCellValue("W1","注册时间")
            ->setCellValue("X1","统一社会信用代码")
            ->setCellValue("Y1","传真")
            ->setCellValue("Z1","联系人")
            ->setCellValue("AA1","法定住所")
            ->setCellValue("AB1","与应征人关系")
            ->setCellValue("AC1","应征代理人姓名")
            ->setCellValue("AD1","应征代理人证件号")
            ->setCellValue("AE1","应征代理人性别")
            ->setCellValue("AF1","应征代理人移动电话")
            ->setCellValue("AG1","应征代理人通讯地址")
            ->setCellValue("AH1","其他应征人");
			// 设置纸张大小为A4
        $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        //设置默认行高
        // $objPHPExcel->getActiveSheet()->getColumnDimension()->setWidth(200);
        // $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(200);
        //所有垂直居中
        $objSheet->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
        //设置单元格宽度
        $objSheet->getStyle("A1:AH1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
        $objSheet->getStyle("A1:AH1")->getAlignment()->setWrapText(TRUE);
        $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()->setWidth(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(30);
        $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(20);
        // for ($i=1; $i < $num+2; $i++) { 
        //     $objPHPExcel->getActiveSheet()->getRowDimension($i)->setRowHeight(80);
        // }
        $row = 1;
        foreach ($data as $val) {
            switch ($val['xb']) {
                case '0':
                    $val['xb'] = '女';
                    break;
                case '1':
                    $val['xb'] = '男';
                    break;
                default:
                    $val['xb'] = '未知';
                    break;
            }
            switch ($val['yzdlrxb']) {
                case '0':
                    $val['yzdlrxb'] = '女';
                    break;
                case '1':
                    $val['yzdlrxb'] = '男';
                    break;
                default:
                    $val['yzdlrxb'] = '未知';
                    break;
            }
            switch ($val['rylx']) {
                case '1':
                    $val['rylx'] = '自然人';
                    break;
                case '1':
                    $val['rylx'] = '法人';
                    break;
                default:
                    $val['rylx'] = '其他';
                    break;
            }

            $row++;
            $objSheet
                ->setCellValue("A".$row,$val['zpbh'])
                ->setCellValue("B".$row,$val['zpmc'])
                ->setCellValue("C".$row,$val['zpmc_fy'])
                ->setCellValue("D".$row,$val['czsm'])
                ->setCellValue("E".$row,$val['czsm_fy'])
                ->setCellValue("F".$row,$val['zpcz'])
                ->setCellValue("G".$row,$val['zpccchang'].'*'.$val['zpcckuan'].'*'.$val['zpccgao'])
                ->setCellValue("H".$row,$val['xm'])
                ->setCellValue("I".$row,$val['xb'])
                ->setCellValue("J".$row,$val['csrq'])
                ->setCellValue("K".$row,$val['gj'])
                ->setCellValue("L".$row,$val['szcs'])
                ->setCellValue("M".$row,$val['gzdwjzw'])
                ->setCellValue("N".$row,$val['zjlx'])
                ->setCellValue("O".$row,' '.$val['zjhm'])
                ->setCellValue("P".$row,$val['txdz'])
                ->setCellValue("Q".$row,$val['dzyj'])
                ->setCellValue("R".$row,$val['yzbm'])
                ->setCellValue("S".$row,' '.$val['gddh'])
                ->setCellValue("T".$row,' '.$val['yddh'])
                ->setCellValue("U".$row,$val['rylx'])
                ->setCellValue("V".$row,$val['fddbrxm'])
                ->setCellValue("W".$row,' '.$val['zcsj'])
                ->setCellValue("X".$row,' '.$val['tyshxydm'])
                ->setCellValue("Y".$row,' '.$val['cz'])
                ->setCellValue("Z".$row,' '.$val['lxr'])
                ->setCellValue("AA".$row,$val['fdzs'])
                ->setCellValue("AB".$row,$val['yzrgx'])
                ->setCellValue("AC".$row,$val['yzdlrxm'])
                ->setCellValue("AD".$row,' '.$val['yzdlrzjhm'])
                ->setCellValue("AE".$row,$val['yzdlrxb'])
                ->setCellValue("AF".$row,$val['yzdlryddh'])
                ->setCellValue("AG".$row,$val['yzdlrtxdz'])
                ->setCellValue("AH".$row,$val['other']);
        }
        
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xlsx");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;
    }
    public function actionIndex()
    {
        $data = DbWork::getRow('sculpture', '*', ['id' => '4715']);
        $arr[] = $data;
        //1.创建模板对象
        $PHPWord = new \PhpOffice\PhpWord\PhpWord();
        // 创建文件夹
        $dir_name = strval(date("Y-m-d"));
        $or_name = md5(rand(0,99));
        $dir = iconv("UTF-8", "GBK", "word/".$dir_name."/".$or_name);
        if (!file_exists($dir)){
            mkdir ($dir,0777,true);
        } else {

        }
        foreach ($arr as $key => $value) {
            $tempPlete = $PHPWord->loadTemplate('./images/muban.docx');
            //2.插入数据
            $tempPlete->setValue('name', $value['name']);
            $tempPlete->setValue('id', $value['id']);
            $tempPlete->setValue('address', $value['district'].$value['street'].$value['location']);
            $tempPlete->setValue('project', @$value['project']);
            $tempPlete->setValue('project_time', @$value['project_time']);
            $tempPlete->setValue('put_location', @$value['put_location']);
            $tempPlete->setValue('author', @$value['author']);
            switch (@$value['type']) {
                case '1':
                    $tempPlete->setValue('type', '圆雕');
                    break;
                case '2':
                    $tempPlete->setValue('type', '浮雕');
                    break;
                case '3':
                    $tempPlete->setValue('type', '壁画');
                    break;
                case '4':
                    $tempPlete->setValue('type', '塑像');
                    break;
                default:
                    $tempPlete->setValue('type', ' ');
                    break;
            }
            $tempPlete->setValue('outward', @$value['outward']);
            $tempPlete->setValue('thick', @$value['thick']);
            $tempPlete->setValue('length', @$value['length']);
            $tempPlete->setValue('width', @$value['width']);
            $tempPlete->setValue('technology', @$value['technology']);
            $tempPlete->setValue('material', @$value['material']);
            // $tempPlete->setValue('img1', 1);
            // $tempPlete->setValue('img2', 2);
            $img = json_decode($data['img_url']);
            if(!empty($img[0])){
                $extend = explode("." , $img[0]);
                $thumb_img = "_400_400.".$extend[1];
                $img_one = $extend[0].$thumb_img;
                $sign_pic_url_0 = @$img_one? @$img_one :"";
            };
            if(!empty($img[1])){
                $extend = explode("." , $img[1]);
                $thumb_img = "_400_400.".$extend[1];
                $img_two = $extend[0].$thumb_img;
                $sign_pic_url_1 = @$img_two? @$img_two :"";
            };
            $picParam = ['path' => './'.$sign_pic_url_0, 'width' => 200, 'height' => 200]; 
            $tempPlete->setImageValue('img1', $picParam);
            $picParam2 = ['path' => './'.$sign_pic_url_1, 'width' => 200, 'height' => 200];
            $tempPlete->setImageValue('img2', $picParam2);
            //3.保存文件
            $tempPlete->saveAs($dir.'/'.$value['id'].'.docx');
        }
        self::zip('./'.$dir.'/',"./word/".$dir_name,$or_name);
        echo $or_name.'.zip';
        
    }
//      $path = PUBLIC_DIR.'/images/';    //待压缩文件夹父目录
//      $zipPath = PUBLIC_DIR.'/images_zip/'; //压缩文件保存目录
    public function zip($path,$zipPath,$or_name)
    {
        $zip = new \ZipArchive;
        if ($zip->open($zipPath.'/'.$or_name.'.zip', \ZipArchive::CREATE) === true)
        {
            //将images目录下所有文件添加到zip中
            if ($handle = opendir($path)){
                // 添加目录中的所有文件
                while (false !== ($entry = readdir($handle))){
                    if ($entry != "." && $entry != ".." && !is_dir($path. $entry)){
                        $zip->addFile($path . $entry);
                    }
                }
                closedir($handle);
            }
            // 关闭zip文件
            $zip->close();
        }

    }
    // 艺术品导出
    public function actionScuexecl()
    {
        $query = (new \yii\db\Query())
            ->select('sculpture.id')
            ->from("sculpture");

        // 根据账户权限 获取不同级别数据
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                // 市级单位判断 如果是雕办
                //$admin = $this->admin_id;
                
                //if($admin == 3339 || ($admin >= 3344 && $admin<=3352) || $admin >= 3373){
                    // $query->andWhere(['sculpture.shi_uid' => 3339]);
                //}else{
                //    $query->andWhere(['sculpture.shi_uid' => $admin]);
                //}
                break;
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                $xia_qu = $this->admin_name;
                $street = DbWork::queryAll("select street from location where district='{$xia_qu}' and status = 1");
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
				$jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                break;
            case '4':
                $query->andWhere(['sculpture.admin_id' => $this->admin_id]);
                break;
            default:
                die('权限不足');
                break;
        }
        $query->andWhere(['sculpture.del'=>0]);
        $query->orderBy('district DESC,id DESC');
        $res = $query->offset(0)->all();
        $num = count($res);
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        $district = DistrictSort($district);
        return $this->renderPartial('/admin/scuexecl',['num'=>$num,'district'=>$district]);
    }
    public function actionScuexecls()
    {
        $district_value = empty($this->_GETDATA['district_value']) ? '' :$this->_GETDATA['district_value']; //Yii::$app->request->get('district_value');
        $ids = empty($this->_GETDATA['ids']) ? '' :$this->_GETDATA['ids']; //Yii::$app->request->get('ids');
        $approval_name = empty($this->_GETDATA['approval_name']) ? '' :$this->_GETDATA['approval_name'];  //Yii::$app->request->get('approval_name');
        $lastid =  empty($this->_GETDATA['lastid']) ? '' :$this->_GETDATA['lastid']; //Yii::$app->request->get('lastid');
        $ht =  empty($this->_GETDATA['ht']) ? '' :$this->_GETDATA['ht']; //Yii::$app->request->get('ht');
        $dizhi =  empty($this->_GETDATA['dizhi']) ? '' :$this->_GETDATA['dizhi']; //Yii::$app->request->get('dizhi');
        $qu_status =  empty($this->_GETDATA['qu_status']) ? '' :$this->_GETDATA['qu_status']; //Yii::$app->request->get('dizhi');
        // 多条件检索
        $arr['type'] = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $arr['material'] = empty($this->_GETDATA['material']) ? '' :$this->_GETDATA['material']; //Yii::$app->request->get('material');
        $arr['technology'] = empty($this->_GETDATA['technology']) ? '' :$this->_GETDATA['technology']; //Yii::$app->request->get('technology');
        $arr['outward'] = empty($this->_GETDATA['outward']) ? '' :$this->_GETDATA['outward'];//Yii::$app->request->get('outward');
        $arr['put_location'] = empty($this->_GETDATA['put_location']) ? '' :$this->_GETDATA['put_location']; //Yii::$app->request->get('put_location');
        $arr['size'] = empty($this->_GETDATA['size']) ? '' :$this->_GETDATA['size'];
        $arr['is_show'] = empty($this->_GETDATA['is_show']) ? '' :$this->_GETDATA['is_show']; //Yii::$app->request->get('is_show');
        $arr['level'] = empty($this->_GETDATA['level']) ? '' :$this->_GETDATA['level']; //Yii::$app->request->get('is_show');
        $arr['img'] = empty($this->_GETDATA['img']) ? '' :$this->_GETDATA['img']; //Yii::$app->request->get('is_show');
        $arr['del'] = empty($this->_GETDATA['del']) ? '' :$this->_GETDATA['del']; //Yii::$app->request->get('is_show');

        if($arr['del'] ==2){
            $query = (new \yii\db\Query())
                ->select('sculpture.*,admin.username,sculpture_sub.status,sculpture_att.*')
                ->leftJoin('admin', 'sculpture.del_uid  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
                ->leftJoin('districtorder', 'sculpture.district  = districtorder.district')
                ->from("sculpture");
        }else{
            $query = (new \yii\db\Query())
                ->select('sculpture.*,admin.username,sculpture_sub.status,sculpture_att.*,admin.username as del_name')
                ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
                ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
                ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
                ->leftJoin('districtorder', 'sculpture.district  = districtorder.district')
                ->from("sculpture");
        }
        
        if($ids){
            $idss = explode(',', $ids);
            $query->andWhere(['in', 'sculpture.id', $idss]);
        }
        if($district_value && $district_value!='全市'){
            $query->andWhere(['sculpture.district' => $district_value]);
        }
        if($qu_status && $qu_status!='区审核状态'){
            if($qu_status =='3'){
                $query->andWhere(['sculpture_sub.status' => '0']);
            }else{
                $query->andWhere(['sculpture_sub.status' => $qu_status]);
            }
        }
        if($approval_name){
            if($ht=='chachong'){
                $query->andWhere(['sculpture.name'=>$approval_name]);
            }else{
                $query->andWhere(['like','sculpture.name',$approval_name]);
            }
        }
        if($dizhi){
            $query->andWhere(['or',['like','sculpture.street',$dizhi],['like','sculpture.location',$dizhi]]);
        }
        if($arr['type'] && $arr['type']!='请选择属性'){
            $query->andWhere(['sculpture.type'=>$arr['type']]);
        }
        if($arr['material'] && $arr['material']!='请选择材料'){
            $query->andWhere(['like','sculpture.material',$arr['material']]);
        }
        if($arr['technology'] && $arr['technology']!='请选择工艺'){
            $query->andWhere(['like','sculpture.technology',$arr['technology']]);
        }
        if($arr['outward'] && $arr['outward']!='请选择外观'){
            $query->andWhere(['like','sculpture.outward',$arr['outward']]);
        }
        if($arr['put_location'] && $arr['put_location']!='请选择摆放环境'){
            $query->andWhere(['sculpture.put_location'=>$arr['put_location']]);
        }
        if($arr['is_show']!=NULL && $arr['is_show']!='公开状态'){
            if($arr['is_show'] == 1){
                $query->andWhere(['sculpture.is_show'=>1]);
            }else{
                $query->andWhere(['<>','sculpture.is_show',1]);
            }
        }
        if($arr['level'] && $arr['level']!='是否建议拆除'){
            if($arr['level']==2){
                $query->andWhere(['sculpture.dismantle'=>'1']);
            }else{
                $query->andWhere(['sculpture.dismantle'=>'0']);
            }
        }
        if($arr['size'] && $arr['type']){
            switch ($arr['size']) {
                case '特大型':
                    $query->andWhere(['sculpture.model'=>3]);
                    break;
                case '大型':
                    $query->andWhere(['sculpture.model'=>2]);
                    break;
                case '中型':
                    $query->andWhere(['sculpture.model'=>1]);
                    break;
                case '小型':
                    $query->andWhere(['sculpture.model'=>0]); 
                    break;
                default:
                    # code...
                    break;
            }
        }
        if($arr['del'] ==2){
            $query->andWhere(['sculpture.del' => 1]);
        }else{
            $query->andWhere(['sculpture.del' => 0]);
        }
        
        $query->orderBy('districtorder.ord ASC,sculpture.id DESC');
        $res = $query->all();
        $title = date("Y_m_d_H_i",time()).'艺术品导出';
        // 判断是不是携带图片导出
        if($arr['img'] == '2'){
            self::actionImgExecl($res,$title,$arr['del']);
        }else{
            self::actionNoimgExecl($res,$title,$arr['del']);
        }
        die;
    }
    public function actionImgExecl($data,$title,$del)
    {
        $num  = count($data);
        $objPHPExcel = new \PHPExcel();
        $objSheet=$objPHPExcel->getActiveSheet();
        $objSheet->setTitle($title);
        $objSheet
            ->setCellValue("A1",'艺术品图片')
            ->setCellValue("B1","作品编号")
            ->setCellValue("C1","公共艺术品名称")
            ->setCellValue("D1","建设单位")
            ->setCellValue("E1","建设时间")
            ->setCellValue("F1","区")
            ->setCellValue("G1","街道")
            ->setCellValue("H1","详细地址")
            ->setCellValue("I1","摆放环境")
            ->setCellValue("J1","作者")
            ->setCellValue("K1","类型")
            ->setCellValue("L1","高")
            ->setCellValue("M1","宽")
            ->setCellValue("N1","厚")
            ->setCellValue("O1","经度")
            ->setCellValue("P1","纬度")
            ->setCellValue("Q1","材料")
            ->setCellValue("R1","工艺")
            ->setCellValue("S1","外观现状")
            ->setCellValue("T1","艺术铭文")
            ->setCellValue("U1","艺术品备注")
            ->setCellValue("V1","填报人")
            ->setCellValue("W1","填报人电话")
            ->setCellValue("X1","维保人")
            ->setCellValue("Y1","维保单位")
            ->setCellValue("Z1","维保联系方式")
            ->setCellValue("AA1","区是否审核")
            ->setCellValue("AB1","是否公开")
            ->setCellValue("AC1","作品解读")
            ->setCellValue("AD1","建议拆除")
            ->setCellValue("AE1","填报时间");
        if($del ==2 ){
            $objSheet->setCellValue("V1","删除人");
            $objSheet->setCellValue("W1","删除时间");
        }
		// 设置纸张大小为A4
        $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        //设置默认行高
        // $objPHPExcel->getActiveSheet()->getColumnDimension()->setWidth(200);
        // $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(200);
        //所有垂直居中
        $objSheet->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
        //设置单元格宽度
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(80);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AC')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AE')->setWidth(25);
        $objSheet->getStyle("A1:AE1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
        $objSheet->getStyle('A')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('B')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('C')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('D')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('E')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('F')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('G')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('H')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('I')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('M')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('N')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('O')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('P')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('Q')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('R')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('S')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('T')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('U')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('V')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('W')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('X')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('Y')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('Z')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AA')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AB')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AC')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AD')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AE')->getAlignment()->setWrapText(TRUE);
        // for ($i=1; $i < $num+2; $i++) { 
        //     $objPHPExcel->getActiveSheet()->getRowDimension($i)->setRowHeight(80);
        // }
        $row = 1;
        foreach ($data as $val) {
            $val['zpbh'] = str_replace('区','',$val['district']).str_pad($val['zpbh'],3,"0",STR_PAD_LEFT);
            switch ($val['type']) {
                case '1':
                    $val['type'] = "圆雕";
                    break;
                case '2':
                    $val['type'] = "浮雕";
                    break;
                case '3':
                    $val['type'] = "壁画";
                    break;
                case '4':
                    $val['type'] = "塑像";
                    break;
                default:
                    $val['type'] = "未知";
                    break;
            }
            switch ($val['status']) {
                case '1':
                    $val['status'] = "审核通过";
                    break;
                case '2':
                    $val['status'] = "未通过";
                    break;
                default:
                    $val['status'] = "未审核";
                    break;
            }
            switch ($val['is_show']) {
                case '1':
                    $val['is_show'] = "公开";
                    break;
                default:
                    $val['is_show'] = "未公开";
                    break;
            }
            switch ($val['dismantle']) {
                case '1':
                    $val['dismantle'] = "是";
                    break;
                default:
                    $val['dismantle'] = "否";
                    break;
            }
            $row++;

            $objDrawing[$row] = new \PHPExcel_Worksheet_Drawing();
            $imgs = json_decode($val['img_url']);
            // $imgs[0] = '/upload/img/2020-04-03/931e71b8a83cded953d51c5dbc5abd48_400_400.JPG';
            // $objDrawing[$row]->setPath('.'.$imgs[0]);
            if($imgs[0] && file_exists('./'.$imgs[0])){ 
                $extend = explode("." , $imgs[0]);
                $thumb_img = "_400_400.".$extend[1];
                $thumb_imgs = $extend[0].$thumb_img;
                if(file_exists('./'.$thumb_imgs)){
                    $objDrawing[$row]->setPath('.'.$thumb_imgs);
                    $imgsize = getimagesize('.'.$thumb_imgs);
                }else{
                    $objDrawing[$row]->setPath('.'.$imgs[0]);
                    $imgsize = getimagesize('.'.$imgs[0]);
                }
                if($imgsize[0] >= $imgsize[1]){
                    $objDrawing[$row]->setWidth($imgsize[0]); //照片宽度
                    if($imgsize[1]>=0){
                        $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(ceil($imgsize[1]*0.8));
                    }else{
                        $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
                    }
                    
                }else{
                    // $objDrawing[$row]->setHeight(360);//照片高度
                    $objDrawing[$row]->setWidth($imgsize[0]); //照片宽度
                    if($imgsize[1]>=0){
                        $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(ceil($imgsize[1]*0.8));
                    }else{
                        $objPHPExcel->getActiveSheet()->getRowDimension($row)->setRowHeight(20);
                    }
                    
                }
                // 设置宽度高度
                
                /*设置图片要插入的单元格*/
                $objDrawing[$row]->setCoordinates('A'.$row);
                // 图片偏移距离
                $objDrawing[$row]->setOffsetX(0);
                $objDrawing[$row]->setOffsetY(0);
                $objDrawing[$row]->setWorksheet($objPHPExcel->getActiveSheet());
            }else{
                $objSheet->setCellValue("A".$row,'无图片');
            } 
            // $objSheet
            //     ->setCellValue("A".$row,$val['name']);
            $objSheet
                ->setCellValue("B".$row,$val['zpbh'])
                ->setCellValue("C".$row,$val['name'])
                ->setCellValue("D".$row,$val['project'])
                ->setCellValue("E".$row,str_replace('-','.',$val['project_time']))
                ->setCellValue("F".$row,$val['district'])
                ->setCellValue("G".$row,$val['street'])
                ->setCellValue("H".$row,$val['location'])
                ->setCellValue("I".$row,$val['put_location'])
                ->setCellValue("J".$row,$val['author'])
                ->setCellValue("K".$row,$val['type'])
                ->setCellValue("L".$row,$val['length'])
                ->setCellValue("M".$row,$val['width'])
                ->setCellValue("N".$row,$val['thick'])
                ->setCellValue("O".$row,' '.$val['longitude'])
                ->setCellValue("P".$row,' '.$val['latitude'])
                ->setCellValue("Q".$row,$val['material'])
                ->setCellValue("R".$row,$val['technology'])
                ->setCellValue("S".$row,$val['outward'])
                ->setCellValue("T".$row,$val['epigraph'])
                ->setCellValue("U".$row,$val['content'])
                ->setCellValue("V".$row,$val['input_people'])
                ->setCellValue("W".$row,' '.$val['mobile'])
                ->setCellValue("X".$row,$val['weibao_name'])
                ->setCellValue("Y".$row,$val['weibao_danwei'])
                ->setCellValue("Z".$row,' '.$val['weibao_phone'])
                ->setCellValue("AA".$row,$val['status'])
                ->setCellValue("AB".$row,$val['is_show'])
                ->setCellValue("AC".$row,$val['decipher'])
                ->setCellValue("AD".$row,$val['dismantle'])
                ->setCellValue("AE".$row,date("Y.m.d H:i",$val['create_time']));
            if($del ==2 ){
                $objSheet->setCellValue("V".$row,$val['username']);
                $objSheet->setCellValue("W".$row,date("Y.m.d H:i",$val['del_time']));
            }
        }
        
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xlsx");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;
    }
    public function actionNoimgExecl($data,$title,$del)
    {
        $objPHPExcel = new \PHPExcel();
        $objSheet=$objPHPExcel->getActiveSheet();
        $objSheet->setTitle($title);
        $objSheet
            ->setCellValue("A1",'艺术品编号')
            ->setCellValue("B1","公共艺术品名称")
            ->setCellValue("C1","建设单位")
            ->setCellValue("D1","建设时间")
            ->setCellValue("E1","区")
            ->setCellValue("F1","街道")
            ->setCellValue("G1","详细地址")
            ->setCellValue("H1","摆放环境")
            ->setCellValue("I1","作者")
            ->setCellValue("J1","类型")
            ->setCellValue("K1","高")
            ->setCellValue("L1","宽")
            ->setCellValue("M1","厚")
            ->setCellValue("N1","经度")
            ->setCellValue("O1","纬度")
            ->setCellValue("P1","材料")
            ->setCellValue("Q1","工艺")
            ->setCellValue("R1","外观现状")
            ->setCellValue("S1","艺术铭文")
            ->setCellValue("T1","艺术品备注")
            ->setCellValue("U1","填报人")
            ->setCellValue("V1","填报人电话")
            ->setCellValue("W1","维保人")
            ->setCellValue("X1","维保单位")
            ->setCellValue("Y1","维保联系方式")
            ->setCellValue("Z1","是否审核")
            ->setCellValue("AA1","是否公开")
            ->setCellValue("AB1","作品解读")
            ->setCellValue("AC1","建议拆除")
            ->setCellValue("AD1","填报时间");
            if($del ==2 ){
                $objSheet->setCellValue("U1","删除人");
                $objSheet->setCellValue("V1","删除时间");
            }
			// 设置纸张大小为A4
        $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        //所有垂直居中
        $objSheet->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
        //设置单元格宽度
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(50);
        $objPHPExcel->getActiveSheet()->getColumnDimension('AD')->setWidth(25);
        $objSheet->getStyle("A1:AD1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
        $objSheet->getStyle('A')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('B')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('C')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('D')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('E')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('F')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('G')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('H')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('I')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('M')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('N')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('O')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('P')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('Q')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('R')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('S')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('T')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('U')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('V')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('W')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('X')->getAlignment()->setWrapText(TRUE);
        $objSheet->getStyle('AB')->getAlignment()->setWrapText(TRUE);
        //设置单元格边框
        // $objPHPExcel->getActiveSheet()->getStyle('A1:C1')->getBorders()->getAllBorders()->setBorderStyle(\PHPExcel_Style_Border::BORDER_THIN);

        $row = 1;
        foreach ($data as $val) {
            $val['zpbh'] = str_replace('区','',$val['district']).str_pad($val['zpbh'],3,"0",STR_PAD_LEFT);

            switch ($val['type']) {
                case '1':
                    $val['type'] = "圆雕";
                    break;
                case '2':
                    $val['type'] = "浮雕";
                    break;
                case '3':
                    $val['type'] = "壁画";
                    break;
                case '4':
                    $val['type'] = "塑像";
                    break;
                default:
                    $val['type'] = "未知";
                    break;
            }
            switch ($val['status']) {
                case '1':
                    $val['status'] = "审核通过";
                    break;
                case '2':
                    $val['status'] = "未通过";
                    break;
                default:
                    $val['status'] = "未审核";
                    break;
            }
            switch ($val['is_show']) {
                case '1':
                    $val['is_show'] = "公开";
                    break;
                default:
                    $val['is_show'] = "未公开";
                    break;
            }
            switch ($val['dismantle']) {
                case '1':
                    $val['dismantle'] = "是";
                    break;
                default:
                    $val['dismantle'] = "否";
                    break;
            }
            $row++;
            $objSheet
                ->setCellValue("A".$row,$val['zpbh']);
            $objSheet
                ->setCellValue("B".$row,$val['name'])
                ->setCellValue("C".$row,$val['project'])
                ->setCellValue("D".$row,str_replace('-','.',$val['project_time']))
                ->setCellValue("E".$row,$val['district'])
                ->setCellValue("F".$row,$val['street'])
                ->setCellValue("G".$row,$val['location'])
                ->setCellValue("H".$row,$val['put_location'])
                ->setCellValue("I".$row,$val['author'])
                ->setCellValue("J".$row,$val['type'])
                ->setCellValue("K".$row,$val['length'])
                ->setCellValue("L".$row,$val['width'])
                ->setCellValue("M".$row,$val['thick'])
                ->setCellValue("N".$row,' '.$val['longitude'])
                ->setCellValue("O".$row,' '.$val['latitude'])
                ->setCellValue("P".$row,$val['material'])
                ->setCellValue("Q".$row,$val['technology'])
                ->setCellValue("R".$row,$val['outward'])
                ->setCellValue("S".$row,$val['epigraph'])
                ->setCellValue("T".$row,$val['content'])
                ->setCellValue("U".$row,$val['input_people'])
                ->setCellValue("V".$row,' '.$val['mobile'])
                ->setCellValue("W".$row,$val['weibao_name'])
                ->setCellValue("X".$row,$val['weibao_danwei'])
                ->setCellValue("Y".$row,' '.$val['weibao_phone'])
                ->setCellValue("Z".$row,$val['status'])
                ->setCellValue("AA".$row,$val['is_show'])
                ->setCellValue("AB".$row,$val['decipher'])
                ->setCellValue("AC".$row,$val['dismantle'])
                ->setCellValue("AD".$row,date("Y.m.d H:i",$val['create_time']));
                if($del ==2 ){
                    $objSheet->setCellValue("U".$row,$val['username']);
                    $objSheet->setCellValue("V".$row,date("Y.m.d H:i",$val['del_time']));
                }
        }
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xlsx");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;
    }
    public function actionExecl()
    {  
        set_time_limit(0);
        ini_set("memory_limit", "10240M");

        $query = (new \yii\db\Query())
            ->select('sculpture.*,admin.username,sculpture_sub.status,sculpture_att.*')
            ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->leftJoin('districtorder', 'sculpture.district  = districtorder.district')
            ->from("sculpture");
        // 根据账户权限 获取不同级别数据
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                // 市级单位判断 如果是雕办
                // $admin = $this->admin_id;
                // if($admin =='3339'){
                //     // $query->andWhere(['sculpture.shi_uid' => 3339]);
                // }else{
                //     $query->andWhere(['sculpture.shi_uid' => $admin]);
                // }
                break;
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                $xia_qu = $this->admin_name;
                $street = DbWork::queryAll("select street from location where district='{$xia_qu}' and status = 1");
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                break;
            case '4':
                $query->andWhere(['sculpture.admin_id' => $this->admin_id]);
                break;
            default:
                die('权限不足');
                break;
        }
        $title = "艺术品列表";
        $query->andWhere(['sculpture.del'=>0]);
        $query->orderBy('districtorder.ord ASC,sculpture.id DESC');
        $res = $query->offset(0)->all();
        self::actionNoimgExecl($res,$title,0);
        die;
    }
    // 携带图片的execl 导出
    public function actionExecls()
    {  
        $page = empty($this->_GETDATA['page']) ? 0 :(int)$this->_GETDATA['page'];
        $district = empty($this->_GETDATA['district']) ? "" :$this->_GETDATA['district'];
        $title = empty($this->_GETDATA['title']) ? '' :$this->_GETDATA['title'];
        set_time_limit(0);
        ini_set("memory_limit", "1024M");
        $query = (new \yii\db\Query())
            ->select('sculpture.*,admin.username,sculpture_sub.status,sculpture_att.*')
            ->leftJoin('admin', 'sculpture.admin_id  = admin.id')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->leftJoin('districtorder', 'sculpture.district  = districtorder.district')
            ->from("sculpture");
        // 根据账户权限 获取不同级别数据
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                break;
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                $xia_qu = $this->admin_name;
                $street = DbWork::queryAll("select street from location where district='{$xia_qu}' and status=1");
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
                $role_jurisdiction = $this->role_jurisdiction;
                $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                break;
            case '4':
                $query->andWhere(['sculpture.admin_id' => $this->admin_id]);
                break;
            default:
                die('权限不足');
                break;
        }
        $title = $title ? $title :"艺术品列表";
        $query->andWhere(['sculpture.del'=>0]);
        if($page){
            $query->offset($page*500)->limit(500);
        }else{
            if($page ==0 && $district =='' ){
                $query->offset($page*500)->limit(500);
            }
        }
        if($district){
            $query->andWhere(['sculpture.district'=>$district]);
        }
        $query->orderBy('districtorder.ord ASC,sculpture.id DESC');
        
        $res = $query->all();
        
        self::actionImgExecl($res,$title,0);
        die;
    }

    // 日常巡查导出
    public function actionSign()
    {
        $district = empty($this->_GETDATA['district']) ? '' :$this->_GETDATA['district']; //Yii::$app->request->get('district');
        $street = empty($this->_GETDATA['street']) ? '' :$this->_GETDATA['street']; //Yii::$app->request->get('street');
        $type = empty($this->_GETDATA['type']) ? '' :$this->_GETDATA['type']; //Yii::$app->request->get('type');
        $day = empty($this->_GETDATA['day']) ? '' :$this->_GETDATA['day']; //Yii::$app->request->get('nian');
        $query = (new \yii\db\Query())
            ->select('sculpture.zpbh,sculpture.id,sculpture.name as sc_name,sculpture.district,sculpture.street,punch_list.day,punch_list.content,punch_list.create_time,punch_list.content,punch_list.name,punch_list.phone,punch_list.username')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin("punch_list", "sculpture.id  = punch_list.sculpture_id and punch_list.day='$day'")
            ->from("sculpture");
        $query->andWhere(['sculpture_sub.status'=>1]); 
        // $query->andWhere(['punch_list.day'=>$BeginDate]); 
        $query->andWhere(['sculpture.del'=>0]); 
        
        switch ($this->role_level) {
            case '0':
                break;
            case '1':
                if($district!='' && $district!='undefined'){
                    $query->andWhere(['sculpture.district'=>$district]);
                }
                if($street!='' && $street!='undefined'){
                    $query->andWhere(['sculpture.street'=>$street]); 
                }
                break;
            case '2':
                // 区 判断审核判断 或者进行再次上报 
                if($district!='' && $district!='undefined'){
                    $query->andWhere(['sculpture.district'=>$district]);
                }else{
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.district' => $role_jurisdiction]);
                }
                if($street!='' && $street!='undefined'){
                    $query->andWhere(['sculpture.street'=>$street]); 
                }
                break;
            case '3':
                // 街道办事处 判断是否是进行上报的 
                if($street!='' && $street!='undefined'){
                    $query->andWhere(['sculpture.street'=>$street]); 
                }else{
                    $role_jurisdiction = $this->role_jurisdiction;
                    $query->andWhere(['sculpture.street' => $role_jurisdiction]);
                }
                break;
            case '4':
                die("权限不足");
            default:
                if($district!='' && $district!='undefined'){
                    $query->andWhere(['sculpture.district'=>$district]); 
                }
                if($street!='' && $street!='undefined'){
                    $query->andWhere(['sculpture.street'=>$street]); 
                }
                break;
        }
        switch ($type) {
            case '1':
                $query->andWhere(['<>','punch_list.day','']); 
                break;
            case '2':
                $query->andWhere(['punch_list.day'=>null]); 
                break;
            default:
                # code...
                break;
        }
        $query->orderBy('sculpture.id ASC');
        $list = $query->all();
        $title = $district.$street.$day.'艺术品巡查表';
        self::actionSignExecl($list,$title);
        die;
    }
    public function actionSignExecl($data,$title)
    {
        $objPHPExcel = new \PHPExcel();
        $objSheet=$objPHPExcel->getActiveSheet();
        $objSheet->setTitle($title);
        $objSheet
            ->setCellValue("A1",'艺术品编号')
            ->setCellValue("B1","公共艺术品名称")
            ->setCellValue("C1","区")
            ->setCellValue("D1","街道")
            ->setCellValue("E1","是否巡查")
            ->setCellValue("F1","巡查人")
            ->setCellValue("G1","巡查人电话")
            ->setCellValue("H1","巡查备注")
            ->setCellValue("I1","巡查时间");
			// 设置纸张大小为A4
        $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(\PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        //设置默认行高
        $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);
        // $objPHPExcel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(80);
        //所有垂直居中
        $objSheet->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER)->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);//设置excel文件默认水平垂直方向居中
        //设置单元格宽度
        $objSheet->getStyle("A1:I1")->getFill()->setFillType(\PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('6fc144');
        $objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);
        $row = 1;
        foreach ($data as $val) {
            $val['zpbh'] = str_replace('区','',$val['district']).str_pad($val['zpbh'],3,"0",STR_PAD_LEFT);
            if($val['day'] != null){
                $val['day'] = "是";
            }else{
                $val['day'] = "否";
            }
            if($val['name'] =='undefined'){
                $val['name'] = '';
            }
            $row++;
            $objSheet
                ->setCellValue("A".$row,$val['zpbh']);
            $objSheet
                ->setCellValue("B".$row,$val['sc_name'])
                ->setCellValue("C".$row,$val['district'])
                ->setCellValue("D".$row,$val['street'])
                ->setCellValue("E".$row,$val['day'])
                ->setCellValue("F".$row,$val['name'])
                ->setCellValue("G".$row,' '.$val['phone'])
                ->setCellValue("H".$row,$val['content'])
                ->setCellValue("I".$row,$val['create_time']);
        }
        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel,'Excel2007');//生成excel文件
        header('Content-Type:application/vnd.ms-excel');
        // header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');//告诉浏览器数据excel07文件
        header("Content-Disposition: attachment;filename={$title}.xlsx");//告诉浏览器将输出文件的名称
        header('Cache-Control: max-age=0');//禁止缓存
        $objWriter->save("php://output");
        exit;
    }
}