<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */

namespace app\controllers\admin;

use app\models\DbDongao;
use Yii;
use yii\data\Pagination;
use yii\web\UploadedFile;


class CansaiController extends BaseController
{
    public $enableCsrfValidation = false;
    public $keys;

    public function actionZonglan()
    {
        $zpmc = empty($this->_GETDATA['zpmc']) ? '' :$this->_GETDATA['zpmc']; // 排序
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh']; // 排序
        $lang = empty($this->_GETDATA['lang']) ? '' :$this->_GETDATA['lang']; // 排序
        $zz = empty($this->_GETDATA['zz']) ? '' :$this->_GETDATA['zz']; // 排序
        $query = (new \yii\db\Query())
            ->select('zp_jcb.zpbh,zp_jcb.zpmc,gw_opus.opus_desc,gw_opus.jj,gw_opus.printnumber,zp_jcb.deleted,zp_jcb.zpmc_fy')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            
            ->from("dongao.zp_jcb");
        if($zpmc){
            $query->orWhere(['like','zp_jcb.zpmc',$zpmc]);
            $query->orWhere(['like','zp_jcb.zpmc_fy',$zpmc]);
        }
        if($zpbh){
            $query->andWhere(['like','zp_jcb.zpbh',$zpbh]);
        }
        if($lang){
            $query->andWhere(['zp_jcb.lang'=>$lang]);
        }
        if($zz){
            $query->leftJoin('dongao.gw_qtyzr','gw_opus.enroll_id=gw_qtyzr.enroll_id');
            $query->orWhere(['like','gw_enroll.xm',$zz]);
            $query->orWhere(['like','gw_qtyzr.name',$zz]);
        }
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '15', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        } 
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/cansai/zonglan',['list' => $list,'pages' => $page,'page_now'=>$page_now,'lang'=>$lang]);
    }
    public function actionChuxuan()
    {
        $zpmc = empty($this->_GETDATA['zpmc']) ? '' :$this->_GETDATA['zpmc']; // 排序
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh']; // 排序
        $lang = empty($this->_GETDATA['lang']) ? '' :$this->_GETDATA['lang']; // 排序
        $zz = empty($this->_GETDATA['zz']) ? '' :$this->_GETDATA['zz']; // 排序
        $query = (new \yii\db\Query())
            ->select('zp_yl.*,zp_jcb.zpbh,zp_jcb.zpmc,gw_opus.opus_desc,gw_opus.jj,gw_opus.printnumber,zp_jcb.deleted,zp_jcb.zpmc_fy')
            ->leftJoin('dongao.zp_jcb','zp_yl.zp_id=zp_jcb.zpbh')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            ->from("dongao.zp_yl");
        if($zpmc){
            $query->orWhere(['like','zp_jcb.zpmc',$zpmc]);
            $query->orWhere(['like','zp_jcb.zpmc_fy',$zpmc]);
        }
        if($zpbh){
            $query->andWhere(['like','zp_jcb.zpbh',$zpbh]);
        }
        if($lang){
            $query->andWhere(['zp_jcb.lang'=>$lang]);
        }
        if($zz){
            $query->leftJoin('dongao.gw_qtyzr','gw_opus.enroll_id=gw_qtyzr.enroll_id');
            $query->orWhere(['like','gw_enroll.xm',$zz]);
            $query->orWhere(['like','gw_qtyzr.name',$zz]);
        }
        $query->orderBy('zp_yl.zp_ps desc');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '15', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        } 
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/cansai/chuxuan',['list' => $list,'pages' => $page,'page_now'=>$page_now,'lang'=>$lang]);
    }
    public function actionRuwei()
    {
        $zpmc = empty($this->_GETDATA['zpmc']) ? '' :$this->_GETDATA['zpmc']; // 排序
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh']; // 排序
        $lang = empty($this->_GETDATA['lang']) ? '' :$this->_GETDATA['lang']; // 排序
        $zz = empty($this->_GETDATA['zz']) ? '' :$this->_GETDATA['zz']; // 排序
        $query = (new \yii\db\Query())
            ->select('zp_rw.*,zp_jcb.zpbh,zp_jcb.zpmc,gw_opus.opus_desc,gw_opus.jj,gw_opus.printnumber,zp_jcb.deleted,zp_jcb.zpmc_fy')
            ->leftJoin('dongao.zp_jcb','zp_rw.zp_id=zp_jcb.zpbh')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            ->from("dongao.zp_rw");
        if($zpmc){
            $query->orWhere(['like','zp_jcb.zpmc',$zpmc]);
            $query->orWhere(['like','zp_jcb.zpmc_fy',$zpmc]);
        }
        if($zpbh){
            $query->andWhere(['like','zp_jcb.zpbh',$zpbh]);
        }
        if($lang){
            $query->andWhere(['zp_jcb.lang'=>$lang]);
        }
        if($zz){
            $query->leftJoin('dongao.gw_qtyzr','gw_opus.enroll_id=gw_qtyzr.enroll_id');
            $query->orWhere(['like','gw_enroll.xm',$zz]);
            $query->orWhere(['like','gw_qtyzr.name',$zz]);
        }
        $query->andWhere(['zp_rw.ss'=>1]);
        // $query->orderBy('zp_wl.zp_ps desc');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '15', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        } 
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/cansai/zp_rw',['list' => $list,'pages' => $page,'page_now'=>$page_now,'lang'=>$lang]);
    }
    public function actionTiming()
    {
        $zpmc = empty($this->_GETDATA['zpmc']) ? '' :$this->_GETDATA['zpmc']; // 排序
        $zpbh = empty($this->_GETDATA['zpbh']) ? '' :$this->_GETDATA['zpbh']; // 排序
        $lang = empty($this->_GETDATA['lang']) ? '' :$this->_GETDATA['lang']; // 排序
        $zz = empty($this->_GETDATA['zz']) ? '' :$this->_GETDATA['zz']; // 排序
        $query = (new \yii\db\Query())
            ->select('zp_wl.*,zp_jcb.zpbh,zp_jcb.zpmc,gw_opus.opus_desc,gw_opus.jj,gw_opus.printnumber,zp_jcb.deleted,zp_jcb.zpmc_fy')
            ->leftJoin('dongao.zp_jcb','zp_wl.zp_id=zp_jcb.zpbh')
            ->leftJoin('dongao.gw_opus','zp_jcb.o_id=gw_opus.printnumber')
            ->leftJoin('dongao.gw_enroll','gw_opus.enroll_id=gw_enroll.id')
            ->from("dongao.zp_wl");
        if($zpmc){
            $query->orWhere(['like','zp_jcb.zpmc',$zpmc]);
            $query->orWhere(['like','zp_jcb.zpmc_fy',$zpmc]);
        }
        if($zpbh){
            $query->andWhere(['like','zp_jcb.zpbh',$zpbh]);
        }
        if($lang){
            $query->andWhere(['zp_jcb.lang'=>$lang]);
        }
        if($zz){
            $query->leftJoin('dongao.gw_qtyzr','gw_opus.enroll_id=gw_qtyzr.enroll_id');
            $query->orWhere(['like','gw_enroll.xm',$zz]);
            $query->orWhere(['like','gw_qtyzr.name',$zz]);
        }
        $query->andWhere(['zp_wl.del'=>0]);
        $query->orderBy('zp_wl.zp_ps desc');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '15', 'route' => null]
        );
        $page_now = empty($this->_GETDATA['page']) ? '' :$this->_GETDATA['page']; //Yii::$app->request->get('page');
        if($page_now =='' ||$page_now ==0){
            $page_now = 1;
        } 
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        // echo $query->createCommand()->getRawSql();
        return $this->renderPartial('/cansai/timing',['list' => $list,'pages' => $page,'page_now'=>$page_now,'lang'=>$lang]);
    }
    public function actionDetail()
    {
        $printnumber = Yii::$app->request->get('id');
        $query = (new \yii\db\Query())
            ->select('gw_opus.*,zp_jcb.zpmc_fy,zp_jcb.czsm_fy,zp_jcb.zpbh')
            ->leftJoin('dongao.zp_jcb', 'gw_opus.printnumber  = zp_jcb.o_id')
            ->from("dongao.gw_opus");
        $query->andWhere(['gw_opus.printnumber' => $printnumber]);
        $list = $query->one();

        // 附件表
        $query = (new \yii\db\Query())
                ->select('file_type,file_url,thumbnail_url')
                ->from("dongao.sys_fileinfo");
        $query->andWhere(['deleted' => 0]);        
        $query->andWhere(['data_id' => $list['objuuid']]);        
        $query->andWhere(['file_code' => $list['opus_code']]);        
        $list_sys = $query->all();
        // 作者信息
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("dongao.gw_enroll");
        $query->andWhere(['id' => $list['enroll_id']]);
        $list_user = $query->one();
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("dongao.gw_qtyzr");
        $query->andWhere(['enroll_id' => $list_user['id']]);
        $list_users = $query->all();
        return $this->renderPartial('/cansai/detail',['detail' => $list,'list_sys'=>$list_sys,'list_user'=>$list_user,'list_users'=>$list_users]);
    }
    
}