<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/19
 * Time: 9:29 PM
 */
namespace app\controllers\admin;


use app\models\DbWork;
use yii\web\Controller;
use Yii;

class BaseController extends Controller
{
    // public $enableCsrfValidation = false;
    public $keys;
    public $_DATA;
    public $_GETDATA;
    public $admin_id;
    public $admin_name;
    public $role_id;
    public $re_num;
    public $sign_num;
    public $role_level;
    public $role_parent;
    public $role_jurisdiction;
    public $is_read;
    public $street_arr;

    public function init()
    {
        $session = Yii::$app->session;
        // 判断是否登录
        if (!$session->isActive) {
            $session->open();
        }
        if (!in_array($this->route, ['admin/login','admin/login/captcha'])) {
            $session = Yii::$app->session;
            if($_GET['ssotype'] == 'jingbansso'){
                $session['login'] = 1;
                $session['admin_id'] = '3339';
                $session['admin_name'] = '市规划自然资源委(城雕办)';
                // 存储权限信息
                $role = DbWork::getRow('adminrole', '*', ['admin_id' => '3339']);
                $session['role_level'] = $role['level'];
                $session['role_parent'] = $role['parent'];
                $session['role_jurisdiction'] = $role['jurisdiction'];
                $session['is_read'] = 0;
            }else{
                if (!isset($session['login'])) {
                    header('Location: /admin/login/login');
                    die;
                    // return $this->redirect('/admin/login/login');
                    // Yii::$app->end();
                    // exit();
                    // die;
                }
            }
        }


        $post = Yii::$app->request->post();
        foreach ($post as $key=>$value){
            if(!is_array($value)){
                $post[$key] = htmlspecialchars($value);
            }else{
                foreach ($value as $kk=>$vv){
                    $value[$kk] = htmlspecialchars($vv);
                }
                $post[$key] = $value;
            }

        }
        $get = Yii::$app->request->get();
        foreach ($get as $key => $value) {
            if (!is_array($value)) {
                $get[$key] = htmlspecialchars($value);
            } else {
                foreach ($value as $kk => $vv) {
                    $value[$kk] = htmlspecialchars($vv);
                }
                $get[$key] = $value;
            }
        }
        $this->_GETDATA = $get;
        $this->admin_id = $session['admin_id'];
        $this->admin_name = $session['admin_name'];
        $this->role_level = $session['role_level'];
        $this->role_parent = $session['role_parent'];
        $this->role_jurisdiction = $session['role_jurisdiction'];

        $this->is_read = $session['is_read'];
        $this->street_arr = array("石景山雕塑园","古城公园","北京国际雕塑园","王府井管委会","密云区园林绿化服务中心","密云区文化和旅游局","密云区教工委","石景山区公园管理中心","八大处公园","怀柔科学城管理委员会","北京雁栖湖生态发展示范区管理委员会","临空经济核心区","中关村顺义园","绿色生态产业功能区");
        $this->_DATA = $post;
        // $res = $this->getObject();
        // $session['object'] = $res;
        // 获取数量
        $session['re_num'] = self::letter();
        $session['sign_num'] = self::sign_view();
        $php_urls = $_SERVER['REQUEST_URI'];
        $php_urls =explode('?',$php_urls);
        $php_url = $php_urls[0];
        switch ($session['role_level']) {
            case '1':
                $power =  DbWork::getRow('power', '*', ['means' => $php_url,'shi'=>1]);
                break;
            case '2':
                $power =  DbWork::getRow('power', '*', ['means' => $php_url,'qu'=>2]);
                break;
            case '3':
                $power =  DbWork::getRow('power', '*', ['means' => $php_url,'xiang'=>3]);
                break;
            case '4':
                $power =  DbWork::getRow('power', '*', ['means' => $php_url,'jiceng'=>4]);
                break;
            default:
                break;
        }
        if($php_url !='/admin/login/login' && $php_url !='/admin/login/login-check' && $php_url !='/admin/index/index'&& $php_url !='/admin/index/index' && $php_url !='/admin/login/captcha'){
            if(!$power){
                echo "<script> alert('权限不足');</script>";
                die;
            }
        }
        
    }
    public function sign_view()
    {
        $nian = $DateY = (string)date("Y");
        $DateM = (string)date("m");
        $spring = array('01','02','03');
        $summer = array('04','05','06');
        $autumn = array('07','08','09');
        $winter = array('10','11','12');
        if(in_array($DateM,$spring)){ $yue = '03';}
        if(in_array($DateM,$summer)){ $yue = '06';}
        if(in_array($DateM,$autumn)){ $yue = '09';}
        if(in_array($DateM,$winter)){ $yue = '12';}
        $BeginDate=$nian.$yue;
        $query = (new \yii\db\Query())
            ->select('sculpture.zpbh,sculpture.id,sculpture.name,sculpture.district,punch_list.day,punch_list.content,sculpture_sub.status_time')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->leftJoin("punch_list", "sculpture.id  = punch_list.sculpture_id and punch_list.day='$BeginDate'")
            ->from("sculpture");
        $query->andWhere(['sculpture_sub.status'=>1]); 
        $query->andWhere(['sculpture.del'=>0]);
        $query->andWhere(['<=','sculpture_sub.status_time',getthemonth(substr($BeginDate,0,4).'-'.substr($BeginDate,4,6).'-01')]);  
        $dizhis = array();
        $dizhi = array();
        // 根据级别获取 获取地理位置
        switch ($this->role_level) {
            case '0':
               
                break;
            case '1':
               
                break;
            case '2':
                $districts = str_replace('委宣传部','',$this->admin_name);
                $query->andWhere(['sculpture.district'=>$districts]);
                break;
            case '3':
                $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->role_parent]);
                $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
                $jurisdiction =  DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $this->admin_id]);
                $query->andWhere(['sculpture.street'=>$jurisdiction['jurisdiction']]);
                break;
            default:
                
                break;
        }
        $query->andWhere(['punch_list.day'=>null]); 
        $query->orderBy('sculpture.id ASC');
        return $query->count();
    }
    public function letter()
    {
        $query = (new \yii\db\Query())
            ->select('letters.id,letters.addtime,letters.title,letters_reply.id as rid')
            ->join("LEFT JOIN","letters","letters_reply.lid=letters.id")
            ->from("letters_reply");
        $query->andWhere(['or',
            ['letters_reply.admin_id' => $this->admin_id,'letters_reply.isread'=>0],
            ['letters_reply.send' => $this->admin_id,'letters_reply.s_isread'=>0]
        ]);
        // $num = $query->count();
        // echo $query->createCommand()->getRawSql();
        return $query->count();
    }
    // public function afterAction($action){
    //     parent::init();
    //     // 获取方法名称 
    //     $currentaction = $action->id;
    //     $novalidactions = ['login','logincheck','index'];
    //     if(!in_array($currentaction,$novalidactions)) {
    //         // 获取HTTP_REFERER   如果获取不到或者获取不同则跳转登录
    //         $referer = explode('/',$_SERVER['HTTP_REFERER']);
    //         $host = explode('/',$_SERVER['HTTP_HOST']);
    //         if($referer[2]!=$host[0]){
    //             return $this->redirect('/admin/login/login');
    //         }
    //     }
    // }
    /**
     * 重写方法不验证csrf
     * @param $action
     * @return bool
     * @throws \yii\web\BadRequestHttpException
     */
    public function beforeAction($action) {
        parent::init();
        // 获取方法名称 
        $currentaction = $action->id;
        $novalidactions = ['login','logincheck','index'];
        // if(!in_array($currentaction,$novalidactions)) {
        //     // 获取HTTP_REFERER   如果获取不到或者获取不同则跳转登录
        //     if(isset($_SERVER['HTTP_REFERER'])){
        //         $referer = explode('/',$_SERVER['HTTP_REFERER']);
        //         $host = explode('/',$_SERVER['HTTP_HOST']);
        //         if($referer[2]!=$host[0]){
        //             $url = "/admin/login/login"; 
        //             echo "<script language='javascript' type='text/javascript'>"; 
        //             echo "window.location.href='$url'"; 
        //             echo "</script>"; 
        //             // return $this->redirect('/admin/login/login');
        //             die;
        //         }
        //     }else{
        //         $url = "/admin/login/login"; 
        //             echo "<script language='javascript' type='text/javascript'>"; 
        //             echo "window.location.href='$url'"; 
        //             echo "</script>"; 
        //         die;
        //     }
        // }
        // die;
        $currentaction = $action->id;
        $accessactions = ['sculptureusered','level','bredits','edits','task_add','add_task_street','add_letters','letters_reply','add_artists','edit_artists','add_workss','edit-admins','isshow','delds','listreductions','listreduction','deldss','task_huitui','del-tipoffs','tipoffshy','tipoffssc','show','delartisrworks','login-check','edit-user','edit-users','add-user','add-users'];
        if(in_array($currentaction,$accessactions)) {
            $action->controller->enableCsrfValidation = true;
        }
            parent::beforeAction($action);
        return true;
    }
  
}