<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/11
 * Time: 9:56 AM
 */

namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;
use yii\web\UploadedFile;


class ArtistController extends BaseController
{
    public $enableCsrfValidation = true;
    public $keys;

    public function actionArtist()
    {
        $query = (new \yii\db\Query())
            ->select('id,name,simg,title,addtime,work_unit,update_type,is_show')
            ->from("artist");
        $query->andWhere(['status' => 0]);
        $query->andWhere(['del' => 0]);
        $query->orderBy('addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/artist', ['list' => $list, 'pages' => $page]);
        // return $this->renderPartial('/admin/artist');
    }
    public function actionArtistinfo()
    {
        $id = (int)$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $detail = DbWork::getRow('artist', '*', ['id' => $id]);
        $update_detail = array();
        $artist_evaluate = array();
        $artist_update = array();
        if($detail['update_type'] ==1){
            $update_detail = DbWork::getRow('artist', '*', ['number' => $detail['number'],'status' => 1,'del' => 0]);
        }
        $artist_evaluate = DbWork::getRow('artist_evaluate', '*', ['aid' => $id]);

        $artist_update = DbWork::getAll('artist_update', '*', ['aid' => $id,],'','updatetime desc');
        // Artistevaluate

        return $this->renderPartial('/admin/artistinfo',['detail' => $detail,'update_detail'=>$update_detail,'artist_evaluate'=>$artist_evaluate,'artist_update'=>$artist_update]);
    }
    public function actionArtistcode()
    {
        $id = (int)$this->_DATA['id'];
        $str ="1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
        $salt =substr(str_shuffle($str),mt_rand(0,strlen($str)-11),8);
        return $this->renderPartial('/admin/artistcode',['id' => $id,'scode' =>$salt]); 
    }
    public function actionArtistscodeadd()
    {
        $id = (int)$this->_DATA['id'];
        $where['scode_time'] = time()+259200;
        $str ="1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
        $salt =substr(str_shuffle($str),mt_rand(0,strlen($str)-11),8);
        $where['scode'] = md5($salt);
        $res = DbWork::update('artist',$where,['id'=>$id]);
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功','scode'=>$salt,'time'=>date("Y-m-d H:i:s",$where['scode_time'])]);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);

    }
    public function actionArtistevaluate()
    {
        $where['name'] = $this->_DATA['evaluate_name'];
        $where['aid'] = $this->_DATA['aid'];
        $where['phone'] = $this->_DATA['evaluate_phone'];
        $where['bank'] = $this->_DATA['evaluate_bank'];
        $where['account'] = $this->_DATA['evaluate_account'];
        $where['evaluate'] = $this->_DATA['evaluate_evaluate'];
        $wheres['work_time'] = $this->_DATA['evaluate_work_time'];
        $wheres['work_name'] = $this->_DATA['evaluate_work_name'];
        $wheres['work_number'] = $this->_DATA['evaluate_work_number'];
        $wheres['work'] = $this->_DATA['evaluate_work'];
        $arr = array();
        for ($i=0; $i < count($wheres['work_time']); $i++) { 
            $arr[] = $wheres['work_time'][$i].';'.$wheres['work_name'][$i].';'.$wheres['work_number'][$i].';'.$wheres['work'][$i];
        }
        $where['content'] = implode('|', $arr);
        $res = DbWork::getRow('artist_evaluate', 'id,aid', ['aid' => $where['aid']]);
        if($res){
            $res = DbWork::update('artist_evaluate',$where,['id'=>$res['id']]);
        }else{
           $res = DbWork::save('artist_evaluate',$where); 
        }
        echo "<script>alert('保存成功'); </script>";
        return $this->redirect("/admin/index/artistinfo?id=".$where['aid']);
    }
    public function actionArtistupdate()
    {
        $where['aid'] = (int)$this->_DATA['aid'];
        $update_time = $this->_DATA['update_time'];
        $update_content = $this->_DATA['update_content'];
        $where['updatetime'] = implode(';', $update_time);
        $where['content'] = implode(';', $update_content);
        $res = DbWork::getRow('artist_update', 'id,aid', ['aid' => $where['aid']]);
        if($res){
            $res = DbWork::update('artist_update',$where,['id'=>$res['id']]);
        }else{
           $res = DbWork::save('artist_update',$where); 
        }
        echo "<script>alert('保存成功'); </script>";
        return $this->redirect("/admin/index/artistinfo?id=".$where['aid']);
    }
    public function actionArtistupdatetab()
    {
        // 获取原数据  
        $id = (int)$this->_DATA['id'];
        $res = $history = DbWork::getRow('artist', '*', ['id' => $id]);
        // 获取更新数据
        $arr = DbWork::getRow('artist', 'id', ['number' => $res['number'],'status'=>1]);
        $brr['id'] = $res['id'];
        $brr['update_type'] = 0;
        $brr['status'] = 0;
        unset($history['scode']);
        unset($history['scode_time']);
        unset($history['del']);
        unset($history['del_time']);
        unset($history['status']);
        unset($history['update_type']);
        unset($history['id']);
        $db = Yii::$app->db;
        $transaction = $db->beginTransaction();
        try {
            //将原数据 添加近 history表中
            $res = DbWork::save('artist_history',$history); 
            // 删除原数据
            $res1 = DbWork::delete('artist',['id'=>$id]); 
            // 将新数据变更为基础数据
            
            $res2 = DbWork::update('artist',$brr,['id'=>$arr['id']]);
            $transaction->commit();
            return json_encode(['code' => 1, 'msg' => '成功']);
        } catch(\Exception $e) {
            $transaction->rollBack();
            throw $e;
            return json_encode(['code' => 0, 'msg' => '失败']);
        } catch(\Throwable $e) {
            $transaction->rollBack();
            throw $e;
            return json_encode(['code' => 0, 'msg' => '失败']);
        }
        return json_encode(['code' => 0, 'msg' => '失败']);
    }
    public function actionArtistdeltab()
    {
        $id = (int)$this->_DATA['id'];
        $res = DbWork::getRow('artist', 'id,number', ['id' => $id]);
        $arr = DbWork::getRow('artist', 'id', ['number' => $res['number'],'status'=>1]);
        $up_id = $arr['id'];
        $query = (new \yii\db\Query())
            ->select('id')
            ->from("artist_update");
        $query->andWhere(['aid' => $id]);
        $query->orderBy('updatetime DESC');
        $list = $query->one();
        // 将基础便删除，更新表字段变成 status 变为1
        $db = Yii::$app->db;
        $transaction = $db->beginTransaction();
        try {
            $res1 = DbWork::delete('artist',['id'=>$up_id]);
            $res1 = DbWork::delete('artist_update',['id'=>$list['id']]);
            $transaction->commit();
            return json_encode(['code' => 1, 'msg' => '成功']);
        } catch(\Exception $e) {
            $transaction->rollBack();
            throw $e;
            return json_encode(['code' => 0, 'msg' => '失败']);
        } catch(\Throwable $e) {
            $transaction->rollBack();
            throw $e;
            return json_encode(['code' => 0, 'msg' => '失败']);
        }
        return json_encode(['code' => 0, 'msg' => '失败']);
    }
    public function actionArtisthistory()
    {
        $id = (int)$this->_GETDATA['id'];
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("artist_history");
        $query->andWhere(['number' => $id]);
        $query->orderBy('addtime DESC');
        $list = $query->all();
        return $this->renderPartial('/admin/artisthistory', ['list' => $list]);
    }
    public function actionArtistedit()
    {
        $id = (int)$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $detail = DbWork::getRow('artist', '*', ['id' => $id]);
        return $this->renderPartial('/admin/edit_artist',['detail'=>$detail]);
    }
    public function actionAdd_artist()
    {
        return $this->renderPartial('/admin/add_artist');
    }
    // 数据新增
    public function actionAdd_artists()
    {
        $query = (new \yii\db\Query())
            ->select("id")
            ->from("artist");
        $query->andWhere(['status' => 0,'del'=>0]);
        $num = $query->count();
        $where['number'] = date('Ymd').str_pad($num+1,5,"0",STR_PAD_LEFT);
        $where['status'] = 0;
        $where['name'] = !empty($this->_DATA['name']) ? $this->_DATA['name'] : '';
        $where['sex'] = !empty($this->_DATA['sex']) ? (int)$this->_DATA['sex'] : '';
        $where['nationality'] = !empty($this->_DATA['nationality']) ? $this->_DATA['nationality'] : '';
        $where['nation'] = !empty($this->_DATA['nation']) ? $this->_DATA['nation'] : '';
        $where['face'] = !empty($this->_DATA['face']) ? $this->_DATA['face'] : '';
        $where['birthday'] = !empty($this->_DATA['birthday']) ? $this->_DATA['birthday'] : '';
        $where['type'] = !empty($this->_DATA['type']) ? $this->_DATA['type'] : '';
        $where['certificates'] = !empty($this->_DATA['certificates']) ? $this->_DATA['certificates'] : '';
        $where['phone'] = !empty($this->_DATA['phone']) ? $this->_DATA['phone'] : '';
        $where['telephone'] = !empty($this->_DATA['telephone']) ? $this->_DATA['telephone'] : '';
        $where['email'] = !empty($this->_DATA['email']) ? $this->_DATA['email'] : '';
        $where['wx'] = !empty($this->_DATA['wx']) ? $this->_DATA['wx'] :  '';
        $where['work_unit'] = !empty($this->_DATA['work_unit']) ? $this->_DATA['work_unit'] : '';
        $where['job'] = !empty($this->_DATA['job']) ? $this->_DATA['job'] : '';
        $where['permanent'] = !empty($this->_DATA['permanent']) ? $this->_DATA['permanent'] : '';
        $where['title'] = !empty($this->_DATA['title']) ? $this->_DATA['title'] : '';
        $where['address'] = !empty($this->_DATA['address']) ? $this->_DATA['address'] : '';
        $where['school'] = !empty($this->_DATA['school']) ? $this->_DATA['school'] : '';
        $school_time['year'] = !empty($this->_DATA['school_time_year']) ? $this->_DATA['school_time_year'] :'';
        $school_time['month'] = !empty($this->_DATA['school_time_month']) ? $this->_DATA['school_time_month'] :'';
        $where['school_time'] = $school_time['year'].'年'.$school_time['month'].'月';
        $where['major'] = !empty($this->_DATA['major']) ? $this->_DATA['major'] : '';
        $where['education'] = !empty($this->_DATA['education']) ? $this->_DATA['education'] : '';
        $where['fields'] = !empty($this->_DATA['fields']) ? $this->_DATA['fields'] : '';
        if($where['fields']){
            foreach ($where['fields'] as $key => $value) {
                if($value =='其他'){
                    $where['fields'][$key] = $where['fields'][$key]."：".$this->_DATA['fields_other'];
                }
            }
            $where['fields'] = implode(';',$where['fields']);
        }
        
        // 处理工作经理
        if($this->_DATA['experience_year_min']){
            $experience_arr = array();
            foreach ($this->_DATA['experience_year_min'] as $k => $v) {
                // echo $v;
                // echo $this->_DATA['experience_month_min'][$k];
                $experience_arr[] = $v.'|'.$this->_DATA['experience_month_min'][$k].'|'.$this->_DATA['experience_year_max'][$k].'|'.$this->_DATA['experience_month_max'][$k].'|'.$this->_DATA['experience_danwei'][$k].'|'.$this->_DATA['experience_danwei'][$k];
            }
            $where['experience'] = implode(';',$experience_arr);
        }
        $where['achievement'] = !empty($this->_DATA['achievement']) ? $this->_DATA['achievement'] : '';
        $where['opus'] = !empty($this->_DATA['opus']) ? $this->_DATA['opus'] : '';
        $where['simg'] = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        $where['other'] = !empty($this->_DATA['other']) ? $this->_DATA['other'] : '';
        $where['addtime'] = time();
        $result = DbWork::save('artist', $where);
        if (!$result) {
            echo "<script> alert('保存失败！'); window.history.go(-1);</script>";
        }
        return $this->redirect(['admin/artist/artist', 'id' => 1]);
    }
    public function actionEdit_artists()
    {
        $where['name'] = !empty($this->_DATA['name']) ? $this->_DATA['name'] : '';
        $where['sex'] = !empty($this->_DATA['sex']) ? (int)$this->_DATA['sex'] : '';
        $where['nationality'] = !empty($this->_DATA['nationality']) ? $this->_DATA['nationality'] : '';
        $where['nation'] = !empty($this->_DATA['nation']) ? $this->_DATA['nation'] : '';
        $where['face'] = !empty($this->_DATA['face']) ? $this->_DATA['face'] : '';
        $where['birthday'] = !empty($this->_DATA['birthday']) ? $this->_DATA['birthday'] : '';
        $where['type'] = !empty($this->_DATA['type']) ? $this->_DATA['type'] : '';
        $where['certificates'] = !empty($this->_DATA['certificates']) ? $this->_DATA['certificates'] : '';
        $where['phone'] = !empty($this->_DATA['phone']) ? $this->_DATA['phone'] : '';
        $where['telephone'] = !empty($this->_DATA['telephone']) ? $this->_DATA['telephone'] : '';
        $where['email'] = !empty($this->_DATA['email']) ? $this->_DATA['email'] : '';
        $where['wx'] = !empty($this->_DATA['wx']) ? $this->_DATA['wx'] :  '';
        $where['work_unit'] = !empty($this->_DATA['work_unit']) ? $this->_DATA['work_unit'] : '';
        $where['job'] = !empty($this->_DATA['job']) ? $this->_DATA['job'] : '';
        $where['permanent'] = !empty($this->_DATA['permanent']) ? $this->_DATA['permanent'] : '';
        $where['title'] = !empty($this->_DATA['title']) ? $this->_DATA['title'] : '';
        $where['address'] = !empty($this->_DATA['address']) ? $this->_DATA['address'] : '';
        $where['school'] = !empty($this->_DATA['school']) ? $this->_DATA['school'] : '';
        $school_time['year'] = !empty($this->_DATA['school_time_year']) ? $this->_DATA['school_time_year'] :'';
        $school_time['month'] = !empty($this->_DATA['school_time_month']) ? $this->_DATA['school_time_month'] :'';
        $where['school_time'] = $school_time['year'].'年'.$school_time['month'].'月';
        $where['major'] = !empty($this->_DATA['major']) ? $this->_DATA['major'] : '';
        $where['education'] = !empty($this->_DATA['education']) ? $this->_DATA['education'] : '';
        $where['fields'] = !empty($this->_DATA['fields']) ? $this->_DATA['fields'] : '';
        if($where['fields']){
            foreach ($where['fields'] as $key => $value) {
                if($value =='其他'){
                    $where['fields'][$key] = $where['fields'][$key]."：".$this->_DATA['fields_other'];
                }
            }
            $where['fields'] = implode(';',$where['fields']);
        }
        
        // 处理工作经理
        if($this->_DATA['experience_year_min']){
            $experience_arr = array();
            foreach ($this->_DATA['experience_year_min'] as $k => $v) {
                // echo $v;
                // echo $this->_DATA['experience_month_min'][$k];
                $experience_arr[] = $v.'|'.$this->_DATA['experience_month_min'][$k].'|'.$this->_DATA['experience_year_max'][$k].'|'.$this->_DATA['experience_month_max'][$k].'|'.$this->_DATA['experience_danwei'][$k].'|'.$this->_DATA['experience_danwei'][$k];
            }
            $where['experience'] = implode(';',$experience_arr);
        }
        $where['achievement'] = !empty($this->_DATA['achievement']) ? $this->_DATA['achievement'] : '';
        $where['opus'] = !empty($this->_DATA['opus']) ? $this->_DATA['opus'] : '';
        $where['simg'] = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        $where['other'] = !empty($this->_DATA['other']) ? $this->_DATA['other'] : '';
        $where['addtime'] = time();
        $result = DbWork::update('artist',$where,['id' => $this->_DATA['id']]);
        // $result = DbWork::save('artist', $where);
        if (!$result) {
            echo "<script> alert('保存失败！'); window.history.go(-1);</script>";
        }
        return $this->redirect(['admin/artist/artist', 'id' => 1]);
    }
    public function actionDelds()
    {
        $id = $this->_DATA['id'];
        if( is_array($id) ){
            foreach ($id as $key => $value) {
            $res = DbWork::update('artist',['del'=>1],['id'=>$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
            $res = DbWork::update('artist',['del'=>1],['id'=>$this->_DATA['id']]);
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    public function actionShow()
    {
        $id = $this->_DATA['id'];
        $is_show = (int)$this->_DATA['is_show'];
        if( is_array($id) ){
            foreach ($id as $key => $value) {
                $res = DbWork::update('artist',['is_show'=>$is_show],['id'=>(int)$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
            $res = DbWork::update('artist',['is_show'=>$is_show],['id'=>$id]);
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    // 专家作品
    public function actionWorks()
    {
        $query = (new \yii\db\Query())
            ->select('id,title,simg,desc,addtime')
            ->from("works");
        $query->andWhere(['del' => 0]);
        $query->orderBy('addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/works', ['list' => $list, 'pages' => $page]);
    }
    public function actionAdd_works()
    {
        return $this->renderPartial('/admin/add_works');
    }
    // 数据新增
    public function actionAdd_workss()
    {
        $where['title'] = !empty($this->_DATA['title']) ? $this->_DATA['title'] : '';
        $where['desc'] = !empty($this->_DATA['desc']) ? (int)$this->_DATA['desc'] : '';
        if(!empty($this->_DATA['content'])){
            $where['content'] =   stripslashes(htmlspecialchars_decode($this->_DATA['content']));
        }else{
            $where['content'] = '';
        }
        $where['simg'] = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        $where['addtime'] = time();
        $result = DbWork::save('works', $where);
        if (!$result) {
            echo "<script> alert('保存失败！'); window.history.go(-1);</script>";
        }
        return $this->redirect(['admin/artist/works', 'id' => 1]);
    }
    public function actionWorksedit()
    {
        $id = (int)$this->_GETDATA['id']; //Yii::$app->request->get('id');
        $detail = DbWork::getRow('works', '*', ['id' => $id]);
        return $this->renderPartial('/admin/edit_works',['detail'=>$detail]);
    }
    public function actionEdit_workss()
    {
        $where['title'] = !empty($this->_DATA['title']) ? $this->_DATA['title'] : '';
        $where['desc'] = !empty($this->_DATA['desc']) ? (int)$this->_DATA['desc'] : '';
        if(!empty($this->_DATA['content'])){
            $where['content'] =   stripslashes(htmlspecialchars_decode($this->_DATA['content']));
        }else{
            $where['content'] = '';
        }
        $where['simg'] = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        // $where['addtime'] = time();
        $result = DbWork::update('works',$where,['id' => $this->_DATA['id']]);
        // $result = DbWork::save('works', $where);
        if (!$result) {
            echo "<script> alert('保存失败！'); window.history.go(-1);</script>";
        }
        return $this->redirect(['admin/artist/works', 'id' => 1]);
    }
    public function actionArtist_works()
    {
        $id = !empty($this->_GETDATA['id']) ? $this->_GETDATA['id'] : '';
        $query = (new \yii\db\Query())
            ->select('artistworks.id,works.title,works.desc,works.simg,artistworks.wid')
            ->leftJoin('works', 'artistworks.wid  = works.id')
            ->from("artistworks");
        $query->andWhere(['works.del' => 0]);
        $query->andWhere(['artistworks.aid' => $id]);
        $list = $query->all();
        return $this->renderPartial('/admin/artist_works', ['list' => $list,'id'=>$id]);
    }
    public function actionAdd_artistworks()
    {
        $id = !empty($this->_GETDATA['id']) ? $this->_GETDATA['id'] : '';
        $ids = DbWork::getAll('artistworks','wid',['aid'=>$id]);
        $idss = array_column($ids,'wid');
        $query = (new \yii\db\Query())
            ->select('works.title,works.desc,works.simg,works.id,works.addtime')
            // ->leftJoin('artistworks', 'works.id  = artistworks.wid')
            ->from("works");
        $query->andWhere(['works.del' => 0]);
        $query->andWhere(['not in', 'works.id',$idss]);
        $query->orderBy('works.addtime DESC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize' => '10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/addworkss', ['list' => $list, 'pages' => $page,'id'=>$id]);
    }
    public function actionAddartisrworks()
    {
        $id = (int)$this->_DATA['wid'];
        $where['aid'] = (int)$this->_DATA['aid'];
        if(is_array($id) ){
            foreach ($id as $key => $value) {
                $where['wid'] = (int)$value;
                $res = DbWork::save('artistworks',$where);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
            $where['wid'] = (int)$id;
            $ress = DbWork::save('artistworks',$where);
            if($ress){
                return json_encode(['code' => 1, 'msg' => '操作成功']);  
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        
    }
    public function actionDelartisrworks()
    {
        $id = $this->_DATA['id'];
        if(is_array($id) ){
            foreach ($id as $key => $value) {
                // $res1 = DbWork::delete('artistworks',$where); 
                $res = DbWork::delete('works',['id'=>(int)$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
            // $ress = DbWork::delete('artistworks',$where); 
            $ress = DbWork::delete('works',['id'=>(int)$id]);
            if($ress){
                return json_encode(['code' => 1, 'msg' => '操作成功']);  
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        
    }
}