<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/19
 * Time: 9:46 PM
 */
namespace app\controllers\admin;

use app\models\DbWork;
use Yii;
use yii\data\Pagination;


class AdminController extends BaseController
{
    public $enableCsrfValidation = false;

    public function actionAdminList()
    {
        // 查看level级别
        // 根据level 级别获取对应列表
        $role_name = Yii::$app->request->get('role_name');
        $username = Yii::$app->request->get('username')?Yii::$app->request->get('username'):'';
        switch ($this->role_level) {
            case '0':
                // 先获取 街道层级的用户
                $role_name = $role_name ? $role_name:"1";
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>1]);
                $query->andWhere(['adminrole.level' => $role_name]);
                if($username !=''){
                    $query->andWhere(['like','admin.username',$username]);
                }
                
                $query->orderBy('admin.id DESC');
               
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_list',['list'=>$list,'pages'=>$page,'role_name'=>$role_name,'username'=>$username]);
                break;
            case '1':
                // 先获取 街道层级的用户
                $role_name = $role_name ? $role_name:"2";
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>1]);
                $query->andWhere(['adminrole.level' => $role_name]);
                if($username !=''){
                    $query->andWhere(['like','admin.username',$username]);
                }
                $query->orderBy('admin.id DESC');
               
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_list',['list'=>$list,'pages'=>$page,'role_name'=>$role_name,'username'=>$username]);
                break;
            case '2':
                // 先获取 街道层级的用户
                // if($role_name =='4'){
                    $user = DbWork::getAll('adminrole','admin_id',['parent'=>$this->admin_id ]);
                    $parent = array_column($user,'admin_id');
                    $query = (new \yii\db\Query())
                        ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                        ->from("adminrole")
                        ->leftJoin('admin','admin.id=adminrole.admin_id');
                    $query->andWhere(['admin.status' =>1]);
                    $query->andWhere(['in','adminrole.parent',$parent]);
                    if($username !=''){
                        $query->andWhere(['like','admin.username',$username]);
                    }
                    $query->orderBy('admin.id DESC');
                // }else{
                //     if($this->is_read ==0){
                //         $parent = $this->admin_id;
                //     }else{
                //         $user = DbWork::getRow('admin', 'id', ['username' => $this->role_jurisdiction]);
                //         $parent = $user['id'];
                //     }
                //     $query = (new \yii\db\Query())
                //         ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                //         ->from("adminrole")
                //         ->leftJoin('admin','admin.id=adminrole.admin_id');
                //     $query->andWhere(['admin.status' =>1]);
                //     $query->andWhere(['adminrole.parent' =>$parent]);
                //     $query->orderBy('admin.id DESC');
                //     // echo '区';
                // }
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_list',['list'=>$list,'pages'=>$page,'role_name'=>$role_name,'username'=>$username]);
                break;
            case '3':
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,admin.mobile')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>1]);
                $query->andWhere(['adminrole.parent' => $this->admin_id]);
                $query->orderBy('admin.id DESC');
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_list',['list'=>$list,'pages'=>$page,'role_name'=>$role_name,'username'=>$username]);
                break;
            default:
                
                break;
        }
    }
    public function actionAdminDel()
    {
        // 查看level级别
        // 根据level 级别获取对应列表
        $role_name = Yii::$app->request->get('role_name');
        switch ($this->role_level) {
            case '0':
                // 先获取 街道层级的用户
                $role_name = $role_name ? $role_name:"1";
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,del_time')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>0]);
                $query->andWhere(['admin.del_uid' =>$this->admin_id]);
                $query->andWhere(['adminrole.level' => $role_name]);
                $query->orderBy('admin.del_time DESC');
               
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_lists',['list'=>$list,'pages'=>$page,'role_name'=>$role_name]);
                break;
            case '1':
                // 先获取 街道层级的用户
                $role_name = $role_name ? $role_name:"2";
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,del_time')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>0]);
                $query->andWhere(['admin.del_uid' =>$this->admin_id]);
                $query->andWhere(['adminrole.level' => $role_name]);
                $query->orderBy('admin.del_time DESC');
               
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_lists',['list'=>$list,'pages'=>$page,'role_name'=>$role_name]);
                break;
            case '2':
                // 先获取 街道层级的用户
                if($role_name =='4'){
                    $user = DbWork::getAll('adminrole','admin_id',['parent'=>$this->admin_id ]);
                    $parent = array_column($user,'admin_id');
                    $query = (new \yii\db\Query())
                        ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,del_time')
                        ->from("adminrole")
                        ->leftJoin('admin','admin.id=adminrole.admin_id');
                    $query->andWhere(['admin.status' =>0]);
                    $query->andWhere(['admin.del_uid' =>$this->admin_id]);
                    $query->andWhere(['in','adminrole.parent',$parent]);
                    $query->orderBy('admin.del_time DESC');
                }else{
                    $query = (new \yii\db\Query())
                        ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,del_time')
                        ->from("adminrole")
                        ->leftJoin('admin','admin.id=adminrole.admin_id');
                    $query->andWhere(['admin.status' =>0]);
                    $query->andWhere(['admin.del_uid' =>$this->admin_id]);
                    $query->andWhere(['adminrole.parent' => $this->admin_id]);
                    $query->orderBy('admin.del_time DESC');
                }
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_lists',['list'=>$list,'pages'=>$page,'role_name'=>$role_name]);
                break;
            case '3':
                $query = (new \yii\db\Query())
                    ->select('admin.id,admin.username,adminrole.level,admin.status,admin.create_time,del_time')
                    ->from("adminrole")
                    ->leftJoin('admin','admin.id=adminrole.admin_id');
                $query->andWhere(['admin.status' =>0]);
                $query->andWhere(['admin.del_uid' =>$this->admin_id]);
                $query->andWhere(['adminrole.parent' => $this->admin_id]);
                $query->orderBy('admin.del_time DESC');
                $countQuery = clone $query;
                $page = new Pagination(
                    ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
                );
                $list = $query->offset($page->offset)->limit($page->limit)->all();
                return $this->renderPartial('/admin/admin_lists',['list'=>$list,'pages'=>$page,'role_name'=>$role_name]);
                break;
            default:
                
                break;
        }
    }
    // 添加基层员工
    public function actionAddAdmin()
    {
        switch ($this->role_level) {
            case '0':
                // 获取所有的街道信息
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['level'=>3]);
                break;
            case '1':
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['level'=>3]);
                break;
            case '2':
                // 获取对应权限的街道
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['parent'=>$this->admin_id]);
                break;
            case '3':
                // 添加 基层员工
                $info = DbWork::getAll('adminrole','admin_id,jurisdiction',['admin_id'=>$this->admin_id]);
                break;
            default:
                
                break;
        }
        return $this->renderPartial('/admin/add-admin',['info'=>$info]);
    }

    public function actionAddAdmins()
    {
        $salt = $this->getSalt();
        $where['username'] = $this->_DATA['name'];
        $where['mobile'] = $this->_DATA['mobile'];
        $where['salt'] = $salt;
        $where['create_time'] = time();
        $where['password'] = md5($this->_DATA['pwd'] . $salt);

        $res = DbWork::save('admin',$where);
        $admin_id = Yii::$app->db->getLastInsertID();
        $role['jurisdiction'] = $this->_DATA['jurisdiction'];
        $role['level'] = $this->_DATA['level'];
        $role['admin_id'] = $admin_id;
        $role['parent'] = $this->_DATA['parent'];
        $res = DbWork::save('adminrole',$role);
        if ($res) {
            echo "<script>alert('添加成功'); </script>";
            return $this->redirect('/admin/admin/admin-list');
            // return $this->redirect('/admin/login/login');
        }else{
            echo "<script>alert('添加失败'); javascript:history.go(-1)</script>";
        }
        // if ($res) {
        //     return json_encode(['code' => 1, 'msg' => '操作成功']);
        // }
        // return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    public function actionEditAdmin()
    {
        $id = Yii::$app->request->get('id');
        $info = DbWork::getRow('admin','*',['id'=>$id]);
        return $this->renderPartial('/admin/edit-admin',['info'=>$info]);
    
    }
    public function actionEditAdmins()
    {
        Yii::getLogger()->log('区级用户修改',yii\log\Logger::LEVEL_INFO,'admin_log');
        $salt = $this->getSalt();
        $where['id'] = $this->_DATA['id'];
        $where['pwd'] = $this->_DATA['pwd'];
        $where['mobile'] = $this->_DATA['mobile'];
        // $where['status'] = $this->_DATA['status'];
        $where['salt'] = $salt;
        if($where['pwd']){
            $where['password'] = md5($this->_DATA['pwd'] . $salt);
        }
        $res = DbWork::update('admin',$where,['id'=>$where['id']]);
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }

    public function actionCheckadmin()
    {
        $id  = $this->_DATA['id'];
        $info = DbWork::getRow('admin','*',['id'=>$id]);
        if($info){
            if($info['password'] == md5($this->_DATA['pwd'] . $info['salt'])){
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }else{
                return json_encode(['code' => 0, 'msg' => '操作失败']);
            }
        }else{
           return json_encode(['code' => 0, 'msg' => '操作失败']); 
        }
    }
    public function actionCheckadmins()
    {
        // $salt = $this->getSalt();
        
        // // $where['pwd'] = $this->_DATA['pwd'];
        // $where['salt'] = $salt;
        Yii::getLogger()->log('本账户修改密码',yii\log\Logger::LEVEL_INFO,'admin_log');
        $info = DbWork::getRow('admin','id,password,salt',['id'=>$this->admin_id]);
        if(md5($this->_DATA['pwd'] . $info['salt']) == $info['password']){
            if($this->_DATA['new_pwd']){
                $where['password'] = md5($this->_DATA['new_pwd'] . $info['salt']);
            }
            $where['mobile'] = $this->_DATA['mobile'];
            $res = DbWork::update('admin',$where,['id'=>$this->admin_id]);
            if($res){
                echo "<script>alert('保存成功'); javascript:history.go(-1);</script>";
                // return $this->redirect('/admin/index/adminpwd');
            }else{
                echo "<script>alert('修改失败'); javascript:history.go(-1);</script>";
                // return $this->redirect('/admin/index/adminpwd');
            }
        }else{
            echo "<script>alert('原密码不正确'); javascript:history.go(-1);</script>";
            // return $this->redirect('/admin/index/adminpwd');
        }
    }
    public function actionDelAdmin()
    {
        // if($this->role_id == 1){
        $res = DbWork::update('admin',['status'=>0,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$this->_DATA['id']]);
        DbWork::delete('admin_role',['admin_id'=>$this->_DATA['id']]);
        if($res){
            return json_encode(['code'=>1,'msg'=>'操作成功']);
        }else{
            return json_encode(['code'=>0,'msg'=>'操作失败']);
        }
        // }
        // return json_encode(['code'=>0,'msg'=>'没有权限']);
    }
    public function actionDelAdmins()
    {
        // if($this->role_id == 1){
        
        $id = $this->_DATA['id'];
        // 判断是否是数组
        if( is_array($id) ){
            foreach ($id as $key => $value) {
                // $res = DbWork::update('sculpture',['is_show'=>$this->_DATA['isshow'] ],['id'=>$value]);
                $res = DbWork::update('admin',['status'=>1,'del_time'=>time()],['id'=>$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
             $res = DbWork::update('admin',['status'=>1,'del_time'=>time()],['id'=>$id]);
             if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }


        // $res = DbWork::update('admin',['status'=>1,'del_time'=>time()],['id'=>$this->_DATA['id']]);
        // if($res){
        //     return json_encode(['code'=>1,'msg'=>'操作成功']);
        // }else{
        //     return json_encode(['code'=>0,'msg'=>'操作失败']);
        // }
        // }
        // return json_encode(['code'=>0,'msg'=>'没有权限']);
    }
    public function actionDelAdminss()
    {
        $id = $this->_DATA['id'];
        // 判断是否是数组
        if( is_array($id) ){
            foreach ($id as $key => $value) {
                // $res = DbWork::update('sculpture',['is_show'=>$this->_DATA['isshow'] ],['id'=>$value]);
                $res = DbWork::delete('admin',['id'=>$value]);
                // $res = DbWork::update('admin',['status'=>1,'del_time'=>time()],['id'=>$value]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }else{
             // $res = DbWork::update('admin',['status'=>1,'del_time'=>time()],['id'=>$id]);
            $res = DbWork::delete('admin',['id'=>$id]);
             if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }

        // DbWork::delete('admin',['admin_id'=>$this->_DATA['id']]);
        // if($res){
        //     return json_encode(['code'=>1,'msg'=>'操作成功']);
        // }else{
        //     return json_encode(['code'=>0,'msg'=>'操作失败']);
        // } 
    }
    public function actionDelLetter()
    {
        Yii::getLogger()->log('公众参与进入回收站',yii\log\Logger::LEVEL_INFO,'admin_log');
        $type = $this->_DATA['type'];
        $id = $this->_DATA['id'];
        if($type == 3){
            $info = DbWork::getRow('letter','*',['id'=>$id]);
            $res = DbWork::update('letter',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$id]);
            $ress = DbWork::update('letter',['isreply'=>0],['id'=>$info['path']]);
        }else{
            $res = DbWork::update('letter',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$id]); 
        }
        if($res){
            return json_encode(['code'=>1,'msg'=>'操作成功']);
        }else{
            return json_encode(['code'=>0,'msg'=>'操作失败']);
        }
    
    }
    public function actionDelTipoffs()
    {
       $id = $this->_DATA['id']; 
       $res = DbWork::update('tipoffs',['del'=>1,'del_time'=>time(),'del_uid'=>$this->admin_id],['id'=>$id]); 
       if($res){
            return json_encode(['code'=>1,'msg'=>'操作成功']);
        }else{
            return json_encode(['code'=>0,'msg'=>'操作失败']);
        }
    }

    public function actionDelNotice()
    {
        $res = DbWork::update('announcement',['del'=>1],['id'=>$this->_DATA['id']]);
        // $res = DbWork::delete('announcement',['id'=>$this->_DATA['id']]);
        if($res){
            return json_encode(['code'=>1,'msg'=>'操作成功']);
        }else{
            return json_encode(['code'=>0,'msg'=>'操作失败']);
        }
    
    }

    public function actionRoleList()
    {
        $role = DbWork::getAll('role','*',['status'=>1]);
        return $this->renderPartial('/admin/role_list',['role'=>$role]);
    }

    public function actionAddRole()
    {
        $object = DbWork::getAll('object','*',['status'=>1]);
        return $this->renderPartial('/admin/add-role',['object'=>$object]);
    }

    public function actionAddRoles()
    {
        if($this->role_id == 1) {
            $role_name = $this->_DATA['role_name'];
            $object = $this->_DATA['object_id'];
            $object_id = explode(',', $object);
            $res = DbWork::save('role', ['role_name' => $role_name, 'create_time' => time()]);
            $role_id = Yii::$app->db->getLastInsertID();
            for ($i = 0; $i < count($object_id); $i++) {
                DbWork::save('role_object', ['role_id' => $role_id, 'object_id' => $object_id[$i]]);
            }
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        return json_encode(['code'=>0,'msg'=>'没有权限']);
    }

    public function actionDelRole()
    {
        if($this->role_id == 1) {
            $admin = DbWork::getAll('admin_role','*',['role_id'=>$this->_DATA['id']]);
            if($admin){
                return json_encode(['code' => 0, 'msg' => '该角色下尚存在管理员，请勿删除']);
            }
            $res = DbWork::update('role',['status'=>0],['id'=>$this->_DATA['id']]);
            DbWork::delete('role_object',['role_id'=>$this->_DATA['id']]);
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        return json_encode(['code'=>0,'msg'=>'没有权限']);
    }

    public function actionChangeObject()
    {
        $id = Yii::$app->request->get('id');
        $objects = DbWork::getAll('role_object','*',['role_id'=>$id]);
        $object_id = array_column($objects,'object_id');
        $object = DbWork::getAll('object','*',['status'=>1]);
        return $this->renderPartial('/admin/change-object',['object_id'=>$object_id,'object'=>$object,'role_id'=>$id]);
    }

    public function actionChangeObjects()
    {
        if($this->role_id == 1){
            $role_id = $this->_DATA['role_id'];
            $object = $this->_DATA['object_id'];
            $object_id = explode(',', $object);
            DbWork::delete('role_object', ['role_id' => $role_id]);
            for ($i = 0; $i < count($object_id); $i++) {
               DbWork::save('role_object', ['role_id' => $role_id, 'object_id' => $object_id[$i]]);
            }
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code'=>0,'msg'=>'没有权限']);
    }


    public function actionObjectList()
    {
        $query = (new \yii\db\Query())
            ->select('*')
            ->from("object")
            ->where(['status'=>1]);
        $query->orderBy('id ASC');
        $countQuery = clone $query;
        $page = new Pagination(
            ['totalCount' => $countQuery->count(), 'defaultPageSize'=>'10', 'route' => null]
        );
        $list = $query->offset($page->offset)->limit($page->limit)->all();
        return $this->renderPartial('/admin/object_list',['list'=>$list,'pages'=>$page]);
    }

    public function actionAddObject()
    {
        return $this->renderPartial('/admin/add-object');
    }

    public function actionAddObjects()
    {
        if($this->role_id == 1){
            $object_name = $this->_DATA['object_name'];
            $object_url = $this->_DATA['object_url'];
            $res = DbWork::save('object',['object_name'=>$object_name,'object_url'=>$object_url,'create_time'=>time()]);
            if ($res) {
                $session = Yii::$app->session;
                unset($session['object']);
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        return json_encode(['code'=>0,'msg'=>'没有权限']);
    }

    public function actionDelObject()
    {
        if($this->role_id == 1) {
            $res = DbWork::update('object',['status'=>0],['id'=>$this->_DATA['id']]);
            if ($res) {
                return json_encode(['code' => 1, 'msg' => '操作成功']);
            }
            return json_encode(['code' => 0, 'msg' => '操作失败']);
        }
        return json_encode(['code'=>0,'msg'=>'没有权限']);
    }

    public function getSalt()
    {
        $str ="1234567890qwertyuiopasdfghjklzxcvbnm";
        $salt =substr(str_shuffle($str),mt_rand(0,strlen($str)-11),10);
        return $salt;
    }
    public function actionLetterreduction()
    {
        $id = Yii::$app->request->post('id');
        $type = Yii::$app->request->post('type');
        if(empty($id)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if(empty($type)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        switch ($type) {
            case '0':
                $res = DbWork::update('letter',['del'=>0],['id'=>$this->_DATA['id']]);
                break;
            case '1':
                $res = DbWork::update('letter',['del'=>0],['id'=>$this->_DATA['id']]);
                break;
            case '2':
                 $res = DbWork::update('announcement',['del'=>0],['id'=>$this->_DATA['id']]);
                break;
            default:
                return json_encode(['code' => 0, 'msg' => '操作失败']);
                break;
        }
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    public function actionLetterreductions()
    {
        $id = Yii::$app->request->post('id');
        $type = Yii::$app->request->post('type');
        if(empty($id)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        if(empty($type)){
            return json_encode(['code' => 0, 'msg' => '参数不足']);
        }
        switch ($type) {
            case '0':
                $res = DbWork::delete('letter',['id'=>$this->_DATA['id']]);
                // $res = DbWork::update('letter',['del'=>0],['id'=>$this->_DATA['id']]);
                break;
            case '1':
                $res = DbWork::delete('letter',['id'=>$this->_DATA['id']]);
                break;
            case '2':
                $res = DbWork::delete('announcement',['id'=>$this->_DATA['id']]);
                // $res = DbWork::update('announcement',['del'=>0],['id'=>$this->_DATA['id']]);
                break;
            default:
                return json_encode(['code' => 0, 'msg' => '操作失败']);
                break;
        }
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }

    public function actionTipoffssc()
    {
        Yii::getLogger()->log('公众参与彻底删除',yii\log\Logger::LEVEL_INFO,'admin_log');
        // $id = Yii::$app->request->post('id');
        $res = DbWork::delete('tipoffs',['id'=>$this->_DATA['id']]);
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
    public function actionTipoffshy()
    {
        // $id = Yii::$app->request->post('id');
        Yii::getLogger()->log('公众参与还原',yii\log\Logger::LEVEL_INFO,'admin_log');
        $res = DbWork::update('tipoffs',['del'=>0],['id'=>$this->_DATA['id']]);
        if ($res) {
            return json_encode(['code' => 1, 'msg' => '操作成功']);
        }
        return json_encode(['code' => 0, 'msg' => '操作失败']);
    }
}