<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/22
 * Time: 9:07 PM
 */

namespace app\controllers;

use app\common\ApiController;
use app\models\Admin;
use app\models\DbWork;
use app\utils\AipOcr;
use Yii;

class SiteController extends ApiController
{
    public function actionLogin()
    {
        $session = Yii::$app->session;
        if($session['login_num']>=3){
            if( (time()-$session['login_num_time']) >=120){
                $session['login_num'] = 0;
                $session['login_num_time'] = 0;
            }else{
                return $this->responseJson([], 400, '登录失败,请稍后再试');
            }
            
        }
        $username = $this->_DATA['username'];
        $password = $this->_DATA['password'];
        $user = Admin::checks($username, $password);
        if ($user) {
            $this->user = $user;
            $arr['name'] = $user['username'];
            if(strlen($password) <8){
                $session['login_num'] = $session['login_num']+1;
                $session['login_num_time'] = time();
                return $this->responseJson([], 400, '账户被冻结，请联系管理员');
            }
            return $this->responseJson($arr, 200, '登录成功');
        } else {
            $session['login_num'] = $session['login_num']+1;
            if($session['login_num']>=3){ 
                $session['login_num_time'] = time();
                return $this->responseJson([], 400, '登录失败');
            }
            return $this->responseJson([], 400, '登录失败');
        }
        return $this->responseJson([], 400, '登录失败');
    }

    public function actionList()
    {
        $uid = $this->user['id'];
        $status = isset($this->_DATA['status']) ? $this->_DATA['status'] : '';
        $page = isset($this->_DATA['page']) ? $this->_DATA['page'] : 1;
        $pageSize = isset($this->_DATA['pagesize']) ? $this->_DATA['pagesize'] : 10;
        $page = max(1, $page);
        $data = array('total' => 0, 'total_page' => 0, 'cur_page' => 0, 'datalist' => array());
        
        $query = (new \yii\db\Query())
            ->select("id,name,district,street,location,type,img_url,create_time")
            ->from("sculpture");
        $query->andWhere(['del' => 0 ]);
            // ->where($where);
        // if (empty($status)) {
        //     // $query->andWhere(['admin_id' => $uid]);
        //     $query->andWhere(['or' , ['=' , 'admin_id' , $uid] , ['=' , 'jiceng_xiafa' , $uid]]);
        //     // $where = ['admin_id' => $uid];
        // } else {
        //     $query->andWhere(['or' , ['=' , 'admin_id' , $uid] , ['=' , 'jiceng_xiafa' , $uid]]);
        //     // $query->andWhere(['or',['name',['admin_id' => $uid],['jiceng_xiafa' => $uid]]);
        //     // $query->andWhere(['admin_id' => $uid ]);
        //     $query->andWhere(['status' => $status ]);
        //     // $where = ['admin_id' => $uid, 'status' => $status];
        // }
        $query->andWhere(['admin_id' => (int)$uid ]);
        // $query->andWhere(['status' => 3]);
        if(isset($this->_DATA['title']))
        {
            $query->andWhere(['or',['like','name',$this->_DATA['title'] ],['like','project',$this->_DATA['title']],['like','district',$this->_DATA['title']],['like','street',$this->_DATA['title']],['like','location',$this->_DATA['title']]]);
            // $query->andWhere(["like","name",$this->_DATA['title']]);
        }
        // 属性
        if(isset($this->_DATA['type']))
        {
            $query->andWhere(['type' => $this->_DATA['type'] ]);
        }
        // 高
        if(isset($this->_DATA['min_length']))
        {
            $query->andWhere(["between","length",$this->_DATA['min_length'],$this->_DATA['max_length']]);
        }
        // 宽
        if(isset($this->_DATA['min_width']))
        {
            $query->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
        }
        // 宽
        if(isset($this->_DATA['min_width']))
        {
            $query->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
        }
        // 材料 
        if(isset($this->_DATA['material']))
        {
            $query->andWhere(["like","material",$this->_DATA['material']]);
        }
        // 工艺
        if(isset($this->_DATA['technology']))
        {
            $query->andWhere(["like","technology",$this->_DATA['technology']]);
        }
        // 外观
        if(isset($this->_DATA['outward']))
        {
            $query->andWhere(["outward"=> $this->_DATA['outward'] ]);
        }
        // 摆放环境
        if(isset($this->_DATA['put_location']))
        {
            $query->andWhere(["put_location"=>$this->_DATA['put_location']]);
        }

        $data['total'] = $query->count();
        if ($data['total'] > 0) {
            $data['total_page'] = ceil($data['total'] / $pageSize);
            $data['cur_page'] = max(1, intval($page));
            $queryList = (new \yii\db\Query())
                ->select("id,name,district,street,location,type,img_url,create_time")
                ->from("sculpture");
            $queryList->andWhere(['del' => 0 ]);
            // if (empty($status)) {
            //     $queryList->andWhere(['or' , ['=' , 'admin_id' , $uid] , ['=' , 'jiceng_xiafa' , $uid]]);
            //     // $queryList->andWhere(['admin_id' => $uid ]);
            //     // $where = ['admin_id' => $uid];
            // } else {
            //     $queryList->andWhere(['or' , ['=' , 'admin_id' , $uid] , ['=' , 'jiceng_xiafa' , $uid]]);
            //     // $queryList->andWhere(['admin_id' => $uid ]);
            //     $queryList->andWhere(['status' => $status ]);
            //     // $where = ['admin_id' => $uid, 'status' => $status];
            // }
            $queryList->andWhere(['admin_id' => (int)$uid ]);
            // $query->andWhere(['status' => 3]);
            if(isset($this->_DATA['title']))
            {
                $queryList->andWhere(['or',['like','name',$this->_DATA['title'] ],['like','project',$this->_DATA['title']],['like','district',$this->_DATA['title']],['like','street',$this->_DATA['title']],['like','location',$this->_DATA['title']]]);
                // $queryList->andWhere(["like","name",$this->_DATA['title']]);
            }
            // 属性
            if(isset($this->_DATA['type']))
            {
                $queryList->andWhere(['type' => $this->_DATA['type'] ]);
            }
            // 高
            if(isset($this->_DATA['min_length']))
            {
                $queryList->andWhere(["between","length",$this->_DATA['min_length'],$this->_DATA['max_length']]);
            }
            // 宽
            if(isset($this->_DATA['min_width']))
            {
                $queryList->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
            }
            // 宽
            if(isset($this->_DATA['min_width']))
            {
                $queryList->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
            }
            // 材料 
            if(isset($this->_DATA['material']))
            {
                $queryList->andWhere(["like","material",$this->_DATA['material']]);
            }
            // 工艺
            if(isset($this->_DATA['technology']))
            {
                $queryList->andWhere(["like","technology",$this->_DATA['technology']]);
            }
            // 外观
            if(isset($this->_DATA['outward']))
            {
                $queryList->andWhere(["outward"=> $this->_DATA['outward'] ]);
            }
            // 摆放环境
            if(isset($this->_DATA['put_location']))
            {
                $queryList->andWhere(["put_location"=>$this->_DATA['put_location']]);
            }
                // ->where($where);
            $list = $queryList->offset(($page - 1) * $pageSize)->limit($pageSize)->all();
            
            foreach ($list as $item) {
                $adInfo = $this->normalizeAdInfo($item);
                $data['datalist'][] = $adInfo;
            }
        }
        return $this->responseJson($data, 200, '请求成功');
    }

    /**
     * 数据处理
     * @param $temp
     * @return mixed
     */
    public function normalizeAdInfo($temp)
    {
        $d = DbWork::getRow('deny', '*', ['s_id' => $temp['id']], 'id DESC');
        if ($d) {
            $temp['deny'] = $d['deny'];
        } else {
            $temp['deny'] = '';
        }
        return $temp;
    }

    public function actionAdd()
    {
        $id = !empty($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $name = !empty($this->_DATA['name']) ? $this->_DATA['name'] : '不详';
        $project = !empty($this->_DATA['project']) ? $this->_DATA['project'] : '';
        $project_time = !empty($this->_DATA['project_time']) ? $this->_DATA['project_time'] : '';
        $district = !empty($this->_DATA['district']) ? $this->_DATA['district'] : '';
        $street = !empty($this->_DATA['street']) ? $this->_DATA['street'] : '';
        $location = !empty($this->_DATA['location']) ? $this->_DATA['location'] : '';
        $put_location = !empty($this->_DATA['put_location']) ? $this->_DATA['put_location'] : '';
        $author = !empty($this->_DATA["author"]) ? $this->_DATA["author"] : '';
        $longitude = !empty($this->_DATA['longitude']) ? $this->_DATA['longitude'] : '';
        $latitude = !empty($this->_DATA['latitude']) ? $this->_DATA['latitude'] : '';
        $type = !empty($this->_DATA['type']) ? $this->_DATA['type'] : '';
        $length = !empty($this->_DATA['length']) ? $this->_DATA['length'] : '';
        $width = !empty($this->_DATA['width']) ? $this->_DATA['width'] : '';
        $thick = !empty($this->_DATA['thick']) ? $this->_DATA['thick'] : 0;
        $material = !empty($this->_DATA['material']) ? $this->_DATA['material'] : '';
        $technology = !empty($this->_DATA['technology']) ? $this->_DATA['technology'] : '';
        $outward = !empty($this->_DATA['outward']) ? $this->_DATA['outward'] : '';
        $input_people = !empty($this->_DATA['input_people']) ? $this->_DATA['input_people'] : '';
        $input_unit = !empty($this->_DATA['input_unit']) ? $this->_DATA['input_unit'] : '';
        $mobile = !empty($this->_DATA['mobile']) ? $this->_DATA['mobile'] : '';
        $epigraph = !empty($this->_DATA['epigraph']) ? $this->_DATA['epigraph'] : '';
        $epigraphImg = !empty($this->_DATA['epigraphImg']) ? $this->_DATA['epigraphImg'] : '';
        $remarkImg = !empty($this->_DATA['remarkImg']) ? $this->_DATA['remarkImg'] : '';
        $describeImg = !empty($this->_DATA['describeImg']) ? $this->_DATA['describeImg'] : '';
        $content = !empty($this->_DATA['content']) ? $this->_DATA['content'] : '';
        $weibao_danwei = !empty($this->_DATA['weibao_danwei']) ? $this->_DATA['weibao_danwei'] : '';
        $weibao_name = !empty($this->_DATA['weibao_name']) ? $this->_DATA['weibao_name'] : '';
        $weibao_phone = !empty($this->_DATA['weibao_phone']) ? $this->_DATA['weibao_phone'] : '';
        $images = !empty($this->_DATA['image']) ? $this->_DATA['image'] : '';
        $image = substr($images, 0);
        $img_url = json_encode(explode(',', $image));
        $data = [
            'name' => $name,
            'admin_id' => $this->user['id'],
            'project' => $project,
            'project_time' => $project_time,
            'district' => $district,
            'street' => $street,
            'location' => $location,
            'put_location' => $put_location,
            'author' => $author,
            'longitude' => trim($longitude),
            'latitude' => trim($latitude),
            'type' => $type,
            'length' => $length,
            'width' => $width,
            'thick' => $thick,
            'material' => implode(',', $material),
            'technology' => implode(',', $technology),
            'outward' => implode(',', $outward),
            'epigraph' => $epigraph,
            'epigraphImg' => $epigraphImg,
            'remarkImg' => $remarkImg,
            'describeImg' => $describeImg,
            'content' => $content,
            'img_url' => $img_url,
            'input_people' => $input_people,
            'input_unit' => $input_unit,
            'mobile' => $mobile,
            'create_time' => time()
        ];
        $data2 =[
            'weibao_danwei' => $weibao_danwei,
            'weibao_name' => $weibao_name,
            'weibao_phone' => $weibao_phone,
        ];
        $data['model'] = ScuSize($data['width'],$data['length'],$data['type']);
        if (!empty($id)) {
            unset($data['create_time']);
            // 判断是否可以修改且 有没有权限修改
            $info = DbWork::getRow('sculpture_sub','id,sid,shangbao,status',['sid'=>$id]);
            if($info['shangbao']==1 || $info['status']==1){
                return $this->responseJson([], 400, '艺术品处于未上报或审核未通过，才可以进行修改');
            }
            $infos = DbWork::getRow('sculpture','id,admin_id',['id'=>$id]);
            if($infos['admin_id'] != $this->user['id']){
                return $this->responseJson([], 400, '无法修改他人上报艺术品！');
            }
            // $transaction = Yii::$app->db->beginTransaction();
            $m = new DbWork();
            $res = $m->update('sculpture', $data, ['id' => $id]);
            $res2 = $m->update('sculpture_att', $data2, ['sid' => $id]);
            if($res || $res2){
                return $this->responseJson([], 200, '修改成功');
            }else{
                return $this->responseJson([], 400, '修改失败');
            }    
        } else {
            $query = (new \yii\db\Query())
                    ->select('id')
                    ->from("sculpture");
            $query->andWhere(['district' => $data['district']]);
            $num = $query->count();
            $data['zpbh'] = $num+1;

            // 走事务插入三张表
            // DbWork::save('sculpture', $data);
            $transaction = Yii::$app->db->beginTransaction();
            $m = new DbWork();
            try {
                $res = $m->save('sculpture',$data);
                if(!$res){
                    $transaction->rollBack();
                    return $this->responseJson([], 400, '提交失败');
                }
                $data2['sid'] = $sub['sid'] = $res;
                $res1 = $m->save('sculpture_sub',$sub);
                $res2 = $m->save('sculpture_att',$data2);
                $transaction->commit();
                return $this->responseJson([], 200, '提交成功');
            } catch (\Exception $e) {
                $transaction->rollBack();
                return $this->responseJson([], 400, '提交失败');
            }
        }
        // return $this->responseJson([], 200, '提交成功');
    }
    public function get_real_ip()
    {

        $ip=FALSE;

        //客户端IP 或 NONE 

        if(!empty($_SERVER["HTTP_CLIENT_IP"])){

            $ip = $_SERVER["HTTP_CLIENT_IP"];

        }

        //多重代理服务器下的客户端真实IP地址（可能伪造）,如果没有使用代理，此字段为空

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {

            $ips = explode (", ", $_SERVER['HTTP_X_FORWARDED_FOR']);

            if ($ip) { array_unshift($ips, $ip); $ip = FALSE; }

            for ($i = 0; $i < count($ips); $i++) {

                if (!eregi ("^(10│172.16│192.168).", $ips[$i])) {

                    $ip = $ips[$i];

                    break;

                }

            }

        }

        //客户端IP 或 (最后一个)代理服务器 IP 

        return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);

    }
    // 举报信息 
    public function actionTipoffs()
    {
        $ip = self::get_real_ip();
        $configquery = (new \yii\db\Query())
            ->select('id')
            ->from("tipoffs");
        $configquery->andWhere(['>=', 'addtime', time()-30]);
        $configquery->andWhere(['ip' => $ip]);
        $res = $configquery->one();

        if($res){
            return $this->responseJson([], 400, '您在五分钟只能提交一次，请稍后再提交');
            die;
        }
        $content = !empty($this->_DATA['content']) ? $this->_DATA['content'] : '';
        $type = !empty($this->_DATA['type']) ? $this->_DATA['type'] : 0;
        // $simg = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        $simg = !empty($this->_DATA['simg']) ? implode(';', $this->_DATA['simg']) : '';
        $status = !empty($this->_DATA['status']) ? implode(',', $this->_DATA['status']) : '';
        // $status = !empty($this->_DATA['status']) ? $this->_DATA['status'] : '';
        $lng = !empty($this->_DATA['lng']) ? $this->_DATA['lng'] : '';
        $lat = !empty($this->_DATA['lat']) ? $this->_DATA['lat'] : '';
        $district = !empty($this->_DATA['district']) ? $this->_DATA['district'] : '';
        $street = !empty($this->_DATA['street']) ? $this->_DATA['street'] : '';
        $data = [
            'content' => $content,
            'addtime' => time(),
            'type' => $type,
            'simg' => $simg,
            'status' => $status,
            'lng' => $lng,
            'lat' => $lat,
            'district' => $district,
            'street' => $street,
            'ip' => $ip
        ];
        $res = DbWork::save('tipoffs', $data);
        if($res){
            return $this->responseJson([], 200, '提交成功');
        }else{
            return $this->responseJson([], 400, '提交失败');
        }
        

    }
    // public function getuserinfo($openid)
    // {
    //     // 获取access_token 
    //     $access_token = self::get_access_token();
    //     $url = "https://api.weixin.qq.com/sns/userinfo?access_token={$access_token}&openid={$openid}&lang=zh_CN";
    //     $data = self::Geturl($url);
    //     echo $url;
    //     var_dump($data);
    //     if($data){
    //         if($data['errcode']){
    //             die("获取出错");
    //         }else{
    //             return $data;
    //         }
    //     }else{
    //         die("获取详情出错");
    //     }
    // }
    //  游客添加上报信息  限制是IP  5分钟一次
    public function actionAdds()
    {
        $ip = self::get_real_ip();
        // 查看该IP 近五分钟是否提交过
        // $where['create_time'] = ['>', 'id', 10] " < ".time()-300;
        // $where['ip'] = $ip;
        // $res = DbWork::getRow('sculptures', 'id', $where);

        $configquery = (new \yii\db\Query())
            ->select('id')
            ->from("sculptures");
        $configquery->andWhere(['>=', 'create_time', time()-30]);
        $configquery->andWhere(['ip' => $ip]);

        $res = $configquery->one();

        if($res){
            return $this->responseJson([], 400, '您在五分钟只能以提交，请稍后再提交');
            die;
        }
        $wx_openid = !empty($this->_DATA['openid']) ? $this->_DATA['openid'] : '';
        $wx_headimgurl = !empty($this->_DATA['wx_headimgurl']) ? $this->_DATA['wx_headimgurl'] : '';
        $wx_sex = !empty($this->_DATA['wx_sex']) ? $this->_DATA['wx_sex'] : '';
        $wx_name = !empty($this->_DATA['wx_name']) ? $this->_DATA['wx_name'] : '';
        // if($wx_openid){
        //     // 通过openid  获取获取用户详情
        //     $xrr = self::getuserinfo($wx_openid); 
        //     $wx_name = $xrr['nickname'];
        //     $wx_sex = $xrr['sex'];
        //     $wx_headimgurl = $xrr['headimgurl'];
        // }else{
        //     return $this->responseJson([], 400, '获取用户详情出错');
        //     die;
        // }
        
        $id = !empty($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $name = !empty($this->_DATA['name']) ? $this->_DATA['name'] : '不详';
        $project = !empty($this->_DATA['project']) ? $this->_DATA['project'] : '';
        $project_time = !empty($this->_DATA['project_time']) ? $this->_DATA['project_time'] : '';
        $district = !empty($this->_DATA['district']) ? $this->_DATA['district'] : '';
        $street = !empty($this->_DATA['street']) ? $this->_DATA['street'] : '';
        $location = !empty($this->_DATA['location']) ? $this->_DATA['location'] : '';
        $put_location = !empty($this->_DATA['put_location']) ? $this->_DATA['put_location'] : '';
        $author = !empty($this->_DATA["author"]) ? $this->_DATA["author"] : '';
        $longitude = !empty($this->_DATA['longitude']) ? $this->_DATA['longitude'] : '';
        $latitude = !empty($this->_DATA['latitude']) ? $this->_DATA['latitude'] : '';
        $type = !empty($this->_DATA['type']) ? $this->_DATA['type'] : '';
        $length = !empty($this->_DATA['length']) ? $this->_DATA['length'] : '';
        $width = !empty($this->_DATA['width']) ? $this->_DATA['width'] : '';
        $thick = !empty($this->_DATA['thick']) ? $this->_DATA['thick'] : 1;
        $material = !empty($this->_DATA['material']) ? implode(',', $this->_DATA['material']) : '';
        $technology = !empty($this->_DATA['technology']) ? implode(',', $this->_DATA['technology']) : '';
        $outward = !empty($this->_DATA['outward']) ? implode(',', $this->_DATA['outward']) : '';
        $input_people = !empty($this->_DATA['input_people']) ? $this->_DATA['input_people'] : '';
        $input_unit = !empty($this->_DATA['input_unit']) ? $this->_DATA['input_unit'] : '';
        $mobile = !empty($this->_DATA['mobile']) ? $this->_DATA['mobile'] : '';
        $epigraph = !empty($this->_DATA['epigraph']) ? $this->_DATA['epigraph'] : '';
        $epigraphImg = !empty($this->_DATA['epigraphImg']) ? $this->_DATA['epigraphImg'] : '';
        $remarkImg = !empty($this->_DATA['remarkImg']) ? $this->_DATA['remarkImg'] : '';
        $describeImg = !empty($this->_DATA['remarkImg']) ? $this->_DATA['describeImg'] : '';
        $content = !empty($this->_DATA['content']) ? $this->_DATA['content'] : '';
        $weibao_danwei = !empty($this->_DATA['weibao_danwei']) ? $this->_DATA['weibao_danwei'] : '';
        $weibao_name = !empty($this->_DATA['weibao_name']) ? $this->_DATA['weibao_name'] : '';
        $weibao_phone = !empty($this->_DATA['weibao_phone']) ? $this->_DATA['weibao_phone'] : '';
        $images = !empty($this->_DATA['image']) ? $this->_DATA['image'] : '';
        $wx_openid = !empty($this->_DATA['openid']) ? $this->_DATA['openid'] : '';
        $image = substr($images, 0);
        $img_url = json_encode(explode(',', $image));
        
        $data = [
            'name' => $name,
            'admin_id' => '-1',
            'project' => $project,
            'project_time' => $project_time,
            'district' => $district,
            'street' => $street,
            'location' => $location,
            'put_location' => $put_location,
            'author' => $author,
            'longitude' => trim($longitude),
            'latitude' => trim($latitude),
            'type' => $type,
            'length' => $length,
            'width' => $width,
            'thick' => $thick,
            'material' => $material,
            'technology' => $technology,
            'outward' => $outward,
            'epigraph' => $epigraph,
            'epigraphImg' => $epigraphImg,
            'remarkImg' => $remarkImg,
            'describeImg' => $describeImg,
            'content' => $content,
            'weibao_danwei' => $weibao_danwei,
            'weibao_phone' => $weibao_phone,
            'weibao_name' => $weibao_name,
            'img_url' => $img_url,
            'input_people' => $input_people,
            'input_unit' => $input_unit,
            'mobile' => $mobile,
            'status' => 1,
            'wx_openid' => $wx_openid,
            'wx_name' => $wx_name,
            'wx_sex' => $wx_sex,
            'wx_headimgurl' => $wx_headimgurl,
            'create_time' => time()
        ];
        // var_dump($data);
        // die;
        if (!empty($id)) {
            DbWork::update('sculptures', $data, ['id' => $id]);
        } else {
            DbWork::save('sculptures', $data);
        }

        return $this->responseJson([], 200, '提交成功');
    }

    // 游客查看所有的审核通过的信息
    public function actionLists()
    {
        $page = isset($this->_DATA['page']) ? $this->_DATA['page'] : 1;
        $pageSize = isset($this->_DATA['pagesize']) ? $this->_DATA['pagesize'] : 10;
        $latitude = isset($this->_DATA['latitude']) ? $this->_DATA['latitude'] : '';
        $longitude = isset($this->_DATA['longitude']) ? $this->_DATA['longitude'] : '';
        $page = max(1, $page);

        $data = array('total' => 0, 'total_page' => 0, 'cur_page' => 0, 'datalist' => array());

        // $connection = Yii::$app->db;


        if($latitude && $longitude){
            $query = (new \yii\db\Query())
            ->select(["id,name,district,street,location,type,img_url,create_time,longitude,latitude","(round(6367000 * 2 * asin(sqrt(pow(sin(((latitude * pi()) / 180 - ({$latitude} * pi()) / 180) / 2), 2) + cos(({$latitude} * pi()) / 180) * cos((latitude * pi()) / 180) * pow(sin(((longitude * pi()) / 180 - ({$longitude} * pi()) / 180) / 2), 2))))) AS kil"])
            ->from("sculpture");
        }else{
            $query = (new \yii\db\Query())
            ->select("*")
            ->from("sculpture");
        }
        $query->andWhere(['is_show' => 1]);
        $query->andWhere(['del' => 0]);
        // 区域
        if(isset($this->_DATA['district']))
        {
            // $query->andWhere(["like","district",$this->_DATA['district']]);
            $query->andWhere(['district' => $this->_DATA['district'] ]);
        }
        if(isset($this->_DATA['title']))
        {
            $query->andWhere(["like","name",$this->_DATA['title']]);
        }
        // 属性
        if(isset($this->_DATA['type']))
        {
            $query->andWhere(['type' => $this->_DATA['type'] ]);
        }
        // 高
        if(isset($this->_DATA['min_length']))
        {
            $query->andWhere(["between","length",$this->_DATA['min_length'],$this->_DATA['max_length']]);
        }
        // 宽
        if(isset($this->_DATA['min_width']))
        {
            $query->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
        }
        // 宽
        if(isset($this->_DATA['min_width']))
        {
            $query->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
        }
        // 材料 
        if(isset($this->_DATA['material']))
        {
            $query->andWhere(["like","material",$this->_DATA['material']]);
        }
        // 工艺
        if(isset($this->_DATA['technology']))
        {
            $query->andWhere(["like","technology",$this->_DATA['technology']]);
        }
        // 外观
        if(isset($this->_DATA['outward']))
        {
            $query->andWhere(["outward"=> $this->_DATA['outward'] ]);
        }
        // 摆放环境
        if(isset($this->_DATA['put_location']))
        {
            $query->andWhere(["put_location"=>$this->_DATA['put_location']]);
        }
        $data['total'] = $query->count();
        // echo $query->createCommand()->getRawSql();
        // var_dump($data);
        // die;
        if ($data['total'] > 0) {
            $data['total_page'] = ceil($data['total'] / $pageSize);
            $data['cur_page'] = max(1, intval($page));
            if($latitude && $longitude){
                $queryList = (new \yii\db\Query())
                ->select(["id","name","create_time","img_url","district","street","location","type","length","material","(round(6367000 * 2 * asin(sqrt(pow(sin(((latitude * pi()) / 180 - ({$latitude} * pi()) / 180) / 2), 2) + cos(({$latitude} * pi()) / 180) * cos((latitude * pi()) / 180) * pow(sin(((longitude * pi()) / 180 - ({$longitude} * pi()) / 180) / 2), 2))))) AS kil"])
                ->from("sculpture");
            }else{
                $queryList = (new \yii\db\Query())
                ->select(["id","name","create_time","img_url","district","street","location","type","length","material"])
                ->from("sculpture");
            }
            // $queryList = (new \yii\db\Query())
            //     ->select("id,name,create_time,img_url,district,street,location,type,length,material,(round(6367000 * 2 * asin(sqrt(pow(sin(((latitude * pi()) / 180 - (39.9052500000 * pi()) / 180) / 2), 2) + cos((39.9052500000 * pi()) / 180) * cos((latitude * pi()) / 180) * pow(sin(((longitude * pi()) / 180 - (116.7200100000 * pi()) / 180) / 2), 2))))) AS kil")
            //     ->from("sculpture");

            $queryList->andWhere(['is_show' => 1]);
            $queryList->andWhere(['del' => 0]);
            // 标题 
            if(isset($this->_DATA['district']))
            {
                // $query->andWhere(["like","district",$this->_DATA['district']]);
                $queryList->andWhere(['district' => $this->_DATA['district']]);
            }
            if(isset($this->_DATA['title']))
            {
                $queryList->andWhere(["like","name",$this->_DATA['title']]);
            }
            // 属性
            if(isset($this->_DATA['type']))
            {
                $queryList->andWhere(['type' => $this->_DATA['type'] ]);
            }
            // 高
            if(isset($this->_DATA['min_length']))
            {
                $queryList->andWhere(["between","length",$this->_DATA['min_length'],$this->_DATA['max_length']]);
            }
            // 宽
            if(isset($this->_DATA['min_width']))
            {
                $queryList->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
            }
            // 宽
            if(isset($this->_DATA['min_width']))
            {
                $queryList->andWhere(["between","width",$this->_DATA['min_width'],$this->_DATA['max_width']]);
            }
            // 材料 
            if(isset($this->_DATA['material']))
            {
                $queryList->andWhere(["like","material",$this->_DATA['material']]);
            }
            // 工艺
            if(isset($this->_DATA['technology']))
            {
                $queryList->andWhere(["like","technology",$this->_DATA['technology']]);
            }
            // 外观
            if(isset($this->_DATA['outward']))
            {
                $queryList->andWhere(["outward"=> $this->_DATA['outward'] ]);
            }
            // 摆放环境
            if(isset($this->_DATA['put_location']))
            {
                $queryList->andWhere(["put_location"=>$this->_DATA['put_location']]);
            }
                // ->where($where);
            if($latitude && $longitude){
                $list = $queryList->offset(($page - 1) * $pageSize)->limit($pageSize)->orderBy(["kil"=>"ASC"])->all();
            }else{
                $list = $queryList->offset(($page - 1) * $pageSize)->limit($pageSize)->all();
            }
            
            // 图片替换
            foreach ($list as $key => $value) {
                $value['img_url'] = str_replace('.jpeg','_400_400.jpeg',$value['img_url']);
                $value['img_url'] = str_replace('.JPEG','_400_400.JPEG',$value['img_url']);
                $value['img_url'] = str_replace('.PNG','_400_400.PNG',$value['img_url']);
                $value['img_url'] = str_replace('.png','_400_400.png',$value['img_url']);
                $value['img_url'] = str_replace('.JPG','_400_400.JPG',$value['img_url']);
                $value['img_url'] = str_replace('.jpg','_400_400.jpg',$value['img_url']); 
				//$simg = json_decode($value['img_url']);
                // $simg = explode(';',$value['img_url']);
                //$simgs[] = $simg[0];
                //$simgs[] = $simg[1];
                //$list[$key]['img_url'] = json_encode($simgs); 
                $list[$key]['img_url'] = $value['img_url']; 
				$list[$key]['street'] = '';
            }
            // echo $queryList->createCommand()->getRawSql();
            // die("1112");
            if($latitude && $longitude){
                foreach ($list as $item) {
                    // $adInfo = $this->normalizeAdInfo($item);
                    if($item['kil'] < 1000){
                        if($item['kil'] > 1){
                            $item['kil'] = $item['kil']."m";
                        }else{
                            $item['kil'] = "0m";
                        }
                        
                    }
                    if($item['kil'] > 5000){
                        $item['kil'] = '5km+';
                    }
                    if($item['kil']>=1000 && $item['kil']<=5000){
                        $item['kil'] = number_format(($item['kil']/1000),2)."km";
                    }
                    
                    $data['datalist'][] = $item;
                }
            }else{
                foreach ($list as $item) {
                    $item['kil'] = '--km';
                    $data['datalist'][] = $item;
                }
            }
        }
        
        return $this->responseJson($data, 200, '请求成功');
    }

    // 游客查看详情
    public function actionDetails()
    {
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';

        $query = (new \yii\db\Query())
            // ->select('sculpture.name,sculpture.project,sculpture.project_time,sculpture.district,sculpture.street,sculpture.location,sculpture.put_location,sculpture.author,sculpture.type,length,sculpture.width,sculpture.thick,sculpture.longitude,sculpture.latitude,sculpture.material,sculpture.technology,sculpture.outward,sculpture.epigraph,sculpture.content,sculpture.input_people,sculpture.input_unit,sculpture.mobile,sculpture.img_url,sculpture.epigraphImg,sculpture.remarkImg,sculpture.describeImg,sculpture.create_time,sculpture_att.weibao_danwei,sculpture_att.weibao_name,sculpture_att.weibao_phone,sculpture.id,sculpture_att.decipher,sculpture.project_time')
            ->select('sculpture.name,sculpture.project_time,sculpture.district,sculpture.street,sculpture.location,sculpture.author,sculpture.longitude,sculpture.latitude,sculpture.material,sculpture.img_url,sculpture.create_time,sculpture.id,sculpture_att.decipher')
			->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->from("sculpture");
        $query->andWhere(['sculpture.del'=>0]);
        $query->andWhere(['sculpture.id'=>$id]);
        $sculpture = $query->one();
        // if ($sculpture['type'] != 1) {
        //     $sculpture['thick'] = '';
        // }
        if($sculpture['id'] =='186'){ 
            $sculpture['material'] = '不锈钢，铝合金'; 
        }
        if($sculpture['id'] =='467'){ 
            $sculpture['material'] = '铝合金'; 
        }
        $simg = json_decode($sculpture['img_url']);
        // $simg = explode(';',$value['img_url']);
        $simgs[] = $simg[0];
        $simgs[] = $simg[1];
        $sculpture['img_url'] = json_encode($simgs); 
		$sculpture['street'] = '';
        // $sculpture = DbWork::getRow('sculpture', '*', ['id' => $id]);
        // if ($sculpture['type'] != 1) {
        //     $sculpture['thick'] = '';
        // }
        return $this->responseJson($sculpture, 200, '请求成功');
    }


    public function actionDetail()
    {
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $query = (new \yii\db\Query())
            ->select('sculpture.*,sculpture_att.weibao_danwei,sculpture_att.weibao_name,sculpture_att.weibao_phone')
            ->leftJoin('sculpture_att', 'sculpture.id  = sculpture_att.sid')
            ->from("sculpture");
        $query->andWhere(['sculpture.del'=>0]);
        $query->andWhere(['sculpture.id'=>$id]);
        $sculpture = $query->one();
        if ($sculpture['type'] != 1) {
            $sculpture['thick'] = '';
        }
        if(!empty($sculpture)){
            $sculpture['qu_status'] = 1;
            $sculpture['status'] = 1;
        }
        return $this->responseJson($sculpture, 200, '请求成功');
    }

    public function actionGetDistrict()
    {
        $district = DbWork::queryAll("select distinct(district) from location where status=1");
        return $this->responseJson($district, 200, '请求成功');
    }

    public function actionGetStreet()
    {
        $district = $this->_DATA['district'];
        $street = DbWork::queryAll("select street from location where district='{$district}' and  status=1");
        return $this->responseJson($street, 200, '请求成功');
    }

    public function actionUpload()
    {
        $path = \Yii::$app->basePath . '/web';
        $exif = exif_imagetype($_FILES['file']['tmp_name']);
        $ext = [
            1 => '.gif',
            2 => '.jpeg',
            3 => '.png',
            6 => '.bmp',
            7 => '.jpg',
        ];
        if (!in_array($exif, [1, 2, 3, 6,7])) {
            return $this->responseJson([], 400, '只能上传图片');
        } 

        $type = file_format($_FILES['file']['name']);
        if($type !=3){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $d111cn = explode('.',$_FILES['file']['name']);
        $exif_name = md5($_FILES['file']['name'] . mt_rand(1, 9999999)) .'.'. strtolower(array_pop($d111cn));
        $file_r_path = '/upload/img/' . date('Y-m-d') . '/';
        $des = $path . $file_r_path . $exif_name;

        if (!is_dir($path . $file_r_path)) {
            @mkdir($des, 0777, true);
        }
        $id = @move_uploaded_file($_FILES['file']['tmp_name'], $des);
        if (!$id) {
            return $this->responseJson([], 400, '上传失败');
        }

        self::getThumb('.'.$file_r_path . $exif_name,400,400);
        return $this->responseJson(['url' => $file_r_path . $exif_name], 200, '请求成功');
        
    }
   /**
     * 图片压缩处理
     * @param string $sFile 源图片路径
     * @param int $iWidth 自定义图片宽度
     * @param int $iHeight 自定义图片高度
     * @return string 压缩后的图片路径
     */
    function getThumb($sFile,$iWidth,$iHeight){
        
        //图片公共路径
        $public_path = '';
        //判断该图片是否存在
        if(!file_exists($public_path.$sFile)) return $sFile;
        //判断图片格式(图片文件后缀)
        $extend = explode("." , $sFile);
        $attach_fileext = $extend[2];
        if (!in_array($attach_fileext, array('jpg','png','jpeg','JPG','PNG','JPEG'))){
            return '';
        }
        //压缩图片文件名称
        $sFileNameS = str_replace(".".$attach_fileext, "_".$iWidth.'_'.$iHeight.'.'.$attach_fileext, $sFile);
        //判断是否已压缩图片，若是则返回压缩图片路径
        if(file_exists($public_path.$sFileNameS)){
            return $sFileNameS;
        }
            
        //生成压缩图片，并存储到原图同路径下
        self::resizeImage($public_path.$sFile, $public_path.$sFileNameS, $iWidth, $iHeight);
        if(!file_exists($public_path.$sFileNameS)){
            return $sFile;
        }
        return $sFileNameS;
    }
    /**
     * 生成图片
     * @param string $im 源图片路径
     * @param string $dest 目标图片路径
     * @param int $maxwidth 生成图片宽
     * @param int $maxheight 生成图片高
     */
    function resizeImage($im, $dest, $maxwidth, $maxheight) {
        $img = getimagesize($im);
        switch ($img[2]) {
        case 1:
        $im = @imagecreatefromgif($im);
        break;
        case 2:
        $im = @imagecreatefromjpeg($im);
        break;
        case 3:
        $im = @imagecreatefrompng($im);
        break;
        }
        
        $pic_width = imagesx($im);
        $pic_height = imagesy($im);
        $resizewidth_tag = false;
        $resizeheight_tag = false;
        if (($maxwidth && $pic_width > $maxwidth) || ($maxheight && $pic_height > $maxheight)) {
        if ($maxwidth && $pic_width > $maxwidth) {
        $widthratio = $maxwidth / $pic_width;
        $resizewidth_tag = true;
        }
        
        if ($maxheight && $pic_height > $maxheight) {
        $heightratio = $maxheight / $pic_height;
        $resizeheight_tag = true;
        }
        
        if ($resizewidth_tag && $resizeheight_tag) {
        if ($widthratio < $heightratio)
        $ratio = $widthratio;
        else
        $ratio = $heightratio;
        }
        
        
        if ($resizewidth_tag && !$resizeheight_tag)
        $ratio = $widthratio;
        if ($resizeheight_tag && !$resizewidth_tag)
        $ratio = $heightratio;
        $newwidth = $pic_width * $ratio;
        $newheight = $pic_height * $ratio;
        
        if (function_exists("imagecopyresampled")) {
        $newim = imagecreatetruecolor($newwidth, $newheight);
        imagecopyresampled($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $pic_width, $pic_height);
        } else {
        $newim = imagecreate($newwidth, $newheight);
        imagecopyresized($newim, $im, 0, 0, 0, 0, $newwidth, $newheight, $pic_width, $pic_height);
        }
        
        imagejpeg($newim, $dest);
        imagedestroy($newim);
        } else {
        imagejpeg($im, $dest);
        }
    }
    /**
     * 获取任务列表
     */
    public function actionGet_task_list()
    {
        $uid = $this->user['id'];

        $list = DbWork::getAll('task_list', 'ob_id,sculpture_name,describe,start_time,expect_end_time,status', ['admin_id' => $uid]);
        return $this->responseJson($list, 200, '请求成功');
    }

    /**
     * 获取任务详情
     */
    public function actionGet_task_detail()
    {
        $sid = !empty($this->_DATA['ob_id']) ? $this->_DATA['ob_id'] : '';

        $detail = DbWork::getRow('task_list', 'ob_id,sculpture_name,describe,start_time,expect_end_time,unit_name,status,remark,remark_img', ['ob_id' => $sid]);
        if (empty($detail)) {
            return $this->responseJson([], 400, '任务不存在');
        }

        return $this->responseJson($detail, 200, '请求成功');
    }

    /**
     * 提交任务
     */
    public function actionPerform_task()
    {
        $sid = !empty($this->_DATA['ob_id']) ? $this->_DATA['ob_id'] : '';
        $remark = !empty($this->_DATA['remark']) ? $this->_DATA['remark'] : '';
        $img = !empty($this->_DATA['remark_img']) ? $this->_DATA['remark_img'] : '';

        if (empty($remark) || empty($img) || empty($sid)) {
            return $this->responseJson([], 400, '参数为空');
        }

        $sculpture = DbWork::getRow('task_list', '*', ['ob_id' => $sid]);
        if (empty($sculpture) || $sculpture['status'] != 0) {
            return $this->responseJson([], 400, '任务不存在或已完成');
        }

        $data = array(
            'remark' => $remark,
            'remark_img' => $img,
            'status' => 1,
            'end_time' => date('Y-m-d 00:00:00'),
        );
        $result = DbWork::update('task_list', $data, array('ob_id' => $sid));
        if (!$result) {
            return $this->responseJson([], 400, '任务失败');
        }

        return $this->responseJson([], 200, '任务成功');
    }
    /*
    新打卡列表
     */
    public function actionSculpture_list()
    {
        $uid = $this->user['id'];
        $street = DbWork::getRow('adminrole', '*', ['admin_id' => $uid]);
        $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $street['parent']]);
        $location_district = $street['jurisdiction'];
        $query = (new \yii\db\Query())
            ->select('sculpture.id,sculpture.name,sculpture.longitude,sculpture.latitude,sculpture.mobile,sculpture.img_url,sculpture.content,sculpture_sub.status')
            ->leftJoin('sculpture_sub', 'sculpture.id  = sculpture_sub.sid')
            ->from("sculpture");
		if($street['level'] == 3){
            $query->andWhere(['sculpture.district' => $jurisdiction['jurisdiction']]);
        }
        if($street['level'] == 4){
            $jurisdiction = DbWork::getRow('adminrole', 'jurisdiction,parent', ['admin_id' => $street['parent']]);
            $jurisdictions = DbWork::getRow('adminrole', 'jurisdiction', ['admin_id' => $jurisdiction['parent']]);
            $query->andWhere(['sculpture.district' => $jurisdictions['jurisdiction']]);
        }
        $query->andWhere(['sculpture.street' => $location_district]);
        $query->andWhere(['sculpture.del' => 0]);
        // $query->andWhere(['sculpture.qu_status'=>1]);
        $query->andWhere(['sculpture_sub.status'=>1]);

        $query->orderBy('sculpture.id DESC');
        $list = $query->all();
		$lists = array();
        if($list){
            $DateY = (string)date("Y");
            $DateM = (string)date("m");
            $spring = array('01','02','03');
            $summer = array('04','05','06');
			$autumn = array('07','08','09');
            $winter = array('10','11','12');
            if(in_array($DateM,$spring)){ $BeginDate = $DateY.'03'; }
            if(in_array($DateM,$summer)){ $BeginDate = $DateY.'06'; }
            if(in_array($DateM,$autumn)){ $BeginDate = $DateY.'09'; }
            if(in_array($DateM,$winter)){ $BeginDate = $DateY.'12'; }
            foreach ($list as $key => $value) {
                $ss = (new \yii\db\Query())
                    ->select('id')
                    ->from("punch_list");
                $ss->andWhere(['sculpture_id'=>$value['id']]);
                $ss->andWhere(['day'=>$BeginDate]);
                $jurisdiction = $ss->all(); 
                if($jurisdiction){
                    $list[$key]['status'] = 1;
                    unset($list[$key]);
                }else{
                    $list[$key]['status'] = 0;
                }
            }
            foreach ($list as $k => $v) {
               $lists[] = $v;
            }
            return $this->responseJson($lists, 200, '请求成功');
        }
        return $this->responseJson($list, 200, '请求成功');
    }
    /**
     * 用户打卡
     */
    public function actionUser_sign()
    {
        $uid = $this->user['id'];
        $username = $this->user['username'];
        $sid = !empty($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $img = !empty($this->_DATA['img']) ? $this->_DATA['img'] : '';
        $content = !empty($this->_DATA['content']) ? $this->_DATA['content'] : '';
        $name = !empty($this->_DATA['name']) ? $this->_DATA['name'] : '';
        $phone = !empty($this->_DATA['phone']) ? $this->_DATA['phone'] : '';

        if (empty($sid) || empty($img)) {
            return $this->responseJson([], 400, '参数为空');
        }
        $sculpture = DbWork::getRow('sculpture', '*', ['id' => $sid]);
        if (empty($sculpture)) {
            return $this->responseJson([], 400, '公共艺术品不存在');
        }

        $sculpture = DbWork::getRow('sculpture', '*', ['id' => $sid]);

        $DateY = (string)date("Y");
        $DateM = (string)date("m");
        $spring = array('01','02','03');
        $summer = array('04','05','06');
		$autumn = array('07','08','09');
        $winter = array('10','11','12');
        if(in_array($DateM,$spring)){ $BeginDate = $DateY.'03'; }
        if(in_array($DateM,$summer)){ $BeginDate = $DateY.'06'; }
        if(in_array($DateM,$autumn)){ $BeginDate = $DateY.'09'; }
        if(in_array($DateM,$winter)){ $BeginDate = $DateY.'12'; }
        $data = array(
            'username' => $username,
            'uid' => $uid,
            'sculpture_id' => $sid,
            'sculpture_name' => $sculpture['name'],
            'image' => $img,
            'day' => $BeginDate,
            'content' => $content,
            'name' => $name,
            'phone' => $phone,
            'create_time' => date('Y-m-d H:i:s')
        );
        // 判断是否已经打卡了
        $is_null = DbWork::getRow('punch_list', '*', ['sculpture_id' => $sid,'day'=>$BeginDate]);
        if($is_null){
            return $this->responseJson([], 400, '该艺术品已经巡查，无需重复巡查！');
        }else{
            $result = DbWork::save('punch_list', $data);
            if (!$result) {
                return $this->responseJson([], 400, '巡查失败');
            }
            return $this->responseJson([], 200, '巡查成功');
        }
        
    }
    //  原来的
    public function actionIdentifyss()
    {

        $img = !empty($this->_DATA['img']) ? $this->_DATA['img'] : '';

        if (empty($img)) {
            return $this->responseJson([], 400, '参数为空');
        }
        $img = "https://sculpture.bceit.com" . $img;
        $ocr = new AipOcr('17087990', 'Zmrr4Bw93KPPPVA3z240HGHH', 'R01OdzfyTrpSvAGsWsueY4RHZUkNOva7');
        $result = $ocr->basicGeneralUrl($img);
        if (empty($result['words_result'])) {
            return $this->responseJson([], 400, '识别失败');
        }
        $str = '';
        foreach ($result['words_result'] as $value) {
            $str .= $value['words'];
        }
        return $this->responseJson($str, 200, '识别成功');
    }
    //  原来的
    public function actionIdentify()
    {

        $img = !empty($this->_DATA['img']) ? $this->_DATA['img'] : '';

        if (empty($img)) {
            return $this->responseJson([], 400, '参数为空');
        }
        $img = "https://www.diaosubeijing.cn/".$img;
        // $img = "https://sculpture.bceit.com" . $img;
        $ocr = new AipOcr('19905913', 'UFWqcq1N9r5AUx2imTtwCLyn', 'XZklY9pYnV9vNDwTd0dt6l5EIlZGH5SX');
        $result = $ocr->basicGeneralUrl($img);
        if (empty($result['words_result'])) {
            return $this->responseJson([], 400, '识别失败');
        }
        $str = '';
        foreach ($result['words_result'] as $value) {
            $str .= $value['words'];
        }
        return $this->responseJson($str, 200, '识别成功');
    }

        // 查看附近是否有数据
    public function actionGetnearby()
    {
        $longitude = !empty($this->_DATA['longitude']) ? $this->_DATA['longitude'] : ''; //经度
        $latitude = !empty($this->_DATA['latitude']) ? $this->_DATA['latitude'] : ''; //纬度
        $point = self::returnSquarePoint($longitude,$latitude,1);  
        $right_bottom_lat = $point['right_bottom']['lat']; //右下纬度    
        $left_top_lat = $point['left_top']['lat']; //右上纬度    
        $left_top_lng = $point['left_top']['lng']; //左上纬度    
        $right_bottom_lng = $point['right_bottom']['lng']; //右下纬度   

        $query = (new \yii\db\Query())
            ->select('id,img_url,create_time,district,street,location,longitude,latitude,name')
            ->from("sculpture");
        $query->andWhere(["between","latitude",$right_bottom_lat,$left_top_lat]);
        $query->andWhere(["between","longitude",$left_top_lng,$right_bottom_lng]);
        $query->andWhere(["del"=>"0"]);
        // $query->andWhere(["status"=>"1"]);
        $res = $query->all();
        // echo $query->createCommand()->getRawSql();
        if (empty($res)) {
            return $this->responseJson([], 400, '周围不存在');
        }
        return $this->responseJson($res, 200, '周围存在');

    }
    private function returnSquarePoint($lng, $lat,$distance)
    {
        $earthdata = 6371;
        $a = sin($distance / (2 * $earthdata));
        $b = cos(deg2rad($lat));
        $dlng = 2*($a/$b);
        $dlng = rad2deg($dlng);
        $dlat = $distance/$earthdata;
        $dlat = rad2deg($dlat);
        $arr = array(
            'left_top'=>array('lat'=>$lat+$dlat,'lng'=>$lng-$dlng),
            'right_top'=>array('lat'=>$lat+$dlat,'lng'=>$lng+$dlng),
            'left_bottom'=>array('lat'=>$lat-$dlat,'lng'=>$lng-$dlng),
            'right_bottom'=>array('lat'=>$lat-$dlat,'lng'=>$lng+$dlng),
        );
        return $arr;
//         $dlat = $distance/$earthdata;
//         $dlat = rad2deg($dlat);
        // $dlng =  2 * asin(sin($distance / (2 * $earthdata)) / cos(deg2rad($lat)));
    }
    public function Geturl($url){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $output = curl_exec($ch);
        curl_close($ch);
        return json_decode($output,true);
    } 
    // 通过code  获取openid

    public function actionWxinfo()
    {
        $code = !empty($this->_DATA['code']) ? $this->_DATA['code'] : '';
        if (empty($code)) {
            return $this->responseJson([], 400, '参数为空');
        }
        //$appid = 'wxd4f2106846f1f913';
        //$secret = 'b34a2d41611bf0941317e54409593302';
		$appid = 'wxfd269e62e2695cd4';
		$secret = '30a23ad65e7495d348230ef8f940a279';
        $url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid={$appid}&secret={$secret}&code={$code}&grant_type=authorization_code";
        $res = self::Geturl($url);
        if($res){
            if($res['errcode'] == 40163){
                $arr = array();
                return $this->responseJson($arr, 400, '获取openid 出错');
            }else{
                $userinfo = self::get_access_token($res['access_token']);
                if($userinfo){
                    $arr['wx_openid'] = $userinfo['openid'];
                    $arr['wx_name'] = $userinfo['nickname'];
                    $arr['wx_sex'] = $userinfo['sex'];
                    $arr['wx_headimgurl'] = $userinfo['headimgurl'];
                    return $this->responseJson($arr, 200, '周围存在');
                }
            }
        }else{
            $arr = array();
            return $this->responseJson($arr, 400, '获取openid 出错'); 
        }
        
    }
    // 获取 access_token
    public function get_access_token($access)
    {
        //$appid = 'wxd4f2106846f1f913';
		$appid = 'wxfd269e62e2695cd4';
		//$secret = '6b0830cf7c3cd119f6b73b63562f7e8d';
        $url = "https://api.weixin.qq.com/sns/userinfo?access_token={$access}&openid={$appid}&lang=zh_CN";
        $data = self::Geturl($url);
        if($data){
            return $data;
        }else{
            die("获取access_token 出错");
        }
    }
    // 接口转发
    public function actionZhuanfa()
    {
        $jingdu = !empty($this->_DATA['jingdu']) ? $this->_DATA['jingdu'] : die(json_encode(array('code'=>404,'msg'=>"经度不能为空")));
        $weidu = !empty($this->_DATA['weidu']) ? $this->_DATA['weidu'] : die(json_encode(array('code'=>404,'msg'=>"纬度不能为空")));
        //$url = 'http://103.83.47.182:8080/api/values/get?MethodName=Query_XZQHByPOINT&Parameter={"points":"'.$jingdu.','.$weidu.'"}';
 	$url = 'http://192.162.6.6:8080/api/values/get?MethodName=Query_XZQHByPOINT&Parameter={"points":"'.$jingdu.','.$weidu.'"}';
        $data = self::Geturl($url);
        die(json_encode($data));
        // var_dump($data);
        // die($data);
        // die($data);

    }
    // 疫情防控接口
    public function actionMeetingform()
    {

        $arr['name'] = !empty($this->_DATA['name']) ? $this->_DATA['name'] : die(json_encode(array('code'=>404,'msg'=>"姓名不能为空")));
        $arr['phone'] = !empty($this->_DATA['phone']) ? $this->_DATA['phone'] : die(json_encode(array('code'=>404,'msg'=>"手机号码不能为空")));
        $arr['suspected'] = !empty($this->_DATA['suspected']) ? $this->_DATA['suspected'] : die(json_encode(array('code'=>404,'msg'=>"是否有疑似症状不能为空！")));
        $arr['isGoRiskAreas'] = !empty($this->_DATA['isGoRiskAreas']) ? $this->_DATA['isGoRiskAreas'] : die(json_encode(array('code'=>404,'msg'=>"是否去过高风险地区不能为空！")));
        $arr['beenAbroad'] = !empty($this->_DATA['beenAbroad']) ? $this->_DATA['beenAbroad'] : die(json_encode(array('code'=>404,'msg'=>"近14天个人或家属是否出国出境不能为空！")));

        // 二次判断
        if($arr['suspected'] !='false' || $arr['suspected']!='ture'){
            die(json_encode(array('code'=>404,'msg'=>"是否有疑似症状请选择是或否！")));
        }
        if($arr['isGoRiskAreas'] !='false' || $arr['suspected']!='ture'){
            die(json_encode(array('code'=>404,'msg'=>"是否去过高风险地区请选择是或否！")));
        }
        if($arr['beenAbroad'] !='false' || $arr['suspected']!='ture'){
            die(json_encode(array('code'=>404,'msg'=>"近14天个人或家属是否出国出境请选择是或否！")));
        }
        $res = DbWork::getRow('meetingform', 'phone,addtime', ['phone' => $arr['phone']]); 
        if($res){
            die(json_encode(array('code'=>400,'msg'=>"该用户已在".date('Y-m-d H:i')."时许进行填写，无需再次填写")));
        }else{
            $arr['addtime'] = time();
            $ress = DbWork::save('meetingform', $arr);
            if($ress){
                die(json_encode(array('code'=>200,'msg'=>"提交成功！")));
            }else{
                die(json_encode(array('code'=>400,'msg'=>"录入失败！")));
            }
        }

    }
}
