<?php
/**
 * Created by PhpStorm.
 * User: shangpeng
 * Date: 2019-04-20
 * Time: 18:18
 */

namespace app\controllers;
use app\common\ApiController;
use Yii;
use yii\helpers\Url;


class LogController extends ApiController
{
    public function init()
    {
        $key = Yii::$app->request->get('key');

        if($key !='q3j4rklajfklajlf'){
            die;
        }

    }

    private function isInPath()
    {
        $path = Yii::$app->request->get('path');
        $path_list = ['api','cron','curl_http_request',
            'log_msg','web','api_reg_user',
            'cmd','curl_http_request_web',
            'app_api_log','web_log_msg','cron_run'];

        if(!in_array($path,$path_list)){
            exit('path error');
        }
    }

    public function actionList()
    {
        $key = Yii::$app->request->get('key');
        $path = Yii::$app->request->get('path');

        $this->isInPath();

        $dir = scandir(Yii::$app->basePath . "/runtime/logs/{$path}");

        $str = '';


        $dir = array_slice($dir,-10);

        foreach ($dir as $v){
            if($v== '.' || $v == '..'){
                continue;
            }
            $url = Url::to(['/log/dl','key'=>$key,'f'=>$v,'path'=>$path]);
            $str .="<a href='$url'>{$v}</a><br/>";
        }

        return $str;

    }

    public function actionDl()
    {
        $f = Yii::$app->request->get('f');

        if(!preg_match('/^[0-9]{4}-[0-9]{2}-[0-9]{2}\.log(\.{1}[0-9]{1,})?$/',$f)){
            exit('file error');
        }

        $this->isInPath();

        $path = Yii::$app->request->get('path');
        $path = Yii::$app->basePath . "/runtime/logs/{$path}/" . $f;
        if(!file_exists($path)){
            exit('not found');
        }
        return \Yii::$app->response->sendFile($path);
    }

    /**
     * @return string
     *
     */
    public function actionRunCmd()
    {
        return $this->renderPartial('/log/cmd');

    }


    public function actionCreateCmd()
    {
        $job_name = Yii::$app->request->post('job_name');




    }
}