<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/13
 * Time: 9:04 PM
 */

namespace app\controllers;


use app\common\ApiController;
use app\models\DbWork;

class IndexController extends ApiController
{
    public $enableCsrfValidation = false;

    public function actionLogin()
    {
        return $this->renderPartial('login');
    }

    public function actionCheckLogin()
    {
        $request = \Yii::$app->request;
        $username = $request->post('username');
        $password = $request->post('password');
        if ($username == '雕塑北京' && $password == '20192019') {
            $session = \Yii::$app->session;
            $session['is_login'] = 1;
            return $this->redirect('/index/index');
        } else {
            return $this->redirect('/index/login');
        }
    }

    public function actionIndex()
    {
        $session = \Yii::$app->session;
        if (!isset($session['is_login']) && $session['is_login'] != 1) {
            return $this->redirect('/index/login');
        }
        $district = DbWork::queryAll("select distinct(district) from location");
        $street = DbWork::getAll('location', '*', ['district' => '东城区']);
        return $this->renderPartial('question.php', ['district' => $district, 'street' => $street]);
    }

    public function actionGetStreet()
    {
        $district = \Yii::$app->request->post('district');
        $street = DbWork::getAll('location', '*', ['district' => $district]);
        return json_encode($street);
    }

    public function actionAdd()
    {
        $request = \Yii::$app->request;
        $name = $request->post('name');
        $project = $request->post('project');
        $project_time = $request->post('project_time');
        $district = $request->post('district');
        $street = $request->post('street');
        $location = $request->post('location');
        $put_location = $request->post('put_location');
        $author = $request->post("author");
        $longitude = $request->post('longitude_1') . '°' . $request->post('longitude_2') . '’' . $request->post('longitude_3') . '’’';
        $latitude = $request->post('latitude_1') . '°' . $request->post('latitude_2') . '’' . $request->post('latitude_3') . '’’';
        $type = $request->post('thick');
        $length = $request->post('length');
        $width = $request->post('width');
        $thick = $request->post('thick');
        $material = $request->post('material');
        $technology = $request->post('technology');
        $outward = $request->post('outward');
        $input_people = $request->post('input_people');
        $input_unit = $request->post('input_unit');
        $mobile = $request->post('mobile');
        $epigraph = $request->post('epigraph');
        $content = $request->post('content');
        $images = $request->post('image');
        $image = substr($images, 0);
        $img_url = json_encode(explode(',', $image));
        $data = [
            'name' => empty($name) ? '无名称' : $name,
            'project' => empty($project) ? 0 : $project,
            'project_time' => empty($project_time) ? 0 : $project_time,
            'district' => empty($district) ? 0 : $district,
            'street' => empty($street) ? 0 : $street,
            'location' => empty($location) ? 0 : $location,
            'put_location' => empty($put_location) ? 0 : $put_location,
            'author' => empty($author) ? 0 : $author,
            'longitude' => empty($longitude) ? 0 : $longitude,
            'latitude' => empty($latitude) ? 0 : $latitude,
            'type' => empty($type) ? 1 : $type,
            'length' => empty($length) ? 0 : $length,
            'width' => empty($width) ? 0 : $width,
            'thick' => empty($thick) ? 0 : $thick,
            'material' => implode(',', $material),
            'technology' => implode(',', $technology),
            'outward' => empty($outward) ? 0 : $outward,
            'epigraph' => empty($epigraph) ? 0 : $epigraph,
            'content' => empty($content) ? 0 : $content,
            'img_url' => empty($img_url) ? 0 : $img_url,
            'input_people' => empty($input_people) ? 0 : $input_people,
            'input_unit' => empty($input_unit) ? 0 : $input_unit,
            'mobile' => empty($mobile) ? 0 : $mobile,
            'status' => 1,
            'create_time' => time()
        ];
        DbWork::save('sculpture', $data);
        return $this->redirect('/index/success');
    }

    public function actionSuccess()
    {
        return $this->renderPartial('/index/success');
    }

    public function actionUpload()
    {
        $path = \Yii::$app->basePath . '/web';
        $img = getimagesize($_FILES['file']['tmp_name']);
        if(!$img){
            $arr['code'] = 400;
            $arr['msg'] = '请上传jpg,png,bmp,jpeg类型图片';
            $arr['data']['src'] = '';
            return json_encode($arr);
        }
        $exif = exif_imagetype($_FILES['file']['tmp_name']);
        $ext = [
            1 => '.gif',
            2 => '.jpeg',
            3 => '.png',
            6 => '.bmp',
        ];
        if (!in_array($exif, [1, 2, 3, 6])) {
            return json_encode(["success" => false, 'error' => 2]);
        }
        $exif_name = md5($_FILES['file']['name'] . mt_rand(1, 9999999)) . $ext[$exif];
        $file_r_path = '/upload/img/' . date('Y-m-d') . '/';
        $des = $path . $file_r_path . $exif_name;

        if (!is_dir($path . $file_r_path)) {
            @mkdir($des, 0777, true);
        }
        $id = @move_uploaded_file($_FILES['file']['tmp_name'], $des);
        if (!$id) {
            return json_encode(["success" => false, 'error' => 1]);
        }
        return json_encode(["success" => true, 'file_path' => $file_r_path . $exif_name, 'error' => 0]);
    }

}
