<?php
/**
 * Created by PhpStorm.
 * User: yangge
 * Date: 2019/7/22
 * Time: 9:07 PM
 */

namespace app\controllers;
error_reporting(E_ALL^E_NOTICE);
use app\common\ApiController;
use app\models\Admin;
use app\models\DbWork;
use app\utils\AipOcr;

class ArtistController extends ApiController
{
    // 检验code 是否正确 或符合更新的要求
    public function actionScode()
    {
        //  707e8aaff8fbc38309d0f9b8fac792c1
        $code = md5($this->_DATA['code']);
        if($code == md5("AYjjAHuy")){
            return $this->responseJson([], 200, '新增');
        }else{
            $res = DbWork::getRow('artist', 'id,name,phone,sex,nationality,nation,face,birthday,type,certificates,telephone,email,wx,work_unit,job,permanent,title,address,school,school_time,major,education,fields,other,number,experience,achievement,opus,simg,scode_time', ['scode' => $code,'status'=>0,'del'=>0]);
            if($res){
                if($res['scode_time'] < time()){
                   return $this->responseJson([], 400, 'code 已过有效期'); 
                }else{
                    return $this->responseJson($res, 200, '更新');
                }
            }else{
                return $this->responseJson([], 400, 'code 错误');
            }
        }
    }
    // 数据新增/更新
    public function actionArtist()
    {
        $id = (int)$this->_DATA['id'];
        $number = (int)$this->_DATA['number'];
        if($id){
            $user = DbWork::getRow('artist', '*', ['id' => $id,'number'=>$number,'del'=>0]);
            if($user){
                $where['number'] = $number;
                $where['status'] = 1;
            }else{
                return $this->responseJson([], 400, 'id 或编号错误');
            } 
        }else{
            $query = (new \yii\db\Query())
                ->select("id")
                ->from("artist");
            $query->andWhere(['status' => 0,'del'=>0]);
            $num = $query->count();
            $where['number'] = date('Ymd').str_pad($num+1,5,"0",STR_PAD_LEFT);
            $where['status'] = 0;
        }
        $where['name'] = !empty($this->_DATA['name']) ? $this->_DATA['name'] : die(json_encode(array('code'=>400,'message'=>"姓名不能为空")));
        $where['sex'] = !empty($this->_DATA['sex']) ? (int)$this->_DATA['sex'] : die(json_encode(array('code'=>400,'message'=>"性别不能为空")));
        $where['nationality'] = !empty($this->_DATA['nationality']) ? $this->_DATA['nationality'] : die(json_encode(array('code'=>400,'message'=>"国籍不能为空")));
        $where['nation'] = !empty($this->_DATA['nation']) ? $this->_DATA['nation'] : die(json_encode(array('code'=>400,'message'=>"民族不能为空")));
        $where['face'] = !empty($this->_DATA['face']) ? $this->_DATA['face'] : die(json_encode(array('code'=>400,'message'=>"政治面貌不能为空")));
        $where['birthday'] = !empty($this->_DATA['birthday']) ? $this->_DATA['birthday'] : die(json_encode(array('code'=>400,'message'=>"出生年月不能为空")));
        $where['type'] = !empty($this->_DATA['type']) ? $this->_DATA['type'] : die(json_encode(array('code'=>400,'message'=>"证据类型不能为空")));
        $where['certificates'] = !empty($this->_DATA['certificates']) ? $this->_DATA['certificates'] : die(json_encode(array('code'=>400,'message'=>"证据号码不能为空")));
        $where['phone'] = !empty($this->_DATA['phone']) ? $this->_DATA['phone'] : die(json_encode(array('code'=>400,'message'=>"手机号码不能为空")));
        $where['telephone'] = !empty($this->_DATA['telephone']) ? $this->_DATA['telephone'] : '';
        $where['email'] = !empty($this->_DATA['email']) ? $this->_DATA['email'] : '';
        $where['wx'] = !empty($this->_DATA['wx']) ? $this->_DATA['wx'] :  die(json_encode(array('code'=>400,'message'=>"微信号不能为空")));
        $where['work_unit'] = !empty($this->_DATA['work_unit']) ? $this->_DATA['work_unit'] : die(json_encode(array('code'=>400,'message'=>"工作单位不能为空")));
        $where['job'] = !empty($this->_DATA['job']) ? $this->_DATA['job'] : die(json_encode(array('code'=>400,'message'=>"职务不能为空")));
        $where['permanent'] = !empty($this->_DATA['permanent']) ? $this->_DATA['permanent'] : die(json_encode(array('code'=>400,'message'=>"常 住 地不能为空")));
        $where['title'] = !empty($this->_DATA['title']) ? $this->_DATA['title'] : '';
        $where['address'] = !empty($this->_DATA['address']) ? $this->_DATA['address'] : die(json_encode(array('code'=>400,'message'=>"收件地址不能为空")));
        $where['school'] = !empty($this->_DATA['school']) ? $this->_DATA['school'] : die(json_encode(array('code'=>400,'message'=>"最后毕业院校不能为空")));
        $where['school_time'] = !empty($this->_DATA['school_time']) ? $this->_DATA['school_time'] :'';
        $where['major'] = !empty($this->_DATA['major']) ? $this->_DATA['major'] : die(json_encode(array('code'=>400,'message'=>"所学专业 不能为空")));
        $where['education'] = !empty($this->_DATA['education']) ? $this->_DATA['education'] : die(json_encode(array('code'=>400,'message'=>"最高学历 不能为空")));
        $where['fields'] = !empty($this->_DATA['fields']) ? $this->_DATA['fields'] : die(json_encode(array('code'=>400,'message'=>"专业领域不能为空")));
        $where['experience'] = !empty($this->_DATA['experience']) ? $this->_DATA['experience'] : '';
        $where['achievement'] = !empty($this->_DATA['achievement']) ? $this->_DATA['achievement'] : '';
        $where['opus'] = !empty($this->_DATA['opus']) ? $this->_DATA['opus'] : '';
        $where['simg'] = !empty($this->_DATA['simg']) ? $this->_DATA['simg'] : '';
        $where['other'] = !empty($this->_DATA['other']) ? $this->_DATA['other'] : '';
        $where['addtime'] = time();
        // $where['birthday'] = str_replace('-', '年', $where['birthday']).'月';
        // var_dump($where);
        if($id){
            $result = DbWork::save('artist', $where);
            if (!$result) {
                return $this->responseJson([], 400, '录入失败');
            }
        }else{
            $users = DbWork::getRow('artist', 'certificates', ['certificates'=>$where['certificates'],'del'=>0]);
            if($users){
                return $this->responseJson([], 400, '证件号码已存在，请确认后再进行新增操作！');
            }else{
                $result = DbWork::save('artist', $where);
                if (!$result) {
                    return $this->responseJson([], 400, '录入失败');
                }
            }

        }
        // 原基础表 变成有更新
        if($id){
            $update['update_type'] = 1;
            $update['scode'] = 0;
            $update['scode_time'] = '';
            $res = DbWork::update('artist',$update,['id' => $id,'number'=>$number,'del'=>0]);

            // 记录原表与更新表变化 并进行记录
            
            unset($user['id']);
            unset($user['addtime']);
            unset($user['del']);
            unset($user['status']);
            unset($user['update_type']);
            unset($user['addtime']);
            unset($user['scode']);
            unset($user['scode_time']);
            unset($where['addtime']);
            $diff = array_diff($where, $user);
            foreach ($diff as $key => $value) {
                $diff_key[] = $key;
                $diff_val[] = $value;
            }
            $diff_arr['fields'] = implode(';', $diff_key);
            $diff_arr['content'] =  implode('%_%', $diff_val);
            $diff_arr['updatetime'] =  time();
            $diff_arr['aid'] =  $id;
            $result = DbWork::save('artist_update', $diff_arr);
            
        }
        return $this->responseJson([], 200, '提交成功');
    }
    // 专家列表页
    public function actionArtistlist()
    {
        $page = isset($this->_DATA['page']) ? $this->_DATA['page'] : 1;
        $pageSize = isset($this->_DATA['pagesize']) ? $this->_DATA['pagesize'] : 10;
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $page = max(1, $page);
        // $data = array('total' => 0, 'total_page' => 0, 'cur_page' => 0, 'datalist' => array());
        $query = (new \yii\db\Query())
            ->select("id,name,simg,work_unit,job")
            ->from("artist");
        $query->andWhere(['del' => 0 ]);
        // $query->andWhere(['is_show' => 1 ]);
        $list = $query->offset(($page - 1) * $pageSize)->limit($pageSize)->all();
        return $this->responseJson($list, 200, '请求成功');
    }
    // 专家详情页
    public function actionDetails()
    {
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $query = (new \yii\db\Query())
            ->select("id,name,simg,work_unit,job,achievement,fields")
            ->from("artist");
        $query->andWhere(['del' => 0 ]);
        $query->andWhere(['id' => $id ]);
        // $query->andWhere(['is_show' => 1 ]);
        $list['details'] = $query->all();

        $query = (new \yii\db\Query())
            ->select('artistworks.id,works.title,works.desc,works.simg,artistworks.wid')
            ->leftJoin('works', 'artistworks.wid  = works.id')
            ->from("artistworks");
        $query->andWhere(['works.del' => 0]);
        $query->andWhere(['artistworks.aid' => $id]);
        $list['works'] = $query->all();
        return $this->responseJson($list, 200, '请求成功');
    }
    // 作品列表页
    public function actionWorks()
    {
        $page = isset($this->_DATA['page']) ? $this->_DATA['page'] : 1;
        $pageSize = isset($this->_DATA['pagesize']) ? $this->_DATA['pagesize'] : 10;
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $page = max(1, $page);
        // $data = array('total' => 0, 'total_page' => 0, 'cur_page' => 0, 'datalist' => array());
        $query = (new \yii\db\Query())
            ->select("id,title,simg,desc")
            ->from("works");
        $query->andWhere(['del' => 0 ]);
        // $query->andWhere(['is_show' => 1 ]);
        $list = $query->offset(($page - 1) * $pageSize)->limit($pageSize)->all();
        return $this->responseJson($list, 200, '请求成功');
    }
    public function actionWorksinfo()
    {
        $id = isset($this->_DATA['id']) ? $this->_DATA['id'] : '';
        $query = (new \yii\db\Query())
            ->select("*")
            ->from("works");
        $query->andWhere(['del' => 0 ]);
        $query->andWhere(['id' => $id ]);
        // $query->andWhere(['is_show' => 1 ]);
        $list = $query->one();
        $list['content'] = htmlspecialchars_decode($list['content']);
        $query = (new \yii\db\Query())
            ->select('artist.id,artist.name')
            ->leftJoin('artist', 'artistworks.aid  = artist.id')
            ->from("artistworks");
        $query->andWhere(['artist.del' => 0]);
        // $query->andWhere(['artist.is_show' => 1]);
        $query->andWhere(['artistworks.wid' => $id]);
        $list['author'] = $query->one();
        return $this->responseJson($list, 200, '请求成功');
    }
}