<?php

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';

$config = [
    'id' => 'basic',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log',function($app){
        Yii::info(['GET'=>$_GET,'POST'=>$_POST,'SERVER'=>$_SERVER,'row_body'=>Yii::$app->request->getRawBody()],'web_log_msg');
    }],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'timeZone' => 'Asia/Shanghai',
    'components' => [
        'redis' => [
            'class' => 'yii\redis\Connection',
            'hostname' => YII_ENV =='prod'? '172.18.195.87': '127.0.0.1',
            'port' => 6379,
            'database' => 0,
        ],
        'request' => [
            'enableCsrfValidation' => true,
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => '4ntiX6QjfO5Kw0E4_WoDyy0JaFeweXKR',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            //'identityClass' => 'app\models\User',
            //'enableAutoLogin' => true,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure a transport
            // for the mailer to send real emails.
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'smtp.exmail.qq.com',
                'username' => '',
                'password' => '',
                'port' => '465',
                'encryption' => 'ssl',
            ],
            'messageConfig'=>[
                'charset'=>'UTF-8',
                'from'=>[]
            ],
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/web/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'categories' => ['api_reg_user'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/api/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'categories' => ['cmd_exec_run'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/cmd/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['curl_http_request'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/curl_http_request_web/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['app_api_log'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/app_api_log/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['web_log_msg'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/web_log_msg/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
				[
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['admin_log'],
                    'levels' => ['info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/admin_log/' . date('Y-m-d') . '.log',
                    'logVars' => ['_GET','_POST','_FILES','_COOKIE','_SESSION'],
                ],
            ],
        ],
        'db' => $db,

        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            //'suffix' => '.html',
            'rules' => [
            ],
        ],

    ],
    'defaultRoute' => 'admin/index/index',
    'params' => $params,

];

if (YII_ENV_DEV) {
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        'allowedIPs' => ['127.0.0.1', '127.0.0.2', '::1']
    ];
}

return $config;
