<?php

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';

$config = [
    'id' => 'basic-console',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log',function($app){
        Yii::info([$_SERVER],'cron_run');
    }],
    'controllerNamespace' => 'app\commands',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure a transport
            // for the mailer to send real emails.
            'useFileTransport' => false,
            'transport' => [
                'class' => 'Swift_SmtpTransport',
                'host' => 'smtp.exmail.qq.com',
                'username' => '',
                'password' => '',
                'port' => '465',
                'encryption' => 'ssl',
            ],
            'messageConfig'=>[
                'charset'=>'UTF-8',
                'from'=>[]
            ],
        ],
        'redis' => [
            'class' => 'yii\redis\Connection',
            'hostname' => YII_ENV =='prod'? '': '127.0.0.1',
            'port' => 6379,
            'database' => 0,
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'log' => [
            //'traceLevel' => YII_DEBUG ? 3 : 0,
            'flushInterval' => 1,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'levels' => ['error', 'warning'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/cron/' . date('Y-m-d') . '.log',
                    //'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['curl_http_request'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/curl_http_request/' . date('Y-m-d') . '.log',
                    'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['log_msg'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/log_msg/' . date('Y-m-d') . '.log',
                    'logVars' => ['*'],
                ],
                [
                    'class' => 'yii\log\FileTarget',
                    'exportInterval' => 1,
                    'categories' => ['cron_run'],
                    'levels' => ['error', 'warning','info'],
                    'fileMode' => 0777,
                    'logFile' => '@runtime/logs/cron_run/' . date('Y-m-d') . '.log',
                    'logVars' => ['*'],
                ],

            ],
        ],
        'db' => $db,
    ],
    'params' => $params,

    /*
    'controllerMap' => [
        'fixture' => [ // Fixture generation command line.
            'class' => 'yii\faker\FixtureController',
        ],
    ],
    */
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
    ];
}

return $config;
