<?php
/**
 * Created by PhpStorm.
 * User: dasaoge
 * Date: 2019/8/15
 * Time: 23:08
 */

namespace app\common;


use yii\web\Controller;
use app\models\DbWork;
use yii;

class ApiController extends Controller
{
    public $enableCsrfValidation = false;

    public $_DATA;
    public $user;

    public function init()
    {
        header("Access-Control-Allow-Origin:*");
        // 跳过验证
        $tiaoguo_arr = array("/site/index","/site/adds","/site/lists","/site/details","/site/get-street","/site/get-district","/site/tipoffs","/site/getnearby","/site/wxinfo","/site/identify","/site/zhuanfa","/site/meetingform","/artist/scode","/artist/artist","/artist/artistlist","/artist/details","/artist/works","/artist/worksinfo","/location/index","/location/zhuan","/location/menu");
        if(in_array($_SERVER["REQUEST_URI"],$tiaoguo_arr)){
            $post = Yii::$app->request->post();
            foreach ($post as $key => $value) {
                if (!is_array($value)) {
                    $post[$key] = htmlspecialchars($value);
                } else {
                    foreach ($value as $kk => $vv) {
                        $value[$kk] = htmlspecialchars($vv);
                    }
                    $post[$key] = $value;
                }
            }
            $this->_DATA = $post;
        }else{
            $post = Yii::$app->request->post();
            foreach ($post as $key => $value) {
                if (!is_array($value)) {
                    $post[$key] = htmlspecialchars($value);
                } else {
                    foreach ($value as $kk => $vv) {
                        $value[$kk] = htmlspecialchars($vv);
                    }
                    $post[$key] = $value;
                }
            }
            $this->_DATA = $post;
            if (empty($this->_DATA['token']) && !isset($this->_DATA['login'])) {
                // 
                // echo 'http://'.$_SERVER['SERVER_NAME'].'/admin/login/login';
                // $this->redirect('http://www.baidu.com');
                // return $this->redirect('http://'.$_SERVER['SERVER_NAME'].'/admin/login/login');
                @header("http/1.1 404 not found");
                echo '<!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <title>404</title>
                    <style>
                        div#div1{
                            position:fixed;
                            top:0;
                            left:0;
                            bottom:0;
                            right:0;
                            z-index:-1;
                        }
                        div#div1 > img {
                            height:100%;
                            width:100%;
                            border:0;
                        }
                    </style>
                </head>
                <body>
                <div id="div1"><img src="/not_find/404.jpg" /></div>
                </body>
                </html>';
                die;
                return $this->responseJson([], 400, '登录信息已失效，请先登录');
            } elseif (!empty($this->_DATA['token'])) {
                $user = DbWork::getRow('admin', '*', ['token' => $this->_DATA['token']]);
                // return $this->responseJson([], 401, $this->_DATA['token']);
                if ($user['status'] == 0) {
                    // return $this->redirect('http://'.$_SERVER['SERVER_NAME'].'/admin/login/login');
                    // return $this->responseJson([], 400, '登录信息已失效，请重新登录');
                    @header("http/1.1 404 not found");
                    echo '<!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <title>404</title>
                    <style>
                        div#div1{
                            position:fixed;
                            top:0;
                            left:0;
                            bottom:0;
                            right:0;
                            z-index:-1;
                        }
                        div#div1 > img {
                            height:100%;
                            width:100%;
                            border:0;
                        }
                    </style>
                </head>
                <body>
                <div id="div1"><img src="/not_find/404.jpg" /></div>
                </body>
                </html>';
                die;
                }
                $this->user = $user;
            }
        }
        
    }

    //格式化JSON返回
    public function responseJson($result, $code = true, $message = null, $ext = null, $exit = true)
    {
        if (!empty($this->postBody)) {
            Yii::info(json_encode($this->postBody), 'api_log');
        } else {
            Yii::info('当前请求没有参数', 'api_log');
        }
        $data = [
            'code' => $code,
            'message' => $message ? $message : '',
            'result' => $result,
            'token' => (isset($this->user)) ? $this->user['token'] : ''
        ];
        if ($ext !== null && is_array($ext)) {
            foreach ($ext as $k => $v) {
                if (!isset($data[$k])) {
                    $data[$k] = $v;
                }
            }
        }
        $json = json_encode($data);
        Yii::info($json, 'api_log');
        header('Content-type: application/json');
        echo $json;
        ob_flush();
        if ($exit === true) {
            exit;
        }
    }
}